/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump;

import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpConfiguration;
import com.intellij.database.dump.dbdump.DumpSettings;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpProperties
implements Disposable {
    private static final String PATH = "_PATH";
    private static final String COMMAND = "_COMMAND";
    private static final String EXPANDED = "_EXPANDED";
    private static final String VARIANTS = "_VARIANTS_";
    private final ThreadPoolExecutor myExecutor;
    private final DumpConfiguration myConfiguration;
    private final DumpSettings mySettings;

    DumpProperties(@NotNull DumpConfiguration configuration, @NotNull DumpSettings settings) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/dump/dbdump/DumpProperties", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dump/dbdump/DumpProperties", "<init>"));
        }
        this.myConfiguration = configuration;
        this.mySettings = settings;
        this.myExecutor = ConcurrencyUtil.newSingleThreadExecutor((String)"Dump tool help parser");
    }

    public void store() {
        String key = this.myConfiguration.getPropertyKey();
        PropertiesComponent component = PropertiesComponent.getInstance();
        component.setValue(key + PATH, this.mySettings.getPathToExecutable());
        component.setValue(key + COMMAND, this.mySettings.getCommand());
        component.setValue(key + EXPANDED, String.valueOf(this.mySettings.isExpanded()));
    }

    public void restore() {
        String key = this.myConfiguration.getPropertyKey();
        PropertiesComponent component = PropertiesComponent.getInstance();
        String path = component.getValue(key + PATH);
        String command = component.getValue(key + COMMAND);
        String expanded = component.getValue(key + EXPANDED);
        if (path != null) {
            this.mySettings.setPathToExecutable(path);
        }
        if (command != null) {
            this.mySettings.setCommand(command);
        }
        this.mySettings.setExpanded(expanded != null ? Boolean.valueOf(expanded) : true);
    }

    public void storeVariants() {
        DumpConfiguration configuration = this.mySettings.getConfiguration();
        String key = configuration.getPropertyKey();
        String path = this.mySettings.getPathToExecutable();
        File file = new File(path);
        if (!(file.exists() && file.isFile() && Files.isExecutable(Paths.get(path, new String[0])))) {
            this.mySettings.setVariants(ContainerUtil.newArrayList());
            return;
        }
        int hash = FileUtil.fileHashCode((File)file);
        PropertiesComponent component = PropertiesComponent.getInstance();
        String value = component.getValue(key + VARIANTS + hash);
        if (value == null) {
            this.myExecutor.submit(new MyVariantsTask(this.mySettings, path, configuration.getHelpCommand(), hash));
            return;
        }
        this.mySettings.setVariants(StringUtil.split((String)value, (String)" "));
    }

    public void dispose() {
        this.myExecutor.shutdown();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.myExecutor.awaitTermination(120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<String> getVariants(@NotNull String path, @NotNull String helpCommand) {
        List<String> list;
        Throwable throwable;
        BufferedReader reader;
        Process process;
        block21: {
            block22: {
                String string;
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dump/dbdump/DumpProperties", "getVariants"));
                }
                if (helpCommand == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpCommand", "com/intellij/database/dump/dbdump/DumpProperties", "getVariants"));
                }
                process = DumpProperties.createProcess(path, helpCommand);
                if (process == null) {
                    List list2 = ContainerUtil.emptyList();
                    if (list2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpProperties", "getVariants"));
                    }
                    return list2;
                }
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                throwable = null;
                StringBuilder builder = new StringBuilder();
                while ((string = reader.readLine()) != null) {
                    builder.append(string);
                }
                list = DumpProperties.getFromString(builder.toString());
                if (reader == null) break block21;
                if (throwable == null) break block22;
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block21;
            }
            reader.close();
        }
        List<String> list3 = list;
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpProperties", "getVariants"));
        }
        return list3;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                reader.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException iOException) {
                    process.destroyForcibly();
                    List list4 = ContainerUtil.emptyList();
                    if (list4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpProperties", "getVariants"));
                    }
                    return list4;
                }
            }
        }
    }

    @Nullable
    private static Process createProcess(@NotNull String path, @NotNull String helpCommand) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dump/dbdump/DumpProperties", "createProcess"));
        }
        if (helpCommand == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helpCommand", "com/intellij/database/dump/dbdump/DumpProperties", "createProcess"));
        }
        try {
            GeneralCommandLine line = new GeneralCommandLine(new String[]{path, helpCommand});
            return line.createProcess();
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    @NotNull
    private static List<String> getFromString(@NotNull String current) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/DumpProperties", "getFromString"));
        }
        List<DumpCommandLineLexeme> result = DbDumpUtil.extractArguments(current);
        List<String> list = result.stream().map(DumpCommandLineLexeme::getText).distinct().collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/DumpProperties", "getFromString"));
        }
        return list;
    }

    private static class MyVariantsTask
    implements Runnable {
        private final DumpSettings mySettings;
        private final String myPath;
        private final String myCommand;
        private final int myHash;

        private MyVariantsTask(@NotNull DumpSettings settings, @NotNull String path, @NotNull String command, int hash) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dump/dbdump/DumpProperties$MyVariantsTask", "<init>"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dump/dbdump/DumpProperties$MyVariantsTask", "<init>"));
            }
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/dump/dbdump/DumpProperties$MyVariantsTask", "<init>"));
            }
            this.mySettings = settings;
            this.myPath = path;
            this.myCommand = command;
            this.myHash = hash;
        }

        @Override
        public void run() {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            List variants = DumpProperties.getVariants(this.myPath, this.myCommand);
            DbUIUtil.invokeLater(() -> {
                properties.setValue(this.mySettings.getConfiguration().getPropertyKey() + DumpProperties.VARIANTS + this.myHash, StringUtil.join((Collection)variants, (String)" "));
                this.mySettings.setVariants(variants);
            });
        }
    }
}

