/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.TranspositionAwareDefaultExtractor;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.CharOut;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlValuesExtractor
extends TranspositionAwareDefaultExtractor<DatabaseSettings.StdState> {
    public XmlValuesExtractor(ObjectFormatter converter) {
        this(new DatabaseSettings.StdState(), converter);
    }

    public XmlValuesExtractor(DatabaseSettings.StdState state, ObjectFormatter converter) {
        super(state, converter);
    }

    @Override
    @NotNull
    public String getLinePrefix() {
        if (" <row>\n" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/XmlValuesExtractor", "getLinePrefix"));
        }
        return " <row>\n";
    }

    @Override
    @NotNull
    public String getLineSuffix() {
        if (" </row>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/XmlValuesExtractor", "getLineSuffix"));
        }
        return " </row>";
    }

    @Override
    public String getLineSeparator() {
        return "\n";
    }

    @Override
    @NotNull
    public String getValuePrefix() {
        if ("  " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/XmlValuesExtractor", "getValuePrefix"));
        }
        return "  ";
    }

    @Override
    @NotNull
    public String getValueSuffix() {
        if ("\n" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/XmlValuesExtractor", "getValueSuffix"));
        }
        return "\n";
    }

    @Override
    public String getValueSeparator() {
        return "";
    }

    @Override
    @NotNull
    public String getNullLiteral(DataConsumer.Row row, DataConsumer.Column column) {
        String string = this.getValueLiteral(GenericDialect.INSTANCE, "", row, column);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/XmlValuesExtractor", "getNullLiteral"));
        }
        return string;
    }

    @Override
    public String getColumnName(DataConsumer.Column column) {
        return XmlValuesExtractor.escapeXmlTagName(column.name);
    }

    @Override
    public String getValueLiteral(@NotNull DatabaseDialect dialect, @NotNull String value, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/extractors/XmlValuesExtractor", "getValueLiteral"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/extractors/XmlValuesExtractor", "getValueLiteral"));
        }
        if (column == null) {
            return "";
        }
        String columnName = this.getColumnName(column);
        return "<" + columnName + ">" + value + "</" + columnName + ">";
    }

    @Override
    @NotNull
    public String getFileExtension() {
        if ("xml" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/extractors/XmlValuesExtractor", "getFileExtension"));
        }
        return "xml";
    }

    private static String escapeXmlTagName(String text) {
        char firstChar;
        StringBuilder sb = new StringBuilder(text);
        int len = sb.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Character.isLetterOrDigit(sb.charAt(i2))) continue;
            sb.setCharAt(i2, '_');
        }
        char c = firstChar = sb.length() == 0 ? (char)'\u0000' : sb.charAt(0);
        if (firstChar == '\u0000' || firstChar != '_' && !Character.isLetter(firstChar)) {
            sb.insert(0, '_');
        }
        return sb.toString();
    }

    @Override
    public boolean isIncludeColumnNames() {
        return false;
    }

    @Override
    public boolean isIncludeRowNumbers() {
        return false;
    }

    @Override
    protected TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase startExtraction(CharOut out, DatabaseDialectEx dialect, boolean forceSkipHeader, boolean transposedMode, List<DataConsumer.Column> allColumns, int ... selectedColumns) {
        return new TranspositionAwareDefaultExtractor.TranspositionAwareExtractionBase(out, dialect, forceSkipHeader, transposedMode, allColumns, selectedColumns){

            @Override
            protected void doAppendHeader(boolean appendNewLine) {
                this.myOutput.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<data>\n");
            }

            @Override
            protected void doAppendFooter() {
                this.myOutput.append("\n</data>");
            }
        };
    }
}

