/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableList;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSynonym;
import com.intellij.dbm.common.DbmTable;
import com.intellij.util.StreamExtKt$sam$Predicate$i$95be0870;
import gnu.trove.TIntHashSet;
import gnu.trove.TLongHashSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u000b\u001a*\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u001a\"\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u001a\u0010\u0010\u0018\u001a\u00020\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\u0013\u001a\n\u0010\u001a\u001a\u00020\u0005*\u00020\u001b\u001a \u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\b\b\u0000\u0010\u001e*\u00020\u001f*\b\u0012\u0004\u0012\u0002H\u001e0 \"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"AGES_AGO", "Ljava/sql/Timestamp;", "DEFAULT_OPTIONS", "Lcom/intellij/database/introspection/DBIntrospectionOptions;", "dropUnexistentObjects", "", "family", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "existentObjectIds", "Lgnu/trove/TIntHashSet;", "Lgnu/trove/TLongHashSet;", "setMajorVersionParameters", "version", "Lorg/jetbrains/dekaf/util/Version;", "min", "", "parameters", "", "", "", "setOracleFastSlowModeParameters", "fast", "", "stringToBoolean", "str", "derefAll", "Lcom/intellij/database/model/basic/BasicModSchema;", "toList", "", "E", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/families/Family;", "database-introspection"})
@JvmName(name="BaseIntrospectionFunctions")
public final class BaseIntrospectionFunctions {
    @JvmField
    @NotNull
    public static final Timestamp AGES_AGO = new Timestamp(139460400000L);
    @JvmField
    @NotNull
    public static final DBIntrospectionOptions DEFAULT_OPTIONS = new DBIntrospectionOptions(DBIntrospectionOptions.SourceLoading.NO_SOURCES);

    @NotNull
    public static final <E extends BasicElement> List<E> toList(@NotNull Family<E> $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if ($receiver.hasChildren()) {
            List list2 = (List)ImmutableList.builder().addAll((Iterable)$receiver).build();
            list = list2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ImmutableList.builder<E>().addAll(this).build()");
        } else {
            List list3 = Collections.emptyList();
            list = list3;
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"Collections.emptyList()");
        }
        return list;
    }

    public static final void derefAll(@NotNull BasicModSchema $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof DbmSchema) {
            for (DbmSynonym dbmSynonym : ((DbmSchema)$receiver).getSchema().getSynonyms()) {
                dbmSynonym.origin.resolveObject();
            }
            for (DbmTable dbmTable : ((DbmSchema)$receiver).getSchema().getTables()) {
                for (DbmForeignKey f : dbmTable.getForeignKeys()) {
                    f.resolve();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void dropUnexistentObjects(@NotNull ModIdentifyingFamily<? extends BasicModIdentifiedElement> family, @NotNull TIntHashSet existentObjectIds) {
        void predicate$iv;
        void $receiver$iv22;
        Intrinsics.checkParameterIsNotNull(family, (String)"family");
        Intrinsics.checkParameterIsNotNull((Object)existentObjectIds, (String)"existentObjectIds");
        if (family.isEmpty()) {
            return;
        }
        Stream stream = family.stream();
        Function1 function1 = (Function1)new Function1<BasicModIdentifiedElement, Boolean>(existentObjectIds){
            final /* synthetic */ TIntHashSet $existentObjectIds;

            public final boolean invoke(BasicModIdentifiedElement e) {
                return this.$existentObjectIds.contains((int)e.getObjectId()) ^ true;
            }
            {
                this.$existentObjectIds = tIntHashSet;
                super(1);
            }
        };
        Stream stream2 = $receiver$iv22.filter(new StreamExtKt$sam$Predicate$i$95be0870((Function1)predicate$iv));
        Intrinsics.checkExpressionValueIsNotNull(stream2, (String)"filter(predicate)");
        List elementsToDrop2 = stream2.collect(Collectors.toList());
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)elementsToDrop2)));
        int $receiver$iv22 = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        int n3 = $receiver$iv22;
        int n4 = n;
        if (n2 > 0 ? n3 <= n4 : n3 >= n4) {
            while (true) {
                void i2;
                ((BasicModIdentifiedElement)elementsToDrop2.get((int)i2)).drop();
                if (i2 == n) break;
                void var3_3 = i2 + n2;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void dropUnexistentObjects(@NotNull ModIdentifyingFamily<? extends BasicModIdentifiedElement> family, @NotNull TLongHashSet existentObjectIds) {
        void predicate$iv;
        void $receiver$iv22;
        Intrinsics.checkParameterIsNotNull(family, (String)"family");
        Intrinsics.checkParameterIsNotNull((Object)existentObjectIds, (String)"existentObjectIds");
        if (family.isEmpty()) {
            return;
        }
        Stream stream = family.stream();
        Function1 function1 = (Function1)new Function1<BasicModIdentifiedElement, Boolean>(existentObjectIds){
            final /* synthetic */ TLongHashSet $existentObjectIds;

            public final boolean invoke(BasicModIdentifiedElement e) {
                return this.$existentObjectIds.contains(e.getObjectId()) ^ true;
            }
            {
                this.$existentObjectIds = tLongHashSet;
                super(1);
            }
        };
        Stream stream2 = $receiver$iv22.filter(new StreamExtKt$sam$Predicate$i$95be0870((Function1)predicate$iv));
        Intrinsics.checkExpressionValueIsNotNull(stream2, (String)"filter(predicate)");
        List elementsToDrop2 = stream2.collect(Collectors.toList());
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)elementsToDrop2)));
        int $receiver$iv22 = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        int n3 = $receiver$iv22;
        int n4 = n;
        if (n2 > 0 ? n3 <= n4 : n3 >= n4) {
            while (true) {
                void i2;
                ((BasicModIdentifiedElement)elementsToDrop2.get((int)i2)).drop();
                if (i2 == n) break;
                void var3_3 = i2 + n2;
            }
        }
    }

    public static final boolean stringToBoolean(@Nullable String str) {
        if (str == null) {
            return false;
        }
        String string = str;
        Locale locale = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String s = string3;
        return Intrinsics.areEqual((Object)s, (Object)"true") || Intrinsics.areEqual((Object)s, (Object)"yes") || Intrinsics.areEqual((Object)s, (Object)"1") || Intrinsics.areEqual((Object)s, (Object)"+");
    }

    /*
     * WARNING - void declaration
     */
    public static final void setMajorVersionParameters(@NotNull Version version, int min, @NotNull Map<String, Object> parameters) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        int verMajor = version.get(0);
        int n = min;
        int n2 = verMajor;
        if (n <= n2) {
            while (true) {
                void v;
                parameters.put("V" + (int)v, true);
                if (v == n2) break;
                ++v;
            }
        }
    }

    public static final void setOracleFastSlowModeParameters(boolean fast, @NotNull Map<String, Object> parameters) {
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        parameters.put(fast ? "FAST" : "SLOW", true);
        parameters.put("CAT", fast ? "sys.dba" : "sys.all");
    }
}

