/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospectionFunctions;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.util.Case;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.CommonPreprocessor;
import com.intellij.sql.Evaluator;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBQueryRunner;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.StringOperator;
import org.jetbrains.dekaf.util.Version;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\u00062\u00020\b:\u0003nopB9\b\u0014\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00030\f\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010F\u001a\u00028\u00002\u0006\u0010#\u001a\u00020\u0002H\u0083\b\u00a2\u0006\u0002\u0010GJ\b\u0010H\u001a\u00020IH\u0004J\r\u0010J\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010%J\u0012\u0010K\u001a\u00020I2\b\u0010#\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010L\u001a\u00020IH\u0014J!\u0010M\u001a\u00020I2\u0012\u0010N\u001a\n\u0012\u0006\b\u0001\u0012\u00020P0O\"\u00020PH\u0016\u00a2\u0006\u0002\u0010QJ \u0010R\u001a\u00020I2\u0006\u0010S\u001a\u00020T2\u000e\u0010N\u001a\n\u0012\u0004\u0012\u00020P\u0018\u00010UH$J9\u0010V\u001a\u00020I2\u0006\u0010W\u001a\u00020P2\u0006\u0010X\u001a\u00020\u00192\u0006\u0010Y\u001a\u00020Z2\u0012\u0010[\u001a\n\u0012\u0006\b\u0001\u0012\u00020A0O\"\u00020AH\u0016\u00a2\u0006\u0002\u0010\\J\b\u0010]\u001a\u00020IH\u0016J\u0010\u0010^\u001a\u00020I2\u0006\u0010S\u001a\u00020TH$J\b\u0010_\u001a\u00020IH\u0016J\u0010\u0010_\u001a\u00020I2\u0006\u0010S\u001a\u00020TH\u0014J\u0015\u0010`\u001a\u00020\u00192\u0006\u0010a\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010bJ\u0010\u0010c\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u0002H\u0014J\b\u0010d\u001a\u00020IH\u0004J\u0010\u0010e\u001a\u00020I2\u0006\u0010f\u001a\u00020\u0004H\u0004J\u0018\u0010g\u001a\u00020I2\u0006\u0010h\u001a\u00020A2\u0006\u0010i\u001a\u00020AH\u0004J\u0015\u0010j\u001a\u00020\u00192\u0006\u0010a\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010bJ\u0019\u0010k\u001a\u00020I2\u000e\b\u0004\u0010l\u001a\b\u0012\u0004\u0012\u00020I0mH\u0084\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00030\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001cR*\u0010.\u001a\u0004\u0018\u00018\u00002\b\u0010\u0018\u001a\u0004\u0018\u00018\u0000@BX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u00102\u001a\u0004\b/\u0010%\"\u0004\b0\u00101R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001c\u00109\u001a\u0004\u0018\u00010:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001c\u0010?\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B0@8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010C\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\u0015\"\u0004\bE\u0010\u0017\u00a8\u0006q"}, d2={"Lcom/intellij/database/introspection/BaseIntrospector;", "MM", "Lcom/intellij/database/model/basic/BasicModModel;", "MR", "Lcom/intellij/database/model/basic/BasicModRoot;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "MS", "Lcom/intellij/database/introspection/DBIntrospector;", "dbFacade", "Lorg/jetbrains/dekaf/core/DBFacade;", "modModelClass", "Ljava/lang/Class;", "modRootClass", "modSchemaClass", "(Lorg/jetbrains/dekaf/core/DBFacade;Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;)V", "getDbFacade", "()Lorg/jetbrains/dekaf/core/DBFacade;", "driverVersion", "Lorg/jetbrains/dekaf/util/Version;", "getDriverVersion", "()Lorg/jetbrains/dekaf/util/Version;", "setDriverVersion", "(Lorg/jetbrains/dekaf/util/Version;)V", "<set-?>", "", "initialized", "getInitialized", "()Z", "setInitialized", "(Z)V", "getModModelClass", "()Ljava/lang/Class;", "getModRootClass", "getModSchemaClass", "model", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "modelFactory", "Lcom/intellij/database/model/impl/ModelFactory;", "getModelFactory$database_introspection", "()Lcom/intellij/database/model/impl/ModelFactory;", "setModelFactory$database_introspection", "(Lcom/intellij/database/model/impl/ModelFactory;)V", "myConsiderSystemSchemasReinstrospection", "getMyConsiderSystemSchemasReinstrospection", "myModel", "getMyModel", "setMyModel", "(Lcom/intellij/database/model/basic/BasicModModel;)V", "Lcom/intellij/database/model/basic/BasicModModel;", "options", "Lcom/intellij/database/introspection/DBIntrospectionOptions;", "getOptions", "()Lcom/intellij/database/introspection/DBIntrospectionOptions;", "setOptions", "(Lcom/intellij/database/introspection/DBIntrospectionOptions;)V", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getProgressIndicator", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "setProgressIndicator", "(Lcom/intellij/openapi/progress/ProgressIndicator;)V", "queryParameters", "", "", "", "serverVersion", "getServerVersion", "setServerVersion", "castModel", "(Lcom/intellij/database/model/basic/BasicModModel;)Lcom/intellij/database/model/basic/BasicModModel;", "checkNotInitialized", "", "createNewModel", "init", "initInternalState", "introspectAuto", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "([Lcom/intellij/database/model/basic/BasicNamespace;)V", "introspectAutoInTran", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "", "introspectFragment", "namespace", "withSources", "objectKind", "Lcom/intellij/database/model/ObjectKind;", "objectNames", "(Lcom/intellij/database/model/basic/BasicNamespace;ZLcom/intellij/database/model/ObjectKind;[Ljava/lang/String;)V", "introspectNamespaces", "introspectNamespacesInTran", "introspectSessionState", "isPossibleToIntrospectSchemaIncrementally", "schema", "(Lcom/intellij/database/model/basic/BasicSchema;)Z", "modelCanBeAccepted", "postIntrospectionProcess", "postIntrospectionProcessWithModel", "root", "updateStatus", "status", "details", "whetherSourcesActual", "writeSources", "r", "Lkotlin/Function0;", "AbstractRetriever", "DatabaseRetriever", "SchemaRetriever", "database-introspection"})
public abstract class BaseIntrospector<MM extends BasicModModel, MR extends BasicModRoot, S extends BasicSchema, MS extends BasicSchema>
implements DBIntrospector {
    @NotNull
    private final DBFacade dbFacade;
    @NotNull
    private final Class<MM> modModelClass;
    @NotNull
    private final Class<MR> modRootClass;
    @NotNull
    private final Class<MS> modSchemaClass;
    @Nullable
    private ModelFactory modelFactory;
    private final boolean myConsiderSystemSchemasReinstrospection;
    @Nullable
    private MM myModel;
    @NotNull
    private DBIntrospectionOptions options;
    @Nullable
    private ProgressIndicator progressIndicator;
    @JvmField
    @NotNull
    protected final Map<String, Object> queryParameters;
    @NotNull
    private Version serverVersion;
    @NotNull
    private Version driverVersion;
    private boolean initialized;

    @NotNull
    protected final DBFacade getDbFacade() {
        return this.dbFacade;
    }

    @NotNull
    protected final Class<MM> getModModelClass() {
        return this.modModelClass;
    }

    @NotNull
    protected final Class<MR> getModRootClass() {
        return this.modRootClass;
    }

    @NotNull
    protected final Class<MS> getModSchemaClass() {
        return this.modSchemaClass;
    }

    @Nullable
    public final ModelFactory getModelFactory$database_introspection() {
        return this.modelFactory;
    }

    public final void setModelFactory$database_introspection(@Nullable ModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    protected final boolean getMyConsiderSystemSchemasReinstrospection() {
        return this.myConsiderSystemSchemasReinstrospection;
    }

    @Nullable
    protected final MM getMyModel() {
        return this.myModel;
    }

    private final void setMyModel(MM MM) {
        this.myModel = MM;
    }

    @Override
    @NotNull
    public final DBIntrospectionOptions getOptions() {
        return this.options;
    }

    @Override
    public final void setOptions(@NotNull DBIntrospectionOptions dBIntrospectionOptions) {
        Intrinsics.checkParameterIsNotNull((Object)dBIntrospectionOptions, (String)"<set-?>");
        this.options = dBIntrospectionOptions;
    }

    @Override
    @Nullable
    public final ProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    @Override
    public final void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    @NotNull
    protected final Version getServerVersion() {
        return this.serverVersion;
    }

    protected final void setServerVersion(@NotNull Version version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"<set-?>");
        this.serverVersion = version;
    }

    @NotNull
    protected final Version getDriverVersion() {
        return this.driverVersion;
    }

    protected final void setDriverVersion(@NotNull Version version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"<set-?>");
        this.driverVersion = version;
    }

    protected final boolean getInitialized() {
        return this.initialized;
    }

    private final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    @Override
    public void init(@Nullable BasicModModel model) {
        this.checkNotInitialized();
        if (model != null && this.modelCanBeAccepted(model)) {
            BaseIntrospector baseIntrospector = this;
            BaseIntrospector baseIntrospector2 = this;
            BasicModModel basicModModel = model;
            if (basicModModel == null) {
                throw new TypeCastException("null cannot be cast to non-null type MM");
            }
            BasicModModel basicModModel2 = basicModModel;
            baseIntrospector2.myModel = basicModModel2;
        } else {
            this.myModel = this.createNewModel();
        }
        ConnectionInfo connectionInfo = this.dbFacade.getConnectionInfo();
        Version version = connectionInfo.serverVersion;
        Intrinsics.checkExpressionValueIsNotNull((Object)version, (String)"connectionInfo.serverVersion");
        this.serverVersion = version;
        Version version2 = connectionInfo.driverVersion;
        Intrinsics.checkExpressionValueIsNotNull((Object)version2, (String)"connectionInfo.driverVersion");
        this.driverVersion = version2;
        this.initInternalState();
        this.initialized = true;
    }

    private final MM castModel(BasicModModel model) {
        BasicModModel basicModModel = model;
        if (basicModModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type MM");
        }
        return (MM)basicModModel;
    }

    protected boolean modelCanBeAccepted(@NotNull BasicModModel model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        return this.modModelClass.isAssignableFrom(model.getClass());
    }

    protected void initInternalState() {
    }

    protected final void checkNotInitialized() {
        if (this.initialized) {
            throw (Throwable)new IllegalStateException(this.getClass().getSimpleName() + " already initialized");
        }
    }

    @NotNull
    protected MM createNewModel() {
        Object object;
        block3: {
            block2: {
                object = this.modelFactory;
                if (object == null) break block2;
                Rdbms rdbms = this.dbFacade.rdbms();
                Intrinsics.checkExpressionValueIsNotNull((Object)rdbms, (String)"dbFacade.rdbms()");
                if ((object = (BasicModModel)((ModelFactory)object).createModel(rdbms, this.modModelClass)) != null) break block3;
            }
            throw (Throwable)new IllegalStateException("Model Factory is not specified");
        }
        return (MM)object;
    }

    @NotNull
    public MM getModel() {
        MM MM;
        if (this.myModel != null) {
            MM = this.myModel;
            if (MM == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)new IllegalStateException("The introspector is not initialized yet: model is not created");
        }
        return MM;
    }

    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull S schema) {
        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
        return schema.getIntrospectionTimestamp() != null && (Intrinsics.areEqual((Object)((Object)this.options.getSources()), (Object)((Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES)) || this.whetherSourcesActual(schema));
    }

    protected boolean whetherSourcesActual(@NotNull S schema) {
        Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
        Date date = schema.getIntrospectionTimestamp();
        return Intrinsics.areEqual((Object)this.getModel().getSchemaSourcesVersion((BasicSchema)schema), (Object)(date != null ? Long.valueOf(date.getTime()) : null));
    }

    @Override
    public void introspectAuto(BasicNamespace ... namespaces) {
        Intrinsics.checkParameterIsNotNull((Object)namespaces, (String)"namespaces");
        if (!this.initialized) {
            throw (Throwable)new IllegalStateException("Introspector is not initialized yet.");
        }
        int n = ((Object[])namespaces).length;
        ArrayList<BasicNamespace> theNamespaces = new ArrayList<BasicNamespace>(n);
        if (n > 0) {
            for (int j = 0; j < namespaces.length; ++j) {
                BasicNamespace ns = namespaces[j];
                boolean bl = ns.getModel() == this.getModel();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Namespaces must be from this model";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                theNamespaces.add(ns);
            }
        }
        this.dbFacade.inTransaction(new InTransactionNoResult(this, theNamespaces){
            final /* synthetic */ BaseIntrospector this$0;
            final /* synthetic */ ArrayList $theNamespaces;

            public final void run(@NotNull DBTransaction tran) {
                Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
                DBTransaction dBTransaction = tran;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBTransaction, (String)"tran");
                this.this$0.introspectAutoInTran(dBTransaction, this.$theNamespaces);
            }
            {
                this.this$0 = baseIntrospector;
                this.$theNamespaces = arrayList;
            }
        });
    }

    protected abstract void introspectAutoInTran(@NotNull DBTransaction var1, @Nullable Collection<? extends BasicNamespace> var2);

    @Override
    public void introspectNamespaces() {
        if (!this.initialized) {
            throw (Throwable)new IllegalStateException("Introspector is not initialized yet.");
        }
        this.dbFacade.inTransaction(new InTransactionNoResult(this){
            final /* synthetic */ BaseIntrospector this$0;

            public final void run(@NotNull DBTransaction it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DBTransaction dBTransaction = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBTransaction, (String)"it");
                this.this$0.introspectNamespacesInTran(dBTransaction);
            }
            {
                this.this$0 = baseIntrospector;
            }
        });
    }

    protected abstract void introspectNamespacesInTran(@NotNull DBTransaction var1);

    @Override
    public void introspectSessionState() {
        if (!this.initialized) {
            throw (Throwable)new IllegalStateException("Introspector is not initialized yet.");
        }
        this.dbFacade.inTransaction(new InTransactionNoResult(this){
            final /* synthetic */ BaseIntrospector this$0;

            public final void run(@NotNull DBTransaction it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DBTransaction dBTransaction = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)dBTransaction, (String)"it");
                this.this$0.introspectSessionState(dBTransaction);
            }
            {
                this.this$0 = baseIntrospector;
            }
        });
    }

    protected void introspectSessionState(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
    }

    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        Intrinsics.checkParameterIsNotNull((Object)namespace, (String)"namespace");
        Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"objectKind");
        Intrinsics.checkParameterIsNotNull((Object)objectNames, (String)"objectNames");
    }

    protected final void postIntrospectionProcess() {
        this.getModel().modify(BasicModRoot.class, (ModelModifier<BasicModRoot>)new ModelModifier<BasicModRoot>(this){
            final /* synthetic */ BaseIntrospector this$0;

            public final void perform(BasicModRoot r) {
                BasicModRoot basicModRoot = r;
                Intrinsics.checkExpressionValueIsNotNull((Object)basicModRoot, (String)"r");
                this.this$0.postIntrospectionProcessWithModel(basicModRoot);
            }
            {
                this.this$0 = baseIntrospector;
            }
        });
    }

    protected final void postIntrospectionProcessWithModel(@NotNull BasicModRoot root2) {
        Intrinsics.checkParameterIsNotNull((Object)root2, (String)"root");
        for (BasicModSchema basicModSchema : root2.getAllSchemas()) {
            BaseIntrospectionFunctions.derefAll(basicModSchema);
        }
    }

    protected final void updateStatus(@NotNull String status, @NotNull String details) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            ProgressIndicator progressIndicator2 = this.progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText(status);
            }
            ProgressIndicator progressIndicator3 = this.progressIndicator;
            if (progressIndicator3 == null) break block2;
            progressIndicator3.setText2(StringUtil.capitalize((String)Case.LOWER.apply(details)));
        }
    }

    protected final void writeSources(@NotNull Function0<Unit> r) {
        Intrinsics.checkParameterIsNotNull(r, (String)"r");
        this.getModel().writeSources(new Runnable(r){
            final /* synthetic */ Function0 $r;

            public final void run() {
                this.$r.invoke();
            }
            {
                this.$r = function0;
            }
        });
    }

    protected BaseIntrospector(@NotNull DBFacade dbFacade, @NotNull Class<MM> modModelClass, @NotNull Class<MR> modRootClass, @NotNull Class<MS> modSchemaClass) {
        Intrinsics.checkParameterIsNotNull((Object)dbFacade, (String)"dbFacade");
        Intrinsics.checkParameterIsNotNull(modModelClass, (String)"modModelClass");
        Intrinsics.checkParameterIsNotNull(modRootClass, (String)"modRootClass");
        Intrinsics.checkParameterIsNotNull(modSchemaClass, (String)"modSchemaClass");
        this.queryParameters = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        this.dbFacade = dbFacade;
        this.modModelClass = modModelClass;
        this.modRootClass = modRootClass;
        this.modSchemaClass = modSchemaClass;
        this.options = BaseIntrospectionFunctions.DEFAULT_OPTIONS;
        Version version = Version.ZERO;
        if (version == null) {
            Intrinsics.throwNpe();
        }
        this.serverVersion = version;
        Version version2 = Version.ZERO;
        if (version2 == null) {
            Intrinsics.throwNpe();
        }
        this.driverVersion = version2;
        this.myConsiderSystemSchemasReinstrospection = BaseIntrospectionFunctions.stringToBoolean(System.getProperty("dbe.always.reintrospect.system.schemas"));
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u00a4\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\u001f\u0010\u001c\u001a\u00020\u001d2\u0014\b\u0004\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001d0\u001fH\u0084\bJ\r\u0010 \u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b!J!\u0010\"\u001a\u0002H#\"\u0004\b\u0004\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%H\u0004\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u001dH\u0014J\b\u0010(\u001a\u00020\u001dH&J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u0011H\u0014J\u001a\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u00112\b\u0010-\u001a\u0004\u0018\u00010\u0012H\u0004R\u0016\u0010\u0005\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR<\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010@BX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006."}, d2={"Lcom/intellij/database/introspection/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/sql/Evaluator;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "model", "getModel", "()Lcom/intellij/database/model/basic/BasicModModel;", "Lcom/intellij/database/model/basic/BasicModModel;", "<set-?>", "Lcom/intellij/sql/CommonPreprocessor;", "preprocessor", "getPreprocessor", "()Lcom/intellij/sql/CommonPreprocessor;", "setPreprocessor", "(Lcom/intellij/sql/CommonPreprocessor;)V", "", "", "", "queryParameters", "getQueryParameters", "()Ljava/util/Map;", "setQueryParameters", "(Ljava/util/Map;)V", "getTransaction", "()Lorg/jetbrains/dekaf/core/DBTransaction;", "evaluate", "expression", "inModel", "", "modifier", "Lkotlin/Function1;", "init", "init$database_introspection", "performQuery", "R", "query", "Lorg/jetbrains/dekaf/sql/SqlQuery;", "(Lorg/jetbrains/dekaf/sql/SqlQuery;)Ljava/lang/Object;", "prepareParameters", "process", "reportRetrieving", "what", "setQueryParameter", "name", "value", "database-introspection"})
    protected abstract class AbstractRetriever
    implements Evaluator {
        @NotNull
        private final MM model;
        @NotNull
        private final DBTransaction transaction;
        @NotNull
        private Map<String, Object> queryParameters;
        @NotNull
        private CommonPreprocessor preprocessor;

        @NotNull
        protected final MM getModel() {
            return this.model;
        }

        @NotNull
        protected final DBTransaction getTransaction() {
            return this.transaction;
        }

        @NotNull
        protected final Map<String, Object> getQueryParameters() {
            Map<String, Object> map = this.queryParameters;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queryParameters");
            }
            return map;
        }

        private final void setQueryParameters(Map<String, Object> map) {
            this.queryParameters = map;
        }

        @NotNull
        protected final CommonPreprocessor getPreprocessor() {
            CommonPreprocessor commonPreprocessor = this.preprocessor;
            if (commonPreprocessor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preprocessor");
            }
            return commonPreprocessor;
        }

        private final void setPreprocessor(CommonPreprocessor commonPreprocessor) {
            this.preprocessor = commonPreprocessor;
        }

        public void init$database_introspection() {
            this.queryParameters = new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
            this.preprocessor = new CommonPreprocessor(true, this);
            Map<String, Object> map = this.queryParameters;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queryParameters");
            }
            map.putAll(BaseIntrospector.this.queryParameters);
            this.prepareParameters();
        }

        protected void prepareParameters() {
        }

        protected final void inModel(@NotNull Function1<? super MR, Unit> modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, (String)"modifier");
            this.model.modify(BaseIntrospector.this.modRootClass, new ModelModifier<MR>(modifier){
                final /* synthetic */ Function1 $modifier;

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    this.$modifier.invoke(MR);
                }
                {
                    this.$modifier = function1;
                }
            });
        }

        public abstract void process();

        protected final void setQueryParameter(@NotNull String name, @Nullable Object value) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            if (value != null) {
                Map<String, Object> map = this.queryParameters;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"queryParameters");
                }
                map.put(name, value);
            } else {
                Map<String, Object> map = this.queryParameters;
                if (map == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"queryParameters");
                }
                map.remove(name);
            }
        }

        @Override
        @Nullable
        public Object evaluate(@NotNull String expression) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            Map<String, Object> map = this.queryParameters;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queryParameters");
            }
            return map.get(expression);
        }

        protected final <R> R performQuery(@NotNull SqlQuery<R> query) {
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            CommonPreprocessor commonPreprocessor = this.preprocessor;
            if (commonPreprocessor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preprocessor");
            }
            SqlQuery preprocessedQuery = query.rewrite((StringOperator)commonPreprocessor);
            DBQueryRunner dBQueryRunner = this.transaction.query(preprocessedQuery);
            CommonPreprocessor commonPreprocessor2 = this.preprocessor;
            if (commonPreprocessor2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"preprocessor");
            }
            Object[] objectArray = commonPreprocessor2.getBindableParameters();
            return (R)dBQueryRunner.withParams(Arrays.copyOf(objectArray, objectArray.length)).run();
        }

        protected void reportRetrieving(@NotNull String what) {
            Intrinsics.checkParameterIsNotNull((Object)what, (String)"what");
            BaseIntrospector.this.updateStatus("Introspecting database", what);
        }

        public AbstractRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            this.model = BaseIntrospector.this.getModel();
            this.transaction = transaction;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0002B\u000f\b\u0014\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/database/introspection/BaseIntrospector$DatabaseRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;)V", "database-introspection"})
    protected abstract class DatabaseRetriever
    extends AbstractRetriever {
        protected DatabaseRetriever(DBTransaction transaction) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            super(transaction);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010/\u001a\u000200H\u0014J\b\u00101\u001a\u000200H\u0014J\b\u00102\u001a\u000200H\u0014J\b\u00103\u001a\u000200H\u0014J\u001f\u00104\u001a\u0002002\u0014\b\u0004\u00105\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020006H\u0084\bJ\b\u00107\u001a\u000200H\u0014J\b\u00108\u001a\u000200H\u0016J\u0006\u00109\u001a\u000200J\u0006\u0010:\u001a\u000200J\b\u0010;\u001a\u000200H\u0014J\b\u0010<\u001a\u000200H\u0014J\u0010\u0010=\u001a\u0002002\u0006\u0010>\u001a\u00020?H\u0015J\u0010\u0010=\u001a\u0002002\u0006\u0010@\u001a\u00020AH\u0005R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011X\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010\u0005\u001a\u00028\u0002X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R\u001a\u0010&\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001b\"\u0004\b(\u0010\u001dR\u001a\u0010)\u001a\u00020*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006B"}, d2={"Lcom/intellij/database/introspection/BaseIntrospector$SchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$AbstractRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicSchema;)V", "mode", "Lcom/intellij/database/introspection/IntrospectionMode;", "(Lcom/intellij/database/introspection/BaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/basic/BasicSchema;Lcom/intellij/database/introspection/IntrospectionMode;)V", "fragmentKind", "Lcom/intellij/database/model/ObjectKind;", "getFragmentKind", "()Lcom/intellij/database/model/ObjectKind;", "setFragmentKind", "(Lcom/intellij/database/model/ObjectKind;)V", "fragmentNames", "", "", "getFragmentNames", "()[Ljava/lang/String;", "setFragmentNames", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "fromTimestamp", "Ljava/sql/Timestamp;", "getFromTimestamp", "()Ljava/sql/Timestamp;", "setFromTimestamp", "(Ljava/sql/Timestamp;)V", "introspectionBeginTimestamp", "getIntrospectionBeginTimestamp", "setIntrospectionBeginTimestamp", "getMode", "()Lcom/intellij/database/introspection/IntrospectionMode;", "getSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "Lcom/intellij/database/model/basic/BasicSchema;", "sourcesSince", "getSourcesSince", "setSourcesSince", "withSources", "", "getWithSources", "()Z", "setWithSources", "(Z)V", "analyzeBriefInfo", "", "analyzeCurrentContent", "clearSchema", "finishSchema", "inSchema", "modifier", "Lkotlin/Function1;", "prepareParameters", "process", "processMainPhase", "processPreliminaryPhase", "retrieveMainContent", "retrieveMajorNames", "work", "runnable", "Ljava/lang/Runnable;", "block", "Lorg/jetbrains/dekaf/core/InTransactionNoResult;", "database-introspection"})
    protected abstract class SchemaRetriever
    extends AbstractRetriever {
        @NotNull
        private final S schema;
        @NotNull
        private final IntrospectionMode mode;
        private boolean withSources;
        @NotNull
        private ObjectKind fragmentKind;
        @NotNull
        private String[] fragmentNames;
        @NotNull
        private Timestamp fromTimestamp;
        @NotNull
        private Timestamp sourcesSince;
        @Nullable
        private Timestamp introspectionBeginTimestamp;
        final /* synthetic */ BaseIntrospector this$0;

        @NotNull
        protected final S getSchema() {
            return this.schema;
        }

        @NotNull
        protected final IntrospectionMode getMode() {
            return this.mode;
        }

        protected final boolean getWithSources() {
            return this.withSources;
        }

        protected final void setWithSources(boolean bl) {
            this.withSources = bl;
        }

        @NotNull
        protected final ObjectKind getFragmentKind() {
            return this.fragmentKind;
        }

        protected final void setFragmentKind(@NotNull ObjectKind objectKind) {
            Intrinsics.checkParameterIsNotNull((Object)objectKind, (String)"<set-?>");
            this.fragmentKind = objectKind;
        }

        @NotNull
        protected final String[] getFragmentNames() {
            return this.fragmentNames;
        }

        protected final void setFragmentNames(@NotNull String[] stringArray) {
            Intrinsics.checkParameterIsNotNull((Object)stringArray, (String)"<set-?>");
            this.fragmentNames = stringArray;
        }

        @NotNull
        protected final Timestamp getFromTimestamp() {
            return this.fromTimestamp;
        }

        protected final void setFromTimestamp(@NotNull Timestamp timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"<set-?>");
            this.fromTimestamp = timestamp;
        }

        @NotNull
        protected final Timestamp getSourcesSince() {
            return this.sourcesSince;
        }

        protected final void setSourcesSince(@NotNull Timestamp timestamp) {
            Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"<set-?>");
            this.sourcesSince = timestamp;
        }

        @Nullable
        protected final Timestamp getIntrospectionBeginTimestamp() {
            return this.introspectionBeginTimestamp;
        }

        protected final void setIntrospectionBeginTimestamp(@Nullable Timestamp timestamp) {
            this.introspectionBeginTimestamp = timestamp;
        }

        @Override
        protected void prepareParameters() {
            super.prepareParameters();
            this.getQueryParameters().putAll(this.this$0.queryParameters);
            this.setQueryParameter("SCHEMA_NAME", this.schema instanceof BasicNamedElement ? this.schema.getRealName() : (String)null);
            this.setQueryParameter("SCHEMA_ID", this.schema instanceof BasicIdentifiedElement && ((BasicIdentifiedElement)this.schema).getObjectId() != 0L ? Long.valueOf(((BasicIdentifiedElement)this.schema).getObjectId()) : (Long)null);
            String string = this.mode.code;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mode.code");
            this.setQueryParameter(string, Boolean.TRUE);
            this.setQueryParameter("SINCE", this.fromTimestamp);
        }

        protected final void inSchema(@NotNull Function1<? super MS, Unit> modifier) {
            Intrinsics.checkParameterIsNotNull(modifier, (String)"modifier");
            this.getModel().modify((BasicElement)this.schema, this.this$0.modSchemaClass, new ModelModifier<MS>(modifier){
                final /* synthetic */ Function1 $modifier;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    this.$modifier.invoke(MS);
                }
                {
                    this.$modifier = function1;
                }
            });
        }

        @Override
        public void process() {
            this.processPreliminaryPhase();
            this.processMainPhase();
        }

        public final void processPreliminaryPhase() {
            if (this.mode.fragment) {
                return;
            }
            this.analyzeBriefInfo();
            if (this.mode.increment) {
                this.analyzeCurrentContent();
            } else {
                this.clearSchema();
                this.retrieveMajorNames();
            }
        }

        public final void processMainPhase() {
            this.retrieveMainContent();
            this.finishSchema();
        }

        @Deprecated(message="use inModel,inSchema instead", replaceWith=@ReplaceWith(expression="inSchema", imports={}))
        protected void work(@NotNull Runnable runnable) {
            Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
            this.getModel().modify(BasicModRoot.class, (ModelModifier<BasicModRoot>)new ModelModifier<BasicModRoot>(runnable){
                final /* synthetic */ Runnable $runnable;

                public final void perform(BasicModRoot r) {
                    this.$runnable.run();
                }
                {
                    this.$runnable = runnable;
                }
            });
        }

        @Deprecated(message="use inModel,inSchema instead", replaceWith=@ReplaceWith(expression="inSchema", imports={}))
        protected final void work(@NotNull InTransactionNoResult block) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            this.getModel().modify(BasicModRoot.class, (ModelModifier<BasicModRoot>)new ModelModifier<BasicModRoot>(this, block){
                final /* synthetic */ SchemaRetriever this$0;
                final /* synthetic */ InTransactionNoResult $block;

                public final void perform(BasicModRoot r) {
                    this.$block.run(this.this$0.getTransaction());
                }
                {
                    this.this$0 = schemaRetriever;
                    this.$block = inTransactionNoResult;
                }
            });
        }

        protected void analyzeBriefInfo() {
        }

        protected void analyzeCurrentContent() {
        }

        protected void retrieveMajorNames() {
        }

        protected void retrieveMainContent() {
        }

        protected void finishSchema() {
            if (this.withSources) {
                Timestamp timestamp = this.introspectionBeginTimestamp;
                this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, timestamp != null ? Long.valueOf(timestamp.getTime()) : Long.valueOf(0L));
            }
        }

        protected void clearSchema() {
            this.getModel().modify((BasicElement)((BasicElement)this.schema), BasicModSchema.class, clearSchema.1.INSTANCE);
            this.getModel().setSchemaSourcesVersion((BasicSchema)this.schema, null);
        }

        public SchemaRetriever(@NotNull DBTransaction transaction, S schema) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            this($outer, transaction, (BasicSchema)schema, schema.hasChildren() && $outer.isPossibleToIntrospectSchemaIncrementally(schema) ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL);
        }

        /*
         * WARNING - Possible parameter corruption
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public SchemaRetriever(@NotNull DBTransaction transaction, @NotNull S schema, IntrospectionMode mode) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull(schema, (String)"schema");
            Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
            super(transaction);
            this.this$0 = $outer;
            v0 = ObjectKind.NONE;
            if (v0 == null) {
                Intrinsics.throwNpe();
            }
            this.fragmentKind = v0;
            var7_5 = this;
            var8_6 = new String[0];
            var7_5.fragmentNames = (String[])var8_6;
            this.fromTimestamp = BaseIntrospectionFunctions.AGES_AGO;
            this.sourcesSince = BaseIntrospectionFunctions.AGES_AGO;
            this.schema = schema;
            this.mode = mode;
            this.withSources = $outer.getOptions().getSources().compareTo((Enum)DBIntrospectionOptions.SourceLoading.USER_SOURCES) >= 0;
            lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
            this.fromTimestamp = mode.increment != false && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : BaseIntrospectionFunctions.AGES_AGO;
            existentSourcesVersion = this.getModel().getSchemaSourcesVersion((BasicSchema)schema);
            if (!mode.increment) ** GOTO lbl-1000
            v1 = existentSourcesVersion;
            if (v1 == null) {
                v1 = 0L;
            }
            if (Intrinsics.compare((long)v1, (long)0) > 0) {
                v2 = existentSourcesVersion;
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                v3 = new Timestamp(v2);
            } else lbl-1000:
            // 2 sources

            {
                v3 = BaseIntrospectionFunctions.AGES_AGO;
            }
            this.sourcesSince = v3;
        }
    }
}

