/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.introspection.GenericIntrospectorLegacyModelUtils;
import com.intellij.database.introspection.jdbcMetadataWrappers.ClosableIt;
import com.intellij.database.introspection.jdbcMetadataWrappers.DatabaseMetaDataWrapper;
import com.intellij.database.introspection.jdbcMetadataWrappers.MetaDataUtil;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModColumn;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModForeignKey;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModKey;
import com.intellij.database.model.basic.BasicModLikeTable;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModNamespace;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.JdbcTableType;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;

class GenericIntrospectorHelper {
    private final BasicModModel myModel;
    private final DatabaseFamilyId myFamilyId;
    private final boolean mySchemaDbMode;
    private final Map<BasicModElement, String> myProcSpecNames;

    public GenericIntrospectorHelper(@NotNull BasicModModel model, @NotNull Rdbms rdbms) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/introspection/GenericIntrospectorHelper", "<init>"));
        }
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/introspection/GenericIntrospectorHelper", "<init>"));
        }
        this.myProcSpecNames = ContainerUtil.newHashMap();
        this.myModel = model;
        this.myFamilyId = (DatabaseFamilyId)ObjectUtils.chooseNotNull((Object)GenericIntrospectorLegacyModelUtils.findFamily(rdbms), (Object)DatabaseFamilyId.UNKNOWN);
        this.mySchemaDbMode = GenericIntrospectorLegacyModelUtils.isSchemaDbMode(this.myModel, this.myFamilyId);
    }

    @NotNull
    public BasicModModel getModel() {
        BasicModModel basicModModel = this.myModel;
        if (basicModModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospectorHelper", "getModel"));
        }
        return basicModModel;
    }

    @Nullable
    public BasicModNamespace getDatabase(@NotNull BasicModSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospectorHelper", "getDatabase"));
        }
        if (this.mySchemaDbMode) {
            return schema;
        }
        BasicElement parent = schema.getDbParent();
        return parent != null && parent.getKind() == ObjectKind.DATABASE ? (BasicModNamespace)parent : null;
    }

    @NotNull
    public DatabaseMetaDataWrapper.Schema asSchema(@NotNull BasicModSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospectorHelper", "asSchema"));
        }
        BasicModNamespace database = this.getDatabase(schema);
        String databaseName = database == null ? null : database.getName();
        DatabaseMetaDataWrapper.Schema schema2 = this.mySchemaDbMode ? new DatabaseMetaDataWrapper.Schema(StringUtil.notNullize((String)databaseName), StringUtil.nullize((String)schema.getName())) : new DatabaseMetaDataWrapper.Schema(schema.getName(), databaseName);
        if (schema2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospectorHelper", "asSchema"));
        }
        return schema2;
    }

    @NotNull
    public DatabaseMetaDataWrapper.Table asTable(@NotNull BasicModLikeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospectorHelper", "asTable"));
        }
        DatabaseMetaDataWrapper.Table table2 = new DatabaseMetaDataWrapper.Table(this.asSchema((BasicModSchema)table.getDbParent()), table.getName());
        if (table2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospectorHelper", "asTable"));
        }
        return table2;
    }

    public void createTable(@NotNull BasicModSchema schema, @NotNull DatabaseMetaDataWrapper.Table table) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospectorHelper", "createTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospectorHelper", "createTable"));
        }
        ObjectKind kind = JdbcTableType.findByName(table.type).getKind();
        ModNamingFamily tables = GenericIntrospectorLegacyModelUtils.familyOf(schema, kind);
        if (tables == null) {
            tables = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.TABLE);
        }
        if (tables == null) {
            return;
        }
        Object res = tables.createOrGet(table.name);
        res.setComment(table.comment);
    }

    public void createKeys(@NotNull BasicModLikeTable table, @NotNull ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn> keyIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospectorHelper", "createKeys"));
        }
        if (keyIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyIt", "com/intellij/database/introspection/GenericIntrospectorHelper", "createKeys"));
        }
        DatabaseMetaDataWrapper.TableKey storedKey = new DatabaseMetaDataWrapper.TableKey(this.asTable(table), null);
        for (DatabaseMetaDataWrapper.TableKey key : JBIterable.once(keyIt)) {
            storedKey.assign(key);
            this.createKey(table, key, (Iterator<DatabaseMetaDataWrapper.TableKeyColumn>)keyIt.groupIt());
        }
    }

    public void createKey(@NotNull BasicModLikeTable table, @NotNull DatabaseMetaDataWrapper.TableKey key, @NotNull Iterator<DatabaseMetaDataWrapper.TableKeyColumn> keyColumnIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospectorHelper", "createKey"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/introspection/GenericIntrospectorHelper", "createKey"));
        }
        if (keyColumnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyColumnIt", "com/intellij/database/introspection/GenericIntrospectorHelper", "createKey"));
        }
        ModNamingFamily keys = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.KEY);
        if (keys == null) {
            return;
        }
        BasicModKey res = (BasicModKey)keys.createOrGet(StringUtil.notNullize((String)key.name));
        TreeMap columns = ContainerUtil.newTreeMap();
        res.setPrimary(key.primary);
        for (DatabaseMetaDataWrapper.TableKeyColumn col : JBIterable.once(keyColumnIt)) {
            columns.put(col.position, col.name);
        }
        res.setColNames(ArrayUtil.toStringArray(columns.values()));
        res.setNameSurrogate(this.isSurrogate(key));
    }

    public void createRoutine(@NotNull BasicModSchema schema, @NotNull DatabaseMetaDataWrapper.Routine routine2) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospectorHelper", "createRoutine"));
        }
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/introspection/GenericIntrospectorHelper", "createRoutine"));
        }
        String pkg = this.getRealPackage(routine2);
        BasicModElement parent = pkg == null ? schema : GenericIntrospectorHelper.getOrCreatePackage(schema, pkg);
        ModNamingFamily routines = GenericIntrospectorLegacyModelUtils.familyOf(parent, ObjectKind.ROUTINE);
        if (routines == null) {
            return;
        }
        Object procedure = this.getOrCreateRoutineBySpecName(routines, routine2.name, routine2.specificName);
        ((BasicModRoutine)procedure).setRoutineKind(routine2.kind);
        procedure.setComment(routine2.comment);
    }

    public void createColumns(@Nullable BasicModLikeTable table, @NotNull Iterator<DatabaseMetaDataWrapper.TableColumn> columnIt) {
        if (columnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIt", "com/intellij/database/introspection/GenericIntrospectorHelper", "createColumns"));
        }
        if (table == null) {
            return;
        }
        for (DatabaseMetaDataWrapper.TableColumn column : JBIterable.once(columnIt)) {
            this.createColumn(table, column);
        }
    }

    public void createColumn(@NotNull BasicModLikeTable table, @NotNull DatabaseMetaDataWrapper.TableColumn col) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospectorHelper", "createColumn"));
        }
        if (col == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "col", "com/intellij/database/introspection/GenericIntrospectorHelper", "createColumn"));
        }
        ModNamingFamily columns = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.COLUMN);
        if (columns == null) {
            return;
        }
        BasicModColumn column = (BasicModColumn)columns.createOrGet(StringUtil.notNullize((String)col.name));
        column.setComment(col.comment);
        column.setPosition((short)col.position);
        column.setDataType(DataTypeFactory.of(null, StringUtil.notNullize((String)col.typeName), col.length, col.scale, null, null, false, false, col.type));
        column.setNotNull(!col.nullable);
        column.setDefaultExpression(GenericIntrospectorLegacyModelUtils.fixDefaultValue(this.myFamilyId, column, col.def));
        if (col.autoIncrement) {
            column.setSequenceIdentity(GenericIntrospectorLegacyModelUtils.SEQUENCE_IDENTITY);
        }
    }

    @Nullable
    public BasicModSchema createSchema(@NotNull DatabaseMetaDataWrapper.Schema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospectorHelper", "createSchema"));
        }
        ModNamingFamily curFamily = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.myModel.getRoot()), ObjectKind.DATABASE);
        if (curFamily != null) {
            BasicModDatabase db = (BasicModDatabase)curFamily.createOrGet(StringUtil.notNullize((String)schema.database));
            return (BasicModSchema)db.getSchemas().createOrGet(schema.schema);
        }
        curFamily = GenericIntrospectorLegacyModelUtils.familyOf((BasicModElement)((Object)this.myModel.getRoot()), ObjectKind.SCHEMA);
        if (curFamily != null) {
            return (BasicModSchema)curFamily.createOrGet(this.mySchemaDbMode ? StringUtil.notNullize((String)schema.database) : schema.schema);
        }
        return null;
    }

    public void createIndices(@NotNull BasicModLikeTable table, @NotNull ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn> indexColumnIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospectorHelper", "createIndices"));
        }
        if (indexColumnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexColumnIt", "com/intellij/database/introspection/GenericIntrospectorHelper", "createIndices"));
        }
        DatabaseMetaDataWrapper.TableIndex storedIdx = new DatabaseMetaDataWrapper.TableIndex(new DatabaseMetaDataWrapper.Table(this.asSchema((BasicModSchema)table.getDbParent()), table.getName()), "");
        for (DatabaseMetaDataWrapper.TableIndex idx : JBIterable.once(indexColumnIt)) {
            storedIdx.assign(idx);
            this.createIndex(table, storedIdx, (Iterator<DatabaseMetaDataWrapper.TableIndexColumn>)indexColumnIt.groupIt());
        }
    }

    private void createIndex(@NotNull BasicModLikeTable table, @NotNull DatabaseMetaDataWrapper.TableIndex idx, @NotNull Iterator<DatabaseMetaDataWrapper.TableIndexColumn> columnIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospectorHelper", "createIndex"));
        }
        if (idx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idx", "com/intellij/database/introspection/GenericIntrospectorHelper", "createIndex"));
        }
        if (columnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIt", "com/intellij/database/introspection/GenericIntrospectorHelper", "createIndex"));
        }
        ModNamingFamily indices = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.INDEX);
        if (indices == null) {
            return;
        }
        TreeMap columns = ContainerUtil.newTreeMap();
        LinkedHashSet rev = ContainerUtil.newLinkedHashSet();
        for (DatabaseMetaDataWrapper.TableIndexColumn column : JBIterable.once(columnIt)) {
            columns.put(column.position, column.name);
            if (column.sorting != DasIndex.Sorting.DESCENDING) continue;
            rev.add(column.name);
        }
        BasicModIndex index = (BasicModIndex)indices.createOrGet(StringUtil.notNullize((String)idx.name));
        index.setUnique(!idx.nonUnique);
        index.setColNames(ContainerUtil.newArrayList(columns.values()));
        index.setReverseColNames(rev);
        index.setNameSurrogate(this.isSurrogate(idx));
        List<String> names = index.getColNames();
        BasicKey key = (BasicKey)JBIterable.from((Iterable)table.getKeys()).filter(k -> k.getColNames().equals(names)).first();
        if (key != null && key.getUnderlyingIndexName() == null) {
            index.drop();
        } else {
            for (BasicForeignKey foreignKey : table.getForeignKeys()) {
                if (!foreignKey.getColNames().equals(names)) continue;
                index.drop();
                break;
            }
        }
    }

    public void createForeignKeys(@NotNull BasicModLikeTable table, @NotNull ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableFKey, DatabaseMetaDataWrapper.TableFKeyColumn> fkColumnIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospectorHelper", "createForeignKeys"));
        }
        if (fkColumnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fkColumnIt", "com/intellij/database/introspection/GenericIntrospectorHelper", "createForeignKeys"));
        }
        DatabaseMetaDataWrapper.TableFKey storedFkey = new DatabaseMetaDataWrapper.TableFKey(new DatabaseMetaDataWrapper.Table(new DatabaseMetaDataWrapper.Schema("", null), ""), new DatabaseMetaDataWrapper.Table(new DatabaseMetaDataWrapper.Schema("", null), ""), "");
        for (DatabaseMetaDataWrapper.TableFKey fkey : JBIterable.once(fkColumnIt)) {
            storedFkey.assign(fkey);
            this.createForeignKey(table, fkey, (Iterator<DatabaseMetaDataWrapper.TableFKeyColumn>)fkColumnIt.groupIt());
        }
    }

    public void createForeignKey(@NotNull BasicModLikeTable table, @NotNull DatabaseMetaDataWrapper.TableFKey key, @NotNull Iterator<DatabaseMetaDataWrapper.TableFKeyColumn> columnIt) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/introspection/GenericIntrospectorHelper", "createForeignKey"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/introspection/GenericIntrospectorHelper", "createForeignKey"));
        }
        if (columnIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnIt", "com/intellij/database/introspection/GenericIntrospectorHelper", "createForeignKey"));
        }
        ModNamingFamily foreignKeys = GenericIntrospectorLegacyModelUtils.familyOf(table, ObjectKind.FOREIGN_KEY);
        if (foreignKeys == null) {
            return;
        }
        BasicModForeignKey foreignKey = (BasicModForeignKey)foreignKeys.createOrGet(StringUtil.notNullize((String)key.name));
        foreignKey.setOnUpdate(GenericIntrospectorLegacyModelUtils.asCascadeRule(JdbcUtil.getRuleAction((short)key.updateRule), true));
        foreignKey.setOnDelete(GenericIntrospectorLegacyModelUtils.asCascadeRule(JdbcUtil.getRuleAction((short)key.deleteRule), false));
        DasForeignKey.Deferrability deferrability = JdbcUtil.getDeferrability((short)key.deferrability);
        foreignKey.setDeferrable(deferrability != DasForeignKey.Deferrability.NOT_DEFERRABLE);
        foreignKey.setInitiallyDeferred(deferrability == DasForeignKey.Deferrability.INITIALLY_DEFERRED);
        TreeMap columns = ContainerUtil.newTreeMap();
        for (DatabaseMetaDataWrapper.TableFKeyColumn column : JBIterable.once(columnIt)) {
            columns.put(column.position, Pair.create((Object)column.name, (Object)column.targetName));
        }
        ArrayList sCols = ContainerUtil.newArrayList();
        ArrayList tCols = ContainerUtil.newArrayList();
        for (Pair column : columns.values()) {
            sCols.add(column.first);
            tCols.add(column.second);
        }
        foreignKey.setRefSchemaName(this.mySchemaDbMode ? key.targetTable.schema.database : key.targetTable.schema.schema);
        foreignKey.setRefTableName(key.targetTable.name);
        foreignKey.setRefColNames(tCols);
        foreignKey.setColNames(sCols);
        foreignKey.setNameSurrogate(key.surrogateName || this.isSurrogate(key));
        GenericIntrospectorLegacyModelUtils.resolveKey(foreignKey);
    }

    public void createArguments(@Nullable BasicModRoutine procedure, @NotNull Iterator<DatabaseMetaDataWrapper.RoutineArgument> argumentIt) {
        if (argumentIt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentIt", "com/intellij/database/introspection/GenericIntrospectorHelper", "createArguments"));
        }
        if (procedure == null) {
            return;
        }
        for (DatabaseMetaDataWrapper.RoutineArgument argument : JBIterable.once(argumentIt)) {
            this.createArgument(procedure, argument);
        }
    }

    public void createArgument(@NotNull BasicModRoutine procedure, @NotNull DatabaseMetaDataWrapper.RoutineArgument arg) {
        BasicModArgument argument;
        if (procedure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "procedure", "com/intellij/database/introspection/GenericIntrospectorHelper", "createArgument"));
        }
        if (arg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/database/introspection/GenericIntrospectorHelper", "createArgument"));
        }
        if (arg.direction == DasArgument.Direction.RETURN) {
            argument = procedure.createOrGetReturnArgument();
            argument.setName(StringUtil.notNullize((String)arg.name, (String)DasUtil.NO_NAME));
        } else {
            ModNamingFamily arguments = GenericIntrospectorLegacyModelUtils.familyOf(procedure, ObjectKind.ARGUMENT);
            if (arguments == null) {
                return;
            }
            argument = (BasicModArgument)arguments.createOrGet(StringUtil.notNullize((String)arg.name));
            argument.setArgumentDirection(arg.direction);
        }
        argument.setDataType(DataTypeFactory.of(null, StringUtil.notNullize((String)arg.typeName), arg.length, arg.scale, null, null, false, false, arg.type));
        argument.setDefaultExpression(arg.def);
        argument.setPosition((short)arg.position);
        argument.setNotNull(!arg.nullable);
    }

    public void setCasing(@Nullable Casing casing) {
        BasicRoot root2 = this.myModel.getRoot();
        if (casing != null && root2 instanceof BasicModRoot) {
            ((BasicModRoot)root2).setDefaultCasing(casing);
        }
    }

    private boolean isSurrogate(@NotNull DatabaseMetaDataWrapper.TableIndex index) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/introspection/GenericIntrospectorHelper", "isSurrogate"));
        }
        return this.isSurrogate(StringUtil.notNullize((String)index.name), ObjectKind.INDEX) || this.myFamilyId.isDb2() && "SYSIBM".equalsIgnoreCase(index.qualifier);
    }

    private boolean isSurrogate(@NotNull DatabaseMetaDataWrapper.TableKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/introspection/GenericIntrospectorHelper", "isSurrogate"));
        }
        return this.isSurrogate(StringUtil.notNullize((String)key.name), ObjectKind.KEY);
    }

    private boolean isSurrogate(@NotNull DatabaseMetaDataWrapper.TableFKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/introspection/GenericIntrospectorHelper", "isSurrogate"));
        }
        return this.isSurrogate(StringUtil.notNullize((String)key.name), ObjectKind.FOREIGN_KEY);
    }

    private boolean isSurrogate(@NotNull String safeName, @NotNull ObjectKind kind) {
        if (safeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "safeName", "com/intellij/database/introspection/GenericIntrospectorHelper", "isSurrogate"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/introspection/GenericIntrospectorHelper", "isSurrogate"));
        }
        if (this.myFamilyId.isSqlite() && safeName.startsWith("sqlite_autoindex_")) {
            return true;
        }
        if (this.myFamilyId.isHsqldb()) {
            return kind == ObjectKind.INDEX && safeName.startsWith("SYS_IDX") || kind == ObjectKind.KEY && safeName.startsWith("SYS_PK") || kind == ObjectKind.FOREIGN_KEY && safeName.startsWith("SYS_FK");
        }
        if (this.myFamilyId.isH2()) {
            return kind == ObjectKind.INDEX && (safeName.startsWith("PRIMARY_KEY_") || safeName.startsWith("CONSTRAINT_INDEX_")) || (kind == ObjectKind.KEY || kind == ObjectKind.FOREIGN_KEY) && safeName.startsWith("CONSTRAINT_");
        }
        if (this.myFamilyId.isDerby() && safeName.matches("SQL\\d{15}")) {
            return true;
        }
        if (this.myFamilyId.isSybase() && safeName.matches("^.*_\\d{5,}$")) {
            return true;
        }
        if (this.myFamilyId.isOracle() && safeName.startsWith("SYS_")) {
            return true;
        }
        if (this.myFamilyId.isMicrosoft()) {
            return kind == ObjectKind.INDEX && safeName.startsWith("PK__") || kind == ObjectKind.KEY && safeName.startsWith("PK__") || kind == ObjectKind.FOREIGN_KEY && safeName.startsWith("FK__");
        }
        return this.myFamilyId.isMysql() && safeName.equals("PRIMARY") && (kind == ObjectKind.INDEX || kind == ObjectKind.KEY);
    }

    @Nullable
    private String getRealPackage(@NotNull DatabaseMetaDataWrapper.Routine routine2) {
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/introspection/GenericIntrospectorHelper", "getRealPackage"));
        }
        if (routine2.pkg == null && this.myFamilyId.isSybase() && routine2.kind == DasRoutine.Kind.PROCEDURE) {
            return routine2.name;
        }
        return routine2.pkg;
    }

    @Nullable
    private static BasicModElement getOrCreatePackage(@NotNull BasicModSchema schema, @NotNull String cat) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/introspection/GenericIntrospectorHelper", "getOrCreatePackage"));
        }
        if (cat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cat", "com/intellij/database/introspection/GenericIntrospectorHelper", "getOrCreatePackage"));
        }
        ModNamingFamily packages = GenericIntrospectorLegacyModelUtils.familyOf(schema, ObjectKind.PACKAGE);
        return packages == null ? null : (BasicModElement)packages.createOrGet(cat);
    }

    @NotNull
    public String getProcName(@NotNull DatabaseMetaDataWrapper.Routine routine2) {
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/introspection/GenericIntrospectorHelper", "getProcName"));
        }
        String string = MetaDataUtil.getProcName(routine2.specificName, this.getRealPackage(routine2));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospectorHelper", "getProcName"));
        }
        return string;
    }

    @NotNull
    public String getSpecName(@NotNull BasicModRoutine routine2) {
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/introspection/GenericIntrospectorHelper", "getSpecName"));
        }
        String string = (String)ContainerUtil.getOrElse(this.myProcSpecNames, (Object)routine2, (Object)routine2.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospectorHelper", "getSpecName"));
        }
        return string;
    }

    @NotNull
    private <T extends BasicModNamedElement> T getOrCreateRoutineBySpecName(@NotNull ModNamingFamily<T> f, @NotNull String name, @NotNull String specName) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/database/introspection/GenericIntrospectorHelper", "getOrCreateRoutineBySpecName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/introspection/GenericIntrospectorHelper", "getOrCreateRoutineBySpecName"));
        }
        if (specName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specName", "com/intellij/database/introspection/GenericIntrospectorHelper", "getOrCreateRoutineBySpecName"));
        }
        BasicModNamedElement res = f.find(x -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/introspection/GenericIntrospectorHelper", "lambda$getOrCreateRoutineBySpecName$1"));
            }
            if (specName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specName", "com/intellij/database/introspection/GenericIntrospectorHelper", "lambda$getOrCreateRoutineBySpecName$1"));
            }
            return x != null && name.equals(x.getName()) && specName.equals(this.myProcSpecNames.get(x));
        });
        if (res == null && (res = f.find(x -> {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/introspection/GenericIntrospectorHelper", "lambda$getOrCreateRoutineBySpecName$2"));
            }
            return x != null && name.equals(x.getName()) && this.myProcSpecNames.get(x) == null;
        })) != null) {
            this.myProcSpecNames.put(res, specName);
        }
        if (res != null) {
            res.resetSyncPending();
        } else {
            res = (BasicModNamedElement)f.createNewOne();
            res.setName(name);
            this.myProcSpecNames.put(res, specName);
        }
        BasicModNamedElement basicModNamedElement = res;
        if (basicModNamedElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospectorHelper", "getOrCreateRoutineBySpecName"));
        }
        return (T)basicModNamedElement;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = this.myFamilyId;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospectorHelper", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public RoutineMap createRoutineMap() {
        RoutineMap routineMap = new RoutineMap();
        if (routineMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/introspection/GenericIntrospectorHelper", "createRoutineMap"));
        }
        return routineMap;
    }

    public boolean isSchemaDbMode() {
        return this.mySchemaDbMode;
    }

    public class RoutineMap {
        private final Map<String, BasicModRoutine> name2Routine = ContainerUtil.newHashMap();

        @Nullable
        public DasRoutine.Kind guessType(DatabaseMetaDataWrapper.Routine r) {
            BasicModRoutine routine2 = this.name2Routine.get(MetaDataUtil.getProcName(r.specificName, r.pkg));
            if (routine2 == null && GenericIntrospectorHelper.this.getFamilyId().isSybase()) {
                routine2 = this.name2Routine.get(MetaDataUtil.getProcName(r.specificName, r.name));
            }
            return routine2 == null ? DasRoutine.Kind.NONE : routine2.getRoutineKind();
        }

        @Nullable
        public BasicModRoutine get(DatabaseMetaDataWrapper.Routine r) {
            return this.name2Routine.get(GenericIntrospectorHelper.this.getProcName(r));
        }

        public void put(@NotNull BasicModRoutine routine2) {
            if (routine2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/introspection/GenericIntrospectorHelper$RoutineMap", "put"));
            }
            this.name2Routine.put(MetaDataUtil.getProcName(GenericIntrospectorHelper.this.getSpecName(routine2), this.getPackage(routine2)), routine2);
        }

        @Nullable
        private String getPackage(BasicModRoutine routine2) {
            BasicElement parent = routine2.getDbParent();
            return parent == null || parent.getKind() != ObjectKind.PACKAGE ? null : parent.getName();
        }
    }
}

