/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.PostgresIntrospectionException;
import com.intellij.database.introspection.PostgresIntrospector;
import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.PositioningFamily;
import com.intellij.database.model.postgres.PostgresModCatalogObject;
import com.intellij.database.model.postgres.PostgresModLikeStoredTable;
import com.intellij.database.model.postgres.PostgresModRoutine;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModSequence;
import com.intellij.database.model.postgres.PostgresModView;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.PostgresCheckOption;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ArrayUtil;
import gnu.trove.TLongHashSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u00d2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0017\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010 H\u0002\u001a\u0012\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0019H\u0002\u001a\u001e\u0010'\u001a\u0004\u0018\u00010\u000e2\b\u0010(\u001a\u0004\u0018\u00010 2\b\u0010)\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\u0014\u0010*\u001a\u0004\u0018\u00010 2\b\u0010#\u001a\u0004\u0018\u00010 H\u0002\u001a\u000e\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020 \u001a\u001a\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010 2\u0006\u00100\u001a\u00020 H\u0002\u001a\u001d\u00101\u001a\b\u0012\u0004\u0012\u00020 0\u00152\b\u0010/\u001a\u0004\u0018\u00010 H\u0002\u00a2\u0006\u0002\u00102\u001a0\u00103\u001a\b\u0012\u0004\u0012\u00020 042\b\u00105\u001a\u0004\u0018\u00010 2\u0006\u00100\u001a\u00020 2\u000e\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020807H\u0002\u001a7\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020;2\"\u0010<\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020>0=0\u0015\"\n\u0012\u0006\b\u0001\u0012\u00020>0=\u00a2\u0006\u0002\u0010?\u001a!\u0010@\u001a\u00020\u00042\u0012\u0010A\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010 \u0018\u00010\u0015H\u0002\u00a2\u0006\u0002\u0010B\u001a\u0010\u0010C\u001a\u00020 2\u0006\u0010D\u001a\u00020 H\u0002\u001a\u0014\u0010E\u001a\u00020F*\u00020F2\u0006\u0010G\u001a\u00020\tH\u0002\u001a(\u0010H\u001a\u00020\u001c*\u00020I2\b\u0010J\u001a\u0004\u0018\u00010 2\b\u0010K\u001a\u0004\u0018\u00010 2\u0006\u0010D\u001a\u00020 H\u0002\u001a\u0016\u0010H\u001a\u00020\u001c*\u00020L2\b\u0010M\u001a\u0004\u0018\u00010 H\u0002\u001a \u0010N\u001a\u0004\u0018\u00010O*\u00020P2\b\b\u0001\u0010Q\u001a\u00020\t2\u0006\u0010R\u001a\u00020SH\u0002\u001a\u0015\u0010T\u001a\u00020%*\u00020U2\u0006\u0010V\u001a\u00020\u0010H\u0082\u0004\u001a\f\u0010W\u001a\u00020 *\u00020 H\u0002\u001a\u001a\u0010X\u001a\u00020\u001c*\u00020Y2\u0006\u0010Z\u001a\u00020S2\u0006\u0010[\u001a\u00020S\"\u0018\u0010\u0000\u001a\f0\u0001\u00a2\u0006\u0002\b\u0002\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"$\u0010\u0013\u001a\u00020\u0014*\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0016\u0018\u00010\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u001a\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u001a\u00a8\u0006\\"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NO_CHARS", "", "POSITION_OF_OID", "", "POSITION_OF_XMIN", "REL_ANY", "", "REL_MAT_VIEW", "REL_TABLE", "REL_VIEW", "SEQUENCE_DEFAULT_MAX", "Ljava/math/BigInteger;", "SEQUENCE_PARAMS_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "goodNameTemplate", "length", "", "", "", "getLength", "([Ljava/lang/Object;)I", "", "([J)I", "assignSequenceParams", "", "sequence", "Lcom/intellij/database/model/postgres/PostgresModSequence;", "sequenceParams", "", "dataTypeOf", "Lcom/intellij/database/model/DataType;", "spec", "isNotEmpty", "", "array", "makeBigInteger", "stringValue", "implicitAssumption", "normalizeDataTypeSpec", "normalizeDefaultExpression", "expression", "parseArrayOfPositions", "", "str", "what", "parseArrayOfStrings", "(Ljava/lang/String;)[Ljava/lang/String;", "peekColNames", "", "columnPositions", "columns", "Lcom/intellij/database/model/families/PositioningFamily;", "Lcom/intellij/database/model/basic/BasicColumn;", "removeDroppedChildren", "existentIds", "Lgnu/trove/TLongHashSet;", "families", "Lcom/intellij/database/model/families/ModIdentifyingFamily;", "Lcom/intellij/database/model/basic/BasicModIdentifiedElement;", "(Lgnu/trove/TLongHashSet;[Lcom/intellij/database/model/families/ModIdentifyingFamily;)V", "stringsToChars", "strings", "([Ljava/lang/String;)[C", "thinkOutFunDelimiter", "text", "appendIfNo", "Ljava/lang/StringBuilder;", "c", "applySourceText", "Lcom/intellij/database/model/postgres/PostgresModRoutine;", "arguments", "result", "Lcom/intellij/database/model/postgres/PostgresModView;", "sourceText", "getTableOrView", "Lcom/intellij/database/model/postgres/PostgresModLikeStoredTable;", "Lcom/intellij/database/model/postgres/PostgresModSchema;", "relKind", "tableId", "", "matches", "", "pattern", "nameToScript", "setObjectIdAndStateNumber", "Lcom/intellij/database/model/postgres/PostgresModCatalogObject;", "objectId", "stateNr", "database-introspection"})
public final class PostgresIntrospectorKt {
    private static final Logger LOG = Logger.getInstance(PostgresIntrospector.class);
    private static final short POSITION_OF_XMIN = -3;
    private static final short POSITION_OF_OID = -2;
    private static final char REL_TABLE = 'r';
    private static final char REL_MAT_VIEW = 'm';
    private static final char REL_VIEW = 'v';
    private static final char REL_ANY = '\u0000';
    private static final char[] NO_CHARS = new char[0];
    private static final Pattern SEQUENCE_PARAMS_PATTERN = Pattern.compile("\\((\\d+),(\\d+),(\\d+),(\\d+),([FfTt])\\)");
    private static final BigInteger SEQUENCE_DEFAULT_MAX = new BigInteger("9223372036854775807");
    private static final Pattern goodNameTemplate = Pattern.compile("^\\p{IsLowercase}[\\p{IsLowercase}0-9_]*$");

    private static final PostgresModLikeStoredTable getTableOrView(@NotNull PostgresModSchema $receiver, char relKind, long tableId) {
        PostgresModLikeStoredTable table;
        char c = relKind;
        if (c == REL_TABLE) {
            table = (PostgresModLikeStoredTable)$receiver.getTables().getByObjectId(tableId);
        } else if (c == REL_MAT_VIEW) {
            table = (PostgresModLikeStoredTable)$receiver.getMatViews().getByObjectId(tableId);
        } else if (c == REL_VIEW) {
            table = (PostgresModLikeStoredTable)$receiver.getViews().getByObjectId(tableId);
        } else if (c == REL_ANY) {
            table = (PostgresModLikeStoredTable)$receiver.getTables().getByObjectId(tableId);
            if (table == null) {
                table = (PostgresModLikeStoredTable)$receiver.getViews().getByObjectId(tableId);
            }
            if (table == null) {
                table = (PostgresModLikeStoredTable)$receiver.getMatViews().getByObjectId(tableId);
            }
        } else {
            table = null;
        }
        return table;
    }

    /*
     * WARNING - void declaration
     */
    public static final void removeDroppedChildren(@NotNull TLongHashSet existentIds, ModIdentifyingFamily<? extends BasicModIdentifiedElement> ... families) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)existentIds, (String)"existentIds");
        Intrinsics.checkParameterIsNotNull(families, (String)"families");
        ArrayList<BasicModIdentifiedElement> objectsToRemove = new ArrayList<BasicModIdentifiedElement>();
        for (n = 0; n < families.length; ++n) {
            ModIdentifyingFamily<? extends BasicModIdentifiedElement> family = families[n];
            for (BasicModIdentifiedElement basicModIdentifiedElement : family) {
                long id = basicModIdentifiedElement.getObjectId();
                if (existentIds.contains(id)) continue;
                objectsToRemove.add(basicModIdentifiedElement);
            }
        }
        IntProgression intProgression = RangesKt.reversed((IntProgression)((IntProgression)CollectionsKt.getIndices((Collection)objectsToRemove)));
        int family = intProgression.getFirst();
        n = intProgression.getLast();
        int n2 = intProgression.getStep();
        int n3 = family;
        int n4 = n;
        if (n2 > 0 ? n3 <= n4 : n3 >= n4) {
            while (true) {
                void i2;
                BasicModElement objectToRemove = (BasicModElement)objectsToRemove.get((int)i2);
                objectToRemove.drop();
                if (i2 == n) break;
                void var3_5 = i2 + n2;
            }
        }
    }

    public static final void setObjectIdAndStateNumber(@NotNull PostgresModCatalogObject $receiver, long objectId, long stateNr) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        $receiver.setObjectId(objectId);
        $receiver.setStateNumber(stateNr);
    }

    private static final DataType dataTypeOf(String spec) {
        String string = PostgresIntrospectorKt.normalizeDataTypeSpec(spec);
        if (string == null) {
            DataType dataType = DataType.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataType.UNKNOWN");
            return dataType;
        }
        String s = string;
        DataType dataType = DataTypeFactory.of(s);
        Intrinsics.checkExpressionValueIsNotNull((Object)dataType, (String)"DataTypeFactory.of(s)");
        return dataType;
    }

    private static final String normalizeDataTypeSpec(String spec) {
        if (spec == null) {
            return null;
        }
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)spec, (String)"character varying", (String)"varchar", (boolean)false, (int)4, null), (String)"character", (String)"char", (boolean)false, (int)4, null), (String)"char(1)", (String)"char", (boolean)false, (int)4, null), (String)"bit(1)", (String)"bit", (boolean)false, (int)4, null), (String)" without time zone", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String normalizeDefaultExpression(@NotNull String expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        return StringsKt.replace$default((String)expression, (String)"::character varying", (String)"", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> peekColNames(String columnPositions, String what, PositioningFamily<? extends BasicColumn> columns) {
        short[] positions = PostgresIntrospectorKt.parseArrayOfPositions(columnPositions, what);
        int n = positions.length;
        ArrayList<String> names = new ArrayList<String>(n);
        int n2 = 0;
        int n3 = n - 1;
        if (n2 <= n3) {
            while (true) {
                void i2;
                short position;
                if ((position = positions[i2]) > 0) {
                    BasicColumn column = columns.getByNaturalPosition(position);
                    if (column != null) {
                        names.add(column.getName());
                    }
                } else if (position < 0) {
                    short s = position;
                    if (s == POSITION_OF_XMIN) {
                        names.add("xmin");
                    } else if (s == POSITION_OF_OID) {
                        names.add("oid");
                    }
                }
                if (i2 == n3) break;
                ++i2;
            }
        }
        return names;
    }

    /*
     * WARNING - void declaration
     */
    private static final short[] parseArrayOfPositions(String str, String what) {
        String[] s = PostgresIntrospectorKt.parseArrayOfStrings(str);
        int n = PostgresIntrospectorKt.getLength(s);
        if (n == 0) {
            return new short[0];
        }
        short[] positions = new short[n];
        try {
            int n2 = 0;
            int n3 = n - 1;
            if (n2 <= n3) {
                while (true) {
                    void i2;
                    positions[i2] = Short.parseShort(s[i2]);
                    if (i2 != n3) {
                        ++i2;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (NumberFormatException nfe) {
            PostgresIntrospectionException postgresIntrospectionException;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Cannot parse %s: '%s'";
            Object[] objectArray = new Object[]{what, str};
            PostgresIntrospectionException postgresIntrospectionException2 = postgresIntrospectionException;
            PostgresIntrospectionException postgresIntrospectionException3 = postgresIntrospectionException;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            postgresIntrospectionException2(string3, nfe);
            throw (Throwable)postgresIntrospectionException3;
        }
        return positions;
    }

    /*
     * WARNING - void declaration
     */
    private static final char[] stringsToChars(String[] strings) {
        if (strings == null || PostgresIntrospectorKt.getLength(strings) == 0) {
            return NO_CHARS;
        }
        int n = PostgresIntrospectorKt.getLength(strings);
        char[] chars = new char[n];
        int n2 = 0;
        int n3 = n - 1;
        if (n2 <= n3) {
            while (true) {
                void i2;
                String s;
                char c = chars[i2] = (s = strings[i2]) != null && s.length() > 0 ? s.charAt(0) : (char)'\u0000';
                if (i2 == n3) break;
                ++i2;
            }
        }
        return chars;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String[] parseArrayOfStrings(String str) {
        List list;
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len == 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)ArrayUtil.EMPTY_STRING_ARRAY, (String)"ArrayUtil.EMPTY_STRING_ARRAY");
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (len >= 2) {
            String string = str;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (string.charAt(0) == '{' && str.charAt(len - 1) == '}') {
                List list2;
                String string2 = str;
                int n2 = 1;
                int n3 = len - 1;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n2, n3);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                CharSequence charSequence = string4;
                String string5 = ",";
                string5 = new Regex(string5);
                n3 = 0;
                int n4 = 2;
                Object var7_20 = null;
                if (var7_20 != null) {
                    throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: split");
                }
                if ((n4 & 2) != 0) {
                    n3 = 0;
                }
                List list3 = string5.split(charSequence, n3);
                if (!list3.isEmpty()) {
                    ListIterator iterator$iv = list3.listIterator(list3.size());
                    while (iterator$iv.hasPrevious()) {
                        String p1 = (String)iterator$iv.previous();
                        CharSequence charSequence2 = p1;
                        if (charSequence2.length() == 0) continue;
                        list2 = CollectionsKt.take((Iterable)list3, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                Collection collection = list2;
                Collection collection2 = collection;
                if (collection2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection2;
                String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
                if (stringArray != null) return (String[])((Object[])stringArray);
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
        }
        String string = str;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        CharSequence charSequence = string;
        Object thisCollection$iv = " ";
        thisCollection$iv = new Regex((String)thisCollection$iv);
        int $i$f$toTypedArray = 0;
        int n5 = 2;
        Object $i$a$1$unknown = null;
        if ($i$a$1$unknown != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: split");
        }
        if ((n5 & 2) != 0) {
            $i$f$toTypedArray = 0;
        }
        List list4 = thisCollection$iv.split(charSequence, $i$f$toTypedArray);
        if (!list4.isEmpty()) {
            ListIterator iterator$iv = list4.listIterator(list4.size());
            while (iterator$iv.hasPrevious()) {
                String p1 = (String)iterator$iv.previous();
                CharSequence charSequence3 = p1;
                if (charSequence3.length() == 0) continue;
                list = CollectionsKt.take((Iterable)list4, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection collection = list;
        Collection collection3 = collection;
        if (collection3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        thisCollection$iv = collection3;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray != null) return (String[])((Object[])stringArray);
        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
    }

    private static final void assignSequenceParams(PostgresModSequence sequence, String sequenceParams) {
        Matcher m = SEQUENCE_PARAMS_PATTERN.matcher(sequenceParams);
        if (m.find()) {
            try {
                BigInteger next = PostgresIntrospectorKt.makeBigInteger(m.group(1), BigInteger.ONE);
                BigInteger min = PostgresIntrospectorKt.makeBigInteger(m.group(2), BigInteger.ONE);
                BigInteger max = PostgresIntrospectorKt.makeBigInteger(m.group(3), SEQUENCE_DEFAULT_MAX);
                BigInteger inc = PostgresIntrospectorKt.makeBigInteger(m.group(4), BigInteger.ONE);
                String string = m.group(5);
                Locale locale = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
                boolean cycled = StringsKt.contains$default((CharSequence)string3, (CharSequence)"t", (boolean)false, (int)2, null);
                sequence.setSequenceIdentity(SequenceIdentity.of(min, next, inc, max));
                sequence.setCycled(cycled);
            }
            catch (Exception e) {
                LOG.info("Unexpected exception when assigning Postgres sequence parameters. The parameters string: " + sequenceParams + ". " + "Exception message: " + e.getMessage(), (Throwable)e);
            }
        } else {
            LOG.debug("Unexpected format of the Postgres sequence parameters string: " + sequenceParams);
        }
    }

    private static final BigInteger makeBigInteger(String stringValue, BigInteger implicitAssumption) {
        if (stringValue == null) {
            return null;
        }
        BigInteger value = new BigInteger(stringValue);
        return Intrinsics.areEqual((Object)value, (Object)implicitAssumption) ? (BigInteger)null : value;
    }

    private static final void applySourceText(@NotNull PostgresModView $receiver, String sourceText) {
        if (sourceText == null || sourceText.length() == 0) {
            $receiver.setSourceText(null);
            return;
        }
        String string = sourceText;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String s = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (s.charAt(s.length() - 1) == ';') {
            string = s;
            int n = 0;
            int n2 = s.length() - 1;
            String string3 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            s = string4;
        }
        s = "CREATE VIEW " + PostgresIntrospectorKt.nameToScript($receiver.getName()) + " AS\n" + s;
        if (Intrinsics.areEqual((Object)((Object)$receiver.getCheckOption()), (Object)((Object)PostgresCheckOption.NONE)) ^ true) {
            s = s + ("\n" + "WITH " + (Object)((Object)$receiver.getCheckOption()) + " CHECK OPTION");
        }
        $receiver.setSourceText(s);
    }

    private static final void applySourceText(@NotNull PostgresModRoutine $receiver, String arguments, String result, String text) {
        String string = $receiver.getRealName();
        if (string == null) {
            string = "???";
        }
        String name = string;
        String language = $receiver.getLanguageName();
        String d = PostgresIntrospectorKt.thinkOutFunDelimiter(text);
        StringBuilder b = new StringBuilder();
        b.append("CREATE FUNCTION ").append(name);
        b.append(" (").append(arguments).append(')');
        if (result != null) {
            b.append(" RETURNS ").append(result);
        }
        PostgresIntrospectorKt.appendIfNo(b, '\n');
        if (language != null) {
            PostgresIntrospectorKt.appendIfNo(b.append("\tLANGUAGE ").append(language), '\n');
        }
        b.append("AS ").append(d);
        if (!StringsKt.startsWith$default((String)text, (String)"\n", (boolean)false, (int)2, null)) {
            PostgresIntrospectorKt.appendIfNo(b, '\n');
        }
        PostgresIntrospectorKt.appendIfNo(b.append(text), '\n');
        PostgresIntrospectorKt.appendIfNo(b.append(d), '\n');
        $receiver.setSourceText(b.toString());
    }

    private static final String thinkOutFunDelimiter(String text) {
        String string;
        StringBuilder stringBuilder;
        String string2;
        char c;
        String d = "$$";
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)d, (boolean)false, (int)2, null)) {
            c = '$';
            string2 = "fun";
            stringBuilder = new StringBuilder();
            string = String.valueOf(c) + string2;
            d = stringBuilder.append(string).append('$').toString();
        }
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)d, (boolean)false, (int)2, null)) {
            c = '$';
            string2 = "function";
            stringBuilder = new StringBuilder();
            string = String.valueOf(c) + string2;
            d = stringBuilder.append(string).append('$').toString();
        }
        return d;
    }

    private static final String nameToScript(@NotNull String $receiver) {
        String string;
        CharSequence charSequence = $receiver;
        Pattern pattern = goodNameTemplate;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"goodNameTemplate");
        if (PostgresIntrospectorKt.matches(charSequence, pattern)) {
            string = $receiver;
        } else {
            char c = '\"';
            String string2 = StringsKt.replace$default((String)$receiver, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = String.valueOf(c) + string2;
            string = stringBuilder.append(string3).append('\"').toString();
        }
        return string;
    }

    private static final boolean matches(@NotNull CharSequence $receiver, Pattern pattern) {
        return pattern.matcher($receiver).matches();
    }

    private static final StringBuilder appendIfNo(@NotNull StringBuilder $receiver, char c) {
        boolean exists;
        int n = $receiver.length();
        boolean bl = exists = n > 0 && $receiver.charAt(n - 1) == c;
        if (!exists) {
            $receiver.append(c);
        }
        return $receiver;
    }

    private static final boolean isNotEmpty(long[] array) {
        return array != null && array.length > 0;
    }

    private static final int getLength(@Nullable Object[] $receiver) {
        return $receiver != null ? $receiver.length : 0;
    }

    private static final int getLength(@Nullable long[] $receiver) {
        return $receiver != null ? $receiver.length : 0;
    }

    public static final /* synthetic */ void access$assignSequenceParams(@NotNull PostgresModSequence sequence, @NotNull String sequenceParams) {
        PostgresIntrospectorKt.assignSequenceParams(sequence, sequenceParams);
    }

    @Nullable
    public static final /* synthetic */ String access$normalizeDataTypeSpec(@Nullable String spec) {
        return PostgresIntrospectorKt.normalizeDataTypeSpec(spec);
    }

    public static final /* synthetic */ char access$getREL_TABLE$p() {
        return REL_TABLE;
    }

    public static final /* synthetic */ char access$getREL_VIEW$p() {
        return REL_VIEW;
    }

    public static final /* synthetic */ char access$getREL_MAT_VIEW$p() {
        return REL_MAT_VIEW;
    }

    @NotNull
    public static final /* synthetic */ char[] access$stringsToChars(@Nullable String[] strings) {
        return PostgresIntrospectorKt.stringsToChars(strings);
    }

    public static final /* synthetic */ boolean access$isNotEmpty(@Nullable long[] array) {
        return PostgresIntrospectorKt.isNotEmpty(array);
    }

    public static final /* synthetic */ int access$getLength$p(@Nullable Object[] $receiver) {
        return PostgresIntrospectorKt.getLength($receiver);
    }

    public static final /* synthetic */ int access$getLength$p(@Nullable long[] $receiver) {
        return PostgresIntrospectorKt.getLength($receiver);
    }

    @Nullable
    public static final /* synthetic */ PostgresModLikeStoredTable access$getTableOrView(@NotNull PostgresModSchema $receiver, char relKind, long tableId) {
        return PostgresIntrospectorKt.getTableOrView($receiver, relKind, tableId);
    }

    public static final /* synthetic */ char access$getREL_ANY$p() {
        return REL_ANY;
    }

    @NotNull
    public static final /* synthetic */ DataType access$dataTypeOf(@Nullable String spec) {
        return PostgresIntrospectorKt.dataTypeOf(spec);
    }

    @NotNull
    public static final /* synthetic */ List access$peekColNames(@Nullable String columnPositions, @NotNull String what, @NotNull PositioningFamily columns) {
        return PostgresIntrospectorKt.peekColNames(columnPositions, what, columns);
    }

    public static final /* synthetic */ void access$applySourceText(@NotNull PostgresModView $receiver, @Nullable String sourceText) {
        PostgresIntrospectorKt.applySourceText($receiver, sourceText);
    }

    public static final /* synthetic */ void access$applySourceText(@NotNull PostgresModRoutine $receiver, @Nullable String arguments, @Nullable String result, @NotNull String text) {
        PostgresIntrospectorKt.applySourceText($receiver, arguments, result, text);
    }
}

