/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.google.common.collect.ImmutableList;
import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.introspection.BaseMultiDatabaseIntrospector;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.introspection.SybaseIntroQueries;
import com.intellij.database.introspection.SybaseIntrospector$SybaseSchemaRetriever$retrieveSources$;
import com.intellij.database.introspection.SybaseIntrospectorKt;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.database.model.sybase.SybaseDatabase;
import com.intellij.database.model.sybase.SybaseModArgument;
import com.intellij.database.model.sybase.SybaseModCheck;
import com.intellij.database.model.sybase.SybaseModDatabase;
import com.intellij.database.model.sybase.SybaseModForeignKey;
import com.intellij.database.model.sybase.SybaseModFunction;
import com.intellij.database.model.sybase.SybaseModIndex;
import com.intellij.database.model.sybase.SybaseModKey;
import com.intellij.database.model.sybase.SybaseModLikeColumn;
import com.intellij.database.model.sybase.SybaseModLikeTable;
import com.intellij.database.model.sybase.SybaseModMajorObject;
import com.intellij.database.model.sybase.SybaseModModel;
import com.intellij.database.model.sybase.SybaseModProcedure;
import com.intellij.database.model.sybase.SybaseModProcedureGroup;
import com.intellij.database.model.sybase.SybaseModRoot;
import com.intellij.database.model.sybase.SybaseModSchema;
import com.intellij.database.model.sybase.SybaseModTable;
import com.intellij.database.model.sybase.SybaseModTableColumn;
import com.intellij.database.model.sybase.SybaseModTrigger;
import com.intellij.database.model.sybase.SybaseSchema;
import com.intellij.database.model.sybase.SybaseTableColumn;
import com.intellij.dbm.common.QueryRewriters;
import com.intellij.util.NumbersFun;
import com.intellij.util.text.StringKt;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.StringOperator;
import org.jetbrains.dekaf.util.Strings;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002&\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0001:\u0002\u001e\u001fB\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ@\u0010\r\u001a*0\u000eR&\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0014J\u001c\u0010\u0012\u001a\u00060\u0013R\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0005H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0005H\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/database/introspection/SybaseIntrospector;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/model/sybase/SybaseModModel;", "Lcom/intellij/database/model/sybase/SybaseModRoot;", "Lcom/intellij/database/model/sybase/SybaseDatabase;", "Lcom/intellij/database/model/sybase/SybaseSchema;", "Lcom/intellij/database/model/sybase/SybaseModDatabase;", "Lcom/intellij/database/model/sybase/SybaseModSchema;", "facade", "Lorg/jetbrains/dekaf/core/DBFacade;", "(Lorg/jetbrains/dekaf/core/DBFacade;)V", "myQueries", "Lcom/intellij/database/introspection/SybaseIntroQueries;", "createDatabaseRetriever", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector$DatabaseRetriever;", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "createSchemaRetriever", "Lcom/intellij/database/introspection/SybaseIntrospector$SybaseSchemaRetriever;", "schema", "isPossibleToIntrospectSchemaIncrementally", "", "listDatabases", "", "Lcom/intellij/database/introspection/LongIdName;", "listSchemas", "Lcom/intellij/database/model/basic/BasicDatabase;", "retrieveSessionBriefInfo", "", "SybaseDatabaseRetriever", "SybaseSchemaRetriever", "database-introspection"})
public final class SybaseIntrospector
extends BaseMultiDatabaseIntrospector<SybaseModModel, SybaseModRoot, SybaseDatabase, SybaseSchema, SybaseModDatabase, SybaseModSchema> {
    private final SybaseIntroQueries myQueries;

    @Override
    @NotNull
    protected BaseMultiDatabaseIntrospector.DatabaseRetriever createDatabaseRetriever(@NotNull DBTransaction tran, @NotNull SybaseDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        return new SybaseDatabaseRetriever(tran, database);
    }

    @NotNull
    protected SybaseSchemaRetriever createSchemaRetriever(@NotNull DBTransaction tran, @NotNull SybaseSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return new SybaseSchemaRetriever(tran, schema);
    }

    @Override
    protected void retrieveSessionBriefInfo(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        super.retrieveSessionBriefInfo(tran);
        ConnectionInfo info = this.getDbFacade().getConnectionInfo();
        if (info.databaseName != null) {
            SybaseIntrospector this_$iv = this;
            this_$iv.getModel().modify(BaseMultiDatabaseIntrospector.access$getModRootClass$p(this_$iv), new ModelModifier<MR>(info){
                final /* synthetic */ ConnectionInfo $info$inlined;

                public final void perform(MR root2) {
                    MR MR = root2;
                    Intrinsics.checkExpressionValueIsNotNull(MR, (String)"root");
                    SybaseModRoot root3 = (SybaseModRoot)MR;
                    NamingIdentifyingFamily namingIdentifyingFamily = root3.getDatabases();
                    String string = this.$info$inlined.databaseName;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    SybaseModDatabase database = (SybaseModDatabase)namingIdentifyingFamily.createOrGet(string);
                    database.setCurrent(true);
                    if (this.$info$inlined.schemaName != null) {
                        NamingIdentifyingFamily namingIdentifyingFamily2 = database.getSchemas();
                        String string2 = this.$info$inlined.schemaName;
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        SybaseModSchema schema = (SybaseModSchema)namingIdentifyingFamily2.createOrGet(string2);
                        schema.setCurrent(true);
                    }
                }
                {
                    this.$info$inlined = connectionInfo;
                }
            });
        }
    }

    @Override
    @NotNull
    protected List<LongIdName> listDatabases(@NotNull DBTransaction tran) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        List list = (List)tran.query(this.myQueries.listDatabases).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"tran.query(myQueries.listDatabases).run()");
        return list;
    }

    @Override
    @NotNull
    protected List<LongIdName> listSchemas(@NotNull DBTransaction tran, @NotNull BasicDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        List list = (List)tran.query(this.myQueries.listSchemas.rewrite(new StringOperator(database){
            final /* synthetic */ BasicDatabase $database;

            @NotNull
            public final String apply(String it) {
                return StringsKt.replace$default((String)it, (String)"#CAT", (String)("[" + this.$database.getName() + "].dbo"), (boolean)false, (int)4, null);
            }
            {
                this.$database = basicDatabase;
            }
        })).run();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"tran.query(myQueries.lis\u2026base.name}].dbo\")}).run()");
        return list;
    }

    @Override
    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull SybaseSchema schema) {
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        return false;
    }

    public SybaseIntrospector(@NotNull DBFacade facade) {
        Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
        super(facade, SybaseModModel.class, SybaseModRoot.class, SybaseModDatabase.class, SybaseModSchema.class);
        SybaseIntroQueries sybaseIntroQueries = SybaseIntroQueries.QUERIES;
        Intrinsics.checkExpressionValueIsNotNull((Object)sybaseIntroQueries, (String)"SybaseIntroQueries.QUERIES");
        this.myQueries = sybaseIntroQueries;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002*0\u0001R&\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0002B\u0017\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/introspection/SybaseIntrospector$SybaseDatabaseRetriever;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector$DatabaseRetriever;", "Lcom/intellij/database/introspection/BaseMultiDatabaseIntrospector;", "Lcom/intellij/database/model/sybase/SybaseModModel;", "Lcom/intellij/database/model/sybase/SybaseModRoot;", "Lcom/intellij/database/model/sybase/SybaseDatabase;", "Lcom/intellij/database/model/sybase/SybaseSchema;", "Lcom/intellij/database/model/sybase/SybaseModDatabase;", "Lcom/intellij/database/model/sybase/SybaseModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "database", "(Lcom/intellij/database/introspection/SybaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/sybase/SybaseDatabase;)V", "listSchemas", "", "Lcom/intellij/database/introspection/LongIdName;", "prepareParameters", "", "database-introspection"})
    private final class SybaseDatabaseRetriever
    extends BaseMultiDatabaseIntrospector.DatabaseRetriever {
        @Override
        protected void prepareParameters() {
            this.setQueryParameter("CAT", SybaseIntrospectorKt.access$catalogPrefix((SybaseDatabase)this.getDatabase()));
        }

        @Override
        @NotNull
        protected List<LongIdName> listSchemas() {
            SqlQuery<List<LongIdName>> sqlQuery = ((SybaseIntrospector)SybaseIntrospector.this).myQueries.listSchemas;
            Intrinsics.checkExpressionValueIsNotNull(sqlQuery, (String)"myQueries.listSchemas");
            return this.performQuery(sqlQuery);
        }

        public SybaseDatabaseRetriever(@NotNull DBTransaction transaction, SybaseDatabase database) {
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            super((BaseMultiDatabaseIntrospector)SybaseIntrospector.this, transaction, (BasicDatabase)database);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0084\u0004\u0018\u00002\u001e0\u0001R\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0002B\u0017\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0014J\b\u0010\u001a\u001a\u00020\u0012H\u0014J\b\u0010\u001b\u001a\u00020\u0012H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0012H\u0002J\b\u0010'\u001a\u00020\u0012H\u0002J\b\u0010(\u001a\u00020\u0012H\u0002J\b\u0010)\u001a\u00020\u0012H\u0002J\b\u0010*\u001a\u00020\u0012H\u0002J\b\u0010+\u001a\u00020\u0012H\u0014J\b\u0010,\u001a\u00020\u0012H\u0014J\b\u0010-\u001a\u00020\u0012H\u0002J\b\u0010.\u001a\u00020\u0012H\u0002J\b\u0010/\u001a\u00020\u0012H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/database/introspection/SybaseIntrospector$SybaseSchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector$SchemaRetriever;", "Lcom/intellij/database/introspection/BaseIntrospector;", "Lcom/intellij/database/model/sybase/SybaseModModel;", "Lcom/intellij/database/model/sybase/SybaseModRoot;", "Lcom/intellij/database/model/sybase/SybaseSchema;", "Lcom/intellij/database/model/sybase/SybaseModSchema;", "transaction", "Lorg/jetbrains/dekaf/core/DBTransaction;", "schema", "(Lcom/intellij/database/introspection/SybaseIntrospector;Lorg/jetbrains/dekaf/core/DBTransaction;Lcom/intellij/database/model/sybase/SybaseSchema;)V", "rewriter", "Lorg/jetbrains/dekaf/util/StringOperator;", "schemaId", "", "wasProcedures", "", "addRoutineArgument", "", "routine", "Lcom/intellij/database/model/basic/BasicModRoutine;", "ca", "Lcom/intellij/database/introspection/SybaseIntroQueries$OneColumnOrArgument;", "dt", "Lcom/intellij/database/model/DataType;", "analyzeBriefInfo", "analyzeCurrentContent", "finishSchema", "peekColumnPositions", "", "keys", "", "peekIndexColumns", "index", "Lcom/intellij/database/model/sybase/SybaseModIndex;", "progress", "what", "", "retrieveCheckConstraints", "retrieveColumnsAndArguments", "retrieveDefaults", "retrieveForeignKeys", "retrieveIndicesAndKeys", "retrieveMainContent", "retrieveMajorNames", "retrieveProcedures", "retrieveSources", "retrieveTriggers", "database-introspection"})
    protected final class SybaseSchemaRetriever
    extends BaseIntrospector.SchemaRetriever {
        private final int schemaId;
        private final StringOperator rewriter;
        private boolean wasProcedures;

        @Override
        protected void analyzeBriefInfo() {
            this.setIntrospectionBeginTimestamp((Timestamp)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.now).run());
        }

        @Override
        protected void analyzeCurrentContent() {
            this.progress("determining dropped objects");
        }

        @Override
        protected void retrieveMajorNames() {
            this.progress("listing major objects");
            List ms = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveMajorNames.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (ms.isEmpty()) {
                return;
            }
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, ms){
                final /* synthetic */ SybaseSchemaRetriever this$0;
                final /* synthetic */ List $ms$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    block6: for (SybaseIntroQueries.OneMajorName m : this.$ms$inlined) {
                        NamingIdentifyingFamily family;
                        switch (m.type) {
                            case 'S': 
                            case 'U': {
                                Intrinsics.checkExpressionValueIsNotNull((Object)schema2.getTables(), (String)"schema.tables");
                                break;
                            }
                            case 'V': {
                                Intrinsics.checkExpressionValueIsNotNull((Object)schema2.getViews(), (String)"schema.views");
                                break;
                            }
                            case 'F': {
                                Intrinsics.checkExpressionValueIsNotNull((Object)schema2.getFunctions(), (String)"schema.functions");
                                break;
                            }
                            case 'P': {
                                Intrinsics.checkExpressionValueIsNotNull((Object)schema2.getProcedureGroups(), (String)"schema.procedureGroups");
                                break;
                            }
                            default: {
                                continue block6;
                            }
                        }
                        SybaseSchemaRetriever.access$setWasProcedures$p(this.this$0, SybaseSchemaRetriever.access$getWasProcedures$p(this.this$0) | m.type == 'P');
                        SybaseModMajorObject obj = (SybaseModMajorObject)family.renew(m.id, m.name);
                        obj.setStateNumber(m.state_nr);
                    }
                    schema2.getTables().sort();
                    schema2.getViews().sort();
                    schema2.getFunctions().sort();
                    schema2.getProcedureGroups().sort();
                }
                {
                    this.this$0 = sybaseSchemaRetriever;
                    this.$ms$inlined = list;
                }
            });
        }

        @Override
        protected void retrieveMainContent() {
            this.retrieveProcedures();
            this.retrieveColumnsAndArguments();
            this.retrieveDefaults();
            this.retrieveIndicesAndKeys();
            this.retrieveForeignKeys();
            this.retrieveCheckConstraints();
            this.retrieveTriggers();
            this.retrieveSources();
            this.finishSchema();
        }

        private final void retrieveProcedures() {
            if (!this.wasProcedures) {
                return;
            }
            this.progress("retrieving procedure overloads");
            List ps = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveProcedures.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (ps.isEmpty()) {
                return;
            }
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ps){
                final /* synthetic */ List $ps$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    HashSet<SybaseModProcedureGroup> touchedGroups = new HashSet<SybaseModProcedureGroup>(this.$ps$inlined.size());
                    for (SybaseIntroQueries.OneProcedure p : this.$ps$inlined) {
                        SybaseModProcedureGroup group;
                        if ((SybaseModProcedureGroup)schema2.getProcedureGroups().getByObjectId((long)p.id) == null) {
                            continue;
                        }
                        group.getProcedures().createOrGetAt(p.procedure_position);
                        touchedGroups.add(group);
                    }
                    for (SybaseModProcedureGroup group : touchedGroups) {
                        group.getProcedures().sort();
                    }
                }
                {
                    this.$ps$inlined = list;
                }
            });
        }

        private final void retrieveColumnsAndArguments() {
            this.progress("retrieving columns and arguments");
            List cas = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveColumnsAndArguments.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (cas.isEmpty()) {
                return;
            }
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, cas){
                final /* synthetic */ SybaseSchemaRetriever this$0;
                final /* synthetic */ List $cas$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    HashSet<BasicModNamedElement> touchedObjects = new HashSet<BasicModNamedElement>(this.$cas$inlined.size() / 4);
                    SybaseModMajorObject obj = null;
                    int objId = Integer.MIN_VALUE;
                    for (SybaseIntroQueries.OneColumnOrArgument oneColumnOrArgument : this.$cas$inlined) {
                        if (obj == null || objId != oneColumnOrArgument.id) {
                            obj = SybaseIntrospectorKt.access$findObjectById(schema2, oneColumnOrArgument.id);
                            objId = oneColumnOrArgument.id;
                            if (obj == null) continue;
                            touchedObjects.add(obj);
                        }
                        DataType dt = SybaseIntrospectorKt.access$makeDataType(oneColumnOrArgument.type_name, oneColumnOrArgument.length, oneColumnOrArgument.prec, oneColumnOrArgument.scale, oneColumnOrArgument.variable);
                        if (obj instanceof SybaseModLikeTable) {
                            short that$iv;
                            short $receiver$iv$iv;
                            short $receiver$iv;
                            SybaseModLikeColumn column = (SybaseModLikeColumn)((SybaseModLikeTable)obj).getColumns().createOrGet(oneColumnOrArgument.name);
                            column.setPosition(oneColumnOrArgument.colid);
                            column.setDataType(dt);
                            short s = oneColumnOrArgument.bits1;
                            short s2 = SybaseIntrospectorKt.access$getCOLUMN_BITS1_NULLABLE$p();
                            SybaseModLikeColumn sybaseModLikeColumn = column;
                            void var13_15 = $receiver$iv;
                            int n = Short.toUnsignedInt($receiver$iv$iv);
                            $receiver$iv$iv = that$iv;
                            int n2 = n;
                            int n3 = Short.toUnsignedInt($receiver$iv$iv);
                            short s3 = (short)(n2 & n3);
                            sybaseModLikeColumn.setNotNull(s3 == NumbersFun.__0__);
                            $receiver$iv = oneColumnOrArgument.bits2;
                            that$iv = SybaseIntrospectorKt.access$getCOLUMN_BITS2_COMPUTED$p();
                            sybaseModLikeColumn = column;
                            $receiver$iv$iv = $receiver$iv;
                            int n4 = Short.toUnsignedInt($receiver$iv$iv);
                            $receiver$iv$iv = that$iv;
                            n2 = n4;
                            n3 = Short.toUnsignedInt($receiver$iv$iv);
                            s3 = (short)(n2 & n3);
                            sybaseModLikeColumn.setComputed(s3 != NumbersFun.__0__);
                            if (column instanceof SybaseModTableColumn) {
                                $receiver$iv = oneColumnOrArgument.bits1;
                                that$iv = SybaseIntrospectorKt.access$getCOLUMN_BITS1_IDENTITY$p();
                                sybaseModLikeColumn = (SybaseModTableColumn)column;
                                $receiver$iv$iv = $receiver$iv;
                                int n5 = Short.toUnsignedInt($receiver$iv$iv);
                                $receiver$iv$iv = that$iv;
                                n2 = n5;
                                n3 = Short.toUnsignedInt($receiver$iv$iv);
                                s3 = (short)(n2 & n3);
                                sybaseModLikeColumn.setSequenceIdentity(s3 != NumbersFun.__0__ ? SybaseIntrospectorKt.access$getOurSybaseIdentity$p() : (SequenceIdentity)null);
                            }
                        }
                        if (obj instanceof BasicModRoutine) {
                            BasicModRoutine basicModRoutine = (BasicModRoutine)((Object)obj);
                            SybaseIntroQueries.OneColumnOrArgument oneColumnOrArgument2 = oneColumnOrArgument;
                            Intrinsics.checkExpressionValueIsNotNull((Object)oneColumnOrArgument2, (String)"ca");
                            SybaseSchemaRetriever.access$addRoutineArgument(this.this$0, basicModRoutine, oneColumnOrArgument2, dt);
                        }
                        if (!(obj instanceof SybaseModProcedureGroup)) continue;
                        SybaseModProcedure procedure = (SybaseModProcedure)((SybaseModProcedureGroup)obj).getProcedures().createOrGetAt(oneColumnOrArgument.procedure_position);
                        BasicModRoutine basicModRoutine = procedure;
                        Intrinsics.checkExpressionValueIsNotNull((Object)basicModRoutine, (String)"procedure");
                        SybaseIntroQueries.OneColumnOrArgument oneColumnOrArgument3 = oneColumnOrArgument;
                        Intrinsics.checkExpressionValueIsNotNull((Object)oneColumnOrArgument3, (String)"ca");
                        SybaseSchemaRetriever.access$addRoutineArgument(this.this$0, basicModRoutine, oneColumnOrArgument3, dt);
                        touchedObjects.add(procedure);
                    }
                    for (BasicModElement basicModElement : touchedObjects) {
                        BasicModElement basicModElement2 = basicModElement;
                        if (basicModElement2 instanceof SybaseModLikeTable) {
                            ((SybaseModLikeTable)basicModElement).getColumns().sort();
                            continue;
                        }
                        if (basicModElement2 instanceof SybaseModFunction) {
                            ((SybaseModFunction)basicModElement).getArguments().sort();
                            continue;
                        }
                        if (!(basicModElement2 instanceof SybaseModProcedureGroup)) continue;
                        ((SybaseModProcedureGroup)basicModElement).getProcedures().sort();
                    }
                }
                {
                    this.this$0 = sybaseSchemaRetriever;
                    this.$cas$inlined = list;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void addRoutineArgument(BasicModRoutine routine2, SybaseIntroQueries.OneColumnOrArgument ca, DataType dt) {
            BasicModArgument basicModArgument;
            boolean result;
            void that$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            short s = ca.bits2;
            short s2 = SybaseIntrospectorKt.access$getCOLUMN_BITS2_OUTPUT$p();
            void var7_7 = $receiver$iv;
            int n = Short.toUnsignedInt((short)$receiver$iv$iv);
            $receiver$iv$iv = that$iv;
            int n2 = n;
            int n3 = Short.toUnsignedInt((short)$receiver$iv$iv);
            boolean out = (short)(n2 & n3) != NumbersFun.__0__;
            boolean bl = result = out && Strings.eq((String)ca.name, (String)"Return Type", (boolean)false);
            if (result) {
                basicModArgument = routine2.createOrGetReturnArgument();
            } else {
                SybaseModArgument sybaseModArgument;
                BasicModRoutine basicModRoutine = routine2;
                if (basicModRoutine instanceof SybaseModFunction) {
                    ModFamily modFamily = (ModFamily)((Object)((SybaseModFunction)routine2).getArguments());
                    String string = ca.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ca.name");
                    sybaseModArgument = SybaseIntrospectorKt.access$createOrGetByName(modFamily, string);
                } else if (basicModRoutine instanceof SybaseModProcedure) {
                    ModFamily modFamily = (ModFamily)((Object)((SybaseModProcedure)routine2).getArguments());
                    String string = ca.name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ca.name");
                    sybaseModArgument = SybaseIntrospectorKt.access$createOrGetByName(modFamily, string);
                } else {
                    return;
                }
                basicModArgument = sybaseModArgument;
            }
            BasicModArgument argument = basicModArgument;
            argument.setPosition(ca.colid);
            argument.setDataType(dt);
            if (!result) {
                argument.setArgumentDirection(out ? DasArgument.Direction.OUT : DasArgument.Direction.IN);
            }
        }

        private final void retrieveIndicesAndKeys() {
            if (((SybaseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            this.progress("retrieving indices");
            List inds = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveIndices.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (inds.isEmpty()) {
                return;
            }
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this, inds){
                final /* synthetic */ SybaseSchemaRetriever this$0;
                final /* synthetic */ List $inds$inlined;

                /*
                 * WARNING - void declaration
                 */
                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    HashSet<SybaseModTable> touchedTables = new HashSet<SybaseModTable>(this.$inds$inlined.size());
                    SybaseModTable table = null;
                    int tableId = Integer.MIN_VALUE;
                    for (SybaseIntroQueries.OneIndex ind : this.$inds$inlined) {
                        void that$iv;
                        void $receiver$iv;
                        short that$iv2;
                        short $receiver$iv$iv;
                        short $receiver$iv2;
                        if (table == null || tableId != ind.id) {
                            if ((SybaseModTable)schema2.getTables().getByObjectId((long)ind.id) == null) {
                                continue;
                            }
                            tableId = ind.id;
                            touchedTables.add(table);
                        }
                        SybaseModIndex index = (SybaseModIndex)table.getIndices().createOrGet(ind.name);
                        index.setPosition(ind.position);
                        short s = ind.bits2;
                        short s2 = SybaseIntrospectorKt.access$getINDEX_BITS2_NAME_SURROGATE$p();
                        BasicModColumniation basicModColumniation = index;
                        void var12_17 = $receiver$iv2;
                        int n = Short.toUnsignedInt($receiver$iv$iv);
                        $receiver$iv$iv = that$iv2;
                        int n2 = n;
                        int n3 = Short.toUnsignedInt($receiver$iv$iv);
                        short s3 = (short)(n2 & n3);
                        basicModColumniation.setNameSurrogate(s3 != NumbersFun.__0__);
                        $receiver$iv2 = ind.bits1;
                        that$iv2 = SybaseIntrospectorKt.access$getINDEX_BITS1_CLUSTERED$p();
                        basicModColumniation = index;
                        $receiver$iv$iv = $receiver$iv2;
                        int n4 = Short.toUnsignedInt($receiver$iv$iv);
                        $receiver$iv$iv = that$iv2;
                        n2 = n4;
                        n3 = Short.toUnsignedInt($receiver$iv$iv);
                        s3 = (short)(n2 & n3);
                        basicModColumniation.setClustering(s3 != NumbersFun.__0__);
                        $receiver$iv2 = ind.bits1;
                        that$iv2 = SybaseIntrospectorKt.access$getINDEX_BITS1_UNIQUE$p();
                        basicModColumniation = index;
                        $receiver$iv$iv = $receiver$iv2;
                        int n5 = Short.toUnsignedInt($receiver$iv$iv);
                        $receiver$iv$iv = that$iv2;
                        n2 = n5;
                        n3 = Short.toUnsignedInt($receiver$iv$iv);
                        s3 = (short)(n2 & n3);
                        basicModColumniation.setUnique(s3 != NumbersFun.__0__);
                        if (ind.keys1 != null) {
                            byte[] keys;
                            Object object = ind.keys1;
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                            }
                            byte[] keys1 = (byte[])object;
                            if (ind.keys2 == null) {
                                keys = keys1;
                            } else {
                                Object object2 = ind.keys2;
                                if (object2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                                }
                                byte[] keys2 = (byte[])object2;
                                keys = new byte[keys1.length + keys2.length];
                                System.arraycopy(keys1, 0, keys, 0, keys1.length);
                                System.arraycopy(keys2, 0, keys, keys1.length, keys2.length);
                            }
                            SybaseModIndex sybaseModIndex = index;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sybaseModIndex, (String)"index");
                            SybaseSchemaRetriever.access$peekIndexColumns(this.this$0, sybaseModIndex, keys);
                        }
                        short keys = ind.bits2;
                        short keys1 = SybaseIntrospectorKt.access$getINDEX_BITS2_KEY$p();
                        void keys2 = $receiver$iv;
                        int n6 = Short.toUnsignedInt($receiver$iv$iv);
                        $receiver$iv$iv = that$iv2;
                        n2 = n6;
                        n3 = Short.toUnsignedInt($receiver$iv$iv);
                        if ((short)(n2 & n3) == NumbersFun.__0__) continue;
                        SybaseModKey key = (SybaseModKey)table.getKeys().createOrGet(ind.name);
                        key.setNameSurrogate(index.isNameSurrogate());
                        key.setUnderlyingIndexName(ind.name);
                        key.setUnderlyingIndexPosition(ind.position);
                        that$iv2 = ind.bits1;
                        $receiver$iv$iv = SybaseIntrospectorKt.access$getINDEX_BITS1_PRIMARY$p();
                        basicModColumniation = key;
                        n2 = $receiver$iv;
                        void $receiver$iv$iv2 = that$iv;
                        n3 = Short.toUnsignedInt((short)$receiver$iv$iv2);
                        int n7 = Short.toUnsignedInt((short)$receiver$iv$iv2);
                        s3 = (short)(n3 & n7);
                        basicModColumniation.setPrimary(s3 != NumbersFun.__0__);
                        key.setColNames(index.getColNames());
                    }
                    for (SybaseModTable touchedTable : touchedTables) {
                        touchedTable.getIndices().sort();
                    }
                }
                {
                    this.this$0 = sybaseSchemaRetriever;
                    this.$inds$inlined = list;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void peekIndexColumns(SybaseModIndex index, byte[] keys) {
            short position;
            short[] positions = this.peekColumnPositions(keys);
            ImmutableList.Builder names = ImmutableList.builder();
            for (int j = 0; j < positions.length && (position = positions[j]) != 0; ++j) {
                Object v0;
                block2: {
                    void $receiver$iv;
                    Iterable iterable = index.getTable().getColumns();
                    for (Object element$iv : $receiver$iv) {
                        SybaseModTableColumn column = (SybaseModTableColumn)element$iv;
                        if (!(column.getPosition() == position)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                SybaseModTableColumn column = v0;
                if (column == null) continue;
                names.add((Object)column.getName());
            }
            index.setColNames((List)names.build());
        }

        /*
         * WARNING - void declaration
         */
        private final short[] peekColumnPositions(byte[] keys) {
            int n = (keys.length + 7) / 16;
            short[] positions = new short[n];
            int n2 = 0;
            int n3 = n - 1;
            if (n2 <= n3) {
                while (true) {
                    short position;
                    void i2;
                    int offset = i2 << 4 | 4;
                    positions[i2] = position = SybaseIntrospectorKt.peek16(keys, offset);
                    if (position == 0 || i2 == n3) break;
                    ++i2;
                }
            }
            return positions;
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveForeignKeys() {
            Object wfks;
            Object wides;
            void this_$iv;
            if (((SybaseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            this.progress("retrieving foreign keys");
            List fks = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveForeignKeys.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (fks.isEmpty()) {
                return;
            }
            HashSet touchedTables = new HashSet(fks.size());
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            SybaseSchemaRetriever sybaseSchemaRetriever = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv), BaseIntrospector.access$getModSchemaClass$p(this_$iv.this$0), new ModelModifier<MS>(fks, touchedTables, wides){
                final /* synthetic */ List $fks$inlined;
                final /* synthetic */ HashSet $touchedTables$inlined;
                final /* synthetic */ Ref.BooleanRef $wides$inlined;

                /*
                 * WARNING - void declaration
                 */
                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    for (SybaseIntroQueries.OneForeignKey fk : this.$fks$inlined) {
                        BasicElement targetKey;
                        BasicElement basicElement;
                        SybaseModTable targetTable;
                        SybaseModTable table;
                        if ((SybaseModTable)schema2.getTables().getByObjectId(fk.source_table_id) == null) {
                            continue;
                        }
                        SybaseModForeignKey foreignKey = (SybaseModForeignKey)table.getForeignKeys().renew(fk.source_constraint_id, fk.source_constraint_name);
                        foreignKey.setNameSurrogate(SybaseIntrospectorKt.access$detectSurrogateName(fk.source_constraint_name, fk.source_constraint_id));
                        this.$touchedTables$inlined.add(table);
                        SybaseModTable sybaseModTable = targetTable = (SybaseModTable)schema2.getTables().getByObjectId(fk.target_table_id);
                        foreignKey.setRefTableName(sybaseModTable != null ? sybaseModTable.getRealName() : null);
                        BasicNode basicNode = targetTable;
                        if (basicNode != null && (basicNode = basicNode.getKeys()) != null) {
                            Object v3;
                            block11: {
                                void $receiver$iv;
                                Iterable iterable = (Iterable)((Object)basicNode);
                                for (T element$iv : $receiver$iv) {
                                    SybaseModKey k = (SybaseModKey)element$iv;
                                    if (!(k.getUnderlyingIndexPosition() == fk.target_index_position)) continue;
                                    v3 = element$iv;
                                    break block11;
                                }
                                v3 = null;
                            }
                            basicElement = v3;
                        } else {
                            basicElement = null;
                        }
                        BasicElement basicElement2 = targetKey = basicElement;
                        foreignKey.setRefKeyName(basicElement2 != null ? basicElement2.getRealName() : null);
                        Object object = targetKey;
                        if (object == null || (object = object.getColNames()) == null) {
                            object = CollectionsKt.emptyList();
                        }
                        foreignKey.setRefColNames((List<String>)object);
                        short n = fk.involved_columns_count;
                        if (n <= 4) {
                            short[] columnPositions = new short[n];
                            if (n >= 1) {
                                columnPositions[0] = fk.column_position_1;
                            }
                            if (n >= 2) {
                                columnPositions[1] = fk.column_position_2;
                            }
                            if (n >= 3) {
                                columnPositions[2] = fk.column_position_3;
                            }
                            if (n >= 4) {
                                columnPositions[3] = fk.column_position_4;
                            }
                            SybaseModForeignKey sybaseModForeignKey = foreignKey;
                            Intrinsics.checkExpressionValueIsNotNull((Object)sybaseModForeignKey, (String)"foreignKey");
                            SybaseIntrospectorKt.access$assignForeignKeyColumns(sybaseModForeignKey, columnPositions);
                            continue;
                        }
                        this.$wides$inlined.element = true;
                    }
                }
                {
                    this.$fks$inlined = list;
                    this.$touchedTables$inlined = hashSet;
                    this.$wides$inlined = booleanRef;
                }
            });
            if (wides.element) {
                void this_$iv2;
                wfks = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveForeignKeysWideColumnLists.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
                SybaseSchemaRetriever $i$f$inSchema = this;
                BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv2).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv2), BaseIntrospector.access$getModSchemaClass$p(this_$iv2.this$0), new ModelModifier<MS>((List)wfks){
                    final /* synthetic */ List $wfks$inlined;

                    /*
                     * WARNING - void declaration
                     */
                    public final void perform(MS schema) {
                        MS MS = schema;
                        Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                        SybaseModSchema schema2 = (SybaseModSchema)MS;
                        for (int[] wfk : this.$wfks$inlined) {
                            SybaseModForeignKey foreignKey;
                            int n;
                            int constraintId = wfk[0];
                            if (SybaseIntrospectorKt.access$findForeignKeyById(schema2, constraintId) == null) {
                                continue;
                            }
                            for (n = 0; n < 16 && wfk[n + 1] > 0; ++n) {
                            }
                            short[] columnPositions = new short[n];
                            int n2 = 0;
                            int n3 = n - 1;
                            if (n2 <= n3) {
                                while (true) {
                                    void i2;
                                    columnPositions[i2] = (short)wfk[i2 + true];
                                    if (i2 == n3) break;
                                    ++i2;
                                }
                            }
                            SybaseIntrospectorKt.access$assignForeignKeyColumns(foreignKey, columnPositions);
                        }
                    }
                    {
                        this.$wfks$inlined = list;
                    }
                });
            }
            wfks = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p((BaseIntrospector.SchemaRetriever)this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p((BaseIntrospector.SchemaRetriever)this_$iv), BaseIntrospector.access$getModSchemaClass$p(this_$iv.this$0), new ModelModifier<MS>(touchedTables){
                final /* synthetic */ HashSet $touchedTables$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    for (SybaseModTable table : this.$touchedTables$inlined) {
                        table.getForeignKeys().sort();
                    }
                }
                {
                    this.$touchedTables$inlined = hashSet;
                }
            });
            wides = null;
        }

        private final void retrieveCheckConstraints() {
            if (((SybaseSchema)this.getSchema()).getTables().isEmpty()) {
                return;
            }
            this.progress("retrieving check constraints");
            List cs = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveChecks.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (cs.isEmpty()) {
                return;
            }
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(cs){
                final /* synthetic */ List $cs$inlined;

                /*
                 * WARNING - void declaration
                 */
                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    HashSet<SybaseModTable> touchedTables = new HashSet<SybaseModTable>(this.$cs$inlined.size());
                    for (SybaseIntroQueries.OneCheck c : this.$cs$inlined) {
                        SybaseTableColumn sybaseTableColumn;
                        Object s;
                        SybaseModTable table;
                        if ((SybaseModTable)schema2.getTables().getByObjectId(c.table_id) == null) {
                            continue;
                        }
                        SybaseModCheck check = (SybaseModCheck)table.getChecks().renew(c.constraint_id, c.constraint_name);
                        check.setNameSurrogate(SybaseIntrospectorKt.access$detectSurrogateName(c.constraint_name, c.constraint_id));
                        if (c.definition != null) {
                            int len;
                            Object $receiver$iv$iv;
                            void $receiver$iv;
                            int p = StringsKt.indexOf$default((CharSequence)c.definition, (String)"CHECK", (int)0, (boolean)false, (int)6, null);
                            p = p >= 0 ? p + 5 : 0;
                            String string = c.definition;
                            String string2 = string;
                            if (string2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string3 = string2.substring(p);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                            string = string3;
                            void v3 = $receiver$iv;
                            if (v3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            CharSequence charSequence = (CharSequence)v3;
                            int startIndex$iv$iv2 = 0;
                            int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv2 <= endIndex$iv$iv) {
                                boolean match$iv$iv;
                                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv2 : endIndex$iv$iv;
                                char it = $receiver$iv$iv.charAt(index$iv$iv);
                                boolean bl = match$iv$iv = it <= ' ';
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv2;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            if ((len = ((String)(s = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv2, endIndex$iv$iv + 1)).toString())).length()) >= 3 && ((String)s).charAt(0) == '(' && ((String)s).charAt(len - 1) == ')') {
                                void $receiver$iv$iv2;
                                void $receiver$iv2;
                                $receiver$iv$iv = s;
                                startIndex$iv$iv2 = 1;
                                endIndex$iv$iv = len - 1;
                                Object object = $receiver$iv$iv;
                                if (object == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string4 = ((String)object).substring(startIndex$iv$iv2, endIndex$iv$iv);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                $receiver$iv$iv = string4;
                                void v7 = $receiver$iv2;
                                if (v7 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                CharSequence startIndex$iv$iv2 = (CharSequence)v7;
                                int startIndex$iv$iv3 = 0;
                                int endIndex$iv$iv2 = $receiver$iv$iv2.length() - 1;
                                boolean startFound$iv$iv2 = false;
                                while (startIndex$iv$iv3 <= endIndex$iv$iv2) {
                                    boolean match$iv$iv;
                                    int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv3 : endIndex$iv$iv2;
                                    char it = $receiver$iv$iv2.charAt(index$iv$iv);
                                    boolean bl = match$iv$iv = it <= ' ';
                                    if (!startFound$iv$iv2) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv2 = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv3;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv2;
                                }
                                s = ((Object)$receiver$iv$iv2.subSequence(startIndex$iv$iv3, endIndex$iv$iv2 + 1)).toString();
                            }
                            check.setPredicate((String)s);
                        } else {
                            check.setPredicate(null);
                        }
                        if (c.column_position > 0) {
                            Object v9;
                            block19: {
                                void $receiver$iv;
                                s = check.getTable().getColumns();
                                for (T element$iv : $receiver$iv) {
                                    SybaseModTableColumn col = (SybaseModTableColumn)element$iv;
                                    if (!(col.getPosition() == c.column_position)) continue;
                                    v9 = element$iv;
                                    break block19;
                                }
                                v9 = null;
                            }
                            sybaseTableColumn = v9;
                        } else {
                            sybaseTableColumn = null;
                        }
                        SybaseTableColumn column = sybaseTableColumn;
                        check.setColNames(column != null ? Collections.singletonList(column.getName()) : CollectionsKt.emptyList());
                        touchedTables.add(table);
                    }
                    for (SybaseModTable table : touchedTables) {
                        table.getChecks().sort();
                    }
                }
                {
                    this.$cs$inlined = list;
                }
            });
        }

        private final void retrieveDefaults() {
            this.progress("retrieving defaults");
            List ds = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveDefaults.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId}).run();
            if (ds.isEmpty()) {
                return;
            }
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ds){
                final /* synthetic */ List $ds$inlined;

                /*
                 * WARNING - void declaration
                 */
                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    SybaseModTable obj = null;
                    int objectId = Integer.MIN_VALUE;
                    for (SybaseIntroQueries.OneDefault d : this.$ds$inlined) {
                        SybaseModTableColumn column;
                        Object v11;
                        String def;
                        block20: {
                            void $receiver$iv;
                            boolean match$iv$iv;
                            char it;
                            int index$iv$iv;
                            CharSequence $receiver$iv$iv22;
                            String $receiver$iv2;
                            if (obj == null || objectId != d.id) {
                                obj = (SybaseModTable)schema2.getTables().getByObjectId(d.id);
                                objectId = d.id;
                                if (obj == null) continue;
                            }
                            String string = d.text;
                            void v1 = $receiver$iv2;
                            if (v1 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            CharSequence charSequence = (CharSequence)v1;
                            int startIndex$iv$iv = 0;
                            int endIndex$iv$iv = $receiver$iv$iv22.length() - 1;
                            boolean startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                it = $receiver$iv$iv22.charAt(index$iv$iv);
                                boolean bl = match$iv$iv = it <= ' ';
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            if (StringsKt.startsWith$default((String)(def = ((Object)$receiver$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"DEFAULT", (boolean)false, (int)2, null)) {
                                $receiver$iv2 = def;
                                int $receiver$iv$iv22 = 8;
                                String string2 = $receiver$iv2;
                                if (string2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string3 = string2.substring($receiver$iv$iv22);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                                $receiver$iv2 = string3;
                                String string4 = $receiver$iv2;
                                if (string4 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                $receiver$iv$iv22 = string4;
                                startIndex$iv$iv = 0;
                                endIndex$iv$iv = $receiver$iv$iv22.length() - 1;
                                startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    it = $receiver$iv$iv22.charAt(index$iv$iv);
                                    boolean bl = match$iv$iv = it <= ' ';
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                def = ((Object)$receiver$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            } else if (StringsKt.startsWith$default((String)def, (String)"AS", (boolean)false, (int)2, null)) {
                                $receiver$iv2 = def;
                                int $receiver$iv$iv = 3;
                                String string5 = $receiver$iv2;
                                if (string5 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                String string6 = string5.substring($receiver$iv$iv);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                                $receiver$iv2 = string6;
                                String string7 = $receiver$iv2;
                                if (string7 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                }
                                $receiver$iv$iv22 = string7;
                                startIndex$iv$iv = 0;
                                endIndex$iv$iv = $receiver$iv$iv22.length() - 1;
                                startFound$iv$iv = false;
                                while (startIndex$iv$iv <= endIndex$iv$iv) {
                                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                                    it = $receiver$iv$iv22.charAt(index$iv$iv);
                                    boolean bl = match$iv$iv = it <= ' ';
                                    if (!startFound$iv$iv) {
                                        if (!match$iv$iv) {
                                            startFound$iv$iv = true;
                                            continue;
                                        }
                                        ++startIndex$iv$iv;
                                        continue;
                                    }
                                    if (!match$iv$iv) break;
                                    --endIndex$iv$iv;
                                }
                                def = ((Object)$receiver$iv$iv22.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                            }
                            if (!(obj instanceof SybaseModTable)) continue;
                            PositioningNamingFamily columns = obj.getColumns();
                            Iterable startIndex$iv$iv2 = columns;
                            for (T element$iv : $receiver$iv) {
                                SybaseModTableColumn col = (SybaseModTableColumn)element$iv;
                                if (!(col.getPosition() == d.position)) continue;
                                v11 = element$iv;
                                break block20;
                            }
                            v11 = null;
                        }
                        if ((column = (SybaseModTableColumn)v11) == null) continue;
                        column.setDefaultExpression(def);
                    }
                }
                {
                    this.$ds$inlined = list;
                }
            });
        }

        private final void retrieveTriggers() {
            if (((SybaseSchema)this.getSchema()).getTables().isEmpty() && ((SybaseSchema)this.getSchema()).getViews().isEmpty()) {
                return;
            }
            this.progress("retrieving triggers");
            List ts = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveTriggers.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.schemaId, this.schemaId}).run();
            if (ts.isEmpty()) {
                return;
            }
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(ts){
                final /* synthetic */ List $ts$inlined;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    HashSet<SybaseModLikeTable> touchedTables = new HashSet<SybaseModLikeTable>(this.$ts$inlined.size());
                    for (SybaseIntroQueries.OneTrigger t : this.$ts$inlined) {
                        SybaseModLikeTable table;
                        SybaseModTable sybaseModTable = (SybaseModTable)schema2.getTables().getByObjectId(t.table_id);
                        if ((sybaseModTable != null ? (SybaseModLikeTable)sybaseModTable : (SybaseModLikeTable)schema2.getViews().getByObjectId(t.table_id)) == null) {
                            continue;
                        }
                        table = table;
                        SybaseModTrigger trigger2 = (SybaseModTrigger)table.getTriggers().renew(t.trig_id, t.trig_name);
                        TrigEvent event = TrigEvent.of(t.event_code);
                        SybaseIntrospectorKt.access$addEvent(trigger2, event);
                        trigger2.setTurn(t.turn_code == 'I' ? TrigTurn.INSTEAD_OF : TrigTurn.ALSO);
                        touchedTables.add(table);
                    }
                    for (SybaseModLikeTable table : touchedTables) {
                        table.getTriggers().sort();
                    }
                }
                {
                    this.$ts$inlined = list;
                }
            });
        }

        private final void retrieveSources() {
            if (Intrinsics.areEqual((Object)((Object)SybaseIntrospector.this.getOptions().getSources()), (Object)((Object)DBIntrospectionOptions.SourceLoading.NO_SOURCES))) {
                return;
            }
            if (((SybaseSchema)this.getSchema()).getTables().isEmpty() && ((SybaseSchema)this.getSchema()).getViews().isEmpty() && ((SybaseSchema)this.getSchema()).getProcedureGroups().isEmpty() && ((SybaseSchema)this.getSchema()).getFunctions().isEmpty()) {
                return;
            }
            List ss = (List)this.getTransaction().query(((SybaseIntrospector)SybaseIntrospector.this).myQueries.retrieveSources.rewrite(this.rewriter)).withParams(new Object[]{this.schemaId, this.schemaId, this.schemaId}).run();
            if (ss.isEmpty()) {
                return;
            }
            SybaseIntrospector this_$iv = SybaseIntrospector.this;
            this_$iv.getModel().writeSources(new Runnable(this, ss){
                final /* synthetic */ SybaseSchemaRetriever this$0;
                final /* synthetic */ List $ss$inlined;

                public final void run() {
                    SybaseSchemaRetriever this_$iv = this.this$0;
                    BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), (ModelModifier)new ModelModifier<MS>(this){
                        final /* synthetic */ SybaseSchemaRetriever$retrieveSources$$inlined$writeSources$1 this$0;

                        public final void perform(MS schema) {
                            MS MS = schema;
                            Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                            SybaseModSchema schema2 = (SybaseModSchema)MS;
                            for (SybaseIntroQueries.OneSource s : this.this$0.$ss$inlined) {
                                BasicNode basicNode;
                                BasicNode basicNode2;
                                BasicModSourceAware o = s.minor_kind == 'G' ? (BasicModSourceAware)((basicNode2 = SybaseIntrospectorKt.access$findTableOrView(schema2, s.major_kind, s.major_id)) != null && (basicNode2 = basicNode2.getTriggers()) != null ? (SybaseModTrigger)basicNode2.getByObjectId(s.minor_id) : null) : (s.major_kind == 'V' ? (BasicModSourceAware)schema2.getViews().getByObjectId(s.major_id) : (s.major_kind == 'F' ? (BasicModSourceAware)schema2.getFunctions().getByObjectId(s.major_id) : (s.major_kind == 'P' ? (BasicModSourceAware)((basicNode = (SybaseModProcedureGroup)schema2.getProcedureGroups().getByObjectId(s.major_id)) != null && (basicNode = basicNode.getProcedures()) != null ? (SybaseModProcedure)basicNode.getByNaturalPosition((short)s.minor_id) : null) : (BasicModSourceAware)null)));
                                if (o == null) {
                                    continue;
                                }
                                o.setSourceText(StringKt.nullize((String)s.text, (boolean)true));
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = sybaseSchemaRetriever;
                    this.$ss$inlined = list;
                }
            });
        }

        @Override
        protected void finishSchema() {
            super.finishSchema();
            SybaseSchemaRetriever this_$iv = this;
            BaseIntrospector.SchemaRetriever.access$getModel$p(this_$iv).modify((BasicElement)BaseIntrospector.SchemaRetriever.access$getSchema$p(this_$iv), BaseIntrospector.access$getModSchemaClass$p(((BaseIntrospector.SchemaRetriever)this_$iv).this$0), new ModelModifier<MS>(this){
                final /* synthetic */ SybaseSchemaRetriever this$0;

                public final void perform(MS schema) {
                    MS MS = schema;
                    Intrinsics.checkExpressionValueIsNotNull(MS, (String)"schema");
                    SybaseModSchema schema2 = (SybaseModSchema)MS;
                    schema2.setIntrospectionTimestamp(this.this$0.getIntrospectionBeginTimestamp());
                }
                {
                    this.this$0 = sybaseSchemaRetriever;
                }
            });
        }

        private final void progress(String what) {
            String mode = this.getMode().increment ? "incrementally" : "completely";
            String string = String.format("Introspecting schema %s (%s)", ((SybaseSchema)this.getSchema()).getName(), mode);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"format(\"Introspecting sc\u2026(%s)\", schema.name, mode)");
            SybaseIntrospector.this.updateStatus(string, what);
        }

        public SybaseSchemaRetriever(@NotNull DBTransaction transaction, SybaseSchema schema) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            super((BaseIntrospector)SybaseIntrospector.this, transaction, (BasicSchema)schema);
            this.schemaId = (int)schema.getObjectId();
            SybaseDatabase db = schema.getDatabase();
            if (db == null || db.isCurrent()) {
                string = "dbo";
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                char c = '[';
                String string2 = db.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"db.name");
                String string3 = string2;
                StringBuilder stringBuilder2 = stringBuilder;
                String string4 = String.valueOf(c) + string3;
                string = stringBuilder2.append(string4).append("].dbo").toString();
            }
            String catalogPrefix = string;
            StringOperator stringOperator = QueryRewriters.substitute("#CAT", catalogPrefix);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringOperator, (String)"substitute(\"#CAT\", catalogPrefix)");
            this.rewriter = stringOperator;
        }

        public static final /* synthetic */ boolean access$getWasProcedures$p(SybaseSchemaRetriever $this) {
            return $this.wasProcedures;
        }

        public static final /* synthetic */ void access$setWasProcedures$p(SybaseSchemaRetriever $this, boolean bl) {
            $this.wasProcedures = bl;
        }

        public static final /* synthetic */ void access$addRoutineArgument(SybaseSchemaRetriever $this, @NotNull BasicModRoutine routine2, @NotNull SybaseIntroQueries.OneColumnOrArgument ca, @NotNull DataType dt) {
            $this.addRoutineArgument(routine2, ca, dt);
        }

        public static final /* synthetic */ void access$peekIndexColumns(SybaseSchemaRetriever $this, @NotNull SybaseModIndex index, @NotNull byte[] keys) {
            $this.peekIndexColumns(index, keys);
        }
    }
}

