/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.impl.MemoryTextStorage;
import com.intellij.database.model.properties.IdentityAndKind;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0016J\u001f\u0010\u001a\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lcom/intellij/database/model/impl/MemoryTextStorage;", "Lcom/intellij/database/model/ModelTextStorage;", "()V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "", "getMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "beginWrite", "", "endWrite", "getVersion", "", "object", "Lcom/intellij/database/model/basic/BasicElement;", "(Lcom/intellij/database/model/basic/BasicElement;)Ljava/lang/Long;", "hasExistingSources", "", "element", "load", "obj", "Lcom/intellij/database/model/basic/BasicSourceAware;", "processDeleteQueue", "queueDelete", "save", "text", "setVersion", "version", "(Lcom/intellij/database/model/basic/BasicElement;Ljava/lang/Long;)V", "toKey", "", "Lcom/intellij/database/model/properties/IdentityAndKind;", "database-model-impl"})
public final class MemoryTextStorage
implements ModelTextStorage {
    @NotNull
    private final ConcurrentHashMap<String, String> map = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<String, String> getMap() {
        return this.map;
    }

    @Override
    public void save(@NotNull BasicSourceAware obj, @Nullable String text) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String key = this.toKey(obj.getSourcePath());
        if (text != null) {
            Map map = this.map;
            String string = text;
            map.put(key, string);
        } else {
            this.map.remove(key);
        }
    }

    @Override
    public void queueDelete(@NotNull BasicSourceAware obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        this.save(obj, null);
    }

    @Override
    public void processDeleteQueue() {
    }

    @Override
    @Nullable
    public String load(@NotNull BasicSourceAware obj) {
        Intrinsics.checkParameterIsNotNull((Object)obj, (String)"obj");
        String key = this.toKey(obj.getSourcePath());
        return this.map.get(key);
    }

    @Override
    public boolean hasExistingSources(@NotNull BasicElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return !(element instanceof BasicSourceAware) || this.map.contains(this.toKey(((BasicSourceAware)element).getSourcePath()));
    }

    @Override
    public void beginWrite() {
    }

    @Override
    public void endWrite() {
    }

    @Override
    @Nullable
    public Long getVersion(@NotNull BasicElement object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
        return null;
    }

    @Override
    public void setVersion(@NotNull BasicElement object, @Nullable Long version) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"object");
    }

    private final String toKey(@NotNull List<IdentityAndKind> $receiver) {
        return CollectionsKt.joinToString$default((Iterable)$receiver, (CharSequence)"\u0000", null, null, (int)0, null, (Function1)toKey.1.INSTANCE, (int)30, null);
    }
}

