/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.oracle.OraModCheck;
import com.intellij.database.model.oracle.OraModForeignKey;
import com.intellij.database.model.oracle.OraModIndex;
import com.intellij.database.model.oracle.OraModKey;
import com.intellij.database.model.oracle.OraModLikeTable;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModStoredSchemaObject;
import com.intellij.database.model.oracle.OraModTableColumn;
import com.intellij.database.model.oracle.OraModTableTrigger;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModTable
extends OraTable,
OraModLikeTable,
OraModStoredSchemaObject {
    @Override
    @NotNull
    public OraModSchema getSchema();

    @Override
    @NotNull
    default public OraModSchema getDbParent() {
        OraModSchema oraModSchema = this.getSchema();
        if (oraModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModTable", "getDbParent"));
        }
        return oraModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModTable> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends OraModTableColumn> getColumns();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModIndex> getIndices();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModKey> getKeys();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModForeignKey> getForeignKeys();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModCheck> getChecks();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModTableTrigger> getTriggers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks()).append((Iterable)this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setRowTypeSchemaName(@Nullable String var1);

    @Override
    public void setRowTypeObjectName(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    @Override
    public void setTablespaceName(@Nullable String var1);

    public void setTemporary(boolean var1);

    public void setOrganization(@NotNull TableOrganization var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/oracle/OraModTable", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String rowTypeSchemaName = properties.get("RowTypeSchemaName");
        String rowTypeObjectName = properties.get("RowTypeObjectName");
        String system = properties.get("System");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        String tablespaceName = properties.get("TablespaceName");
        String temporary = properties.get("Temporary");
        String organization = properties.get("Organization");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (rowTypeSchemaName != null) {
            this.setRowTypeSchemaName(PropertyConverter.importString(rowTypeSchemaName));
        }
        if (rowTypeObjectName != null) {
            this.setRowTypeObjectName(PropertyConverter.importString(rowTypeObjectName));
        }
        if (system != null) {
            this.setSystem(PropertyConverter.importBoolean(system));
        }
        if (createdTimestamp != null) {
            this.setCreatedTimestamp(PropertyConverter.importDate(createdTimestamp));
        }
        if (modifiedTimestamp != null) {
            this.setModifiedTimestamp(PropertyConverter.importDate(modifiedTimestamp));
        }
        if (tablespaceName != null) {
            this.setTablespaceName(PropertyConverter.importString(tablespaceName));
        }
        if (temporary != null) {
            this.setTemporary(PropertyConverter.importBoolean(temporary));
        }
        if (organization != null) {
            this.setOrganization(PropertyConverter.importTableOrganization(organization));
        }
    }
}

