/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.oracle.OraModLikeTable;
import com.intellij.database.model.oracle.OraModSchema;
import com.intellij.database.model.oracle.OraModSchemaObject;
import com.intellij.database.model.oracle.OraModSourceAware;
import com.intellij.database.model.oracle.OraModViewColumn;
import com.intellij.database.model.oracle.OraModViewTrigger;
import com.intellij.database.model.oracle.OraView;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraModView
extends OraView,
OraModLikeTable,
OraModSchemaObject,
OraModSourceAware {
    @Override
    @NotNull
    public OraModSchema getSchema();

    @Override
    @NotNull
    default public OraModSchema getDbParent() {
        OraModSchema oraModSchema = this.getSchema();
        if (oraModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModView", "getDbParent"));
        }
        return oraModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModView> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends OraModViewColumn> getColumns();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends OraModViewTrigger> getTriggers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModView", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraModView", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setRowTypeSchemaName(@Nullable String var1);

    @Override
    public void setRowTypeObjectName(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setInvalid(boolean var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    public void setModifiable(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/oracle/OraModView", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String rowTypeSchemaName = properties.get("RowTypeSchemaName");
        String rowTypeObjectName = properties.get("RowTypeObjectName");
        String system = properties.get("System");
        String invalid = properties.get("Invalid");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        String modifiable = properties.get("Modifiable");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (rowTypeSchemaName != null) {
            this.setRowTypeSchemaName(PropertyConverter.importString(rowTypeSchemaName));
        }
        if (rowTypeObjectName != null) {
            this.setRowTypeObjectName(PropertyConverter.importString(rowTypeObjectName));
        }
        if (system != null) {
            this.setSystem(PropertyConverter.importBoolean(system));
        }
        if (invalid != null) {
            this.setInvalid(PropertyConverter.importBoolean(invalid));
        }
        if (createdTimestamp != null) {
            this.setCreatedTimestamp(PropertyConverter.importDate(createdTimestamp));
        }
        if (modifiedTimestamp != null) {
            this.setModifiedTimestamp(PropertyConverter.importDate(modifiedTimestamp));
        }
        if (modifiable != null) {
            this.setModifiable(PropertyConverter.importBoolean(modifiable));
        }
    }
}

