/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicUserDefinedType;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresCatalogObject;
import com.intellij.database.model.postgres.PostgresDefTypeAttribute;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.properties.PostgresDataTypeSubCategory;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresDefType
extends PostgresCatalogObject,
BasicMajorObject,
BasicUserDefinedType,
BasicNamedElement {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public PostgresSchema getSchema();

    @Override
    @Nullable
    default public PostgresSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PostgresDefType> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull NamingFamily<@NotNull ? extends PostgresDefTypeAttribute> getAttributes();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.singletonList(ObjectKind.OBJECT_ATTRIBUTE);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<NamingFamily<? extends PostgresDefTypeAttribute>> list = Collections.singletonList(this.getAttributes());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from(this.getAttributes());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public long getStateNumber() {
        return 0L;
    }

    @NotNull
    default public PostgresDataTypeSubKind getSubKind() {
        PostgresDataTypeSubKind postgresDataTypeSubKind = PostgresDataTypeSubKind.NONE;
        if (postgresDataTypeSubKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getSubKind"));
        }
        return postgresDataTypeSubKind;
    }

    @NotNull
    default public PostgresDataTypeSubCategory getSubCategory() {
        PostgresDataTypeSubCategory postgresDataTypeSubCategory = PostgresDataTypeSubCategory.NONE;
        if (postgresDataTypeSubCategory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getSubCategory"));
        }
        return postgresDataTypeSubCategory;
    }

    @Nullable
    default public String getDefinition() {
        return null;
    }

    @NotNull
    default public List<String> getLabels() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getLabels"));
        }
        return list;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        List<String> labels;
        String definition;
        PostgresDataTypeSubCategory subCategory;
        PostgresDataTypeSubKind subKind;
        long stateNumber;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresDefType", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((stateNumber = this.getStateNumber()) != 0L) {
            consumer.accept("StateNumber", PropertyConverter.export(stateNumber));
        }
        if ((subKind = this.getSubKind()) != null && subKind != PostgresDataTypeSubKind.NONE) {
            consumer.accept("SubKind", PropertyConverter.export(subKind));
        }
        if ((subCategory = this.getSubCategory()) != null && subCategory != PostgresDataTypeSubCategory.NONE) {
            consumer.accept("SubCategory", PropertyConverter.export(subCategory));
        }
        if ((definition = this.getDefinition()) != null) {
            consumer.accept("Definition", PropertyConverter.export(definition));
        }
        if (!(labels = this.getLabels()).isEmpty()) {
            consumer.accept("Labels", PropertyConverter.exportListOfString(labels));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "Comment", "StateNumber", "SubKind", "SubCategory", "Definition", "Labels");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresDefType", "getPropertyNames"));
        }
        return list;
    }
}

