/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.GridDataSupport;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;

public class RevertMutations
extends DumbAwareAction
implements GridAction {
    public void update(AnActionEvent e) {
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(grid != null && grid.getDataSupport().canRevert() && grid.getDataSupport().hasPendingChanges());
    }

    public void actionPerformed(AnActionEvent e) {
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        if (grid == null || !grid.getDataSupport().hasRowMutator()) {
            return;
        }
        GridDataSupport support = grid.getDataSupport();
        ModelIndexSet<DataConsumer.Column> columns = grid.getSelectionModel().getSelectedColumns();
        ModelIndexSet<DataConsumer.Row> rows = grid.getSelectionModel().getSelectedRows();
        boolean empty = columns.size() == 0 || rows.size() == 0;
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        support.revert(empty ? model.getRowIndices() : rows, empty ? model.getColumnIndices() : columns);
    }
}

