/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.openapi.util.ActionCallback;
import org.jetbrains.annotations.NotNull;

public class DataGridRequestSource
extends ActionCallback {
    private final ModelIndexSet<DataConsumer.Row> myRows;
    private final ModelIndexSet<DataConsumer.Column> myColumns;
    private int myUpdateCount;
    private boolean myErrorReported;
    private boolean myForceSuccess;

    public DataGridRequestSource(@NotNull DataGrid grid) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/DataGridRequestSource", "<init>"));
        }
        this(ModelIndexSet.forRows(grid, new int[0]), ModelIndexSet.forColumns(grid, new int[0]));
    }

    public DataGridRequestSource(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> myColumns) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/run/ui/DataGridRequestSource", "<init>"));
        }
        if (myColumns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myColumns", "com/intellij/database/run/ui/DataGridRequestSource", "<init>"));
        }
        this.myRows = rows;
        this.myColumns = myColumns;
    }

    public void requestComplete(boolean success) {
        if (success) {
            this.setDone();
        } else {
            this.setRejected();
        }
    }

    public void setForceSuccess(boolean forceSuccess) {
        this.myForceSuccess = forceSuccess;
    }

    public boolean isForceSuccess() {
        return this.myForceSuccess;
    }

    public void setUpdateCount(int updateCount) {
        assert (this.myUpdateCount == 0 && this.myRows.size() != 0);
        this.myUpdateCount = updateCount;
    }

    @NotNull
    public ModelIndexSet<DataConsumer.Row> getRows() {
        ModelIndexSet<DataConsumer.Row> modelIndexSet = this.myRows;
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridRequestSource", "getRows"));
        }
        return modelIndexSet;
    }

    @NotNull
    public ModelIndexSet<DataConsumer.Column> getColumns() {
        ModelIndexSet<DataConsumer.Column> modelIndexSet = this.myColumns;
        if (modelIndexSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DataGridRequestSource", "getColumns"));
        }
        return modelIndexSet;
    }

    public int getUpdateCount() {
        return this.myUpdateCount;
    }

    public void setErrorReported() {
        this.myErrorReported = true;
    }

    public boolean isErrorReported() {
        return this.myErrorReported;
    }
}

