/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.extractors.tz.TimeZonedTime;
import com.intellij.database.run.ui.grid.editors.AbstractZonedTimeDelegate;
import java.sql.Time;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import org.jetbrains.annotations.NotNull;

public class ZonedTimeDelegate
extends AbstractZonedTimeDelegate {
    @Override
    TemporalAccessor toTemporalAccessor(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/ZonedTimeDelegate", "toTemporalAccessor"));
        }
        if (!(value instanceof TimeZonedTime)) {
            throw new IllegalArgumentException("Value must be of type TimeZonedTime");
        }
        TimeZonedTime zonedValue = (TimeZonedTime)value;
        Time time = (Time)zonedValue.getValue();
        ZoneOffset zoneId = zonedValue.getZoneOffset() == null ? ZonedDateTime.now().getOffset() : zonedValue.getZoneOffset();
        LocalTime localTime = time.toLocalTime();
        return localTime.atOffset(OffsetTime.now().getOffset()).withOffsetSameInstant(zoneId);
    }
}

