/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.serialization;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.DataType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.serialization.DbmMetaModel;
import com.intellij.database.serialization.ExportException;
import com.intellij.database.serialization.ModelElementMem;
import com.intellij.database.serialization.ModelMem;
import com.intellij.database.serialization.ModelSerializationFun;
import com.intellij.database.serialization.ModelSerializationVersions;
import com.intellij.database.serialization.MutableNameAndValue;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRoot;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelExporter {
    public void saveModel(@NotNull BasicModel model, @NotNull HierarchicalStreamWriter writer) throws ExportException {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/serialization/ModelExporter", "saveModel"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/database/serialization/ModelExporter", "saveModel"));
        }
        ModelMem modelMem = model.read(this::exportModel);
        ModelExporter.serializeModel(modelMem, writer);
    }

    public ModelMem exportModel(@NotNull BasicModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/serialization/ModelExporter", "exportModel"));
        }
        ModelMem mm = new ModelMem();
        mm.setRdbms(model.getRdbms());
        mm.setVersion(ModelSerializationVersions.CURRENT_VERSION);
        LinkedHashMap<BasicElement, Integer> nodes2 = ModelExporter.orderNodes(model.getRoot());
        for (BasicElement node : nodes2.keySet()) {
            ModelElementMem om = this.exportElement(node, nodes2);
            mm.getNodes().add(om);
        }
        return mm;
    }

    private static LinkedHashMap<BasicElement, Integer> orderNodes(BasicRoot root2) {
        int counter = 0;
        JBTreeTraverser traverser = (JBTreeTraverser)((JBTreeTraverser)new JBTreeTraverser(BasicElement::getDbChildren).withRoot((Object)root2)).expand(e -> e instanceof BasicNamespace ? ((BasicNamespace)e).isVisible() : true);
        LinkedHashMap nodes2 = ContainerUtil.newLinkedHashMap();
        for (BasicElement object : traverser.bfsTraversal()) {
            Integer id = ++counter;
            nodes2.put(object, id);
        }
        return nodes2;
    }

    private ModelElementMem exportElement(BasicElement element, Map<BasicElement, Integer> nodes2) {
        Integer parentId;
        Integer id = nodes2.get(element);
        assert (id != null) : "Each node must be counted and ordered before exporting";
        BasicElement parentElement = element.getDbParent();
        Integer n = parentId = parentElement != null ? nodes2.get(parentElement) : null;
        assert (element instanceof BasicRoot == (parentElement == null));
        ImmutableList<MutableNameAndValue> properties = this.exportElementProperties(element);
        String elementName = element instanceof BasicNamedElement ? ((BasicNamedElement)element).getRealName() : null;
        return new ModelElementMem(id, parentId, element.getKind().code(), elementName, (List<MutableNameAndValue>)properties);
    }

    private ImmutableList<MutableNameAndValue> exportElementProperties(BasicElement element) {
        ImmutableList.Builder b = new ImmutableList.Builder();
        element.exportProperties((name, value) -> {
            if (value != null) {
                b.add((Object)new MutableNameAndValue(name, (String)value));
            } else {
                System.err.println("Attempted to export null property " + name);
            }
        });
        return b.build();
    }

    public void writeModel(@NotNull DbmModel model, @NotNull HierarchicalStreamWriter writer) throws ExportException {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/serialization/ModelExporter", "writeModel"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/database/serialization/ModelExporter", "writeModel"));
        }
        this.writeForest(model, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeForest(@NotNull DbmModel model, @NotNull HierarchicalStreamWriter writer) throws ExportException {
        ModelMem modelMem;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/serialization/ModelExporter", "writeForest"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/database/serialization/ModelExporter", "writeForest"));
        }
        model.startConsistentRead();
        try {
            modelMem = ModelExporter.exportForest(model);
        }
        finally {
            model.finishConsistentRead();
        }
        ModelExporter.serializeModel(modelMem, writer);
    }

    public static ModelMem exportForest(@NotNull DbmModel model) throws ExportException {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/serialization/ModelExporter", "exportForest"));
        }
        LinkedHashMap<DbmObject, Integer> nodes2 = ModelExporter.orderNodes(model.getRoot());
        ArrayList<ModelElementMem> mb = new ArrayList<ModelElementMem>(nodes2.size());
        for (DbmObject node : nodes2.keySet()) {
            ModelElementMem om = ModelExporter.exportNode(node, nodes2);
            mb.add(om);
        }
        TreeMap<String, String> mp = new TreeMap<String, String>();
        return new ModelMem(model.getRdbms(), ModelSerializationVersions.CURRENT_VERSION, mb, mp);
    }

    private static LinkedHashMap<DbmObject, Integer> orderNodes(DbmRoot<?> root2) {
        int counter = 0;
        JBTreeTraverser traverser = (JBTreeTraverser)((JBTreeTraverser)new JBTreeTraverser(DbmObject::getDbChildren).withRoot(root2)).expand(object -> object instanceof DbmNamespace ? ((DbmNamespace)object).isVisible() : true);
        LinkedHashMap nodes2 = ContainerUtil.newLinkedHashMap();
        for (DbmObject object2 : traverser.bfsTraversal()) {
            Integer id = ++counter;
            nodes2.put(object2, id);
        }
        return nodes2;
    }

    private static ModelElementMem exportNode(@NotNull DbmObject node, @NotNull Map<DbmObject, Integer> nodes2) throws ExportException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/serialization/ModelExporter", "exportNode"));
        }
        if (nodes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/database/serialization/ModelExporter", "exportNode"));
        }
        Integer id = nodes2.get(node);
        assert (id != null) : "Each node must be counted and ordered before exporting";
        Integer parentId = node.getDbParent() != null ? nodes2.get(node.getDbParent()) : null;
        ImmutableList<MutableNameAndValue> properties = ModelExporter.exportNodeProperties(node);
        return new ModelElementMem(id, parentId, node.getKind().code(), node.getNameOrNull(), (List<MutableNameAndValue>)properties);
    }

    @NotNull
    static ImmutableList<MutableNameAndValue> exportNodeProperties(@NotNull DbmObject node) throws ExportException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/serialization/ModelExporter", "exportNodeProperties"));
        }
        DbmMetaModel.ObjectMetaInfo mi = DbmMetaModel.obtainMetaInfo(node.getClass());
        ImmutableList.Builder b = ImmutableList.builder();
        for (DbmMetaModel.PropertyMetaInfo pi : mi.getProperties()) {
            MutableNameAndValue propertyNameAndValue = ModelExporter.peekProperty(node, pi);
            if (propertyNameAndValue == null) continue;
            b.add((Object)propertyNameAndValue);
        }
        ImmutableList immutableList = b.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/serialization/ModelExporter", "exportNodeProperties"));
        }
        return immutableList;
    }

    @Nullable
    private static MutableNameAndValue peekProperty(DbmObject object, DbmMetaModel.PropertyMetaInfo pi) throws ExportException {
        try {
            String value = pi.isHolder ? ModelExporter.peekHoldedValue(object, pi) : ModelExporter.peekPlainValue(object, pi);
            return value != null ? new MutableNameAndValue(pi.name, value) : null;
        }
        catch (Exception e) {
            String message = String.format("Exception when attempt to get value of property %s from node class %s (node id: %s, description: %s). Exception class: %s, message: %s", pi.name, object.getClass().getSimpleName(), object.identity(true), object.description(true), e.getClass().getSimpleName(), e.getMessage());
            throw new ExportException(message, e);
        }
    }

    @Nullable
    private static String peekHoldedValue(DbmObject object, DbmMetaModel.PropertyMetaInfo pi) throws ExportException {
        try {
            Object holderObject = pi.propertyField.get(object);
            assert (holderObject instanceof PropertyHolder) : "The final property must implement PropertyHolder";
            PropertyHolder holder = (PropertyHolder)holderObject;
            return holder.exportState();
        }
        catch (Exception e) {
            throw new ExportException("A strange exception when accessing holded property " + pi.propertyField.getName() + ": " + e.getMessage(), e);
        }
    }

    @Nullable
    private static String peekPlainValue(DbmObject node, DbmMetaModel.PropertyMetaInfo pi) throws ExportException {
        try {
            boolean primitive = pi.propertyField.getType().isPrimitive();
            Object value = pi.propertyField.get(node);
            return ModelExporter.convertValueToText(value, primitive);
        }
        catch (Exception e) {
            throw new ExportException("A strange exception when accessing plain property " + pi.propertyField.getName() + ": " + e.getMessage(), e);
        }
    }

    @Nullable
    static String convertValueToText(@Nullable Object value, boolean primitive) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1" : (primitive ? null : "0");
        }
        if (value instanceof Character) {
            Character c = (Character)value;
            return c.charValue() == '\u0000' ? null : c.toString();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            String numberStr = number.toString();
            return numberStr.equals("0") ? null : numberStr;
        }
        if (value instanceof Date) {
            return PropertyConverter.formatTimestamp((Date)value);
        }
        if (value.getClass().isEnum()) {
            return ((Enum)value).name();
        }
        if (value instanceof DataType) {
            return DataTypeFactory.serialize((DataType)value);
        }
        if (value instanceof SequenceIdentity) {
            return ((SequenceIdentity)value).getSpecification();
        }
        String string = value.toString();
        string = ModelSerializationFun.normalize(string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeModel(@NotNull ModelMem mem, @NotNull HierarchicalStreamWriter writer) {
        if (mem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mem", "com/intellij/database/serialization/ModelExporter", "serializeModel"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/database/serialization/ModelExporter", "serializeModel"));
        }
        writer.startNode("database-model");
        try {
            writer.addAttribute("serializer", "dbm");
            writer.addAttribute("rdbms", mem.getRdbms().code);
            writer.addAttribute("format-version", ModelSerializationVersions.CURRENT_VERSION.toString());
            for (Map.Entry<String, String> property : mem.getProperties().entrySet()) {
                writer.addAttribute(property.getKey(), property.getValue());
            }
            for (ModelElementMem object : mem.getNodes()) {
                ModelExporter.serializeNode(object, writer);
            }
        }
        finally {
            writer.endNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serializeNode(ModelElementMem node, HierarchicalStreamWriter writer) {
        writer.startNode(node.getKind());
        try {
            writer.addAttribute("id", Integer.toString(node.getId()));
            if (node.getParentId() != null) {
                writer.addAttribute("parent", node.getParentId().toString());
            }
            if (node.getName() != null) {
                writer.addAttribute("name", node.getName());
            }
            for (MutableNameAndValue property : node.getProperties()) {
                if (property.getName().equalsIgnoreCase("name")) continue;
                ModelExporter.serializeProperty(property, writer);
            }
        }
        finally {
            writer.endNode();
        }
    }

    private static void serializeProperty(MutableNameAndValue property, HierarchicalStreamWriter writer) {
        writer.startNode(property.getName());
        try {
            writer.setValue(property.getValue());
        }
        finally {
            writer.endNode();
        }
    }
}

