/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.serialization;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TimestampParsingException;
import com.intellij.database.serialization.DbmMetaModel;
import com.intellij.database.serialization.ImportException;
import com.intellij.database.serialization.ModelConverters;
import com.intellij.database.serialization.ModelElementMem;
import com.intellij.database.serialization.ModelMem;
import com.intellij.database.serialization.ModelSerializationFun;
import com.intellij.database.serialization.ModelSerializationVersions;
import com.intellij.database.serialization.ModelUpdating;
import com.intellij.database.serialization.MutableNameAndValue;
import com.intellij.database.serialization.ParseValueException;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmMultiDatabaseModel;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleDatabaseModel;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.dbm.factories.RdbmsRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.util.Version;

public final class ModelImporter {
    private static final ModelConverters ourConverters = new ModelConverters();
    private static final Logger LOG = Logger.getInstance(ModelImporter.class);
    @NotNull
    private final ModelFactory myModelFactory;
    public Set<String> myUnconsumedProperties;
    @NotNull
    private static final ImmutableMap<Type, Method> ourObjectParseMethods;

    public ModelImporter(@NotNull ModelFactory modelFactory) {
        if (modelFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelFactory", "com/intellij/database/serialization/ModelImporter", "<init>"));
        }
        this.myUnconsumedProperties = null;
        this.myModelFactory = modelFactory;
    }

    @NotNull
    public ModelMem deserializeModel(@NotNull HierarchicalStreamReader reader) throws ImportException {
        Version formatVersion;
        Rdbms rdbms;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/serialization/ModelImporter", "deserializeModel"));
        }
        String rootNodeName = reader.getNodeName();
        if (!rootNodeName.equalsIgnoreCase("database-model")) {
            throw new ImportException("The root node of the database model must be database-model, but found " + rootNodeName);
        }
        try {
            String rdbmsCode = reader.getAttribute("rdbms");
            if (rdbmsCode == null) {
                throw new ImportException("RDBMS is not specified int the model file");
            }
            if (rdbmsCode.equalsIgnoreCase("POSTGRE")) {
                rdbmsCode = "POSTGRES";
            }
            rdbms = RdbmsRegistry.instance().getDefinitionByCode((String)rdbmsCode).rdbms;
        }
        catch (IllegalArgumentException iae) {
            throw new ImportException("Error reading RDBMS: " + iae.getMessage(), iae);
        }
        try {
            String formatVersionString = reader.getAttribute("format-version");
            formatVersion = formatVersionString == null ? Version.ZERO : Version.of((String)formatVersionString);
        }
        catch (Exception e) {
            throw new ImportException("Error reading format version: " + e.getMessage(), e);
        }
        ModelMem mm = new ModelMem();
        mm.setRdbms(rdbms);
        mm.setVersion(formatVersion);
        int n = reader.getAttributeCount();
        for (int i2 = 0; i2 < n; ++i2) {
            String attrValue;
            String attrName = reader.getAttributeName(i2);
            if (attrName.equalsIgnoreCase("rdbms") || attrName.equalsIgnoreCase("format-version") || (attrValue = reader.getAttribute(i2)) == null || attrValue.isEmpty()) continue;
            mm.getProperties().put(attrName, attrValue);
        }
        if (formatVersion.compareTo(ModelSerializationVersions.MIN_VERSION) < 0 || formatVersion.compareTo(ModelSerializationVersions.CURRENT_VERSION) > 0) {
            String message = "Unsupported format version " + formatVersion + " (the " + ModelSerializationVersions.CURRENT_VERSION + " is expected)";
            reader.appendErrors((ErrorWriter)new ConversionException(message));
        } else {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                ModelElementMem mem = ModelImporter.deserializeObject(reader);
                mm.getNodes().add(mem);
                reader.moveUp();
            }
        }
        ModelMem modelMem = mm;
        if (modelMem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/serialization/ModelImporter", "deserializeModel"));
        }
        return modelMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModelElementMem deserializeObject(@NotNull HierarchicalStreamReader reader) throws ImportException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/serialization/ModelImporter", "deserializeObject"));
        }
        String kind = reader.getNodeName();
        Integer id = ModelImporter.parseId(reader);
        Integer parentId = ModelImporter.parseParentId(reader);
        String name = StringUtil.nullize((String)reader.getAttribute("name"));
        ModelElementMem em = new ModelElementMem();
        em.setKind(kind);
        em.setId(id);
        em.setParentId(parentId);
        em.setName(name);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            try {
                String key = reader.getNodeName();
                key = ModelSerializationFun.normalize(key);
                String value = reader.getValue();
                value = ModelSerializationFun.normalize(value);
                if (key == null || value == null || key.equalsIgnoreCase("name")) continue;
                em.getProperties().add(new MutableNameAndValue(key, value));
            }
            finally {
                reader.moveUp();
            }
        }
        return em;
    }

    private static Integer parseId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/serialization/ModelImporter", "parseId"));
        }
        String str = reader.getAttribute("id");
        if (StringUtil.isEmpty((String)str)) {
            throw new ImportException("The node " + reader.getNodeName() + " has no id");
        }
        try {
            return new Integer(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse id", nfe);
        }
    }

    private static Integer parseParentId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/serialization/ModelImporter", "parseParentId"));
        }
        String str = reader.getAttribute("parent");
        if (StringUtil.isEmpty((String)str)) {
            return null;
        }
        try {
            return new Integer(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse parent id", nfe);
        }
    }

    public BasicModModel importModel(@NotNull ModelMem modelMem) throws ImportException {
        if (modelMem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/database/serialization/ModelImporter", "importModel"));
        }
        ourConverters.convertMem(modelMem);
        BasicModModel model = this.createModel2(modelMem.getRdbms());
        model.modify(BasicModRoot.class, root2 -> {
            if (modelMem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/database/serialization/ModelImporter", "lambda$importModel$0"));
            }
            this.populateModel(modelMem, (BasicModRoot)root2);
        });
        ourConverters.convertModel(model, modelMem.getVersion());
        return model;
    }

    private BasicModModel createModel2(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/serialization/ModelImporter", "createModel2"));
        }
        return this.myModelFactory.createModel(rdbms);
    }

    private void populateModel(@NotNull ModelMem modelMem, @NotNull BasicModRoot root2) {
        BasicModElement element;
        if (modelMem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/database/serialization/ModelImporter", "populateModel"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/serialization/ModelImporter", "populateModel"));
        }
        HashMap<Integer, BasicModRoot> elements = new HashMap<Integer, BasicModRoot>(modelMem.getNodes().size());
        for (ModelElementMem mem : modelMem.getNodes()) {
            ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(mem.getKind());
            if (kind == null) {
                throw new AssertionError((Object)("ObjectKind " + mem.getKind() + " not found"));
            }
            if (mem.getParentId() == null) {
                if (kind != ObjectKind.ROOT) {
                    throw new ImportException("Only a root object can be a root of the tree. However, found " + mem.getKind() + " without a parent");
                }
                element = root2;
            } else {
                BasicModElement parent = (BasicModElement)elements.get(mem.getParentId());
                if (parent == null) {
                    throw new ImportException("Object " + mem.getId() + " references parent " + mem.getParentId() + " that is not found or not processed yet");
                }
                com.intellij.database.model.families.Family family = parent.familyOf(kind);
                if (family == null) continue;
                element = family.createNewOne();
                if (element instanceof BasicModNamedElement) {
                    ((BasicModNamedElement)element).setRealName(mem.getName());
                }
            }
            elements.put(mem.getId(), (BasicModRoot)element);
        }
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        for (ModelElementMem mem : modelMem.getNodes()) {
            element = (BasicModElement)elements.get(mem.getId());
            assert (element != null);
            propertiesMap.clear();
            for (MutableNameAndValue p : mem.getProperties()) {
                propertiesMap.put(ModelImporter.nameFromXmlToHumps(p.getName()), p.getValue());
            }
            element.importProperties(propertiesMap);
            Set<String> unconsumedProperties = this.myUnconsumedProperties;
            if (unconsumedProperties == null) continue;
            propertiesMap.keySet().removeAll(element.getPropertyNames());
            if (propertiesMap.isEmpty()) continue;
            String className = element.getModel().getClass().getSimpleName() + '.' + element.getClass().getSimpleName() + '.';
            for (String propName : propertiesMap.keySet()) {
                unconsumedProperties.add(className + propName);
            }
        }
    }

    public Set<String> getUnconsumedProperties() {
        return this.myUnconsumedProperties;
    }

    public void setUnconsumedProperties(Set<String> unconsumedProperties) {
        this.myUnconsumedProperties = unconsumedProperties;
    }

    @NotNull
    static String nameFromXmlToHumps(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/serialization/ModelImporter", "nameFromXmlToHumps"));
        }
        String string = StringUtil.capitalizeWords((String)name, (String)"-", (boolean)true, (boolean)true).replace("-", "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/serialization/ModelImporter", "nameFromXmlToHumps"));
        }
        return string;
    }

    @NotNull
    public DbmModel buildModel(@NotNull ModelMem modelMem) throws ImportException {
        if (modelMem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/database/serialization/ModelImporter", "buildModel"));
        }
        ourConverters.convertMem(modelMem);
        DbmModel<?, ?> model = ModelImporter.createModel(modelMem.getRdbms());
        DbmModel dbmModel = this.buildModel(modelMem, model);
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/serialization/ModelImporter", "buildModel"));
        }
        return dbmModel;
    }

    @NotNull
    public DbmModel buildModel(@NotNull ModelMem modelMem, @NotNull DbmModel model) throws ImportException {
        if (modelMem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/database/serialization/ModelImporter", "buildModel"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/serialization/ModelImporter", "buildModel"));
        }
        model.startModifications();
        try {
            ModelImporter.buildModelInTransaction(modelMem, model);
        }
        finally {
            model.finishModifications();
        }
        if (!modelMem.getVersion().isOrGreater(new int[]{2, 6})) {
            ModelUpdating.upgradeTo26(model);
        }
        DbmModel dbmModel = model;
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/serialization/ModelImporter", "buildModel"));
        }
        return dbmModel;
    }

    private static void buildModelInTransaction(@NotNull ModelMem modelMem, DbmModel<?, ?> model) {
        DbmSingleDatabaseModel m2;
        if (modelMem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/database/serialization/ModelImporter", "buildModelInTransaction"));
        }
        HashMap<Integer, BasicRoot> objects = new HashMap<Integer, BasicRoot>(modelMem.getNodes().size());
        for (ModelElementMem mem : modelMem.getNodes()) {
            BasicRoot object;
            ObjectKind kind = model.metaModel.findKind(mem.getKind());
            if (kind == null) {
                throw new AssertionError((Object)(mem.getKind() + " not found among " + model.metaModel));
            }
            if (mem.getParentId() == null) {
                if (kind != ObjectKind.ROOT) {
                    throw new ImportException("Only a root object can be a root of the tree. However, found " + mem.getKind() + " without a parent");
                }
                object = model.getRoot();
            } else {
                DbmObject parent = (DbmObject)objects.get(mem.getParentId());
                if (parent == null) {
                    throw new ImportException("Object " + mem.getId() + " references parent " + mem.getParentId() + " that is not found or not processed yet");
                }
                ModFamily family = parent.familyOf(kind);
                object = ((Family)family).create(mem.getName());
            }
            objects.put(mem.getId(), object);
        }
        for (ModelElementMem mem : modelMem.getNodes()) {
            DbmObject object = (DbmObject)objects.get(mem.getId());
            assert (object != null);
            ModelImporter.assignProperties(object, mem.getProperties());
        }
        if (model instanceof DbmMultiDatabaseModel) {
            DbmMultiDatabaseModel m1 = (DbmMultiDatabaseModel)model;
            if (m1.databases().isNotEmpty()) {
                m1.setCurrentDatabase((DbmDatabase)m1.databases().first());
                for (DbmDatabase database : m1.databases()) {
                    if (!((Family)database.getSchemas()).isNotEmpty()) continue;
                    database.setCurrentSchema((DbmSchema)((Family)database.getSchemas()).first());
                }
            }
        } else if (model instanceof DbmSingleDatabaseModel && (m2 = (DbmSingleDatabaseModel)model).schemas().isNotEmpty()) {
            m2.setCurrentSchema((DbmSchema)m2.schemas().first());
        }
    }

    @NotNull
    private static DbmModel<?, ?> createModel(@NotNull Rdbms rdbms) throws ImportException {
        DbmModel model;
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/serialization/ModelImporter", "createModel"));
        }
        Class<? extends DbmModel> modelClass = RdbmsRegistry.instance().getDefinitionByRdbms((Rdbms)rdbms).modelClass;
        try {
            model = modelClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ImportException("Could not instantiate " + modelClass.getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ImportException("Could not instantiate " + modelClass.getSimpleName(), e);
        }
        assert (model.getRdbms().equals((Object)rdbms));
        DbmModel dbmModel = model;
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/serialization/ModelImporter", "createModel"));
        }
        return dbmModel;
    }

    private static void assignProperties(DbmObject object, List<MutableNameAndValue> properties) throws ImportException {
        DbmMetaModel.ObjectMetaInfo mi = DbmMetaModel.obtainMetaInfo(object.getClass());
        for (MutableNameAndValue p : properties) {
            DbmMetaModel.PropertyMetaInfo pi = mi.getPropertiesByName().get(p.getName());
            if (pi == null) {
                throw new ImportException("Unknown how to import property \"" + p.getName() + "\" into an object of class \"" + object.getClass().getSimpleName() + "\"");
            }
            ModelImporter.assignProperty(object, p, pi);
        }
    }

    private static void assignProperty(DbmObject object, MutableNameAndValue p, DbmMetaModel.PropertyMetaInfo pi) throws ImportException {
        try {
            if (pi.isHolder) {
                Object holderObject = pi.propertyField.get(object);
                assert (holderObject != null) : "Property holder must not be null";
                PropertyHolder holder = (PropertyHolder)holderObject;
                holder.importState(p.getValue());
            } else {
                Object value = ModelImporter.parseValue(object, p, pi.valueType);
                if (value != null) {
                    if (pi.setter != null) {
                        pi.setter.invoke((Object)object, value);
                    } else {
                        pi.propertyField.set(object, value);
                    }
                }
            }
        }
        catch (Exception e) {
            String message = "Failed to assign property " + pi.name + " to object " + object.getClass().getSimpleName() + ": " + e.getMessage();
            throw new ImportException(message, e);
        }
    }

    static Object parseValue(@NotNull DbmObject object, @NotNull MutableNameAndValue p, @NotNull Type type) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/serialization/ModelImporter", "parseValue"));
        }
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/database/serialization/ModelImporter", "parseValue"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/serialization/ModelImporter", "parseValue"));
        }
        String propertyName = p.getName();
        String text = ModelSerializationFun.normalize(p.getValue());
        if (text == null) {
            return null;
        }
        try {
            return ModelImporter.parseValue(text, type);
        }
        catch (ParseValueException pve) {
            Throwable cause = pve.getCause();
            String typeName = type instanceof Class ? ((Class)type).getSimpleName() : type.toString();
            String message = cause == null ? String.format("Failed to parse property %s.%s (type %s): %s\nProperty text: %s\n", object.getClass().getSimpleName(), propertyName, typeName, pve.getMessage(), text) : String.format("Failed to parse property %s.%s (type %s): %s\nException %s with message: %s\nProperty text: %s\n", object.getClass().getSimpleName(), propertyName, typeName, pve.getMessage(), cause.getClass().getSimpleName(), cause.getMessage(), text);
            LOG.warn(message);
            return null;
        }
        catch (Exception e) {
            String typeName = type instanceof Class ? ((Class)type).getSimpleName() : type.toString();
            String message = String.format("Failed to parse property %s.%s (type %s): exception %s with message: %s\nProperty text: %s\n", object.getClass().getSimpleName(), propertyName, typeName, e.getClass().getSimpleName(), e.getMessage(), text);
            LOG.warn(message, (Throwable)e);
            return null;
        }
    }

    static Object parseValue(@NotNull String text, @NotNull Type type) throws ParseValueException {
        Object value;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/serialization/ModelImporter", "parseValue"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/serialization/ModelImporter", "parseValue"));
        }
        assert (type instanceof Class);
        Class clazz = (Class)type;
        if (clazz == String.class) {
            value = text;
        } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            char c = Character.toUpperCase(text.isEmpty() ? (char)'0' : text.charAt(0));
            value = c >= '1' && c <= '9' || c == '+' || c == 'Y' || c == 'T';
        } else if (ourObjectParseMethods.containsKey((Object)clazz)) {
            Method method = (Method)ourObjectParseMethods.get((Object)clazz);
            try {
                value = method.invoke(null, text);
            }
            catch (Exception e) {
                String message = "Failed to convert \"" + text + "\" into an instance of " + type + ": " + e.getMessage();
                throw new ParseValueException(message, e);
            }
        } else {
            if (clazz == Date.class) {
                try {
                    return PropertyConverter.parseTimestamp(text);
                }
                catch (TimestampParsingException tpe) {
                    throw new ParseValueException(tpe);
                }
            }
            if (clazz.isEnum()) {
                value = Enum.valueOf(clazz, text);
            } else if (clazz == BigInteger.class) {
                value = new BigInteger(text);
            } else {
                String message = "Unknown how to convert \"" + text + "\" into an instance of " + type;
                throw new ParseValueException(message);
            }
        }
        return value;
    }

    static {
        try {
            ourObjectParseMethods = ImmutableMap.builder().put(Byte.TYPE, (Object)Byte.class.getDeclaredMethod("parseByte", String.class)).put(Byte.class, (Object)Byte.class.getDeclaredMethod("parseByte", String.class)).put(Short.TYPE, (Object)Short.class.getDeclaredMethod("parseShort", String.class)).put(Short.class, (Object)Short.class.getDeclaredMethod("parseShort", String.class)).put(Integer.TYPE, (Object)Integer.class.getDeclaredMethod("parseInt", String.class)).put(Integer.class, (Object)Integer.class.getDeclaredMethod("parseInt", String.class)).put(Long.TYPE, (Object)Long.class.getDeclaredMethod("parseLong", String.class)).put(Long.class, (Object)Long.class.getDeclaredMethod("parseLong", String.class)).put(DataType.class, (Object)DataTypeFactory.class.getDeclaredMethod("deserialize", String.class)).put(SequenceIdentity.class, (Object)SequenceIdentity.class.getDeclaredMethod("of", String.class)).put(LengthUnit.class, (Object)LengthUnit.class.getDeclaredMethod("of", String.class)).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

