/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.statistic;

import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JdbcDriverUsageCollector
extends AbstractApplicationUsagesCollector {
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/statistic/JdbcDriverUsageCollector", "getProjectUsages"));
        }
        HashSet set = new HashSet();
        for (DbDataSource dataSource : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            String driverClass;
            if (!(dataSource.getDelegate() instanceof RawConnectionConfig) || StringUtil.isEmpty((String)(driverClass = ((RawConnectionConfig)dataSource.getDelegate()).getDriverClass()))) continue;
            set.add((Object)new UsageDescriptor(driverClass, 1));
        }
        HashSet hashSet = set;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/statistic/JdbcDriverUsageCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"jdbc-driver", (double)100.0);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/statistic/JdbcDriverUsageCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

