/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseOpenFileDescriptor;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbCustomType;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNodeDescriptor
extends PresentableNodeDescriptor
implements DataProvider,
ComparableObject {
    public static final DbNodeDescriptor[] EMPTY_ARRAY = new DbNodeDescriptor[0];
    private final DbElement myElement;

    public DbNodeDescriptor(DbElement element, NodeDescriptor parent) {
        super(element.getProject(), parent);
        this.myElement = element;
    }

    public DbElement getElement() {
        return this.myElement;
    }

    protected void update(PresentationData presentation) {
        DasSynonym synonym;
        Iterable path;
        String pathString;
        BasicIndex index;
        BasicForeignKey foreignKey;
        Object type;
        SimpleTextAttributes style;
        DbElement element = this.getElement();
        if (!element.isValid()) {
            return;
        }
        presentation.setChanged(true);
        final Icon icon = element.getIcon();
        presentation.setIcon(icon == null ? null : new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                icon.paintIcon(c, g, x, y);
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth() + 3;
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }
        });
        boolean hasErrors = false;
        boolean hasWarnings = false;
        Object delegate = element.getDelegate();
        if (!this.isValid()) {
            hasErrors = true;
        } else if (element instanceof DbDataSource && delegate instanceof LocalDataSource) {
            hasErrors = !DbImplUtil.canConnectTo(element);
            hasWarnings = hasErrors;
            if (!hasErrors) {
                for (DataSourceProblem problem : DatabaseConfigValidator.getProblems(delegate, DatabaseConfigValidator.Control.DUMMY)) {
                    DataSourceProblem.Level level = problem.getLevel();
                    if (level == DataSourceProblem.Level.WARNING) {
                        hasWarnings = true;
                        continue;
                    }
                    if (level != DataSourceProblem.Level.ERROR) continue;
                    hasErrors = true;
                    hasWarnings = true;
                }
            }
        } else if (delegate instanceof BasicSourceAware) {
            hasErrors = ((BasicSourceAware)delegate).isInvalid();
        }
        String nodeText = DbNodeDescriptor.getDisplayName(element);
        presentation.setPresentableText(nodeText);
        SimpleTextAttributes simpleTextAttributes = hasErrors || hasWarnings ? new SimpleTextAttributes(8, this.getColor(), (Color)(hasErrors ? JBColor.RED : JBColor.ORANGE)) : (style = SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (hasErrors && delegate instanceof LocalDataSource && !DbImplUtil.hasDriverFiles((LocalDataSource)((Object)delegate))) {
            presentation.setTooltip("Can't find the driver, open preferences to download");
        }
        if (DbImplUtil.isConnected(element)) {
            style = SimpleTextAttributes.merge((SimpleTextAttributes)style, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            presentation.setTooltip("Connected");
        }
        presentation.addText(new PresentableNodeDescriptor.ColoredFragment(nodeText, null, style));
        if (element instanceof DbDataSource || element instanceof DbNamespaceImpl) {
            String textExt;
            DbElement root2 = DatabaseStructure.getTopSingleRoot(element);
            if (root2 != element && StringUtil.isNotEmpty((String)(textExt = QNameUtil.getQualifiedName(root2)))) {
                presentation.addText(" (" + textExt + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        } else if (element instanceof DbCustomType) {
            String description = DbImplUtil.getCustomTypeShortDescription(element.getDelegate());
            if (description != null) {
                presentation.addText(' ' + description, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else if (element instanceof DbColumn) {
            type = new DdlBuilder().configureFor(element).type((DasTypedObject)((DbColumn)element)).getStatement();
            presentation.addText(" " + (String)type, SimpleTextAttributes.GRAYED_ATTRIBUTES);
            if (DasUtil.isAutoVal((DasColumn)((DbColumn)element))) {
                presentation.addText(" (auto increment)", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else if (element instanceof DbTable) {
            type = element.getKind();
            if (type != ObjectKind.TABLE && type != ObjectKind.VIEW) {
                presentation.addText(" " + element.getTypeName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        } else if (element instanceof DbRoutine) {
            DbRoutine procedure = (DbRoutine)element;
            StringBuilder sb = new StringBuilder();
            DdlBuilder builder = new DdlBuilder(sb).configureFor(element);
            DbImplUtil.getDatabaseDialect((DbElement)procedure).sqlDefinePrototype(builder, (DasRoutine)procedure, false, true);
            presentation.addText(sb.toString(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (element instanceof BasicKey) {
            BasicKey key = (BasicKey)element;
            presentation.addText(" " + StringUtil.join(key.getColNames(), (String)", "), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (element instanceof DasTableKey) {
            presentation.addText(" " + DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)((DasTableKey)element).getColumnsRef()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (element instanceof BasicForeignKey) {
            foreignKey = (BasicForeignKey)element;
            String referencingColumns = StringUtil.join(foreignKey.getColNames(), (String)", ");
            String arrowToReferenced = DbNodeDescriptor.arrowToColumns(foreignKey.getRefTableName(), foreignKey.getRefColumns());
            presentation.addText(" " + referencingColumns + " " + arrowToReferenced, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (element instanceof DasForeignKey) {
            foreignKey = (DasForeignKey)element;
            String referencingColumns = DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)foreignKey.getColumnsRef());
            String arrowToReferenced = DbNodeDescriptor.arrowToColumns(foreignKey.getRefTableName(), (MultiRef<? extends DasTypedObject>)foreignKey.getRefColumns());
            presentation.addText(" " + referencingColumns + " " + arrowToReferenced, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (element instanceof BasicIndex) {
            index = (BasicIndex)element;
            String unique = index.isUnique() ? " UNIQUE" : "";
            String columns = StringUtil.join(index.getColNames(), (String)", ");
            presentation.addText(" " + columns + unique, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (element instanceof DasIndex) {
            index = (DasIndex)element;
            String unique = index.isUnique() ? " UNIQUE" : "";
            String columns = DbNodeDescriptor.multiRef((MultiRef<? extends DasTypedObject>)index.getColumnsRef());
            presentation.addText(" " + columns + unique, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (element instanceof DasSynonym && (pathString = StringUtil.join((Iterable)(path = (synonym = (DasSynonym)element).getTargetPath()), (String)".")).length() > 0) {
            String text = " " + DbNodeDescriptor.arrow() + " " + pathString;
            presentation.addText(text, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    @NotNull
    private static String getDisplayName(@NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DbNodeDescriptor", "getDisplayName"));
        }
        Object d = element.getDelegate();
        String string = d instanceof BasicNode ? ((BasicNode)d).getDisplayName() : DbPresentation.getPresentableName((DasObject)element);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "getDisplayName"));
        }
        return string;
    }

    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        return null;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return DbNodeDescriptor.getData(dataId, this.getElement());
    }

    static Object getData(@NonNls String dataId, DbElement element) {
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            final Project project = element.getProject();
            final Object delegate = ContainerUtil.getFirstItem(((DbElementImpl)element).getDelegates());
            if (delegate instanceof Navigatable) {
                return delegate;
            }
            if (delegate instanceof DatabaseSystem) {
                VirtualFile virtualFile = delegate instanceof SqlDataSource ? (VirtualFile)ContainerUtil.getFirstItem((List)((SqlDataSource)delegate).getFiles()) : DatabaseEditorHelper.findExistingConsoleVirtualFile((DatabaseSystem)delegate);
                if (virtualFile == null && DbImplUtil.canConnectTo(element)) {
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            VirtualFile file = DatabaseEditorHelper.getConsoleVirtualFile((DatabaseSystem)delegate);
                            if (file == null) {
                                return;
                            }
                            new OpenFileDescriptor(project, file).navigate(requestFocus);
                        }
                    };
                }
                return virtualFile == null ? element : new OpenFileDescriptor(project, virtualFile);
            }
            if (delegate instanceof DasNamespace && element.getKind() == ObjectKind.SCHEMA) {
                if (DbImplUtil.canConnectTo(element)) {
                    final DatabaseSystem dataSourceInfo = (DatabaseSystem)ObjectUtils.assertNotNull((Object)element.getDataSource().getDelegate());
                    return new NavigatableAdapter(){

                        public void navigate(boolean requestFocus) {
                            DatabaseEditorHelper.openConsoleFile(project, dataSourceInfo, (DasNamespace)delegate, false);
                        }
                    };
                }
                return element;
            }
            return DbNodeDescriptor.getNavigatableImpl(project, element);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return element;
        }
        return null;
    }

    @NotNull
    public static Object getNavigatableImpl(Project project, DbElement element) {
        VirtualFile virtualFile;
        DatabaseFamilyId familyId;
        boolean isTrigger = element instanceof DbTrigger;
        DbElement parent = element.getDbParent();
        DbElement adjusted = element;
        if (parent instanceof DbTable) {
            if (!isTrigger) {
                adjusted = parent;
            }
        } else if (parent instanceof DbPackage && !(familyId = DbImplUtil.getDatabaseDialect(element).getFamilyId()).isSybase()) {
            DbElement body = (DbElement)parent.getDbChildren(DbElement.class, ObjectKind.BODY).first();
            adjusted = (DbElement)ObjectUtils.chooseNotNull((Object)body, (Object)parent);
        }
        if ((virtualFile = DbImplUtil.findVirtualFile(adjusted)) != null) {
            int offset;
            boolean isTable = DatabaseEditorHelper.isTableDataAvailable(adjusted) || DatabaseEditorHelper.isDefinitionAvailable(adjusted);
            int n = offset = adjusted == element ? -1 : DatabaseOpenFileDescriptor.calcTargetOffset(project, virtualFile, (DasObject)element);
            if (isTable || isTrigger) {
                DatabaseOpenFileDescriptor databaseOpenFileDescriptor = new DatabaseOpenFileDescriptor(project, virtualFile, offset);
                if (databaseOpenFileDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "getNavigatableImpl"));
                }
                return databaseOpenFileDescriptor;
            }
        }
        DbElement dbElement = adjusted;
        if (dbElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "getNavigatableImpl"));
        }
        return dbElement;
    }

    public boolean expandOnDoubleClick() {
        return !(this.getElement() instanceof DbTable);
    }

    public boolean isValid() {
        return this.getElement().isValid();
    }

    public int getWeight() {
        DbElement element = this.getElement();
        if (element == null || !element.isValid()) {
            return super.getWeight();
        }
        return element.getWeight();
    }

    public String toString() {
        return super.toString();
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myElement};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "getEqualityObjects"));
        }
        return objectArray;
    }

    public final boolean equals(Object o) {
        return ComparableObjectCheck.equals((ComparableObject)this, (Object)o);
    }

    public final int hashCode() {
        return ComparableObjectCheck.hashCode((ComparableObject)this, (int)super.hashCode());
    }

    @NotNull
    public static String arrowToColumns(@Nullable String tableName, @NotNull Collection<String> columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnNames", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        String string = StringUtil.isEmpty((String)tableName) ? "" : DbNodeDescriptor.arrow() + " " + tableName + " " + DbNodeDescriptor.multiRef(columnNames);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        return string;
    }

    @NotNull
    public static String arrowToColumns(@Nullable String tableName, @NotNull MultiRef<? extends DasTypedObject> columnsRef) {
        if (columnsRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnsRef", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        String string = StringUtil.isEmpty((String)tableName) ? "" : DbNodeDescriptor.arrow() + " " + tableName + " " + DbNodeDescriptor.multiRef(columnsRef);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "arrowToColumns"));
        }
        return string;
    }

    @NotNull
    public static String multiRef(@NotNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        String string = names.size() == 0 ? "" : "(" + StringUtil.join(names, (String)", ") + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        return string;
    }

    @NotNull
    public static String multiRef(@NotNull MultiRef<? extends DasTypedObject> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        String string = ref.size() == 0 ? "" : "(" + StringUtil.join((Iterable)JBIterable.from((Iterable)ref.names()).filter(n -> n != null), (String)", ") + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "multiRef"));
        }
        return string;
    }

    @NotNull
    public static String arrow() {
        String string = ApplicationManager.getApplication().isUnitTestMode() ? "->" : UIUtil.rightArrow();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DbNodeDescriptor", "arrow"));
        }
        return string;
    }
}

