/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseObjectCommentEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class DatabaseColumnEditor
extends DatabaseEditorBase {
    private EditorTextField myNameField;
    private JPanel myMainPanel;
    private EditorTextField myTypeEditor;
    private JCheckBox myNotNullCheckBox;
    private EditorTextField myDefaultField;
    private JPanel myBoxesPanel;
    private JBCheckBox myAutoIncCheckBox;
    private JPanel myCommentHolder;
    private final ColumnEditorModel myColumnModel;
    private final DatabaseEditorCapabilities.ColumnEditorCaps myCaps;

    public DatabaseColumnEditor(@NotNull DatabaseEditorState state, @NotNull ColumnEditorModel model, @NotNull DatabaseEditorCapabilities.ColumnEditorCaps caps) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/editors/DatabaseColumnEditor", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DatabaseColumnEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/view/editors/DatabaseColumnEditor", "<init>"));
        }
        super(state);
        this.myColumnModel = model;
        this.myCaps = caps;
        this.$$$setupUI$$$();
        JButton commentBtn = DatabaseObjectCommentEditor.createButton(this.getContext(), this.myColumnModel, (JComponent)this.myDefaultField);
        this.myCommentHolder.add((Component)commentBtn, "Center");
        this.applyCaps();
        this.setupControls();
    }

    protected void applyCaps() {
        this.myCommentHolder.setVisible(this.myCaps.getComment().isSupported());
        this.myCommentHolder.getComponent(0).setEnabled(this.myCaps.getComment().isAvailable());
        this.myNameField.setEnabled(this.myCaps.getRename().isAvailable());
        this.myTypeEditor.setEnabled(this.myCaps.getDataType().isAvailable());
        this.myDefaultField.setEnabled(this.myCaps.getDefault().isAvailable());
        this.myNotNullCheckBox.setVisible(this.myCaps.getNotNull().isSupported());
        this.myNotNullCheckBox.setEnabled(this.myCaps.getNotNull().isAvailable());
        this.myAutoIncCheckBox.setVisible(this.myCaps.getAutoInc().isSupported());
        this.myAutoIncCheckBox.setEnabled(this.myCaps.getAutoInc().isAvailable());
    }

    private void setupControls() {
        this.initSubscriptions();
        this.updateFromModel();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnEditor", "getComponent"));
        }
        return jPanel;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myNameField.getFocusTarget();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnEditor", "getPreferredFocusedComponent"));
        }
        return jComponent;
    }

    public JComponent[] getFocusableComponents() {
        return new JComponent[]{this.myNameField.getFocusTarget(), this.myTypeEditor.getFocusTarget(), this.myDefaultField.getFocusTarget(), this.myNotNullCheckBox, this.myAutoIncCheckBox};
    }

    private void createUIComponents() {
        this.myBoxesPanel = new JPanel();
        this.myBoxesPanel.setLayout(new BoxLayout(this.myBoxesPanel, 0));
        SqlPsiFacade psiFacade = SqlPsiFacade.getInstance((Project)this.getContext().getProject());
        SqlLanguageDialect sqlDialect = DbSqlUtil.getSqlDialect(this.getContext().getDialect());
        this.myNameField = new EditorTextField("", this.getProject(), (FileType)FileTypes.PLAIN_TEXT);
        this.myTypeEditor = DatabaseDialogsHelper.createLanguageEditorField((PsiFile)psiFacade.createTypeElementFragment((Language)sqlDialect, this.getContext().getDataSource(), ""));
        this.myDefaultField = DatabaseDialogsHelper.createLanguageEditorField((PsiFile)psiFacade.createExpressionFragment((Language)sqlDialect, this.getContext().getDataSource(), ""));
        this.myNameField.addSettingsProvider(RefactoringUIUtil.SELECT_ALL_ON_FOCUS);
        this.myTypeEditor.addSettingsProvider(RefactoringUIUtil.SELECT_ALL_ON_FOCUS);
        this.myDefaultField.addSettingsProvider(RefactoringUIUtil.SELECT_ALL_ON_FOCUS);
    }

    @NotNull
    public ColumnEditorModel getColumnModel() {
        ColumnEditorModel columnEditorModel = this.myColumnModel;
        if (columnEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnEditor", "getColumnModel"));
        }
        return columnEditorModel;
    }

    @Override
    @NotNull
    public ObjectEditorModel<DeColumn> getModel() {
        ColumnEditorModel columnEditorModel = this.getColumnModel();
        if (columnEditorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnEditor", "getModel"));
        }
        return columnEditorModel;
    }

    @Override
    protected void updateFromModelImpl() {
        DatabaseColumnEditor.setValue(this.myNameField, this.myColumnModel.getName());
        DatabaseColumnEditor.setValue(this.myTypeEditor, this.myColumnModel.getDataType());
        DatabaseColumnEditor.setValue(this.myDefaultField, StringUtil.notNullize((String)this.myColumnModel.getDefault()));
        DatabaseColumnEditor.setValue(this.myNotNullCheckBox, this.myColumnModel.isNotNull());
        DatabaseColumnEditor.setValue((JCheckBox)this.myAutoIncCheckBox, this.myColumnModel.isAutoInc());
    }

    private void initSubscriptions() {
        this.myColumnModel.addListener(new EditorModelBase.Listener(){

            @Override
            public void changed() {
                DatabaseColumnEditor.this.updateFromModel();
            }
        }, this);
        this.myTypeEditor.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!DatabaseColumnEditor.this.myUpdating) {
                    DatabaseColumnEditor.this.myColumnModel.setDataType(e.getDocument().getText());
                    DatabaseColumnEditor.this.myColumnModel.commit();
                }
            }
        });
        this.myNameField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!DatabaseColumnEditor.this.myUpdating) {
                    DatabaseColumnEditor.this.myColumnModel.setName(e.getDocument().getText());
                    DatabaseColumnEditor.this.myColumnModel.commit();
                }
            }
        });
        this.myDefaultField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                if (!DatabaseColumnEditor.this.myUpdating) {
                    DatabaseColumnEditor.this.myColumnModel.setDefault(StringUtil.nullize((String)e.getDocument().getText()));
                    DatabaseColumnEditor.this.myColumnModel.commit();
                }
            }
        });
        this.myNotNullCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!DatabaseColumnEditor.this.myUpdating) {
                    DatabaseColumnEditor.this.myColumnModel.setNotNull(DatabaseColumnEditor.this.myNotNullCheckBox.isSelected());
                    DatabaseColumnEditor.this.myColumnModel.commit();
                }
            }
        });
        this.myAutoIncCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!DatabaseColumnEditor.this.myUpdating) {
                    DatabaseColumnEditor.this.myColumnModel.setAutoInc(DatabaseColumnEditor.this.myAutoIncCheckBox.isSelected());
                    DatabaseColumnEditor.this.myColumnModel.commit();
                }
            }
        });
    }

    public void addComponent(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/view/editors/DatabaseColumnEditor", "addComponent"));
        }
        this.myBoxesPanel.add(component);
    }

    @NotNull
    public JCheckBox getNotNullCheckBox() {
        JCheckBox jCheckBox = this.myNotNullCheckBox;
        if (jCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnEditor", "getNotNullCheckBox"));
        }
        return jCheckBox;
    }

    @NotNull
    public JCheckBox getAutoIncCheckBox() {
        JBCheckBox jBCheckBox = this.myAutoIncCheckBox;
        if (jBCheckBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnEditor", "getAutoIncCheckBox"));
        }
        return jBCheckBox;
    }

    @NotNull
    public EditorTextField getTypeEditor() {
        EditorTextField editorTextField = this.myTypeEditor;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnEditor", "getTypeEditor"));
        }
        return editorTextField;
    }

    @NotNull
    public EditorTextField getNameEditor() {
        EditorTextField editorTextField = this.myNameField;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnEditor", "getNameEditor"));
        }
        return editorTextField;
    }

    @NotNull
    public EditorTextField getDefaultEditor() {
        EditorTextField editorTextField = this.myDefaultField;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnEditor", "getDefaultEditor"));
        }
        return editorTextField;
    }

    @NotNull
    public DatabaseEditorCapabilities.ColumnEditorCaps getCaps() {
        DatabaseEditorCapabilities.ColumnEditorCaps columnEditorCaps = this.myCaps;
        if (columnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseColumnEditor", "getCaps"));
        }
        return columnEditorCaps;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Name:");
        jBLabel.setDisplayedMnemonic('A');
        jBLabel.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        EditorTextField editorTextField = this.myNameField;
        editorTextField.setText("");
        editorTextField.setEnabled(true);
        jPanel2.add((Component)editorTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 7, 0, null, new Dimension(100, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Type:");
        jBLabel2.setDisplayedMnemonic('Y');
        jBLabel2.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myTypeEditor;
        editorTextField2.setText("");
        jPanel2.add((Component)editorTextField2, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(100, -1), null));
        JPanel jPanel3 = this.myBoxesPanel;
        jPanel3.setLayout(new FlowLayout(1, 5, 5));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 3, 4, 0, 3, 3, null, null, null));
        this.myNotNullCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Not null");
        jCheckBox.setMnemonic('N');
        jCheckBox.setDisplayedMnemonicIndex(4);
        jCheckBox.setSelected(false);
        Component component = jPanel3.add(jCheckBox);
        this.myAutoIncCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Auto inc");
        jBCheckBox.setMnemonic('I');
        jBCheckBox.setDisplayedMnemonicIndex(5);
        Component component2 = jPanel3.add((Component)jBCheckBox);
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Default:");
        jBLabel3.setDisplayedMnemonic('F');
        jBLabel3.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jBLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 2, 1, 1, 0, 1, 7, 0, null, new Dimension(100, -1), null));
        EditorTextField editorTextField3 = this.myDefaultField;
        editorTextField3.setText("");
        jPanel4.add((Component)editorTextField3, "Center");
        this.myCommentHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, "East");
        jBLabel.setLabelFor((Component)editorTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

