/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsHolder;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceErrorsConfigurable
implements Configurable,
DataSourceProblemsHolder,
Disposable,
Runnable {
    private final DatabaseConfigEditor myEditor;
    private final Set<DataSourceProblem> myErrors;
    private final Alarm myAlarm;
    private final Runnable myErrorsChanged;
    private final List<Object> myActions;
    private boolean myInvalid;
    private final JPanel myPanel;
    private final JTextPane myContent;

    public DataSourceErrorsConfigurable(@NotNull DatabaseConfigEditor editor, @NotNull Runnable errorsChanged) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/ui/DataSourceErrorsConfigurable", "<init>"));
        }
        if (errorsChanged == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorsChanged", "com/intellij/database/view/ui/DataSourceErrorsConfigurable", "<init>"));
        }
        this.myErrors = ContainerUtil.newHashSet();
        this.myActions = ContainerUtil.newArrayList();
        this.myInvalid = true;
        this.myEditor = editor;
        this.myErrorsChanged = errorsChanged;
        this.myPanel = new JPanel(new BorderLayout());
        this.myContent = new JTextPane();
        this.myContent.setEditorKit(UIUtil.getHTMLEditorKit());
        this.myContent.setEditable(false);
        this.myContent.setBackground(UIUtil.getListBackground());
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)this.myContent, (boolean)true);
        pane.setHorizontalScrollBarPolicy(31);
        this.myPanel.add((Component)pane, "Center");
        this.myAlarm = new Alarm((Disposable)this);
        Disposer.register((Disposable)this, (Disposable)new UiNotifyConnector((Component)this.myPanel, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                DataSourceErrorsConfigurable.this.updateErrors();
            }
        }));
        this.myContent.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                String desc = e.getDescription();
                Object action = DataSourceProblem.extractAction(desc, DataSourceErrorsConfigurable.this.myActions);
                if (action != null) {
                    DataSourceErrorsConfigurable.this.myEditor.processAction(action);
                } else if ("fixall".equals(desc)) {
                    DataSourceErrorsConfigurable.this.fixAll();
                }
            }
        });
    }

    private void fixAll() {
        new Task.Modal(null, "Fixing problems", true){

            public void run(@NotNull ProgressIndicator indicator) {
                NamedProgressive fix;
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DataSourceErrorsConfigurable$3", "run"));
                }
                HashSet fixed = ContainerUtil.newHashSet();
                while (!indicator.isCanceled() && (fix = DataSourceErrorsConfigurable.this.findSomethingToFix(fixed)) != null) {
                    ProgressWindow window = (ProgressWindow)ObjectUtils.tryCast((Object)indicator, ProgressWindow.class);
                    if (window != null) {
                        window.setTitle(fix.getName());
                    }
                    this.setTitle(fix.getName());
                    fix.run(indicator);
                }
            }
        }.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private NamedProgressive findSomethingToFix(@NotNull Set<DataSourceProblem> fixed) {
        if (fixed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixed", "com/intellij/database/view/ui/DataSourceErrorsConfigurable", "findSomethingToFix"));
        }
        DataSourceProblem toFix = null;
        Set<DataSourceProblem> set = this.myErrors;
        synchronized (set) {
            for (DataSourceProblem error : this.myErrors) {
                if (error.getFix() == null || fixed.contains(toFix)) continue;
                toFix = error;
            }
        }
        if (toFix != null) {
            fixed.add(toFix);
            return toFix.getFix();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorsCount() {
        Set<DataSourceProblem> set = this.myErrors;
        synchronized (set) {
            return this.myErrors.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addError(@NotNull DataSourceProblem error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/view/ui/DataSourceErrorsConfigurable", "addError"));
        }
        Set<DataSourceProblem> set = this.myErrors;
        synchronized (set) {
            if (this.myErrors.contains(error)) {
                return;
            }
            this.myErrors.add(error);
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeError(@NotNull DataSourceProblem error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/view/ui/DataSourceErrorsConfigurable", "removeError"));
        }
        Set<DataSourceProblem> set = this.myErrors;
        synchronized (set) {
            this.myErrors.remove(error);
            this.refresh();
        }
    }

    private void refresh() {
        this.myInvalid = true;
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest((Runnable)this, 100);
    }

    public void dispose() {
    }

    @Override
    public void run() {
        if (this.myPanel.isShowing()) {
            this.updateErrors();
        }
        this.myErrorsChanged.run();
    }

    @NotNull
    private List<DataSourceProblem> getSortedProblems() {
        ArrayList result = ContainerUtil.newArrayList(this.myErrors);
        Collections.sort(result, (o1, o2) -> {
            int res = Comparing.compare((int)this.myEditor.getDataSourceGroup(o1.getOwner()), (int)this.myEditor.getDataSourceGroup(o2.getOwner()));
            if (res != 0) {
                return res;
            }
            res = Comparing.compare((Comparable)((Object)this.myEditor.getObjectName(o1.getOwner())), (Comparable)((Object)this.myEditor.getObjectName(o2.getOwner())));
            if (res != 0) {
                return res;
            }
            return Comparing.compare((Comparable)((Object)o1.getText().getTitle()), (Comparable)((Object)o2.getText().getTitle()));
        });
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DataSourceErrorsConfigurable", "getSortedProblems"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateErrors() {
        List<DataSourceProblem> problems;
        Set<DataSourceProblem> set = this.myErrors;
        synchronized (set) {
            if (!this.myInvalid) {
                return;
            }
            this.myInvalid = false;
            problems = this.getSortedProblems();
        }
        this.myActions.clear();
        StringBuilder html = new StringBuilder(DataSourceErrorsConfigurable.getHtmlPrefix());
        String ulWithoutBullets = "<ul style=\"list-style-type:none\">";
        html.append(ulWithoutBullets);
        int fixCount = 0;
        for (DataSourceProblem error : problems) {
            String description = error.getText().getDescription();
            html.append("<li> \u2014&nbsp;");
            if (description.startsWith("<html>") && description.endsWith("<html>")) {
                description = description.substring("<html>".length(), description.length() - "</html>".length());
            }
            DataSourceProblem.formatText(html, this.myActions, description, error.getText().getLinkActions());
            if (error.getFix() != null) {
                DataSourceProblem.formatText(html, this.myActions, " <a href='$ACTION0'>[Fix]</a>", error.getFix());
                ++fixCount;
            }
            html.append("</li>");
        }
        html.append("</ul>");
        if (fixCount > 1) {
            html.append(ulWithoutBullets).append("<li><a href=\"fixall\">Fix all</a></li></ul>");
        }
        html.append("</body></html>");
        this.myContent.setText(html.toString());
    }

    @NotNull
    public static String getHtmlPrefix() {
        String string = "<html><header><style type='text/css'>body {  color: #" + ColorUtil.toHex((Color)new JBColor((Color)Gray.x33, UIUtil.getLabelForeground())) + ";  font-family: '" + UIUtil.getLabelFont().getName() + ",serif';  font-size: " + UIUtil.getLabelFont().getSize() + ";}li {  margin-bottom: 5;}ol {}a { text-decoration: none;}</style></header><body>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/DataSourceErrorsConfigurable", "getHtmlPrefix"));
        }
        return string;
    }

    @Nls
    public String getDisplayName() {
        return "Problems";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void reset() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }
}

