/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.SchemaEditorHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.text.TextRanges;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class GenericEditingResultProcessor
implements AbstractDbRefactoringDialog.ResultProcessor {
    public static final Function<SchemaEditorHelper.ObjectAction, DasObject> GET_OBJECT = action -> action.object;
    private final AbstractDbRefactoringDialog<?> myDialog;
    private TableDialogSettings.Settings mySettings;
    private final RangeMarker myInsertPos;
    private TableDialogSettings myGenSettings;
    public static final Condition<DeObject> INTERNAL_DECLARATIONS = object -> {
        PsiElement child = (PsiElement)DbRenamePsiElementProcessor.getElementOfType(object, SqlElement.class);
        PsiElement parent = (PsiElement)DbRenamePsiElementProcessor.getElementOfType(object.getParent(), SqlElement.class);
        return child == null || parent == null || !PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)child, (boolean)false);
    };
    private static final Condition<DasObject> MODIFIED_CHILD_EXPAND = new Condition<DasObject>(){

        public boolean value(DasObject object) {
            DeTable table = (DeTable)ObjectUtils.tryCast((Object)object, DeTable.class);
            if (table == null || !(table.editedObject instanceof DeObject)) {
                return NORMAL_EXPAND.value((Object)object);
            }
            DeTable deEdited = (DeTable)ObjectUtils.tryCast((Object)table.editedObject, DeTable.class);
            Set ignoreChildren1 = JBIterable.from(table.indices).append(table.foreignKeys).append((Iterable)table.keys).filter(INTERNAL_DECLARATIONS).toSet();
            Set ignoreChildren2 = deEdited != null ? JBIterable.from(deEdited.indices).append(deEdited.foreignKeys).append((Iterable)deEdited.keys).filter(INTERNAL_DECLARATIONS).toSet() : Collections.emptySet();
            return !table.isAlteredIgnoringChild((DeObject)table.editedObject, ignoreChildren1, ignoreChildren2);
        }
    };
    private static final Condition<DasObject> NORMAL_EXPAND = object -> {
        DeObject deObject = (DeObject)object;
        return deObject.lightExported;
    };
    public static final Function<DeObject, DeObject> EXTRACT_EDITED_OBJECT = object -> (DeObject)ObjectUtils.tryCast((Object)object.editedObject, DeObject.class);
    public static final Function<DeObject, SchemaEditorHelper.ObjectAction> ASSIGN_DROP_ACTION = object -> new SchemaEditorHelper.ObjectAction(SchemaEditorHelper.ObjectAction.Action.DROP, (DeObject)object);

    public GenericEditingResultProcessor(AbstractDbRefactoringDialog<?> dialog, @NotNull TableDialogSettings.Settings settings, @Nullable RangeMarker insertPos) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/GenericEditingResultProcessor", "<init>"));
        }
        this.mySettings = new TableDialogSettings.Settings(settings);
        this.myDialog = dialog;
        this.myInsertPos = insertPos;
        this.myGenSettings = new TableDialogSettings((Consumer<TableDialogSettings.Settings>)((Consumer)settings1 -> {
            this.mySettings.assign((TableDialogSettings.Settings)settings1);
            this.myDialog.forcedUpdate();
        }), this.mySettings);
    }

    @NotNull
    private DbDataSource getDataSource() {
        DbDataSource dbDataSource = (DbDataSource)ObjectUtils.assertNotNull((Object)this.myDialog.getContext().getDataSource());
        if (dbDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor", "getDataSource"));
        }
        return dbDataSource;
    }

    private static void fillContext(@NotNull DeModel model, @NotNull LoaderContext context) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/ui/GenericEditingResultProcessor", "fillContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/ui/GenericEditingResultProcessor", "fillContext"));
        }
        JBIterable modifiedRoots = ((JBTreeTraverser)model.traverser().expandAndSkip(object -> {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/ui/GenericEditingResultProcessor", "lambda$fillContext$2"));
            }
            boolean isUpdateRoot = false;
            for (DeObject child : DasUtil.getDbChildren((DasObject)object, (DasModel)model, DeObject.class, (ObjectKind)ObjectKind.NONE)) {
                if (child.editedObject != null) continue;
                isUpdateRoot = true;
                break;
            }
            if (!isUpdateRoot) {
                DeObject obj = (DeObject)ObjectUtils.tryCast((Object)object, DeObject.class);
                isUpdateRoot = obj != null && !obj.lightExported && obj.editedObject instanceof DeObject && obj.isAltered((DeObject)obj.editedObject);
            }
            PsiElement element = (PsiElement)DbRenamePsiElementProcessor.getElementOfType(object, SqlElement.class);
            return !isUpdateRoot || element != null;
        })).bfsTraversal();
        if (modifiedRoots.isEmpty()) {
            context.includeAllSchemas();
        } else {
            for (DasObject root2 : modifiedRoots) {
                context.include(root2);
            }
        }
    }

    @Override
    @Nullable
    public JComponent getPreviewWidget() {
        return null;
    }

    @Nullable
    private static DasNamespace findNamespace(@NotNull DasModel model, @Nullable DeObject object) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/ui/GenericEditingResultProcessor", "findNamespace"));
        }
        DasNamespace namespace = DasUtil.getNamespace((DasObject)object);
        return namespace == null ? model.getCurrentRootNamespace() : namespace;
    }

    @Override
    public boolean process() {
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.EXEC_IN_DB) {
            return this.processDb();
        }
        return this.processSql();
    }

    private boolean processSql() {
        List<RangeMarker> ranges = this.getRanges();
        if (ranges.isEmpty()) {
            return false;
        }
        JBIterable<Pair<PsiElement, String>> renames = this.myDialog.collectRenames();
        if (!renames.isEmpty()) {
            this.processWithRenames(renames, ranges);
        } else {
            this.processWithoutRenames(ranges);
        }
        return true;
    }

    private void processWithRenames(@NotNull JBIterable<Pair<PsiElement, String>> renames, final @NotNull List<RangeMarker> ranges) {
        if (renames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renames", "com/intellij/database/view/ui/GenericEditingResultProcessor", "processWithRenames"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/database/view/ui/GenericEditingResultProcessor", "processWithRenames"));
        }
        Pair pair = (Pair)ObjectUtils.assertNotNull((Object)renames.first());
        renames = renames.skip(1);
        RenameProcessor processor = new RenameProcessor(this.myDialog.getContext().getProject(), (PsiElement)pair.first, (String)pair.second, true, true){

            protected void execute(@NotNull UsageInfo[] usages) {
                if (usages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/database/view/ui/GenericEditingResultProcessor$1", "execute"));
                }
                super.execute(usages);
                GenericEditingResultProcessor.this.insertStatement(ranges);
                GenericEditingResultProcessor.this.open(ranges);
            }
        };
        for (Pair rename : renames) {
            processor.addElement((PsiElement)rename.first, (String)rename.second);
        }
        processor.setPreviewUsages(this.myDialog.isPreviewUsages());
        processor.setPrepareSuccessfulSwingThreadCallback(() -> this.myDialog.close(0));
        processor.run();
    }

    private void processWithoutRenames(@NotNull List<RangeMarker> ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/database/view/ui/GenericEditingResultProcessor", "processWithoutRenames"));
        }
        if (!this.insertStatement(ranges)) {
            return;
        }
        this.open(ranges);
        this.myDialog.close(0);
    }

    private void open(@NotNull List<RangeMarker> ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/database/view/ui/GenericEditingResultProcessor", "open"));
        }
        Project project = this.myDialog.getContext().getProject();
        VirtualFile file = FileDocumentManager.getInstance().getFile(ranges.get(0).getDocument());
        if (project != null && file != null) {
            FileEditorManager.getInstance((Project)project).openFile(file, true, true);
        }
    }

    private boolean insertStatement(@NotNull List<RangeMarker> ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/database/view/ui/GenericEditingResultProcessor", "insertStatement"));
        }
        if (ranges.isEmpty()) {
            return false;
        }
        HashSet visited = ContainerUtil.newHashSet();
        for (RangeMarker marker : ranges) {
            if (visited.add(marker.getDocument())) {
                PsiDocumentManager.getInstance((Project)((Project)ObjectUtils.assertNotNull((Object)this.myDialog.getContext().getProject()))).doPostponedOperationsAndUnblockDocument(marker.getDocument());
            }
            if (marker.isValid()) continue;
            return false;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.myDialog.getContext().getProject(), () -> {
            if (ranges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/database/view/ui/GenericEditingResultProcessor", "lambda$insertStatement$4"));
            }
            String statement = this.myDialog.getStatement();
            statement = StringUtil.trimEnd((String)statement, (String)";");
            RangeMarker main = (RangeMarker)ranges.get(0);
            boolean insertBreak = false;
            if (ranges.size() == 1 && main.getEndOffset() == main.getEndOffset()) {
                int lineStart = main.getDocument().getLineStartOffset(main.getDocument().getLineNumber(main.getStartOffset()));
                insertBreak = !main.getDocument().getText(TextRange.create((int)lineStart, (int)main.getStartOffset())).matches("\\s*");
            }
            main.getDocument().replaceString(main.getStartOffset(), main.getEndOffset(), (CharSequence)((insertBreak ? "\n" : "") + statement));
            for (RangeMarker marker : ranges.subList(1, ranges.size())) {
                marker.getDocument().replaceString(marker.getStartOffset(), marker.getEndOffset(), (CharSequence)"");
            }
        });
        return true;
    }

    @NotNull
    public List<RangeMarker> getRanges() {
        RangeMarker corrected;
        List<RangeMarker> ranges;
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.REPLACE_DDL && !(ranges = this.getModifiedElementsRanges()).isEmpty()) {
            List<RangeMarker> list = ranges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor", "getRanges"));
            }
            return list;
        }
        if (this.myInsertPos != null && this.myInsertPos.isValid() && this.myInsertPos.getDocument().isWritable() && (corrected = this.correctOffset(this.myInsertPos)) != null) {
            List<RangeMarker> list = Collections.singletonList(corrected);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor", "getRanges"));
            }
            return list;
        }
        RangeMarker afterParentRange = this.getAfterParentRange();
        if (afterParentRange != null) {
            List<RangeMarker> list = Collections.singletonList(afterParentRange);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor", "getRanges"));
            }
            return list;
        }
        RangeMarker endOfFile = this.getEndOfFile();
        List<Object> list = endOfFile != null ? Collections.singletonList(endOfFile) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor", "getRanges"));
        }
        return list;
    }

    @NotNull
    private List<RangeMarker> getModifiedElementsRanges() {
        EditorModelBase editorModel = ((DatabaseEditorBase)this.myDialog.getEditor()).getModel();
        Map<PsiFile, TextRanges> rangesPerFile = GenericEditingResultProcessor.collectRanges((JBIterable<? extends DasObject>)this.createTraverser(editorModel).traverse().transform(GET_OBJECT), editorModel.getModel());
        Project project = this.myDialog.getContext().getProject();
        if (project == null || rangesPerFile.isEmpty()) {
            List<RangeMarker> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor", "getModifiedElementsRanges"));
            }
            return list;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (Map.Entry<PsiFile, TextRanges> entry : rangesPerFile.entrySet()) {
            this.patch(entry.getKey(), entry.getValue());
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(entry.getKey());
            if (document == null || !document.isWritable() || entry.getValue().isEmpty()) continue;
            for (TextRange range : entry.getValue()) {
                result.add(document.createRangeMarker(range));
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor", "getModifiedElementsRanges"));
        }
        return arrayList;
    }

    @Nullable
    private RangeMarker getAfterParentRange() {
        EditorModelBase editorModel = ((DatabaseEditorBase)this.myDialog.getEditor()).getModel();
        Project project = this.myDialog.getContext().getProject();
        if (project == null) {
            return null;
        }
        Map<PsiFile, TextRanges> rangesPerFile = GenericEditingResultProcessor.collectRanges(editorModel.getModel().getModelRoots(), editorModel.getModel());
        for (Map.Entry<PsiFile, TextRanges> entry : rangesPerFile.entrySet()) {
            this.patch(entry.getKey(), entry.getValue());
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(entry.getKey());
            if (document == null || !document.isWritable() || entry.getValue().isEmpty()) continue;
            TextRange range = (TextRange)entry.getValue().iterator().next();
            int offset = range.getEndOffset();
            return document.createRangeMarker(offset, offset);
        }
        return null;
    }

    private static Map<PsiFile, TextRanges> collectRanges(@NotNull JBIterable<? extends DasObject> modifiedObjects, @NotNull DasModel model) {
        if (modifiedObjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiedObjects", "com/intellij/database/view/ui/GenericEditingResultProcessor", "collectRanges"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/ui/GenericEditingResultProcessor", "collectRanges"));
        }
        LinkedHashMap rangesPerFile = ContainerUtil.newLinkedHashMap();
        for (DasObject modifiedObject : modifiedObjects) {
            for (DasObject object : (JBTreeTraverser)model.traverser().withRoot((Object)modifiedObject)) {
                PsiElement element = (PsiElement)DbRenamePsiElementProcessor.getElementOfType(object, SqlElement.class);
                PsiFile file = element == null ? null : element.getContainingFile();
                if (file == null) continue;
                TextRanges ranges = (TextRanges)rangesPerFile.get(file);
                if (ranges == null) {
                    ranges = new TextRanges();
                    rangesPerFile.put(file, ranges);
                }
                ranges.union(element.getTextRange());
            }
        }
        return rangesPerFile;
    }

    @Nullable
    private RangeMarker getEndOfFile() {
        VirtualFile file = this.myDialog.getContext().getOrCreateVirtualFile();
        if (file == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return null;
        }
        int length = document.getTextLength();
        return document.createRangeMarker(length, length);
    }

    @Nullable
    private RangeMarker correctOffset(@NotNull RangeMarker pos) {
        ParserDefinition definition;
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/database/view/ui/GenericEditingResultProcessor", "correctOffset"));
        }
        Project project = (Project)ObjectUtils.assertNotNull((Object)this.myDialog.getContext().getProject());
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(pos.getDocument());
        if (file == null) {
            return null;
        }
        PsiElement element = file.findElementAt(pos.getStartOffset());
        if (element == null) {
            return null;
        }
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, SqlStatement.class)) == null) {
            return null;
        }
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect(element);
        ParserDefinition parserDefinition = definition = dialect == null ? null : (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)dialect);
        if (definition != null) {
            PsiElement next;
            TokenSet skip = TokenSet.orSet((TokenSet[])new TokenSet[]{dialect.getStatementSeparators(), definition.getCommentTokens(), definition.getWhitespaceTokens()});
            while ((next = PsiTreeUtil.nextVisibleLeaf((PsiElement)element)) != null && skip.contains(GenericEditingResultProcessor.getNodeType(next))) {
                element = next;
            }
        }
        int offset = element.getTextRange().getEndOffset();
        return pos.getDocument().createRangeMarker(offset, offset);
    }

    @Nullable
    private static IElementType getNodeType(@Nullable PsiElement el) {
        return el == null || el.getNode() == null ? null : el.getNode().getElementType();
    }

    private void patch(@NotNull PsiFile file, @NotNull TextRanges ranges) {
        TextRange lastPatch;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/view/ui/GenericEditingResultProcessor", "patch"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/database/view/ui/GenericEditingResultProcessor", "patch"));
        }
        TokenSet separators = DbSqlUtil.getSqlDialect(this.myDialog.getContext().getDialect()).getStatementSeparators();
        ArrayList patches = ContainerUtil.newArrayList();
        for (TextRange range : JBIterable.once((Iterator)ranges.gapIterator())) {
            if (GenericEditingResultProcessor.shouldPlumb(file, range, separators)) {
                patches.add(range);
                continue;
            }
            TextRange expanded = GenericEditingResultProcessor.expand(file, range, separators);
            if (expanded == null) continue;
            patches.add(expanded);
        }
        for (TextRange patch : patches) {
            ranges.union(patch);
        }
        TextRange last = (TextRange)JBIterable.once((Iterator)ranges.revIterator()).first();
        if (last != null && (lastPatch = GenericEditingResultProcessor.expand(file, TextRange.create((int)last.getEndOffset(), (int)file.getTextLength()), separators)) != null) {
            ranges.union(lastPatch);
        }
    }

    private static boolean shouldPlumb(@NotNull PsiFile file, @NotNull TextRange range, @NotNull TokenSet seps) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/view/ui/GenericEditingResultProcessor", "shouldPlumb"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/view/ui/GenericEditingResultProcessor", "shouldPlumb"));
        }
        if (seps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seps", "com/intellij/database/view/ui/GenericEditingResultProcessor", "shouldPlumb"));
        }
        PsiElement element = file.findElementAt(range.getStartOffset());
        while (element != null && element.getTextOffset() < range.getEndOffset()) {
            IElementType type;
            IElementType iElementType = type = element.getNode() == null ? null : element.getNode().getElementType();
            if (!seps.contains(type) && !StringUtil.isEmptyOrSpaces((String)element.getText())) {
                return false;
            }
            element = PsiTreeUtil.nextVisibleLeaf((PsiElement)element);
        }
        return true;
    }

    @Nullable
    private static TextRange expand(@NotNull PsiFile file, @NotNull TextRange range, @NotNull TokenSet seps) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/view/ui/GenericEditingResultProcessor", "expand"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/view/ui/GenericEditingResultProcessor", "expand"));
        }
        if (seps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seps", "com/intellij/database/view/ui/GenericEditingResultProcessor", "expand"));
        }
        PsiElement element = file.findElementAt(range.getStartOffset());
        int expanded = range.getStartOffset();
        while (element != null && element.getTextOffset() < range.getEndOffset()) {
            IElementType type;
            IElementType iElementType = type = element.getNode() == null ? null : element.getNode().getElementType();
            if (!seps.contains(type) && (!StringUtil.isEmptyOrSpaces((String)element.getText()) || element.getText().contains("\n"))) break;
            expanded = element.getTextRange().getEndOffset();
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        if (expanded == range.getStartOffset()) {
            return null;
        }
        return TextRange.create((int)range.getStartOffset(), (int)expanded);
    }

    private boolean processDb() {
        DatabaseEditorContext context = this.myDialog.getContext();
        if (!DbImplUtil.canConnectToAndModify((DbElement)context.getDataSource())) {
            return false;
        }
        DasNamespace namespace = GenericEditingResultProcessor.findNamespace(context.getModel(), ((DatabaseEditorBaseEx)this.myDialog.getEditor()).getKeyObject());
        DatabaseRefactoringHandler handler = new DatabaseRefactoringHandler(this.getDataSource(), namespace).setStatement(this.myDialog.getStatement());
        GenericEditingResultProcessor.fillContext(this.myDialog.getModel(), handler.getContext());
        DasObject edited = (DasObject)((DatabaseEditorBase)this.myDialog.getEditor()).getModel().getEditedObjects().first();
        handler.getContext().setElementToFocus(edited);
        JBIterable<Pair<PsiElement, String>> renames = this.myDialog.collectRenames();
        if (!renames.isEmpty()) {
            this.processWithRenames(renames, handler);
        } else {
            this.processWithoutRenames(handler);
        }
        return true;
    }

    @Override
    @NotNull
    public DdlPreview.ModelTraverser createTraverser(@NotNull EditorModelBase model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/ui/GenericEditingResultProcessor", "createTraverser"));
        }
        MyModelTraverser myModelTraverser = new MyModelTraverser(model.getModel());
        if (myModelTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor", "createTraverser"));
        }
        return myModelTraverser;
    }

    @Override
    @Nullable
    public JComponent getSettingsPanel() {
        return this.myGenSettings.getComponent();
    }

    @Override
    public String getCurrentAction() {
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.APPEND_DDL) {
            return "To Editor";
        }
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.REPLACE_DDL) {
            return "Replace";
        }
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.EXEC_IN_DB) {
            return "Execute";
        }
        return null;
    }

    @Override
    public void update() {
        JBIterable<? extends DeObject> editedObjects = ((DatabaseEditorBase)this.myDialog.getEditor()).getModel().getEditedObjects();
        JBIterable allObjects = ((JBTreeTraverser)this.myDialog.getModel().traverser().withRoots(editedObjects)).traverse();
        this.myGenSettings.setAvailability(this.myDialog.getContext().getDataSource() != null && (GenericEditingResultProcessor.hasType(editedObjects, BasicElement.class) || GenericEditingResultProcessor.newObjects(editedObjects)), GenericEditingResultProcessor.hasType((JBIterable<? extends DasObject>)allObjects, SqlElement.class));
    }

    @Override
    public ValidationInfo validate() {
        JBIterable modified;
        if (this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.REPLACE_DDL && GenericEditingResultProcessor.hasType((JBIterable<? extends DasObject>)(modified = this.createTraverser(((DatabaseEditorBase)this.myDialog.getEditor()).getModel()).traverse().transform(GET_OBJECT)), BasicElement.class)) {
            return new ValidationInfo("Unable to replace DDL for some objects (they are in DB)");
        }
        return null;
    }

    private static boolean hasType(JBIterable<? extends DasObject> objects, @NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/view/ui/GenericEditingResultProcessor", "hasType"));
        }
        return !objects.filter(o -> {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/database/view/ui/GenericEditingResultProcessor", "lambda$hasType$5"));
            }
            return DbRenamePsiElementProcessor.getElementOfType(o, clazz) != null;
        }).isEmpty();
    }

    private static boolean newObjects(JBIterable<? extends DasObject> objects) {
        return objects.filter(o -> o instanceof DeObject && ((DeObject)o).editedObject != null).isEmpty();
    }

    private void processWithRenames(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler) {
        if (renames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renames", "com/intellij/database/view/ui/GenericEditingResultProcessor", "processWithRenames"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/view/ui/GenericEditingResultProcessor", "processWithRenames"));
        }
        DbRenamePsiElementProcessor.MyRenameProcessor processor = new DbRenamePsiElementProcessor.MyRenameProcessor(this.myDialog.getContext().getProject(), handler, renames, true, true);
        processor.setPrepareSuccessfulSwingThreadCallback(() -> this.myDialog.close(0));
        processor.setPreviewUsages(this.myDialog.isPreviewUsages());
        processor.run();
    }

    private void processWithoutRenames(@NotNull DatabaseRefactoringHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/view/ui/GenericEditingResultProcessor", "processWithoutRenames"));
        }
        Promise<Void> promise = handler.runStatements();
        promise.done(aVoid -> this.myDialog.close(0));
        promise.rejected(this.myDialog::reportError);
    }

    public static boolean isModified(@NotNull DeObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/GenericEditingResultProcessor", "isModified"));
        }
        return !(object.editedObject instanceof DeObject) || object.isAltered((DeObject)object.editedObject);
    }

    @NotNull
    public static SchemaEditorHelper.ObjectAction assignAction(@NotNull DeObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/GenericEditingResultProcessor", "assignAction"));
        }
        SchemaEditorHelper.ObjectAction objectAction = new SchemaEditorHelper.ObjectAction(object.editedObject == null ? SchemaEditorHelper.ObjectAction.Action.CREATE : SchemaEditorHelper.ObjectAction.Action.ALTER, object);
        if (objectAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor", "assignAction"));
        }
        return objectAction;
    }

    public static class AppendDroppedSiblings
    implements Function<DeObject, Iterable<SchemaEditorHelper.ObjectAction>> {
        private final Set<DeObject> myProcessedParents;
        private final TableDialogSettings.Settings mySettings;

        public AppendDroppedSiblings(@NotNull TableDialogSettings.Settings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/GenericEditingResultProcessor$AppendDroppedSiblings", "<init>"));
            }
            this.myProcessedParents = ContainerUtil.newHashSet();
            this.mySettings = settings;
        }

        public Iterable<SchemaEditorHelper.ObjectAction> fun(DeObject object) {
            JBIterable res = this.processParent(object.getParent());
            if (GenericEditingResultProcessor.isModified(object) || this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.APPEND_DDL && this.mySettings.codeType == TableDialogSettings.Settings.CodeType.CREATE_ALL_CODE) {
                res = this.mySettings.codeType == TableDialogSettings.Settings.CodeType.ALTER_CODE ? res.append((Object)GenericEditingResultProcessor.assignAction(object)) : res.append((Object)new SchemaEditorHelper.ObjectAction(SchemaEditorHelper.ObjectAction.Action.CREATE, object));
            }
            return res;
        }

        @NotNull
        private JBIterable<SchemaEditorHelper.ObjectAction> processParent(@Nullable DeObject object) {
            if (!(object instanceof DeTable) || object.editedObject == null || this.myProcessedParents.contains(object)) {
                JBIterable jBIterable = JBIterable.empty();
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor$AppendDroppedSiblings", "processParent"));
                }
                return jBIterable;
            }
            this.myProcessedParents.add(object);
            Set modified = object.getDbChildren(DeObject.class, ObjectKind.NONE).transform(EXTRACT_EDITED_OBJECT).toSet();
            JBIterable jBIterable = object.editedObject.getDbChildren(DeObject.class, ObjectKind.NONE).filter(object1 -> !modified.contains(object1)).transform(ASSIGN_DROP_ACTION);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor$AppendDroppedSiblings", "processParent"));
            }
            return jBIterable;
        }
    }

    private class MyModelTraverser
    extends DdlPreview.ModelTraverser {
        public MyModelTraverser(DeModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/ui/GenericEditingResultProcessor$MyModelTraverser", "<init>"));
            }
            super(model);
        }

        @Override
        @NotNull
        public JBIterable<SchemaEditorHelper.ObjectAction> traverse() {
            JBIterable places = ((JBTreeTraverser)((JBTreeTraverser)this.model.traverser().withRoots(this.getRoots())).expandAndSkip(this.getExpansionMethod())).filter(DeObject.class);
            JBIterable jBIterable = places.intercept(this.getActionGenerator());
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor$MyModelTraverser", "traverse"));
            }
            return jBIterable;
        }

        @NotNull
        private Function<Iterator<DeObject>, Iterator<SchemaEditorHelper.ObjectAction>> getActionGenerator() {
            Function function = iterator -> JBIterable.once((Iterator)iterator).flatten((Function)new AppendDroppedSiblings(GenericEditingResultProcessor.this.mySettings)).iterator();
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor$MyModelTraverser", "getActionGenerator"));
            }
            return function;
        }

        @NotNull
        private JBIterable<? extends DeObject> getRoots() {
            if (((GenericEditingResultProcessor)GenericEditingResultProcessor.this).mySettings.codeType == TableDialogSettings.Settings.CodeType.ALTER_CODE) {
                JBIterable jBIterable = GenericEditingResultProcessor.this.myDialog.getModel().getModelRoots().filter(DeObject.class);
                if (jBIterable == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor$MyModelTraverser", "getRoots"));
                }
                return jBIterable;
            }
            JBIterable<? extends DeObject> jBIterable = ((DatabaseEditorBase)GenericEditingResultProcessor.this.myDialog.getEditor()).getModel().getEditedObjects();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor$MyModelTraverser", "getRoots"));
            }
            return jBIterable;
        }

        @NotNull
        private Condition<DasObject> getExpansionMethod() {
            if (((GenericEditingResultProcessor)GenericEditingResultProcessor.this).mySettings.finalAction == TableDialogSettings.Settings.FinalAction.REPLACE_DDL || ((GenericEditingResultProcessor)GenericEditingResultProcessor.this).mySettings.finalAction == TableDialogSettings.Settings.FinalAction.APPEND_DDL && ((GenericEditingResultProcessor)GenericEditingResultProcessor.this).mySettings.codeType == TableDialogSettings.Settings.CodeType.CREATE_NEW_CODE) {
                Condition condition = MODIFIED_CHILD_EXPAND;
                if (condition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor$MyModelTraverser", "getExpansionMethod"));
                }
                return condition;
            }
            Condition condition = NORMAL_EXPAND;
            if (condition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/GenericEditingResultProcessor$MyModelTraverser", "getExpansionMethod"));
            }
            return condition;
        }
    }
}

