/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableDialogSettings {
    private final Consumer<Settings> mySettingsConsumer;
    private JPanel myPanel;
    private JRadioButton myExecuteInDb;
    private JRadioButton myReplaceDDL;
    private JRadioButton myOpenInEditor;
    private ComboBox myGenTypeBox;
    private boolean myUpdating;
    private final Settings mySettings;
    private static final String GEN_ALTER = "Modify existing objects";
    private static final String GEN_CREATE_NEW = "Create modified objects";
    private static final String GEN_CREATE_ALL = "Create all objects";

    private void createUIComponents() {
        this.myGenTypeBox = new ComboBox();
    }

    public TableDialogSettings(@NotNull Consumer<Settings> settingsConsumer, @NotNull Settings settings) {
        if (settingsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsConsumer", "com/intellij/database/view/ui/TableDialogSettings", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/TableDialogSettings", "<init>"));
        }
        this.myUpdating = false;
        this.mySettingsConsumer = settingsConsumer;
        this.$$$setupUI$$$();
        this.mySettings = new Settings(settings);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TableDialogSettings.this.myUpdating) {
                    return;
                }
                Settings.FinalAction prop = TableDialogSettings.this.getDecodeComponent(e.getSource());
                if (prop != null) {
                    TableDialogSettings.this.processSettingsChange((Object)prop);
                }
            }
        };
        JBTreeTraverser components = UIUtil.uiTraverser((Component)this.myPanel);
        for (JRadioButton btn : components.filter(JRadioButton.class)) {
            btn.addActionListener(listener);
            btn.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        }
        this.myGenTypeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TableDialogSettings.this.myUpdating) {
                    return;
                }
                Object item = e.getItem();
                Settings.CodeType type = TableDialogSettings.getCodeType(item == null ? null : item.toString());
                if (type != null) {
                    TableDialogSettings.this.processSettingsChange((Object)type);
                }
            }
        });
        this.myGenTypeBox.setModel(new DefaultComboBoxModel<Object>(new Object[]{GEN_ALTER, GEN_CREATE_NEW, GEN_CREATE_ALL}));
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        this.processSettingsChange((Object)this.mySettings.finalAction);
    }

    public void setAvailability(boolean db, boolean ddl) {
        this.myExecuteInDb.setEnabled(db);
        this.myReplaceDDL.setEnabled(ddl);
        Settings.FinalAction action = this.mySettings.finalAction;
        if (action == Settings.FinalAction.EXEC_IN_DB && !db) {
            action = Settings.FinalAction.APPEND_DDL;
        }
        if (action == Settings.FinalAction.REPLACE_DDL && !ddl) {
            action = Settings.FinalAction.APPEND_DDL;
        }
        if (action != this.mySettings.finalAction) {
            this.processSettingsChange((Object)action);
        }
    }

    @Nullable
    private static Settings.CodeType getCodeType(@Nullable String string) {
        if (string == GEN_ALTER) {
            return Settings.CodeType.ALTER_CODE;
        }
        if (string == GEN_CREATE_ALL) {
            return Settings.CodeType.CREATE_ALL_CODE;
        }
        if (string == GEN_CREATE_NEW) {
            return Settings.CodeType.CREATE_NEW_CODE;
        }
        return null;
    }

    public void setSettings(@NotNull Settings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/TableDialogSettings", "setSettings"));
        }
        this.mySettings.assign(settings);
        this.processSettingsChange((Object)this.mySettings.finalAction);
    }

    @Nullable
    private Settings.FinalAction getDecodeComponent(Object comp) {
        if (comp == this.myExecuteInDb) {
            return Settings.FinalAction.EXEC_IN_DB;
        }
        if (comp == this.myReplaceDDL) {
            return Settings.FinalAction.REPLACE_DDL;
        }
        if (comp == this.myOpenInEditor) {
            return Settings.FinalAction.APPEND_DDL;
        }
        return null;
    }

    @Nullable
    private JRadioButton getDecodeButton(Object state) {
        if (state == Settings.FinalAction.EXEC_IN_DB) {
            return this.myExecuteInDb;
        }
        if (state == Settings.FinalAction.REPLACE_DDL) {
            return this.myReplaceDDL;
        }
        if (state == Settings.FinalAction.APPEND_DDL) {
            return this.myOpenInEditor;
        }
        return null;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/TableDialogSettings", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JRadioButton jRadioButton = this.myExecuteInDb;
        if (jRadioButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/TableDialogSettings", "getPreferredFocusedComponent"));
        }
        return jRadioButton;
    }

    private void processSettingsChange(@NotNull Object prop) {
        if (prop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prop", "com/intellij/database/view/ui/TableDialogSettings", "processSettingsChange"));
        }
        this.myUpdating = true;
        try {
            this.updateSettings(prop);
            this.updateButtons();
            this.mySettingsConsumer.consume((Object)this.mySettings);
        }
        finally {
            this.myUpdating = false;
        }
    }

    private void updateButtons() {
        ((JRadioButton)ObjectUtils.assertNotNull((Object)this.getDecodeButton((Object)this.mySettings.finalAction))).setSelected(true);
        this.myGenTypeBox.setSelectedItem((Object)this.getGenType());
    }

    private String getGenType() {
        if (this.mySettings.codeType == Settings.CodeType.ALTER_CODE) {
            return GEN_ALTER;
        }
        if (this.mySettings.codeType == Settings.CodeType.CREATE_NEW_CODE) {
            return GEN_CREATE_NEW;
        }
        if (this.mySettings.codeType == Settings.CodeType.CREATE_ALL_CODE) {
            return GEN_CREATE_ALL;
        }
        return null;
    }

    private void updateSettings(@NotNull Object prop) {
        if (prop == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prop", "com/intellij/database/view/ui/TableDialogSettings", "updateSettings"));
        }
        assert (prop instanceof Settings.CodeType || prop instanceof Settings.FinalAction);
        if (prop instanceof Settings.FinalAction) {
            this.setFinalAction((Settings.FinalAction)((Object)prop));
        } else {
            this.setCodeType((Settings.CodeType)((Object)prop));
        }
    }

    private void setFinalAction(@NotNull Settings.FinalAction finalAction) {
        if (finalAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalAction", "com/intellij/database/view/ui/TableDialogSettings", "setFinalAction"));
        }
        this.mySettings.finalAction = finalAction;
        boolean enableCodeType = finalAction == Settings.FinalAction.APPEND_DDL;
        this.myGenTypeBox.setEnabled(enableCodeType);
        if (finalAction == Settings.FinalAction.EXEC_IN_DB) {
            this.setCodeType(Settings.CodeType.ALTER_CODE);
        } else if (finalAction == Settings.FinalAction.REPLACE_DDL) {
            this.setCodeType(Settings.CodeType.CREATE_NEW_CODE);
        } else {
            this.setCodeType(this.mySettings.codeType);
        }
    }

    private void setCodeType(@NotNull Settings.CodeType codeType) {
        if (codeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeType", "com/intellij/database/view/ui/TableDialogSettings", "setCodeType"));
        }
        this.mySettings.codeType = codeType;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 5, 0, 2, 1, 6, null, null, null));
        this.myExecuteInDb = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Execute in database");
        jPanel.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myReplaceDDL = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Replace existing DDL");
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOpenInEditor = jRadioButton = new JRadioButton();
        jRadioButton.setText("Open in editor:");
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        ComboBox comboBox = this.myGenTypeBox;
        jPanel.add((Component)comboBox, new GridConstraints(0, 3, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    public static class Settings {
        public FinalAction finalAction;
        public CodeType codeType;

        public Settings() {
            this(FinalAction.EXEC_IN_DB, CodeType.ALTER_CODE);
        }

        public Settings(@NotNull Settings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/TableDialogSettings$Settings", "<init>"));
            }
            this(settings.finalAction, settings.codeType);
        }

        public Settings(@NotNull FinalAction finalAction, @NotNull CodeType codeType) {
            if (finalAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalAction", "com/intellij/database/view/ui/TableDialogSettings$Settings", "<init>"));
            }
            if (codeType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeType", "com/intellij/database/view/ui/TableDialogSettings$Settings", "<init>"));
            }
            this.assign(finalAction, codeType);
        }

        public void assign(@NotNull FinalAction finalAction, @NotNull CodeType codeType) {
            if (finalAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finalAction", "com/intellij/database/view/ui/TableDialogSettings$Settings", "assign"));
            }
            if (codeType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeType", "com/intellij/database/view/ui/TableDialogSettings$Settings", "assign"));
            }
            this.finalAction = finalAction;
            this.codeType = codeType;
        }

        public void assign(@NotNull Settings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ui/TableDialogSettings$Settings", "assign"));
            }
            this.assign(settings.finalAction, settings.codeType);
        }

        public static enum CodeType {
            CREATE_ALL_CODE,
            CREATE_NEW_CODE,
            ALTER_CODE;

        }

        public static enum FinalAction {
            EXEC_IN_DB,
            REPLACE_DDL,
            APPEND_DDL;

        }
    }
}

