/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RelativeReference;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmOverloadable;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.FamilyUtil;
import com.intellij.dbm.common.NaturalPositioned;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseFamily<@NotNull C extends DbmObject>
extends Family<C> {
    @NotNull
    private final AtomicReference<ImmutableList<C>> myChildren;
    @NotNull
    protected final Class<C> myChildClass;
    private final boolean myNaturalOrdered;

    BaseFamily(@NotNull ObjectKind childKind, @NotNull Class<C> childClass) {
        if (childKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childKind", "com/intellij/dbm/common/BaseFamily", "<init>"));
        }
        if (childClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childClass", "com/intellij/dbm/common/BaseFamily", "<init>"));
        }
        super(childKind);
        this.myChildClass = childClass;
        this.myChildren = new AtomicReference<ImmutableList>(ImmutableList.of());
        this.myNaturalOrdered = NaturalPositioned.class.isAssignableFrom(childClass);
    }

    @Override
    @NotNull
    public abstract C create(@Nullable String var1);

    @Override
    @NotNull
    public C createNewOne() {
        C c = this.create(null);
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "createNewOne"));
        }
        return c;
    }

    @Override
    @NotNull
    public C createOrGet(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/BaseFamily", "createOrGet"));
        }
        BasicNamedElement child = this.get(name);
        if (child == null) {
            child = this.create(name);
        } else {
            child.resetSyncPending();
        }
        BasicNamedElement basicNamedElement = child;
        if (basicNamedElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "createOrGet"));
        }
        return (C)basicNamedElement;
    }

    @Override
    @NotNull
    public C createOrGet(long objectId) {
        BasicElement child = this.getByObjectId(objectId);
        if (child == null) {
            child = this.createNewOne();
            ((DbmObject)child).setObjectId(objectId);
        } else {
            child.resetSyncPending();
        }
        BasicElement basicElement = child;
        if (basicElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "createOrGet"));
        }
        return (C)basicElement;
    }

    @Override
    @NotNull
    public C renew(long objectId, @Nullable String name) {
        DbmObject object;
        int i2;
        int n;
        ImmutableList<C> children = this.myChildren.get();
        if (objectId != 0L) {
            n = children.size();
            for (i2 = 0; i2 < n; ++i2) {
                object = (DbmObject)children.get(i2);
                if (object.getObjectId() != objectId) continue;
                object.setName(name);
                object.resetSyncPending();
                DbmObject dbmObject = object;
                if (dbmObject == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "renew"));
                }
                return (C)dbmObject;
            }
        }
        if (name != null) {
            n = children.size();
            for (i2 = 0; i2 < n; ++i2) {
                object = (DbmObject)children.get(i2);
                if (object.getObjectId() != 0L || !object.isName(name)) continue;
                object.setObjectId(objectId);
                object.setName(name);
                object.resetSyncPending();
                DbmObject dbmObject = object;
                if (dbmObject == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "renew"));
                }
                return (C)dbmObject;
            }
        }
        C object2 = this.create(name);
        ((DbmObject)object2).setObjectId(objectId);
        C c = object2;
        if (c == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "renew"));
        }
        return c;
    }

    @Override
    public C renew(long objectId, String name, BiConsumer<String, String> renameHandler) {
        return (C)this.renew(objectId, name);
    }

    protected void doAddChild(@NotNull C child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/dbm/common/BaseFamily", "doAddChild"));
        }
        boolean ok = false;
        while (!ok) {
            ImmutableList newList;
            ImmutableList<C> oldList = this.myChildren.get();
            ok = this.myChildren.compareAndSet(oldList, newList = ImmutableList.builder().addAll(oldList).add(child).build());
            if (!ok || !(child instanceof NaturalPositioned)) continue;
            ((NaturalPositioned)child).setPosition((short)newList.size());
        }
    }

    @Override
    @NotNull
    public C get(int index) {
        DbmObject dbmObject = (DbmObject)this.myChildren.get().get(index);
        if (dbmObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "get"));
        }
        return (C)dbmObject;
    }

    @Override
    @Nullable
    public C get(String name) {
        if (name == null) {
            return null;
        }
        ImmutableList<C> children = this.myChildren.get();
        int n = children.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DbmObject object = (DbmObject)children.get(i2);
            if (!object.isName(name)) continue;
            return (C)object;
        }
        return null;
    }

    @Override
    @Nullable
    public C get(String name, boolean caseSensitively) {
        if (name == null) {
            return null;
        }
        ImmutableList<C> children = this.myChildren.get();
        int n = children.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DbmObject object = (DbmObject)children.get(i2);
            String objectName = object.getNameOrNull();
            if (objectName == null || !(caseSensitively ? objectName.equals(name) : objectName.equalsIgnoreCase(name))) continue;
            return (C)object;
        }
        return null;
    }

    @Override
    @Nullable
    public C getByObjectId(long objectId) {
        ImmutableList<C> children = this.myChildren.get();
        int n = children.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DbmObject object = (DbmObject)children.get(i2);
            if (object.getObjectId() != objectId) continue;
            return (C)object;
        }
        return null;
    }

    @Override
    @Nullable
    public C getByNaturalPosition(short position) throws IllegalStateException {
        ImmutableList<C> children = this.myChildren.get();
        int n = children.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DbmObject child = (DbmObject)children.get(i2);
            try {
                NaturalPositioned np = (NaturalPositioned)((Object)child);
                if (np.getPosition() != position) continue;
                return (C)child;
            }
            catch (ClassCastException cce) {
                throw new IllegalStateException("The class " + this.myChildClass.getSimpleName() + " doesn't implement interface " + NaturalPositioned.class.getSimpleName(), cce);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public C find(@NotNull Predicate<? super C> predicate) {
        if (predicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predicate", "com/intellij/dbm/common/BaseFamily", "find"));
        }
        ImmutableList<C> children = this.myChildren.get();
        int n = children.size();
        for (int i2 = 0; i2 < n; ++i2) {
            DbmObject object = (DbmObject)children.get(i2);
            if (!predicate.test(object)) continue;
            return (C)object;
        }
        return null;
    }

    @Nullable
    public C get(@NotNull String name, String ... args) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/BaseFamily", "get"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/dbm/common/BaseFamily", "get"));
        }
        ImmutableList<C> children = this.myChildren.get();
        for (DbmObject child : children) {
            if (!child.isName(name) || !(child instanceof DbmOverloadable) || !((DbmOverloadable)((Object)child)).isApplicableTo(args)) continue;
            return (C)child;
        }
        return null;
    }

    @Override
    public String getFamilyDescription() {
        return null;
    }

    @Override
    @Nullable
    public C resolve(@NotNull RelativeReference p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/common/BaseFamily", "resolve"));
        }
        if (p.args == null) {
            return (C)this.resolve2(p.path, null);
        }
        if (p.path.length == 1) {
            return this.get(p.path[0], p.args);
        }
        return null;
    }

    @Override
    @Nullable
    public C resolve2(@NotNull String[] path, @Nullable String[] args) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/BaseFamily", "resolve2"));
        }
        if (path.length != 1) {
            return null;
        }
        String identity = path[0];
        BasicNamedElement child = this.get(identity);
        if (child != null) {
            return (C)child;
        }
        for (DbmObject c : this.myChildren.get()) {
            if (!c.isIdentity(identity)) continue;
            child = c;
            break;
        }
        return (C)child;
    }

    @Override
    @NotNull
    public List<String> getNames() {
        ImmutableList<C> children = this.myChildren.get();
        int n = children.size();
        ArrayList<String> names = new ArrayList<String>(n);
        for (int i2 = 0; i2 < n; ++i2) {
            names.add(((DbmObject)children.get(i2)).getName());
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "getNames"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public C first() {
        DbmObject theFirst = (DbmObject)this.myChildren.get().listIterator().next();
        if (theFirst == null) {
            throw new IllegalStateException("Failed to get the first child because of no children.");
        }
        DbmObject dbmObject = theFirst;
        if (dbmObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "first"));
        }
        return (C)dbmObject;
    }

    @Override
    @Nullable
    public C firstIfExists() {
        ImmutableList<C> children = this.myChildren.get();
        if (children.isEmpty()) {
            return null;
        }
        return (C)((DbmObject)children.listIterator().next());
    }

    @Override
    @NotNull
    public C last() {
        ImmutableList<C> cs = this.myChildren.get();
        if (cs.isEmpty()) {
            throw new IllegalStateException("Failed to get the last child because of no children.");
        }
        DbmObject dbmObject = (DbmObject)cs.get(cs.size() - 1);
        if (dbmObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "last"));
        }
        return (C)dbmObject;
    }

    @Override
    public boolean hasChildren() {
        return !this.myChildren.get().isEmpty();
    }

    @Override
    public int indexOf(BasicElement element) {
        ImmutableList<C> cs = this.myChildren.get();
        return cs.indexOf((Object)element);
    }

    @Override
    public <CC> void traverse(@NotNull Class<CC> objectClass, @NotNull Consumer<? super CC> consumer) {
        if (objectClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectClass", "com/intellij/dbm/common/BaseFamily", "traverse"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/dbm/common/BaseFamily", "traverse"));
        }
        for (DbmObject object : this.myChildren.get()) {
            if (object == null || !objectClass.isAssignableFrom(object.getClass())) continue;
            consumer.consume((Object)object);
        }
    }

    @Override
    @NotNull
    public JBIterable<C> iterable() {
        ImmutableList<C> cs = this.myChildren.get();
        JBIterable jBIterable = cs.isEmpty() ? JBIterable.empty() : JBIterable.from(cs);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "iterable"));
        }
        return jBIterable;
    }

    @Override
    public void move(@NotNull DbmObject object, int position) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/BaseFamily", "move"));
        }
        this.modifying();
        boolean ok = false;
        while (!ok) {
            int p9;
            ImmutableList<C> oldList = this.myChildren.get();
            int curr = oldList.indexOf((Object)object);
            if (curr == -1) {
                throw new IllegalArgumentException(String.format("The family %s doesn't contain item %s", this.getFamilyDescription(), object.toString()));
            }
            if (curr == position) {
                return;
            }
            ImmutableList newList = curr < position ? ImmutableList.builder().addAll((Iterable)oldList.subList(0, curr)).addAll((Iterable)oldList.subList(curr + 1, position)).add(oldList.get(curr)).addAll((Iterable)oldList.subList(position, oldList.size())).build() : ImmutableList.builder().addAll((Iterable)oldList.subList(0, position)).add(oldList.get(curr)).addAll((Iterable)oldList.subList(position, curr)).addAll((Iterable)oldList.subList(curr + 1, oldList.size())).build();
            ok = this.myChildren.compareAndSet(oldList, newList);
            if (!ok || !this.myNaturalOrdered) continue;
            int p1 = Math.min(curr, position);
            for (int i2 = p9 = Math.max(curr, position); i2 >= p1; --i2) {
                NaturalPositioned element = (NaturalPositioned)newList.get(i2);
                element.setPosition((short)(i2 + 1));
            }
        }
    }

    @Override
    @NotNull
    public ImmutableList<C> asList() {
        ImmutableList<C> immutableList = this.myChildren.get();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "asList"));
        }
        return immutableList;
    }

    @Override
    @NotNull
    public Collection<? extends DbmObject> getChildNodes() {
        ImmutableList<C> immutableList = this.asList();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "getChildNodes"));
        }
        return immutableList;
    }

    @Override
    void removeObject(@NotNull DbmObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/BaseFamily", "removeObject"));
        }
        this.modifying();
        boolean ok = false;
        while (!ok) {
            ImmutableList<C> oldList = this.myChildren.get();
            int curr = oldList.indexOf((Object)object);
            if (curr == -1) {
                return;
            }
            ImmutableList newList = ImmutableList.builder().addAll((Iterable)oldList.subList(0, curr)).addAll((Iterable)oldList.subList(curr + 1, oldList.size())).build();
            ok = this.myChildren.compareAndSet(oldList, newList);
            if (!ok || !this.myNaturalOrdered) continue;
            int n = newList.size();
            for (int i2 = curr; i2 < n; ++i2) {
                NaturalPositioned element = (NaturalPositioned)newList.get(i2);
                element.setPosition((short)(i2 + 1));
            }
        }
    }

    @Override
    public void sort() {
        Comparator<DbmObject> comparator = this.myNaturalOrdered ? FamilyUtil.NATURAL_COMPARATOR : FamilyUtil.GENERAL_COMPARATOR;
        this.modifying();
        boolean ok = false;
        while (!ok) {
            ImmutableList<C> oldList = this.myChildren.get();
            if (oldList.size() <= 1) {
                return;
            }
            ArrayList<C> al = new ArrayList<C>(oldList);
            Collections.sort(al, comparator);
            ImmutableList newList = ImmutableList.copyOf(al);
            ok = this.myChildren.compareAndSet(oldList, newList);
        }
    }

    @Override
    public void markChildrenAsSyncPending() {
        ImmutableList<C> children = this.myChildren.get();
        for (DbmObject child : children) {
            child.markSyncPending();
        }
    }

    @Override
    public void removeSyncPendingChildren() {
        if (this.isEmpty()) {
            return;
        }
        LinkedList<DbmObject> droppingObjects = null;
        boolean ok = false;
        while (!ok) {
            Object c2;
            ImmutableList<C> oldList = this.myChildren.get();
            ImmutableList.Builder b = ImmutableList.builder();
            boolean wasFilteredOnes = false;
            for (Object c2 : oldList) {
                if (((DbmObject)c2).isSyncPending()) {
                    if (droppingObjects == null) {
                        droppingObjects = new LinkedList<DbmObject>();
                    }
                    droppingObjects.add((DbmObject)c2);
                    wasFilteredOnes = true;
                    continue;
                }
                b.add(c2);
            }
            if (!wasFilteredOnes) {
                return;
            }
            this.modifying();
            ImmutableList newList = b.build();
            ok = this.myChildren.compareAndSet(oldList, newList);
            if (!ok || droppingObjects == null) continue;
            c2 = droppingObjects.iterator();
            while (c2.hasNext()) {
                DbmObject droppingObject = (DbmObject)c2.next();
                droppingObject.drop();
            }
            if (!this.myNaturalOrdered) continue;
            int n = newList.size();
            for (int i2 = 0; i2 < n; ++i2) {
                NaturalPositioned element = (NaturalPositioned)newList.get(i2);
                element.setPosition((short)(i2 + 1));
            }
        }
    }

    @Override
    public void remove(@NotNull Predicate<? super C> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/dbm/common/BaseFamily", "remove"));
        }
        ImmutableList<C> children = this.myChildren.get();
        if (children.isEmpty()) {
            return;
        }
        this.modifying();
        for (int i2 = children.size() - 1; i2 >= 0; --i2) {
            DbmObject child = (DbmObject)children.get(i2);
            if (!condition.test(child)) continue;
            child.drop();
        }
    }

    @Override
    public void clear() {
        ImmutableList<C> children = this.myChildren.get();
        if (children.isEmpty()) {
            return;
        }
        this.modifying();
        for (int i2 = children.size() - 1; i2 >= 0; --i2) {
            ((DbmObject)children.get(i2)).drop();
        }
    }

    protected abstract void modifying();

    @Override
    public String toString() {
        ImmutableList<C> children = this.myChildren.get();
        int n = children.size();
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return ((DbmObject)children.get(0)).toString();
            }
        }
        StringBuilder b = new StringBuilder();
        b.append(((DbmObject)children.get(0)).toString());
        for (int i2 = 1; i2 < n; ++i2) {
            b.append(',').append(' ').append(((DbmObject)children.get(i2)).toString());
        }
        return b.toString();
    }

    @Override
    public int size() {
        return this.myChildren.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.myChildren.get().isEmpty();
    }

    @Override
    public boolean isNotEmpty() {
        return !this.myChildren.get().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.myChildren.get().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.myChildren.get().containsAll(collection);
    }

    @Override
    @NotNull
    public Iterator<C> iterator() {
        UnmodifiableIterator unmodifiableIterator = this.myChildren.get().iterator();
        if (unmodifiableIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "iterator"));
        }
        return unmodifiableIterator;
    }

    @Override
    @NotNull
    public C[] toArray() {
        ImmutableList<C> objects = this.myChildren.get();
        int n = objects.size();
        Object[] array = (DbmObject[])Array.newInstance(this.myChildClass, n);
        DbmObject[] dbmObjectArray = (DbmObject[])objects.toArray(array);
        if (dbmObjectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "toArray"));
        }
        return dbmObjectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(T[] a) {
        Object[] objectArray = this.myChildren.get().toArray((Object[])a);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "toArray"));
        }
        return objectArray;
    }

    @Override
    public int indexOf(Object o) {
        return this.myChildren.get().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.myChildren.get().lastIndexOf(o);
    }

    @Override
    @NotNull
    public Class<C> getChildClass() {
        Class<C> clazz = this.myChildClass;
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseFamily", "getChildClass"));
        }
        return clazz;
    }
}

