/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.dbm.common.DbmDetail;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.NaturalPositioned;
import com.intellij.dbm.common.StateProperty;
import com.intellij.util.Numbers;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Strings;

public class DbmArgument
extends DbmDetail
implements NaturalPositioned,
BasicArgument {
    @NotNull
    final DbmRoutine myRoutine;
    @StateProperty
    public DasArgument.Direction myDirection;
    @StateProperty
    @Nullable
    public DataType myDataType;
    @StateProperty
    public String myDefaultExpression;
    private short myPosition;

    public DbmArgument(@NotNull DbmRoutine routine2, @Nullable String name) {
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/common/DbmArgument", "<init>"));
        }
        super((DbmObject)((Object)routine2), name);
        this.myRoutine = routine2;
        this.myDirection = DasArgument.Direction.IN;
    }

    @Override
    @Nullable
    public DbmObject getDbParent() {
        return (DbmObject)((Object)this.myRoutine);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ARGUMENT;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmArgument", "getKind"));
        }
        return objectKind;
    }

    @Override
    public short getPosition() {
        return this.myPosition;
    }

    @Override
    public void setPosition(short position) {
        this.myPosition = position;
    }

    @Override
    @NotNull
    public String calculateDisplayOrder() {
        String order = Numbers.toFixLengthNumber(this.getPosition(), 3);
        String naturalName = this.getNaturalNameOrNull();
        if (naturalName != null) {
            order = order + '.' + naturalName;
        }
        String string = order;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmArgument", "calculateDisplayOrder"));
        }
        return string;
    }

    @NotNull
    public DasArgument.Direction getDirection() {
        DasArgument.Direction direction = this.myDirection;
        if (direction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmArgument", "getDirection"));
        }
        return direction;
    }

    public void setDirection(@NotNull DasArgument.Direction direction) {
        if (direction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "direction", "com/intellij/dbm/common/DbmArgument", "setDirection"));
        }
        this.myDirection = direction;
    }

    @Override
    @NotNull
    public DataType getDataType() {
        DataType dt = this.myDataType;
        DataType dataType = dt != null ? dt : DataType.UNKNOWN;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmArgument", "getDataType"));
        }
        return dataType;
    }

    @Override
    @Nullable
    public DasUserDefinedType getCustomType() {
        return null;
    }

    public void setDataType(@Nullable DataType dataType) {
        DataType dt;
        DataType dataType2 = dt = dataType == DataType.UNKNOWN ? null : dataType;
        if (Objects.equals(this.myDataType, dt)) {
            return;
        }
        this.modifying();
        this.myDataType = dt;
    }

    @Override
    @Nullable
    public String getDefaultExpression() {
        return this.myDefaultExpression;
    }

    public void setDefaultExpression(@Nullable String defaultExpression) {
        if (Strings.eq((String)this.myDefaultExpression, (String)defaultExpression)) {
            return;
        }
        this.modifying();
        this.myDefaultExpression = defaultExpression;
    }

    @Override
    public DasRoutine getRoutine() {
        return this.myRoutine;
    }

    @Override
    @NotNull
    public DasArgument.Direction getArgumentDirection() {
        DasArgument.Direction direction = this.myDirection;
        if (direction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmArgument", "getArgumentDirection"));
        }
        return direction;
    }

    @Override
    public boolean isNotNull() {
        return false;
    }

    @Override
    @Nullable
    public String getDefault() {
        return this.getDefaultExpression();
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        String typedDescription = super.description(includeSurrogates);
        String string = (this.myDirection != null ? this.myDirection.name().toLowerCase(Locale.ROOT) : "??") + " " + typedDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmArgument", "description"));
        }
        return string;
    }
}

