/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.util.Casing;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmNamespaceOwner;
import com.intellij.dbm.common.DbmRoot;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmDatabase
extends DbmNamespace
implements BasicModDatabase,
DbmNamespaceOwner {
    @NotNull
    private final DbmRoot myRoot;
    protected final Family<? extends DbmSchema> mySchemas;
    @Nullable
    private DbmSchema myCurrentSchema;

    protected DbmDatabase(@NotNull DbmRoot root2, @Nullable String name) {
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/dbm/common/DbmDatabase", "<init>"));
        }
        super(root2, name);
        this.myRoot = root2;
        this.mySchemas = Family.of(this, ObjectKind.SCHEMA);
        this.assignFamilies(this.mySchemas);
    }

    @NotNull
    public DbmRoot getRoot() {
        DbmRoot dbmRoot = this.myRoot;
        if (dbmRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDatabase", "getRoot"));
        }
        return dbmRoot;
    }

    @Override
    @NotNull
    public Family<? extends DbmSchema> getSchemas() {
        Family<? extends DbmSchema> family = this.mySchemas;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDatabase", "getSchemas"));
        }
        return family;
    }

    @Override
    @NotNull
    public Family<? extends DbmSchema> getNamespaces() {
        Family<? extends DbmSchema> family = this.mySchemas;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDatabase", "getNamespaces"));
        }
        return family;
    }

    @Override
    @NotNull
    public final DbmRoot getDbParent() {
        DbmRoot dbmRoot = this.myRoot;
        if (dbmRoot == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDatabase", "getDbParent"));
        }
        return dbmRoot;
    }

    @Override
    @NotNull
    public final ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.DATABASE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDatabase", "getKind"));
        }
        return objectKind;
    }

    @Override
    public boolean isCurrent() {
        return this.model.getCurrentRootNamespace() == this;
    }

    @Override
    public void setCurrent(boolean current) {
        this.myRoot.setCurrentNamespace(this);
    }

    @Override
    public void setObjectId(long newObjectId) {
        if (this.myObjectId == newObjectId) {
            return;
        }
        this.modifying();
        this.myObjectId = newObjectId;
    }

    @Override
    @NotNull
    public DbmSchema getSchema() {
        throw new IllegalStateException("A database cannot have a parent schema");
    }

    public boolean catalogNamesAreEqual(@NotNull String nameA, @NotNull String nameB) {
        if (nameA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameA", "com/intellij/dbm/common/DbmDatabase", "catalogNamesAreEqual"));
        }
        if (nameB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameB", "com/intellij/dbm/common/DbmDatabase", "catalogNamesAreEqual"));
        }
        return StringUtil.equals((CharSequence)nameA, (CharSequence)nameB);
    }

    @Nullable
    public DbmSchema getCurrentSchema() {
        return this.myCurrentSchema;
    }

    public void setCurrentSchema(@Nullable DbmSchema currentSchema) {
        if (currentSchema != null) {
            assert (currentSchema.myDatabase == this);
            assert (this.mySchemas.contains(currentSchema));
        }
        this.myCurrentSchema = currentSchema;
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/common/DbmDatabase", "getCasing"));
        }
        Casing casing = BasicNamespace.DEFAULT_CASING;
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmDatabase", "getCasing"));
        }
        return casing;
    }
}

