/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ModelReader;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmComplex;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmMatView;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRef;
import com.intellij.dbm.common.DbmRoot;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSequence;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.DbmSynonym;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmUtil;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.ObjectsRef;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public abstract class DbmModel<@NotNull R extends DbmRoot<N>, @NotNull N extends DbmNamespace>
implements BasicModModel {
    protected static Logger LOG = Logger.getInstance(DbmModel.class);
    public static final MetaModel<DbmObject> DEFAULT_META_MODEL = MetaModel.builder().put(ObjectKind.ROOT, ObjectKind.DATABASE, DbmDatabase.class).put(ObjectKind.DATABASE, ObjectKind.SCHEMA, DbmSchema.class).put(ObjectKind.SCHEMA, ObjectKind.TABLE, DbmTable.class).put(ObjectKind.SCHEMA, ObjectKind.VIEW, DbmView.class).put(ObjectKind.SCHEMA, ObjectKind.SEQUENCE, DbmSequence.class).put(ObjectKind.SCHEMA, ObjectKind.MAT_VIEW, DbmMatView.class).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE, DbmSingleRoutine.class).put(ObjectKind.SCHEMA, ObjectKind.SYNONYM, DbmSynonym.class).put(ObjectKind.SCHEMA, ObjectKind.PACKAGE, DbmComplex.class).put(ObjectKind.TABLE, ObjectKind.COLUMN, DbmColumn.class).put(ObjectKind.TABLE, ObjectKind.INDEX, DbmIndex.class).put(ObjectKind.TABLE, ObjectKind.KEY, DbmKey.class).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY, DbmForeignKey.class).put(ObjectKind.TABLE, ObjectKind.CHECK, DbmCheck.class).put(ObjectKind.TABLE, ObjectKind.TRIGGER, DbmTrigger.class).put(ObjectKind.VIEW, ObjectKind.COLUMN, DbmColumn.class).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT, DbmArgument.class).build();
    @NotNull
    public final MetaModel<DbmObject> metaModel;
    @NotNull
    private final R myRoot;
    final MultiMap<DbmObject, DbmRef.ResolvedRef<?, ?>> forwardRefs;
    final MultiMap<DbmObject, DbmRef.ResolvedRef<?, ?>> backwardRefs;
    final ConcurrentMap<ObjectsRef<?, ?>, ConcurrentMap<DbmRef<?>, DbmRef<?>>> objectsRefs;
    private final THashSet<DbmObject> myLastCreatedObjects;
    private final THashSet<DbmObject> myLastModifiedObjects;
    private final THashSet<DbmObject> myLastRemovedObjects;
    private final ReentrantReadWriteLock myLock;
    private volatile long myModificationThreadId;
    private final CopyOnWriteArrayList<BasicModelListener> myListeners;

    protected DbmModel() {
        this(DEFAULT_META_MODEL);
    }

    protected DbmModel(@NotNull MetaModel<DbmObject> meta) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/common/DbmModel", "<init>"));
        }
        this.forwardRefs = MultiMap.createConcurrentSet();
        this.backwardRefs = MultiMap.createConcurrentSet();
        this.objectsRefs = ContainerUtil.newConcurrentMap();
        this.myLastCreatedObjects = new THashSet();
        this.myLastModifiedObjects = new THashSet();
        this.myLastRemovedObjects = new THashSet();
        this.myLock = new ReentrantReadWriteLock();
        this.myModificationThreadId = Long.MIN_VALUE;
        this.myListeners = new CopyOnWriteArrayList();
        this.metaModel = meta;
        this.myRoot = this.createRoot();
    }

    protected abstract R createRoot();

    @Override
    public <V> V read(ModelReader<? super BasicModel, V> reader) {
        V value;
        this.startConsistentRead();
        try {
            value = reader.perform(this);
        }
        finally {
            this.finishConsistentRead();
        }
        return value;
    }

    public void modify(@NotNull ModelModifier<? super DbmRoot> modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/dbm/common/DbmModel", "modify"));
        }
        this.modify((Class)DbmRoot.class, (ModelModifier)modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R2 extends BasicModRoot> void modify(@NotNull Class<R2> rootClass, @NotNull ModelModifier<? super R2> modifier) {
        if (rootClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootClass", "com/intellij/dbm/common/DbmModel", "modify"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/dbm/common/DbmModel", "modify"));
        }
        if (!rootClass.isAssignableFrom(this.myRoot.getClass())) {
            throw new IllegalArgumentException("Cannot cast " + this.myRoot.getClass().getSimpleName() + " to " + rootClass.getSimpleName());
        }
        R root2 = this.myRoot;
        this.startModifications();
        try {
            modifier.perform(root2);
        }
        finally {
            this.finishModifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends BasicElement, M extends E> void modify(@NotNull E element, @NotNull Class<M> clazz, @NotNull ModelModifier<? super M> modifier) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dbm/common/DbmModel", "modify"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/dbm/common/DbmModel", "modify"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/dbm/common/DbmModel", "modify"));
        }
        if (element.getModel() == null) {
            throw new IllegalArgumentException("Orphan element (the element doesn't belong to any model)");
        }
        if (element.getModel() != this) {
            throw new IllegalArgumentException("Alien element (the element belong to another model)");
        }
        Class<?> elementClass = element.getClass();
        if (!clazz.isAssignableFrom(elementClass)) {
            throw new IllegalArgumentException("Attempt to modify element of " + elementClass.getSimpleName() + " as an instance of " + clazz.getSimpleName());
        }
        E modElement = element;
        this.startModifications();
        try {
            modifier.perform(modElement);
        }
        finally {
            this.finishModifications();
        }
    }

    public void startConsistentRead() {
        this.myLock.readLock().lock();
    }

    public void finishConsistentRead() {
        this.myLock.readLock().unlock();
    }

    void doingObjectCreate(@NotNull DbmObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmModel", "doingObjectCreate"));
        }
        this.doingAnyModification();
        this.myLastCreatedObjects.add((Object)object);
    }

    void doingObjectModify(@NotNull DbmObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmModel", "doingObjectModify"));
        }
        this.doingAnyModification();
        this.myLastModifiedObjects.add((Object)object);
    }

    void doingRootsModify() {
        this.doingAnyModification();
    }

    void doingObjectRemove(@NotNull DbmObject object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmModel", "doingObjectRemove"));
        }
        this.doingAnyModification();
        this.myLastRemovedObjects.add((Object)object);
    }

    private void doingAnyModification() {
    }

    public void startModifications() {
        this.myLock.writeLock().lock();
        this.clearModifications();
        this.myModificationThreadId = Thread.currentThread().getId();
    }

    public void finishModifications() {
        this.myModificationThreadId = Long.MIN_VALUE;
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (!writeLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("The model is locked by another thread");
        }
        if (writeLock.getHoldCount() == 1) {
            Trinity<Set<BasicElement>, Set<BasicElement>, Set<BasicElement>> data = this.prepareNotifications();
            this.clearModifications();
            this.compactModifications();
            writeLock.unlock();
            this.processNotifications(data);
        } else {
            writeLock.unlock();
        }
    }

    @Nullable
    private Trinity<Set<BasicElement>, Set<BasicElement>, Set<BasicElement>> prepareNotifications() {
        this.myLastCreatedObjects.removeAll(this.myLastRemovedObjects);
        this.myLastModifiedObjects.removeAll(this.myLastRemovedObjects);
        this.myLastModifiedObjects.removeAll(this.myLastCreatedObjects);
        if (this.myLastCreatedObjects.isEmpty() && this.myLastModifiedObjects.isEmpty() && this.myLastRemovedObjects.isEmpty()) {
            return null;
        }
        return Trinity.create((Object)ContainerUtil.newHashSet(this.myLastCreatedObjects), (Object)ContainerUtil.newHashSet(this.myLastModifiedObjects), (Object)ContainerUtil.newHashSet(this.myLastRemovedObjects));
    }

    private void processNotifications(@Nullable Trinity<Set<BasicElement>, Set<BasicElement>, Set<BasicElement>> data) {
        if (data == null) {
            return;
        }
        for (BasicModelListener listener : this.myListeners) {
            try {
                listener.modified((Set)data.first, (Set)data.second, (Set)data.third);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    private void clearModifications() {
        this.myLastCreatedObjects.clear();
        this.myLastModifiedObjects.clear();
        this.myLastRemovedObjects.clear();
    }

    private void compactModifications() {
        this.myLastCreatedObjects.compact();
        this.myLastModifiedObjects.compact();
        this.myLastRemovedObjects.compact();
    }

    @Override
    public void addListener(@NotNull BasicModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/dbm/common/DbmModel", "addListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(@NotNull BasicModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/dbm/common/DbmModel", "removeListener"));
        }
        this.myListeners.remove(listener);
    }

    public boolean isInModifyingTransaction() {
        return this.myModificationThreadId != Long.MIN_VALUE;
    }

    @Override
    @NotNull
    public Rdbms getRdbms() {
        Rdbms rdbms = UnknownDatabase.RDBMS;
        if (rdbms == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getRdbms"));
        }
        return rdbms;
    }

    @NotNull
    public R getRoot() {
        R r = this.myRoot;
        if (r == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getRoot"));
        }
        return r;
    }

    @NotNull
    public final Family<? extends N> getRootNamespaces() {
        NamingFamily namingFamily = ((DbmRoot)this.myRoot).getNamespaces();
        if (namingFamily == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getRootNamespaces"));
        }
        return namingFamily;
    }

    @Nullable
    public N getCurrentRootNamespace() {
        return ((DbmRoot)this.myRoot).getCurrentNamespace();
    }

    public void setCurrentRootNamespace(@Nullable DbmNamespace namespace) {
        ((DbmRoot)this.myRoot).setCurrentNamespace(namespace);
    }

    @Nullable
    public DbmSchema getCurrentSchema() {
        return ((DbmRoot)this.myRoot).getCurrentSchema();
    }

    @Override
    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/common/DbmModel", "getCasing"));
        }
        DbmObject object = DbmUtil.getModelObjectOf(context);
        if (object == null) {
            Casing casing = BasicNamespace.UNKNOWN_CASING;
            if (casing == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getCasing"));
            }
            return casing;
        }
        Casing casing = object.getNamespace().getCasing(kind, context);
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getCasing"));
        }
        return casing;
    }

    @Override
    public void clearModel() {
        if (((Family)((DbmRoot)this.myRoot).getNamespaces()).isEmpty()) {
            return;
        }
        this.startModifications();
        try {
            ((DbmRoot)this.myRoot).setCurrentNamespace(null);
            ((Family)((DbmRoot)this.myRoot).getNamespaces()).clear();
        }
        finally {
            this.finishModifications();
        }
    }

    @Override
    public void writeSources(@NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/dbm/common/DbmModel", "writeSources"));
        }
        r.run();
    }

    @Deprecated
    @NotNull
    public JBIterable<N> getModelRoots() {
        JBIterable jBIterable = JBIterable.from((Iterable)((DbmRoot)this.getRoot()).getNamespaces());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getModelRoots"));
        }
        return jBIterable;
    }

    @Override
    @Deprecated
    @NotNull
    public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
        if (!(table instanceof DbmTable)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getExportedKeys"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = ((JBTreeTraverser)DbmUtil.dbmTraverser().withRoot((Object)((DbmTable)table))).traverse().flatten((Function)new Function<DbmObject, Iterable<Object>>(){

            public Iterable<Object> fun(DbmObject o) {
                return o.backwardReferences(DbmForeignKey.class).transform(DbmUtil.REF_SOURCE);
            }
        }).filter(DasConstraint.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "getExportedKeys"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots((Iterable)((DbmRoot)this.getRoot()).getNamespaces());
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmModel", "traverser"));
        }
        return jBTreeTraverser;
    }

    @Override
    public void saveSourceText(@NotNull BasicSourceAware object, String sourceText) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmModel", "saveSourceText"));
        }
        throw new IllegalStateException("The method DbmModel.saveSourceText() is not supported.");
    }

    @Override
    @Nullable
    public String loadSourceText(@NotNull BasicSourceAware object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/DbmModel", "loadSourceText"));
        }
        return null;
    }

    @Override
    public void setSchemaSourcesVersion(@NotNull BasicSchema schema, @Nullable Long version) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DbmModel", "setSchemaSourcesVersion"));
        }
    }

    @Override
    @Nullable
    public Long getSchemaSourcesVersion(@NotNull BasicSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DbmModel", "getSchemaSourcesVersion"));
        }
        return null;
    }
}

