/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.ObjectRef;
import com.intellij.dbm.common.StateProperty;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmSynonym
extends DbmMajor
implements BasicSynonym {
    @StateProperty
    public final ObjectRef<DbmSynonym, DbmMajor> origin;

    public DbmSynonym(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/DbmSynonym", "<init>"));
        }
        super(schema, name);
        this.origin = new ObjectRef<DbmSynonym, DbmMajor>(this, schema.schemaObjectResolver());
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.SYNONYM;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSynonym", "getKind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        DbmMajor object = this.origin.resolveObject();
        if (object != null) {
            String objectId = object.identity(includeSurrogates);
            if (object instanceof DbmSynonym) {
                String string = "--> " + objectId + " " + object.description(includeSurrogates);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSynonym", "description"));
                }
                return string;
            }
            String string = "--> " + objectId + ": " + object.description(includeSurrogates);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSynonym", "description"));
            }
            return string;
        }
        String pathString = this.origin.getPathString();
        String string = pathString != null && pathString.length() > 0 ? "--> " + pathString : "--> ?";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSynonym", "description"));
        }
        return string;
    }

    @Override
    @Nullable
    public DasObject resolveTarget() {
        return this.origin.resolveObject();
    }

    @Override
    @NotNull
    public Iterable<String> getTargetPath() {
        Object[] path = this.origin.getPath();
        if (path == null || path.length == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSynonym", "getTargetPath"));
            }
            return list;
        }
        JBIterable jBIterable = JBIterable.of((Object[])path);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmSynonym", "getTargetPath"));
        }
        return jBIterable;
    }

    @Override
    public String toString() {
        String originPathStr = StringUtil.join(this.getTargetPath(), (String)".");
        return this.identity() + "-->" + StringUtil.notNullize((String)StringUtil.nullize((String)originPathStr), (String)"???");
    }
}

