/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmComplex;
import com.intellij.dbm.common.DbmComplexElement;
import com.intellij.dbm.common.DbmRoot;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmUserDefinedType;
import com.intellij.dbm.common.StateProperty;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Strings;

public class DbmVariable
extends DbmComplexElement {
    @StateProperty
    public DataType myDataType;
    @StateProperty
    public String myDefaultExpression;

    public DbmVariable(@NotNull DbmComplex parent, @Nullable String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/common/DbmVariable", "<init>"));
        }
        super(parent, name);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.VARIABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmVariable", "getKind"));
        }
        return objectKind;
    }

    @Nullable
    public DataType getDataType() {
        return this.myDataType;
    }

    public void setDataType(@Nullable DataType dataType) {
        if (Objects.equals(this.myDataType, dataType)) {
            return;
        }
        this.modifying();
        this.myDataType = dataType;
    }

    @Nullable
    public DbmUserDefinedType getCustomType() {
        DbmSchema schema;
        if (this.myDataType == null || !this.myDataType.custom) {
            return null;
        }
        DbmSchema dbmSchema = schema = this.myDataType.schemaName == null ? this.getDbParent().getSchema() : ((DbmRoot)this.model.getRoot()).findSchema(this.myDataType.schemaName);
        if (schema == null) {
            return null;
        }
        return schema.resolveOwnCustomType(this.myDataType.typeName);
    }

    @Nullable
    public String getDefaultExpression() {
        return this.myDefaultExpression;
    }

    public void setDefaultExpression(@Nullable String defaultExpression) {
        if (Strings.eq((String)this.myDefaultExpression, (String)defaultExpression)) {
            return;
        }
        this.modifying();
        this.myDefaultExpression = defaultExpression;
    }
}

