/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.dbm.common.BasicFamily;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNode;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.EmptyFamily;
import com.intellij.dbm.common.Resolver;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Family<@NotNull C extends DbmObject>
implements ModNamingIdentifyingFamily<C>,
Collection<C>,
Resolver<C>,
DbmNode {
    @NotNull
    protected final ObjectKind myChildKind;

    public static <CC extends DbmObject> Family<CC> of(@NotNull DbmObject parent, @NotNull ObjectKind childKind) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/common/Family", "of"));
        }
        if (childKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childKind", "com/intellij/dbm/common/Family", "of"));
        }
        ObjectKind parentKind = parent.getKind();
        Class childClass2 = parent.model.metaModel.getObjectClass(parentKind, childKind);
        if (childClass2 != null) {
            Class cc = childClass2;
            return new BasicFamily(parent, childKind, cc);
        }
        return new EmptyFamily(parent, childKind);
    }

    @Override
    public abstract boolean isPopulatable();

    protected Family(@NotNull ObjectKind childKind) {
        if (childKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childKind", "com/intellij/dbm/common/Family", "<init>"));
        }
        this.myChildKind = childKind;
    }

    @NotNull
    public ObjectKind getChildKind() {
        ObjectKind objectKind = this.myChildKind;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/Family", "getChildKind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public abstract DbmModel getModel();

    @NotNull
    public abstract C create(@Nullable String var1);

    @Override
    @NotNull
    public abstract C createOrGet(@NotNull String var1);

    @Deprecated
    @NotNull
    public C getOrCreate(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/Family", "getOrCreate"));
        }
        BasicModNamedElement basicModNamedElement = this.createOrGet(name);
        if (basicModNamedElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/Family", "getOrCreate"));
        }
        return (C)basicModNamedElement;
    }

    @Override
    @NotNull
    public abstract C renew(long var1, @Nullable String var3);

    @Override
    @NotNull
    public abstract C get(int var1);

    @Override
    @Nullable
    public abstract C get(String var1);

    @Override
    @Nullable
    public abstract C get(String var1, boolean var2);

    @Override
    @Nullable
    public abstract C getByObjectId(long var1);

    @Nullable
    public abstract C getOverload(@NotNull String var1, String[] var2, boolean var3);

    @Nullable
    public abstract C getByNaturalPosition(short var1) throws IllegalStateException;

    @Override
    @Nullable
    public C resolve(String ... path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/Family", "resolve"));
        }
        return (C)((DbmObject)this.resolve2(path, null));
    }

    @Override
    @NotNull
    public abstract List<String> getNames();

    @Override
    @NotNull
    public abstract C first();

    @Nullable
    public abstract C firstIfExists();

    public abstract <CC> void traverse(@NotNull Class<CC> var1, @NotNull Consumer<? super CC> var2);

    @NotNull
    public abstract JBIterable<C> iterable();

    public abstract void move(@NotNull DbmObject var1, int var2);

    @NotNull
    public abstract ImmutableList<C> asList();

    public String getFamilyName() {
        return StringUtil.pluralize((String)this.myChildKind.toString());
    }

    abstract void removeObject(DbmObject var1);

    @Override
    public abstract void markChildrenAsSyncPending();

    @Override
    public abstract void removeSyncPendingChildren();

    @Override
    public abstract void sort();

    @Override
    public abstract void remove(@NotNull Predicate<? super C> var1);

    @Override
    public abstract void clear();

    @Override
    public abstract int size();

    @Override
    public abstract boolean isEmpty();

    public abstract boolean isNotEmpty();

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public abstract boolean containsAll(Collection<?> var1);

    @Override
    @NotNull
    public abstract Iterator<C> iterator();

    @Override
    @NotNull
    public abstract C[] toArray();

    @Override
    @NotNull
    public abstract <T> T[] toArray(T[] var1);

    public abstract int indexOf(Object var1);

    public abstract int lastIndexOf(Object var1);

    @NotNull
    public abstract Class<C> getChildClass();

    public abstract String getFamilyDescription();

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getFamilyDescription()).append('(');
        int n = this.size();
        switch (n) {
            case 0: {
                b.append("empty");
                break;
            }
            case 1: {
                b.append("1 child");
                break;
            }
            default: {
                b.append(n).append(" children");
            }
        }
        b.append(")");
        return b.toString();
    }

    @Override
    @NotNull
    public Stream<C> stream() {
        Stream stream = this.asList().stream();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/Family", "stream"));
        }
        return stream;
    }

    @Override
    public boolean add(C c) throws IllegalStateException {
        throw Family.cannotModifyInnerListDirectly();
    }

    @Override
    public boolean addAll(Collection<? extends C> c) throws IllegalStateException {
        throw Family.cannotModifyInnerListDirectly();
    }

    @Override
    public boolean remove(Object o) throws IllegalStateException {
        throw new IllegalStateException("Don't use method Family.remove(), use Family.removeObject() instead.");
    }

    @Override
    public boolean removeAll(Collection<?> c) throws IllegalStateException {
        throw Family.cannotModifyInnerListDirectly();
    }

    @Override
    public boolean retainAll(Collection<?> c) throws IllegalStateException {
        throw Family.cannotModifyInnerListDirectly();
    }

    private static IllegalStateException cannotModifyInnerListDirectly() throws IllegalStateException {
        return new IllegalStateException("Cannot modify the inner list of Family directly");
    }

    @Override
    @Nullable
    public abstract DbmObject getParentNode();

    @NotNull
    public abstract Collection<? extends DbmObject> getChildNodes();

    @Override
    @NotNull
    public String getDisplayName() {
        String string = StringUtil.pluralize((String)this.myChildKind.code());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/Family", "getDisplayName"));
        }
        return string;
    }
}

