/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.RelativeReference;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRef;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.dbm.common.ReferenceHolder;
import com.intellij.dbm.common.Resolver;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectRef<R extends DbmObject, T extends DbmObject>
implements PropertyHolder,
ReferenceHolder<R> {
    @NotNull
    private final R myOwner;
    @NotNull
    private final Resolver<? extends T> myResolver;
    @NotNull
    private volatile DbmRef<T> myRef;
    @NotNull
    private final Object mySync;

    public ObjectRef(@NotNull R owner, @NotNull Resolver<? extends T> resolver) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/dbm/common/ObjectRef", "<init>"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/dbm/common/ObjectRef", "<init>"));
        }
        this.myRef = DbmRef.empty();
        this.mySync = new Object();
        this.myOwner = owner;
        this.myResolver = resolver;
    }

    public void set(@Nullable T object) {
        if (object != null) {
            this.setResolved(object);
        } else {
            this.clearState();
        }
    }

    public void set(String ... path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/ObjectRef", "set"));
        }
        this.set(path, (String[])null);
    }

    public void set(@NotNull String[] path, @Nullable String[] arguments) {
        DbmObject target;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/ObjectRef", "set"));
        }
        boolean hasArguments = arguments != null;
        DbmObject dbmObject = target = hasArguments ? (DbmObject)this.myResolver.resolve2(path, arguments) : (DbmObject)this.myResolver.resolve(path);
        if (target != null) {
            this.setResolved(target);
        } else {
            this.setUnresolved(path, arguments);
        }
    }

    public void set(@NotNull RelativeReference p) {
        DbmObject target;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/common/ObjectRef", "set"));
        }
        if (p.path != null) {
            target = p.args != null ? (DbmObject)this.myResolver.resolve2(p.path, p.args) : (DbmObject)this.myResolver.resolve(p.path);
        } else if (p.args != null) {
            target = null;
        } else {
            this.clearState();
            return;
        }
        if (target != null) {
            this.setResolved(target);
        } else {
            this.setUnresolved(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setResolved(@NotNull T object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/dbm/common/ObjectRef", "setResolved"));
        }
        Object object2 = this.mySync;
        synchronized (object2) {
            if (this.myRef.getResolvedObject() == object) {
                return;
            }
            ((DbmObject)this.myOwner).modifying();
            this.myRef.drop();
            this.myRef = DbmRef.ref(this, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUnresolved(@NotNull String[] path, @Nullable String[] arguments) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/common/ObjectRef", "setUnresolved"));
        }
        ((DbmObject)this.myOwner).modifying();
        Object object = this.mySync;
        synchronized (object) {
            this.myRef.drop();
            this.myRef = DbmRef.unresolved(this.myOwner, path, arguments == null ? null : arguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUnresolved(@NotNull RelativeReference p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/common/ObjectRef", "setUnresolved"));
        }
        ((DbmObject)this.myOwner).modifying();
        Object object = this.mySync;
        synchronized (object) {
            this.myRef.drop();
            this.myRef = DbmRef.unresolved(this.myOwner, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearState() {
        Object object = this.mySync;
        synchronized (object) {
            if (this.myRef.isEmpty()) {
                return;
            }
            ((DbmObject)this.myOwner).modifying();
            this.myRef.drop();
            this.myRef = DbmRef.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void referenceDropped(@NotNull DbmRef.ResolvedRef<? extends DbmObject, ? extends DbmObject> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/dbm/common/ObjectRef", "referenceDropped"));
        }
        Object object = this.mySync;
        synchronized (object) {
            if (this.myRef == ref) {
                ((DbmObject)this.myOwner).modifying();
                this.myRef = DbmRef.empty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T resolveObject() {
        Object object = this.mySync;
        synchronized (object) {
            Object target = this.myRef.getResolvedObject();
            if (this.myRef.needsResolving()) {
                RelativeReference relativeReference = this.myRef.getRelativeReference();
                assert (relativeReference != null);
                String[] path = relativeReference.path;
                String[] arguments = relativeReference.args;
                DbmObject dbmObject = target = arguments == null ? (DbmObject)this.myResolver.resolve(path) : (DbmObject)this.myResolver.resolve2(path, arguments);
                if (target != null) {
                    this.setResolved(target);
                }
            }
            return target;
        }
    }

    @Override
    @NotNull
    public R getOwner() {
        R r = this.myOwner;
        if (r == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/ObjectRef", "getOwner"));
        }
        return r;
    }

    @NotNull
    public DbmRef<T> getRef() {
        DbmRef<T> dbmRef = this.myRef;
        if (dbmRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/ObjectRef", "getRef"));
        }
        return dbmRef;
    }

    @Nullable
    public T getObject() {
        return this.myRef.getResolvedObject();
    }

    @Nullable
    public String[] getPath() {
        RelativeReference relativeReference = this.myRef.getRelativeReference();
        return relativeReference != null ? relativeReference.path : null;
    }

    @Nullable
    public String[] getArguments() {
        RelativeReference relativeReference = this.myRef.getRelativeReference();
        return relativeReference != null ? relativeReference.args : null;
    }

    @Nullable
    public String getPathString() {
        String[] path = this.getPath();
        return path != null ? StringUtil.join((String[])path, (String)".") : null;
    }

    public boolean isResolved() {
        return this.myRef.getResolvedObject() != null;
    }

    public boolean exists() {
        return !this.myRef.isEmpty();
    }

    @Override
    @Nullable
    public String exportState() {
        RelativeReference relativeReference = this.myRef.getRelativeReference();
        return relativeReference != null ? relativeReference.toString() : null;
    }

    @Override
    public void importState(@Nullable String string) {
        if (string != null) {
            RelativeReference p = RelativeReference.of(string);
            this.set(p);
        } else {
            this.clearState();
        }
    }

    @NotNull
    public String toString() {
        String string = StringUtil.notNullize((String)this.exportState());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/ObjectRef", "toString"));
        }
        return string;
    }
}

