/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.factories;

import com.intellij.database.introspection.GenericIntrospector;
import com.intellij.dbm.common.DBScriptingService;
import com.intellij.dbm.db2.Db2Model;
import com.intellij.dbm.derby.DerbyModel;
import com.intellij.dbm.factories.RdbmsDefinition;
import com.intellij.dbm.generic.GenericModel;
import com.intellij.dbm.h2.H2Model;
import com.intellij.dbm.hsqldb.HsqldbModel;
import com.intellij.dbm.mssql.MsIntrospector;
import com.intellij.dbm.mssql.MsModel;
import com.intellij.dbm.mysql.MysqlIntrospector;
import com.intellij.dbm.mysql.MysqlModel;
import com.intellij.dbm.oracle.DBAbstractScriptingService;
import com.intellij.dbm.oracle.OraIntrospector;
import com.intellij.dbm.oracle.OraModel;
import com.intellij.dbm.oracle.OraScriptingService;
import com.intellij.dbm.postgres.PostgresIntrospector;
import com.intellij.dbm.postgres.PostgresModel;
import com.intellij.dbm.sqlite.SqliteModel;
import com.intellij.dbm.sybase.SybaseIntrospector;
import com.intellij.dbm.sybase.SybaseModel;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.H2db;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class RdbmsRegistry {
    private static final RdbmsRegistry ourInstance = new RdbmsRegistry();
    private final ConcurrentMap<String, RdbmsDefinition> myDefinitions = ContainerUtil.newConcurrentMap();

    public static RdbmsRegistry instance() {
        return ourInstance;
    }

    public void registerDefinition(@NotNull RdbmsDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/dbm/factories/RdbmsRegistry", "registerDefinition"));
        }
        RdbmsDefinition oldValue = this.myDefinitions.putIfAbsent(definition.rdbms.code, definition);
        if (oldValue != null) {
            throw new IllegalStateException("The RDBMS " + oldValue.rdbms + " already registered");
        }
    }

    @NotNull
    public RdbmsDefinition getDefinitionByRdbms(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/dbm/factories/RdbmsRegistry", "getDefinitionByRdbms"));
        }
        RdbmsDefinition definition = (RdbmsDefinition)this.myDefinitions.get(rdbms.code);
        if (definition == null) {
            throw new IllegalArgumentException("The RDBMS " + rdbms + " is not registered");
        }
        RdbmsDefinition rdbmsDefinition = definition;
        if (rdbmsDefinition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/factories/RdbmsRegistry", "getDefinitionByRdbms"));
        }
        return rdbmsDefinition;
    }

    @Nullable
    public RdbmsDefinition findDefinitionByRdbms(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/dbm/factories/RdbmsRegistry", "findDefinitionByRdbms"));
        }
        return (RdbmsDefinition)this.myDefinitions.get(rdbms.code);
    }

    @NotNull
    public RdbmsDefinition getDefinitionByCode(@NotNull String code) {
        if (code == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "code", "com/intellij/dbm/factories/RdbmsRegistry", "getDefinitionByCode"));
        }
        for (RdbmsDefinition definition : this.myDefinitions.values()) {
            if (!definition.rdbms.code.equalsIgnoreCase(code)) continue;
            RdbmsDefinition rdbmsDefinition = definition;
            if (rdbmsDefinition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/factories/RdbmsRegistry", "getDefinitionByCode"));
            }
            return rdbmsDefinition;
        }
        throw new IllegalArgumentException("The RDBMS with code " + code + " is not registered");
    }

    static {
        ourInstance.registerDefinition(new RdbmsDefinition(Oracle.RDBMS, OraModel.class, OraIntrospector.class, OraScriptingService.class));
        ourInstance.registerDefinition(new RdbmsDefinition(Postgres.RDBMS, PostgresModel.class, PostgresIntrospector.class, DBAbstractScriptingService.class));
        ourInstance.registerDefinition(new RdbmsDefinition(Mssql.RDBMS, MsModel.class, MsIntrospector.class, DBAbstractScriptingService.class));
        ourInstance.registerDefinition(new RdbmsDefinition(Sybase.RDBMS, SybaseModel.class, SybaseIntrospector.class, DBAbstractScriptingService.class));
        ourInstance.registerDefinition(new RdbmsDefinition(Mysql.RDBMS, MysqlModel.class, MysqlIntrospector.class, DBScriptingService.class));
        ourInstance.registerDefinition(new RdbmsDefinition(Db2Model.RDBMS, Db2Model.class, GenericIntrospector.class, DBScriptingService.class));
        ourInstance.registerDefinition(new RdbmsDefinition(DerbyModel.RDBMS, DerbyModel.class, GenericIntrospector.class, DBScriptingService.class));
        ourInstance.registerDefinition(new RdbmsDefinition(H2db.RDBMS, H2Model.class, GenericIntrospector.class, DBScriptingService.class));
        ourInstance.registerDefinition(new RdbmsDefinition(HsqldbModel.RDBMS, HsqldbModel.class, GenericIntrospector.class, DBScriptingService.class));
        ourInstance.registerDefinition(new RdbmsDefinition(SqliteModel.RDBMS, SqliteModel.class, GenericIntrospector.class, DBScriptingService.class));
        ourInstance.registerDefinition(new RdbmsDefinition(UnknownDatabase.RDBMS, GenericModel.class, GenericIntrospector.class, DBScriptingService.class));
    }
}

