/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.mssql;

import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.mssql.MsDatabase;
import com.intellij.dbm.mssql.MsType;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MsAliasType
extends DbmMajor
implements MsType,
DasTypedObject {
    @StateProperty
    public int myTypeId;
    @StateProperty
    @Nullable
    public DataType myDataType;
    @StateProperty
    public boolean myNotNull;

    public MsAliasType(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/mssql/MsAliasType", "<init>"));
        }
        super(schema, name);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.ALIAS_TYPE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsAliasType", "getKind"));
        }
        return objectKind;
    }

    @Override
    public int getTypeId() {
        return this.myTypeId;
    }

    @Override
    public void setTypeId(int typeId) {
        if (this.myTypeId == typeId) {
            return;
        }
        this.modifying();
        int oldTypeId = this.myTypeId;
        this.myTypeId = typeId;
        ((MsDatabase)this.getSchema().myDatabase).justTypeIdChanged(this, oldTypeId, typeId);
    }

    @Override
    protected void dissociateIdentifiers() {
        super.dissociateIdentifiers();
        this.setTypeId(0);
    }

    @NotNull
    public DataType getDataType() {
        DataType dt = this.myDataType;
        DataType dataType = dt != null ? dt : DataType.UNKNOWN;
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsAliasType", "getDataType"));
        }
        return dataType;
    }

    public void setDataType(@Nullable DataType dataType) {
        DataType dt;
        DataType dataType2 = dt = dataType == DataType.UNKNOWN ? null : dataType;
        if (Objects.equals(this.myDataType, dt)) {
            return;
        }
        this.modifying();
        this.myDataType = dt;
    }

    public boolean isNotNull() {
        return this.myNotNull;
    }

    public void setNotNull(boolean notNull) {
        if (this.myNotNull == notNull) {
            return;
        }
        this.modifying();
        this.myNotNull = notNull;
    }

    @Nullable
    public String getDefinition() {
        DataType dt = this.myDataType;
        if (dt == null) {
            return null;
        }
        String definition = dt.getSpecification();
        if (this.myNotNull) {
            definition = definition + " not null";
        }
        return definition;
    }

    @Override
    @NotNull
    public String calculateDisplayOrder() {
        String s = this.getNameOrNull();
        String string = s != null ? s : "\u3fff";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsAliasType", "calculateDisplayOrder"));
        }
        return string;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        String string = StringUtil.notNullize((String)this.getDefinition(), (String)"<undefined>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/mssql/MsAliasType", "description"));
        }
        return string;
    }

    @Nullable
    public String getDefault() {
        return null;
    }

    @Nullable
    public DasUserDefinedType getCustomType() {
        return null;
    }
}

