/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.intellij.database.introspection.IntrospectionMode;
import com.intellij.database.introspection.LongIdName;
import com.intellij.database.introspection.OraObjectCodes;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.SourceError;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.dbm.common.BaseIntrospector;
import com.intellij.dbm.common.CascadeRule;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmCheck;
import com.intellij.dbm.common.DbmColumn;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmForeignKey;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmInnerRoutine;
import com.intellij.dbm.common.DbmKey;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmMajor;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleRoutine;
import com.intellij.dbm.common.DbmSourceAware;
import com.intellij.dbm.common.DbmSynonym;
import com.intellij.dbm.common.DbmTrigger;
import com.intellij.dbm.common.DbmView;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.IntrospectionUtil;
import com.intellij.dbm.common.SingleDatabaseIntrospector;
import com.intellij.dbm.common.TrigTurn;
import com.intellij.dbm.oracle.OraBody;
import com.intellij.dbm.oracle.OraCollectionType;
import com.intellij.dbm.oracle.OraIntroQueries;
import com.intellij.dbm.oracle.OraIntrospectionUtils;
import com.intellij.dbm.oracle.OraModel;
import com.intellij.dbm.oracle.OraModule;
import com.intellij.dbm.oracle.OraModuleAttribute;
import com.intellij.dbm.oracle.OraObjectType;
import com.intellij.dbm.oracle.OraPackage;
import com.intellij.dbm.oracle.OraSchema;
import com.intellij.dbm.oracle.OraSequence;
import com.intellij.dbm.oracle.OraTable;
import com.intellij.dbm.oracle.OraView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TLongHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.exceptions.NoTableOrViewException;
import org.jetbrains.dekaf.sql.SqlQuery;

@Deprecated
public class OraIntrospector
extends SingleDatabaseIntrospector<OraSchema, OraModel> {
    private static final Set<String> SYSTEM_SCHEMAS = ImmutableSortedSet.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER).add((Object)"SYS").add((Object)"SYSTEM").add((Object)"CTXSYS").build();
    @NotNull
    private final OraIntroQueries myQueries;
    @NotNull
    private static final Logger LOG = Logger.getInstance(OraIntrospector.class);
    private boolean myFast;
    private static final Pattern SIMPLE_QUOTED_NAME_PATTERN = Pattern.compile("^\\s*\"([^\"]*)\"\\s*$");
    private static final Pattern AUTO_NOT_NULL_CHECK_PATTERN = Pattern.compile("\".+\" IS NOT NULL");

    public OraIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/oracle/OraIntrospector", "<init>"));
        }
        super(facade);
        this.myFast = false;
        this.myQueries = OraIntroQueries.QUERIES;
    }

    @Override
    protected boolean modelCanBeAccepted(@Nullable DbmModel model) {
        return model instanceof OraModel;
    }

    @Override
    @NotNull
    protected OraModel createNewModel() {
        OraModel oraModel = new OraModel();
        if (oraModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "createNewModel"));
        }
        return oraModel;
    }

    @Override
    protected void initInternalState() {
        super.initInternalState();
        if (!this.myServerVersion.isOrGreater(new int[]{10}) && this.myDriverVersion.isOrGreater(new int[]{12})) {
            String message = String.format("Unsupported combination of server/driver versions: found Oracle server version %s with JDBC driver version %s that is not compatible. Oracle server version 9.x must be connected by JDBC driver versions 9.x to 11.x.", this.myServerVersion, this.myDriverVersion);
            throw new IllegalStateException(message);
        }
        this.myFast = (Boolean)this.myFacade.inTransaction((InTransaction)new InTransaction<Boolean>(){

            public Boolean run(@NotNull DBTransaction tran) {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$1", "run"));
                }
                try {
                    return (Boolean)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.checkBaseDictionariesAccess).run();
                }
                catch (NoTableOrViewException ntv) {
                    return false;
                }
            }
        });
        IntrospectionUtil.setMajorVersionParameters(this.myServerVersion, 10, this.myQueryParameters);
        IntrospectionUtil.setOracleFastSlowModeParameters(this.myFast, this.myQueryParameters);
        LOG.info(String.format("Oracle Introspector: initialized for Oracle version %s driver version %s using %s mode", this.myServerVersion, this.myDriverVersion, this.myFast ? "FAST" : "SLOW"));
    }

    @Override
    protected void introspectNamespaces(@NotNull DBTransaction tran) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector", "introspectNamespaces"));
        }
        List schemas = (List)tran.query(this.myQueries.retrieveAllSchemas).run();
        this.applyNamespaces(schemas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNamespaces(@NotNull List<LongIdName> scs) {
        if (scs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scs", "com/intellij/dbm/oracle/OraIntrospector", "applyNamespaces"));
        }
        assert (this.myModel != null);
        ((OraModel)this.myModel).startModifications();
        try {
            Family schemas = ((OraModel)this.myModel).schemas();
            boolean wasEmpty = schemas.isEmpty();
            boolean beforePublic = true;
            schemas.markChildrenAsSyncPending();
            int n = scs.size();
            for (int i2 = 0; i2 < n; ++i2) {
                LongIdName sc = scs.get(i2);
                OraSchema schema = (OraSchema)schemas.renew(sc.id, sc.name);
                beforePublic &= sc.id != 1L;
                if (i2 == 0) {
                    ((OraModel)this.myModel).setCurrentSchema(schema);
                }
                if (!beforePublic || !wasEmpty) continue;
                schema.setVisible(true);
            }
            schemas.removeSyncPendingChildren();
        }
        finally {
            ((OraModel)this.myModel).finishModifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void introspectSessionState(@NotNull DBTransaction tran) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector", "introspectSessionState"));
        }
        OraIntroQueries.OneSessionInfo sessionInfo = (OraIntroQueries.OneSessionInfo)tran.query(this.myQueries.retrieveSessionInfo).run();
        assert (sessionInfo != null);
        ((OraModel)this.myModel).startModifications();
        try {
            OraSchema currentSchema = (OraSchema)((OraModel)this.myModel).schemas().getOrCreate(sessionInfo.current_schema);
            currentSchema.setVisible(true);
            ((OraModel)this.myModel).setCurrentSchema(currentSchema);
            OraSchema userSchema = (OraSchema)((OraModel)this.myModel).schemas().getOrCreate(sessionInfo.current_user);
            userSchema.setVisible(true);
        }
        finally {
            ((OraModel)this.myModel).finishModifications();
        }
    }

    @Override
    protected void introspectAuto(@NotNull DBTransaction tran, @NotNull List<OraSchema> schemas) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector", "introspectAuto"));
        }
        if (schemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/dbm/oracle/OraIntrospector", "introspectAuto"));
        }
        ArrayList<OraSchema> schemasToProcess = new ArrayList<OraSchema>(schemas);
        Iterator<OraSchema> it = schemasToProcess.iterator();
        while (it.hasNext()) {
            OraSchema s = it.next();
            if (s.getObjectId() != 0L || s.isName("SYS")) continue;
            LOG.warn("Oracle schema " + s.getNameOrNull() + " has no object Id");
            it.remove();
        }
        ArrayList<OraSchema> schemas1 = new ArrayList<OraSchema>(schemasToProcess.size());
        ArrayList<OraSchema> schemas2 = new ArrayList<OraSchema>(schemasToProcess.size());
        for (OraSchema schema : schemasToProcess) {
            (schema.getIntrospectionTimestamp() == null ? schemas1 : schemas2).add(schema);
        }
        if (!schemas1.isEmpty()) {
            OraDatabaseFirstRetriever retriever1 = new OraDatabaseFirstRetriever(tran, (OraModel)this.getModel(), schemas1, false);
            retriever1.process();
        }
        if (!schemas2.isEmpty()) {
            OraDatabaseIncRetriever retriever2 = new OraDatabaseIncRetriever(tran, (OraModel)this.getModel(), schemas2, false);
            retriever2.process();
        }
        for (OraSchema schema : schemasToProcess) {
            OraSchemaRetriever retriever = new OraSchemaRetriever(schema);
            retriever.retrieveMain(tran);
        }
    }

    @Override
    public void introspectFragment(@NotNull BasicNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/dbm/oracle/OraIntrospector", "introspectFragment"));
        }
        if (objectKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectKind", "com/intellij/dbm/oracle/OraIntrospector", "introspectFragment"));
        }
        if (objectNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectNames", "com/intellij/dbm/oracle/OraIntrospector", "introspectFragment"));
        }
        assert (namespace.getModel() == this.myModel);
        assert (namespace instanceof OraSchema);
        OraSchema schema = (OraSchema)namespace;
        OraSchemaRetriever retriever = new OraSchemaRetriever(schema, withSources, objectKind, objectNames);
        this.myFacade.inTransaction(retriever::retrieveMain);
    }

    private static void processNames(@NotNull String[] items, @NotNull Family<OraSchema> modelSchemas, boolean renew) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/dbm/oracle/OraIntrospector", "processNames"));
        }
        if (modelSchemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelSchemas", "com/intellij/dbm/oracle/OraIntrospector", "processNames"));
        }
        for (String item : items) {
            try {
                assert (item.length() >= 23) : "The item should be at least 23 characters length";
                String kindCode = item.substring(0, 2);
                String schemaIdStr = item.substring(2, 12);
                String objectIdStr = item.substring(12, 22);
                String objectName = item.substring(22);
                ObjectKind kind = OraObjectCodes.MAJOR_KINDS.get(kindCode);
                assert (kind != null) : "Unknown kind code: " + kindCode;
                int schemaId = Integer.parseInt(schemaIdStr);
                int objectId = Integer.parseInt(objectIdStr);
                OraSchema schema = (OraSchema)modelSchemas.getByObjectId(schemaId);
                assert (schema != null) : "Schema should exist, id:" + schemaId;
                Family<? extends DbmMajor> family = schema.family(kind);
                if (renew) {
                    family.renew(objectId, objectName);
                    continue;
                }
                DbmMajor majorObject = family.create(objectName);
                majorObject.setObjectId(objectId);
            }
            catch (NumberFormatException e) {
                LOG.warn(String.format("Failed to handle item '%s': %s: %s", item, e.getClass().getSimpleName(), e.getMessage()));
            }
        }
    }

    private static void processSynonyms(List<OraIntroQueries.OneSynonym> ss, OraModel model) {
        for (OraIntroQueries.OneSynonym s : ss) {
            OraSchema schema = (OraSchema)model.schemas().get(s.synonym_schema_name);
            if (schema == null) continue;
            DbmSynonym synonym = (DbmSynonym)schema.getSynonyms().renew(s.synonym_id, s.synonym_name);
            synonym.setCreatedAndModifiedTimestamps(s.created_timestamp, s.modified_timestamp);
            String[] originPath = s.origin_db_link != null ? new String[]{s.origin_db_link, s.origin_schema_name, s.origin_object_name} : (s.origin_schema_name != null && !s.origin_schema_name.equals(schema.getName()) ? new String[]{s.origin_schema_name, s.origin_object_name} : new String[]{s.origin_object_name});
            synonym.origin.set(originPath);
        }
    }

    @NotNull
    @Contract(pure=true)
    static String unquoteNameIfPossible(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/oracle/OraIntrospector", "unquoteNameIfPossible"));
        }
        Matcher m = SIMPLE_QUOTED_NAME_PATTERN.matcher(name);
        if (m.matches()) {
            String string = m.group(1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "unquoteNameIfPossible"));
            }
            return string;
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraIntrospector", "unquoteNameIfPossible"));
        }
        return string;
    }

    private static DbmTrigger findTrigger(OraSchema schema, String triggerName) {
        DbmTrigger trigger2;
        for (DbmLikeTable dbmLikeTable : schema.getTables()) {
            DbmTrigger trigger22 = (DbmTrigger)dbmLikeTable.getTriggers().get(triggerName);
            if (trigger22 == null) continue;
            return trigger22;
        }
        for (DbmLikeTable dbmLikeTable : schema.getViews()) {
            trigger2 = (DbmTrigger)dbmLikeTable.getTriggers().get(triggerName);
            if (trigger2 == null) continue;
            return trigger2;
        }
        for (DbmLikeTable dbmLikeTable : schema.getMatViews()) {
            trigger2 = (DbmTrigger)dbmLikeTable.getTriggers().get(triggerName);
            if (trigger2 == null) continue;
            return trigger2;
        }
        return null;
    }

    private static void applySources(@NotNull OraSchema schema, @NotNull String type, @NotNull String name, @NotNull String sourceText) {
        DbmSourceAware sa;
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (sourceText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceText", "com/intellij/dbm/oracle/OraIntrospector", "applySources"));
        }
        if (sourceText.length() == 0) {
            return;
        }
        DbmSourceAware dbmSourceAware = type.equals("TYPE") ? (DbmSourceAware)schema.getObjectTypes().getOrCreate(name) : (type.equals("TYPE BODY") ? schema.getObjectTypes().getOrCreate(name).getOrCreateBody() : (type.equals("PACKAGE") ? (DbmSourceAware)schema.getPackages().getOrCreate(name) : (type.equals("PACKAGE BODY") ? schema.getPackages().getOrCreate(name).getOrCreateBody() : (sa = type.equals("FUNCTION") || type.equals("PROCEDURE") ? (DbmSourceAware)schema.getRoutines().getOrCreate(name) : null))));
        if (sa == null) {
            return;
        }
        sa.setSourceText(sourceText);
    }

    private final class OraSchemaRetriever
    extends BaseIntrospector.SchemaRetriever {
        @NotNull
        private Timestamp myFromTimestamp;
        private Timestamp myBeginTimestamp;
        boolean affectsTables;
        boolean affectsViews;
        boolean affectsTriggers;
        boolean affectsSingleRoutines;
        boolean affectsModulesOrBodies;
        boolean haveDefaults;
        boolean toStop;
        private final Set<DbmLikeTable> myTablesToReorderDetails;
        private final Set<OraModule> myAffectedModules;
        private final Set<DbmObject> myAffectedDepObjects;

        OraSchemaRetriever(OraSchema schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "<init>"));
            }
            super((BaseIntrospector)OraIntrospector.this, (DbmSchema)schema);
            this.toStop = false;
            this.myTablesToReorderDetails = new HashSet<DbmLikeTable>();
            this.myAffectedModules = new HashSet<OraModule>();
            this.myAffectedDepObjects = new HashSet<DbmObject>();
            Date lastIntrospectionTimestamp = schema.getIntrospectionTimestamp();
            this.myFromTimestamp = this.myMode.increment && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : AGES_AGO;
        }

        OraSchemaRetriever(OraSchema schema, @NotNull boolean withSources, @NotNull ObjectKind fragmentKind, String[] fragmentNames) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "<init>"));
            }
            if (fragmentKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragmentKind", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "<init>"));
            }
            if (fragmentNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragmentNames", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "<init>"));
            }
            super((BaseIntrospector)OraIntrospector.this, null, (DbmSchema)schema, IntrospectionMode.FRAGMENT);
            this.toStop = false;
            this.myTablesToReorderDetails = new HashSet<DbmLikeTable>();
            this.myAffectedModules = new HashSet<OraModule>();
            this.myAffectedDepObjects = new HashSet<DbmObject>();
            this.myFragmentKind = fragmentKind;
            this.myFragmentNames = fragmentNames;
            this.myWithSources = withSources;
            this.myFromTimestamp = AGES_AGO;
            String[] fragmentKindTypeNames = OraObjectCodes.KIND_ORACLE_NAMES.get(fragmentKind);
            this.setQueryParameter("major_object_type_names", fragmentKindTypeNames);
            this.setQueryParameter("major_object_names", fragmentNames);
        }

        @Override
        public void process() {
            if (((OraSchema)this.schema).isDropped()) {
                return;
            }
            OraIntrospector.this.myFacade.inTransaction(this::retrieveMain);
        }

        @Override
        protected void analyzeBriefInfo(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "analyzeBriefInfo"));
            }
        }

        @Override
        protected void analyzeCurrentContent(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "analyzeCurrentContent"));
            }
        }

        @Override
        protected void retrieveMajorNames(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveMajorNames"));
            }
        }

        @Override
        protected void retrieveMainContent(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveMainContent"));
            }
            this.retrieveMain(tran);
        }

        void retrieveMain(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveMain"));
            }
            if (this.myMode.fragment) {
                this.retrieveFragment(tran);
            } else {
                this.retrieveEntireSchema(tran);
            }
        }

        private void retrieveEntireSchema(@NotNull DBTransaction tran) {
            boolean skipSystemSchema;
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveEntireSchema"));
            }
            boolean bl = skipSystemSchema = this.myMode.increment && SYSTEM_SCHEMAS.contains(((OraSchema)this.schema).getName()) && !OraIntrospector.this.myConsiderSystemSchemasReinstrospection && !((OraSchema)this.schema).isCurrent();
            if (skipSystemSchema) {
                return;
            }
            this.myBeginTimestamp = (Timestamp)tran.query(((OraIntrospector)OraIntrospector.this).myQueries.askForTimeNow).run();
            assert (this.myBeginTimestamp != null) : "Failed to obtain the current timestamp from the database";
            this.reportRetrieving("schema information");
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "lambda$retrieveEntireSchema$0"));
                }
                this.retrieveSchemaInfo(tran);
            });
            if (this.toStop) {
                return;
            }
            Date modifiedTimestamp = ((OraSchema)this.schema).getModifiedTimestamp();
            boolean bl2 = this.toStop = modifiedTimestamp != null && modifiedTimestamp.before(this.myFromTimestamp);
            if (this.toStop) {
                return;
            }
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "lambda$retrieveEntireSchema$1"));
                }
                this.retrieveSequences(tran);
                this.retrieveObjectTypes(tran);
                this.retrieveCollectionTypes(tran);
                this.retrieveObjectTypeAttributes(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "lambda$retrieveEntireSchema$2"));
                }
                this.retrieveTables(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "lambda$retrieveEntireSchema$3"));
                }
                this.retrieveViews(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "lambda$retrieveEntireSchema$4"));
                }
                this.retrieveColumns(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "lambda$retrieveEntireSchema$5"));
                }
                this.retrieveColumnDefaults(tran);
                this.retrieveColumnComments(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "lambda$retrieveEntireSchema$6"));
                }
                this.retrieveIndices(tran);
                this.retrieveIndicesColumns(tran);
                this.retrieveKeys(tran);
                this.retrieveForeignKeys(tran);
                this.retrieveChecks(tran);
                this.retrieveConstraintColumns(tran);
                this.reorderTableDetails();
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "lambda$retrieveEntireSchema$7"));
                }
                this.retrieveTriggers(tran);
                this.retrievePackages(tran);
                this.retrieveInnerRoutines(tran);
                this.retrieveInnerRoutinesArguments(tran);
                this.retrieveSingleRoutines(tran);
                this.retrieveSingleRoutinesArguments(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "lambda$retrieveEntireSchema$8"));
                }
                this.retrieveErrors(tran);
            });
            this.work(() -> {
                if (tran == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "lambda$retrieveEntireSchema$9"));
                }
                this.retrieveViewSources(tran);
                this.retrieveSources(tran);
            });
            this.reportRetrieving("finishing the schema...");
            long stateNumber = 0L;
            ((OraSchema)this.schema).setIntrospectionActualPoint(stateNumber, this.myBeginTimestamp);
        }

        private void retrieveFragment(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveFragment"));
            }
            this.retrieveFragmentNewObjectNames(tran);
            this.determineAndRemoveDroppedStuff(tran);
            if (this.myFragmentKind == ObjectKind.SEQUENCE) {
                this.retrieveSequences(tran);
            } else if (this.myFragmentKind != ObjectKind.CLUSTER) {
                if (this.myFragmentKind == ObjectKind.TABLE) {
                    this.retrieveTables(tran);
                    this.retrieveColumns(tran);
                    this.retrieveColumnDefaults(tran);
                    this.retrieveColumnComments(tran);
                    this.retrieveIndices(tran);
                    this.retrieveIndicesColumns(tran);
                    this.retrieveKeys(tran);
                    this.retrieveForeignKeys(tran);
                    this.retrieveChecks(tran);
                    this.retrieveConstraintColumns(tran);
                    this.retrieveTriggers(tran);
                    this.reorderTableDetails();
                    if (this.myWithSources) {
                        this.retrieveTriggerSources(tran);
                    }
                } else if (this.myFragmentKind != ObjectKind.MAT_VIEW) {
                    if (this.myFragmentKind == ObjectKind.VIEW) {
                        this.retrieveViews(tran);
                        this.retrieveColumns(tran);
                        this.retrieveColumnComments(tran);
                        this.retrieveTriggers(tran);
                        this.reorderTableDetails();
                        if (this.myWithSources) {
                            this.retrieveViewSources(tran);
                        }
                        if (this.myWithSources) {
                            this.retrieveTriggerSources(tran);
                        }
                    } else if (this.myFragmentKind == ObjectKind.ROUTINE) {
                        this.retrieveSingleRoutines(tran);
                        this.retrieveSingleRoutinesArguments(tran);
                        if (this.myWithSources) {
                            this.retrieveSources(tran);
                        }
                    } else if (this.myFragmentKind == ObjectKind.PACKAGE) {
                        this.retrievePackages(tran);
                        this.retrieveInnerRoutines(tran);
                        this.retrieveInnerRoutinesArguments(tran);
                        if (this.myWithSources) {
                            this.retrieveSources(tran);
                        }
                    } else if (this.myFragmentKind == ObjectKind.OBJECT_TYPE) {
                        this.retrieveObjectTypes(tran);
                        this.retrieveObjectTypeAttributes(tran);
                        this.retrieveInnerRoutines(tran);
                        this.retrieveInnerRoutinesArguments(tran);
                        if (this.myWithSources) {
                            this.retrieveSources(tran);
                        }
                    } else if (this.myFragmentKind == ObjectKind.COLLECTION_TYPE) {
                        this.retrieveCollectionTypes(tran);
                    } else if (this.myFragmentKind == ObjectKind.SYNONYM) {
                        // empty if block
                    }
                }
            }
        }

        private void retrieveFragmentNewObjectNames(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveFragmentNewObjectNames"));
            }
            ObjectKind fragmentKind = this.myFragmentKind;
            SqlQuery<String[]> listIdsQuery = fragmentKind == ObjectKind.OBJECT_TYPE || fragmentKind == ObjectKind.COLLECTION_TYPE ? ((OraIntrospector)OraIntrospector.this).myQueries.listFragmentTypeIds : ((OraIntrospector)OraIntrospector.this).myQueries.listFragmentRegularIds;
            String[] items = this.performQuery(tran, listIdsQuery);
            this.work(() -> OraIntrospector.processNames(items, ((OraModel)OraIntrospector.this.myModel).schemas(), true));
        }

        private void determineAndRemoveDroppedStuff(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "determineAndRemoveDroppedStuff"));
            }
            this.reportRetrieving("detect dropped objects");
            SqlQuery<long[]> query = OraIntrospector.this.myFast ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveAllObjectIdentifiersSlow;
            long[] idsArray = this.performQuery(tran, query);
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            ((OraSchema)this.schema).traversBreadthFirst(DbmObject.class, object -> {
                long id = object.getObjectId();
                if (id == 0L || identifiers.contains(id) || object instanceof DbmNamespace) {
                    return true;
                }
                object.drop();
                return false;
            });
        }

        @Override
        protected void work(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "work"));
            }
            OraIntrospector.this.myProgressIndicator.checkCanceled();
            super.work(runnable);
        }

        @Override
        protected void clearSchema() {
            ArrayList children = new ArrayList();
            ((OraSchema)this.schema).traverseChildren(DbmObject.class, object -> children.add(object));
            for (int i2 = children.size() - 1; i2 >= 0; --i2) {
                ((DbmObject)children.get(i2)).drop();
            }
            ((OraSchema)this.schema).setCreatedAndModifiedTimestamps(null, null);
            ((OraSchema)this.schema).setIntrospectionActualPoint(0L, null);
        }

        @Nullable
        private DbmLikeTable getTableOrViewById(long id) {
            DbmLikeTable table = (DbmLikeTable)((OraSchema)this.schema).getTables().getByObjectId(id);
            if (table == null) {
                table = (DbmLikeTable)((OraSchema)this.schema).getViews().getByObjectId(id);
            }
            if (table == null) {
                table = (DbmLikeTable)((OraSchema)this.schema).getMatViews().getByObjectId(id);
            }
            return table;
        }

        private void retrieveSchemaInfo(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveSchemaInfo"));
            }
            OraIntroQueries.OneSchemaInfo info = this.performQuery(tran, ((OraSchema)this.schema).isPublic() ? ((OraIntrospector)OraIntrospector.this).myQueries.retrievePublicSchemaInfo : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSchemaInfo);
            ((OraSchema)this.schema).setObjectId(info.user_id);
            ((OraSchema)this.schema).setCreatedAndModifiedTimestamps(info.created_timestamp, info.modified_timestamp);
            this.setQueryParameter("SCHEMA_ID", info.user_id);
        }

        private void retrieveSequences(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveSequences"));
            }
            if (((OraSchema)this.schema).getSequences().isEmpty()) {
                return;
            }
            this.reportRetrieving("Sequences");
            List<OraIntroQueries.OneSequence> seqs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSequences);
            if (seqs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneSequence seq : seqs) {
                OraSequence sequence = ((OraSchema)this.schema).getSequences().getOrCreate(seq.sequence_name);
                sequence.setMinValue(this.adjustBigIntegerForSequence(seq.min_value));
                sequence.setMaxValue(this.adjustBigIntegerForSequence(seq.max_value));
                sequence.setIncrementBy(seq.increment_by);
                sequence.setOrdered(seq.order_flag);
                sequence.setCycled(seq.cycle_flag);
                sequence.setCacheSize(seq.cache_size);
                sequence.setNextValue(this.adjustBigIntegerForSequence(seq.last_number));
                sequence.setObjectId(seq.object_id);
                sequence.setCreatedAndModifiedTimestamps(seq.created_timestamp, seq.modified_timestamp);
            }
            ((OraSchema)this.schema).getSequences().sort();
        }

        @Nullable
        private BigInteger adjustBigIntegerForSequence(@Nullable BigDecimal bigDecimalValue) {
            if (bigDecimalValue == null) {
                return null;
            }
            BigInteger bi = bigDecimalValue.toBigInteger();
            return bi.toString().equals("9999999999999999999999999999") ? null : bi;
        }

        private void retrieveObjectTypes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveObjectTypes"));
            }
            if (((OraSchema)this.schema).getObjectTypes().isEmpty()) {
                return;
            }
            this.reportRetrieving("Object Types");
            List<OraIntroQueries.OneObjectType> ots = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveObjectTypes);
            if (ots.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneObjectType ot : ots) {
                OraObjectType superObjectType = null;
                if (ot.supertype_schema_name != null && ot.supertype_name != null) {
                    OraSchema superSchema = (OraSchema)((OraModel)OraIntrospector.this.myModel).schemas().getOrCreate(ot.supertype_schema_name);
                    superObjectType = superSchema.myObjectTypes.getOrCreate(ot.supertype_name);
                }
                OraObjectType oType = (OraObjectType)((OraSchema)this.schema).myObjectTypes.renew(ot.object_id, ot.type_name);
                oType.superObject.setObject(superObjectType);
                oType.setCreatedAndModifiedTimestamps(ot.created_timestamp, ot.modified_timestamp);
                oType.setIncomplete(ot.is_incomplete);
                oType.setFinal(ot.is_final);
                oType.setInstantiable(ot.is_instantiable);
                if (ot.object_id != 0L) {
                    OraBody body = oType.getOrCreateBody();
                    body.setObjectId(ot.body_object_id);
                    body.setName(ot.type_name);
                    body.setCreatedAndModifiedTimestamps(ot.body_created_timestamp, ot.body_modified_timestamp);
                } else {
                    oType.getBodies().clear();
                }
                this.myAffectedDepObjects.add(oType);
                this.myAffectedModules.add(oType);
            }
            ((OraSchema)this.schema).myObjectTypes.sort();
            this.affectsModulesOrBodies = true;
        }

        private void retrieveCollectionTypes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveCollectionTypes"));
            }
            if (((OraSchema)this.schema).getCollectionTypes().isEmpty()) {
                return;
            }
            this.reportRetrieving("Collection Types");
            List<OraIntroQueries.OneCollectionType> cts = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveCollectionTypes);
            if (cts.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneCollectionType ct : cts) {
                OraCollectionType cType = (OraCollectionType)((OraSchema)this.schema).myCollectionTypes.renew(ct.object_id, ct.type_name);
                cType.setArray(ct.collection_kind == 'A');
                cType.setUpperBound(ct.upper_bound);
                DataType type = this.makeDataType(ct.data_type_schema_name, ct.data_type, ct.data_size, ct.data_scale, ct.data_size_units);
                cType.setElementType(type);
                cType.setCreatedAndModifiedTimestamps(ct.created_timestamp, ct.modified_timestamp);
            }
            ((OraSchema)this.schema).myCollectionTypes.sort();
        }

        private void retrieveObjectTypeAttributes(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveObjectTypeAttributes"));
            }
            if (((OraSchema)this.schema).getObjectTypes().isEmpty()) {
                return;
            }
            this.reportRetrieving("Object Type Attributes");
            List<OraIntroQueries.OneObjectTypeAttribute> attrs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveObjectTypeAttributes);
            for (OraIntroQueries.OneObjectTypeAttribute ota : attrs) {
                OraObjectType ot = ((OraSchema)this.schema).myObjectTypes.getOrCreate(ota.type_name);
                OraModuleAttribute attr = ot.getAttributes().getOrCreate(ota.attr_name);
                DataType type = this.makeDataType(ota.data_type_schema, ota.data_type, ota.data_size, ota.data_scale, ota.data_size_units);
                attr.setType(type);
            }
        }

        private void retrieveTables(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveTables"));
            }
            if (((OraSchema)this.schema).getTables().isEmpty()) {
                return;
            }
            this.reportRetrieving("Tables");
            List<OraIntroQueries.OneTable> tabs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveTables);
            if (tabs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneTable tab : tabs) {
                OraTable table = (OraTable)((OraSchema)this.schema).getTables().renew(tab.object_id, tab.table_name);
                table.setComment(tab.comments);
                table.setOrganization(TableOrganization.byCode(tab.organization_kind));
                table.setCreatedAndModifiedTimestamps(tab.created_timestamp, tab.modified_timestamp);
                if (tab.row_type_name != null) {
                    table.setRowObjectType(tab.row_type_schema_name, tab.row_type_name);
                } else if (this.myMode.increment) {
                    table.setRowObjectType(null);
                }
                ((Family)table.getChecks()).clear();
                ((Family)table.getForeignKeys()).clear();
                ((Family)table.getKeys()).clear();
                this.myAffectedDepObjects.add(table);
            }
            ((OraSchema)this.schema).getTables().sort();
            this.affectsTables = true;
        }

        private void retrieveViews(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveViews"));
            }
            if (((OraSchema)this.schema).getViews().isEmpty()) {
                return;
            }
            this.reportRetrieving("Views");
            List<OraIntroQueries.OneView> vs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveViews);
            if (vs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneView v : vs) {
                OraView view2 = ((OraSchema)this.schema).getViews().getOrCreate(v.view_name);
                view2.setComment(v.comments);
                view2.setModifiable(v.modifiable);
                view2.setObjectId(v.object_id);
                view2.setInvalid(v.is_invalid);
                view2.setCreatedAndModifiedTimestamps(v.created_timestamp, v.modified_timestamp);
                ((Family)view2.getChecks()).clear();
                ((Family)view2.getForeignKeys()).clear();
                ((Family)view2.getKeys()).clear();
                this.myAffectedDepObjects.add(view2);
            }
            this.affectsViews = true;
        }

        private void retrieveColumns(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveColumns"));
            }
            this.haveDefaults = false;
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Table and View Columns");
            HashSet<DbmLikeTable> affectedTables = new HashSet<DbmLikeTable>(((OraSchema)this.schema).getTables().size() + ((OraSchema)this.schema).getViews().size());
            DbmLikeTable table = null;
            long table_id = Long.MIN_VALUE;
            List<OraIntroQueries.OneColumn> cols = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveColumns);
            for (OraIntroQueries.OneColumn col : cols) {
                if (col.table_id != table_id) {
                    table = this.getTableOrViewById(col.table_id);
                    if (table == null) continue;
                    table_id = col.table_id;
                    ((Family)table.getColumns()).markChildrenAsSyncPending();
                    affectedTables.add(table);
                }
                assert (table != null);
                NamingFamily tableColumns = table.getColumns();
                DbmColumn column = (DbmColumn)((Family)tableColumns).getOrCreate(col.column_name);
                column.resetSyncPending();
                column.setPosition(col.column_position);
                DataType type = this.makeDataType(col.data_type_schema_name, col.data_type, col.data_size, col.data_scale, col.data_size_units);
                column.setDataType(type);
                column.setMandatory(col.mandatory);
                if (col.has_default_expression) {
                    this.haveDefaults = true;
                    continue;
                }
                column.setDefaultExpression(null);
            }
            if (this.myMode.increment || this.myMode.fragment) {
                for (DbmLikeTable affectedTable : affectedTables) {
                    ImmutableList columns = ((Family)affectedTable.getColumns()).asList();
                    for (int i2 = columns.size() - 1; i2 >= 0; --i2) {
                        DbmColumn column = (DbmColumn)columns.get(i2);
                        if (!column.isSyncPending()) continue;
                        column.drop();
                    }
                }
            }
            this.myTablesToReorderDetails.addAll(affectedTables);
        }

        private void retrieveColumnDefaults(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveColumnDefaults"));
            }
            if (!this.haveDefaults) {
                return;
            }
            this.reportRetrieving("Table and View Column Defaults");
            List<OraIntroQueries.OneColumnDefault> rows = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveColumnDefaults);
            for (OraIntroQueries.OneColumnDefault col : rows) {
                DbmColumn column;
                DbmLikeTable table = ((OraSchema)this.schema).getTableOrView(col.table_name);
                if (table == null || (column = (DbmColumn)((Family)table.getColumns()).get(col.column_name)) == null) continue;
                column.setDefaultExpression(col.default_expression);
            }
        }

        private void retrieveColumnComments(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveColumnComments"));
            }
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Table and View Column Comments");
            List<OraIntroQueries.OneColumnComment> rows = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveColumnComments);
            for (OraIntroQueries.OneColumnComment col : rows) {
                DbmColumn column;
                DbmLikeTable table = ((OraSchema)this.schema).getTableOrView(col.table_name);
                if (table == null || (column = (DbmColumn)((Family)table.getColumns()).get(col.column_name)) == null) continue;
                column.setComment(col.comments);
            }
        }

        private void retrieveIndices(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveIndices"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Indices");
            List<OraIntroQueries.OneIndex> indices = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveIndices);
            if (indices.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneIndex ind : indices) {
                OraTable table = ((OraSchema)this.schema).getTables().getOrCreate(ind.table_name);
                DbmIndex index = (DbmIndex)((Family)table.getIndices()).getOrCreate(ind.index_name);
                index.setNameSurrogate(OraIntrospectionUtils.matches(ind.index_name, OraIntrospectionUtils.surrogateNamePattern));
                index.setUnique(ind.uniqueness);
                index.setClustering(ind.clustering);
                index.setTablespaceName(ind.tablespace_name);
                index.setObjectId(ind.object_id);
                index.setCreatedAndModifiedTimestamps(ind.created_timestamp, ind.modified_timestamp);
                if (this.myMode.fragment) {
                    index.myColumns.clearState();
                }
                this.myTablesToReorderDetails.add(table);
            }
        }

        private void retrieveIndicesColumns(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveIndicesColumns"));
            }
            if (!this.affectsTables) {
                return;
            }
            List<OraIntroQueries.OneIndexColumn> ics = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveIndicesColumns);
            for (OraIntroQueries.OneIndexColumn ic : ics) {
                String columnName;
                OraTable table = ((OraSchema)this.schema).getTables().getOrCreate(ic.table_name);
                DbmIndex index = (DbmIndex)((Family)table.getIndices()).getOrCreate(ic.index_name);
                if (ic.column_position == 1) {
                    index.clearColumnsList();
                }
                String string = columnName = ic.column_expression == null ? ic.column_name : OraIntrospector.unquoteNameIfPossible(ic.column_expression);
                if (ic.column_name != null) {
                    DasIndex.Sorting sorting = ic.descendant ? DasIndex.Sorting.DESCENDING : DasIndex.Sorting.ASCENDING;
                    index.addColumn(columnName, sorting);
                }
                this.myTablesToReorderDetails.add(table);
            }
        }

        private void retrieveKeys(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveKeys"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Keys");
            List<OraIntroQueries.OneKey> keys = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveKeys);
            for (OraIntroQueries.OneKey k : keys) {
                if (k.table_name == null || k.constraint_name == null) continue;
                OraTable table = ((OraSchema)this.schema).getTables().getOrCreate(k.table_name);
                DbmKey key = (DbmKey)((Family)table.getKeys()).getOrCreate(k.constraint_name);
                key.myColumns.clearState();
                key.setNameSurrogate(k.is_surrogate_name);
                key.setPrimary(k.is_pk);
                key.setDeferrable(k.is_deferrable);
                key.setInitiallyDeferred(k.is_initially_deferred);
                key.setModifiedTimestamp(k.modified_timestamp);
                DbmIndex index = k.index_name != null ? (DbmIndex)((Family)table.getIndices()).getOrCreate(k.index_name) : null;
                key.setUnderlyingIndex(index);
            }
        }

        private void retrieveForeignKeys(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveForeignKeys"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Foreign Keys");
            List<OraIntroQueries.OneForeignKey> fks = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveForeignKeys);
            for (OraIntroQueries.OneForeignKey fk : fks) {
                OraTable table = ((OraSchema)this.schema).getTables().getOrCreate(fk.table_name);
                DbmForeignKey fkey = (DbmForeignKey)((Family)table.getForeignKeys()).getOrCreate(fk.constraint_name);
                fkey.myColumns.clearState();
                fkey.refKey.set(fk.ref_schema_name, fk.ref_key_name);
                fkey.setNameSurrogate(fk.is_surrogate_name);
                fkey.setDeferrable(fk.is_deferrable);
                fkey.setInitiallyDeferred(fk.is_initially_deferred);
                fkey.setCascadeDeleteRule(fk.cascade_delete ? CascadeRule.delete : CascadeRule.restrict);
                fkey.setModifiedTimestamp(fk.modified_timestamp);
            }
        }

        private void retrieveChecks(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveChecks"));
            }
            if (!this.affectsTables) {
                return;
            }
            this.reportRetrieving("Check Constraints");
            List<OraIntroQueries.OneCheck> cks = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveChecks);
            for (OraIntroQueries.OneCheck ck : cks) {
                if (ck.predicate == null || ck.is_surrogate_name && AUTO_NOT_NULL_CHECK_PATTERN.matcher(ck.predicate).matches()) continue;
                OraTable table = ((OraSchema)this.schema).getTables().getOrCreate(ck.table_name);
                DbmCheck check = (DbmCheck)((Family)table.getChecks()).getOrCreate(ck.constraint_name);
                check.myColumns.clearState();
                check.setNameSurrogate(ck.is_surrogate_name);
                check.setPredicate(ck.predicate);
                check.setModifiedTimestamp(ck.modified_timestamp);
                this.myAffectedDepObjects.add((DbmObject)((Object)check.getTable()));
            }
        }

        private void retrieveConstraintColumns(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveConstraintColumns"));
            }
            if (!this.affectsTables) {
                return;
            }
            List<OraIntroQueries.OneConstraintColumn> ccs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveConstraintColumns);
            if (ccs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneConstraintColumn cc : ccs) {
                DbmConstraint constraint;
                DbmLikeTable table = ((OraSchema)this.schema).getTableOrView(cc.table_name);
                if (table == null || (constraint = table.getConstraint(cc.constraint_name)) == null) continue;
                if (cc.column_name != null) {
                    constraint.myColumns.add(cc.column_name);
                }
                this.myTablesToReorderDetails.add(table);
            }
        }

        private void reorderTableDetails() {
            for (DbmLikeTable table : this.myTablesToReorderDetails) {
                ((Family)table.getColumns()).sort();
                ((Family)table.getIndices()).sort();
                ((Family)table.getKeys()).sort();
                ((Family)table.getForeignKeys()).sort();
                ((Family)table.getChecks()).sort();
            }
        }

        private void retrieveTriggers(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveTriggers"));
            }
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Triggers");
            List<OraIntroQueries.OneTrigger> trigs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveTriggers);
            if (trigs.isEmpty()) {
                return;
            }
            HashSet<DbmLikeTable> tables = new HashSet<DbmLikeTable>(trigs.size());
            boolean also_retrieve_update_columns = false;
            for (OraIntroQueries.OneTrigger oneTrigger : trigs) {
                DbmLikeTable table = ((OraSchema)this.schema).getTableOrView(oneTrigger.table_name);
                if (table == null) continue;
                DbmTrigger trigger2 = (DbmTrigger)table.getTriggers().renew(oneTrigger.trigger_id, oneTrigger.trigger_name);
                trigger2.trigColumns.clearState();
                trigger2.trigEvents.set(oneTrigger.events);
                trigger2.setTrigTurn(this.trigTurnOf(oneTrigger.turn));
                also_retrieve_update_columns |= oneTrigger.has_on_update_columns;
                trigger2.setCreatedAndModifiedTimestamps(oneTrigger.created_timestamp, oneTrigger.modified_timestamp);
                tables.add(table);
            }
            if (also_retrieve_update_columns) {
                List<String[]> cols = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveTriggerUpdateColumns);
                for (String[] col : cols) {
                    DbmTrigger trigger3;
                    DbmLikeTable table;
                    String tableName = col[0];
                    String triggerName = col[1];
                    String columnName = col[2];
                    if (tableName == null || triggerName == null || columnName == null || (table = ((OraSchema)this.schema).getTableOrView(tableName)) == null || (trigger3 = (DbmTrigger)table.getTriggers().get(triggerName)) == null) continue;
                    trigger3.trigColumns.add(columnName);
                }
            }
            for (DbmLikeTable dbmLikeTable : tables) {
                dbmLikeTable.getTriggers().sort();
            }
            this.myAffectedDepObjects.addAll(tables);
            this.affectsTriggers = true;
        }

        @Nullable
        private TrigTurn trigTurnOf(short turn) {
            switch (turn) {
                case -2: {
                    return TrigTurn.BEFORE_STMT;
                }
                case -1: {
                    return TrigTurn.BEFORE_ROW;
                }
                case 1: {
                    return TrigTurn.AFTER_ROW;
                }
                case 2: {
                    return TrigTurn.AFTER_STMT;
                }
                case 0: {
                    return TrigTurn.INSTEAD_OF;
                }
            }
            return null;
        }

        private void retrievePackages(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrievePackages"));
            }
            if (((OraSchema)this.schema).getPackages().isEmpty()) {
                return;
            }
            this.reportRetrieving("Packages");
            List<OraIntroQueries.OnePackage> packs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrievePackages);
            if (packs.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OnePackage p : packs) {
                OraBody body;
                if (!p.is_body) {
                    OraPackage pack = (OraPackage)((OraSchema)this.schema).getPackages().renew(p.object_id, p.package_name);
                    pack.setObjectId(p.object_id);
                    pack.setInvalid(p.is_invalid);
                    pack.setCreatedAndModifiedTimestamps(p.created_timestamp, p.modified_timestamp);
                    this.myAffectedModules.add(pack);
                    this.myAffectedDepObjects.add(pack);
                    continue;
                }
                DbmObject objectWithThisId = ((OraModel)OraIntrospector.this.myModel).getObjectById(p.object_id);
                if (objectWithThisId != null && objectWithThisId instanceof OraBody) {
                    body = (OraBody)objectWithThisId;
                    body.setName(p.package_name);
                } else {
                    OraPackage pack = ((OraSchema)this.schema).getPackages().getOrCreate(p.package_name);
                    body = pack.getOrCreateBody();
                    body.setObjectId(p.object_id);
                    body.setName(p.package_name);
                }
                body.setInvalid(p.is_invalid);
                body.setCreatedAndModifiedTimestamps(p.created_timestamp, p.modified_timestamp);
                this.myAffectedDepObjects.add(body);
            }
            ((OraSchema)this.schema).getPackages().sort();
            this.affectsModulesOrBodies = true;
        }

        private void retrieveInnerRoutines(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveInnerRoutines"));
            }
            if (this.myAffectedModules.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions");
            for (OraModule oraModule : this.myAffectedModules) {
                oraModule.getRoutines().markChildrenAsSyncPending();
            }
            List<OraIntroQueries.OneInnerRoutine> routines = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveInnerRoutines);
            for (OraIntroQueries.OneInnerRoutine r : routines) {
                OraModule module = null;
                if (r.module_kind == 'T' || r.module_kind == 'Z') {
                    module = (OraModule)((OraSchema)this.schema).getObjectTypes().get(r.module_name);
                }
                if (module == null && (r.module_kind == 'P' || r.module_kind == 'Z')) {
                    module = (OraModule)((OraSchema)this.schema).getPackages().get(r.module_name);
                }
                if (module == null) continue;
                DbmInnerRoutine routine2 = module.getRoutines().getOrCreate(r.routine_name);
                if (routine2.getRoutineKind() == DasRoutine.Kind.NONE) {
                    routine2.setRoutineKind(DasRoutine.Kind.PROCEDURE);
                }
                routine2.setDeterministic(r.is_deterministic);
            }
            boolean bl = OraIntrospector.this.myServerVersion.get(0) < 11;
            for (OraModule module : this.myAffectedModules) {
                Family<? extends DbmInnerRoutine> moduleRoutines = module.getRoutines();
                moduleRoutines.removeSyncPendingChildren();
                if (!bl) continue;
                moduleRoutines.sort();
            }
        }

        private void retrieveInnerRoutinesArguments(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveInnerRoutinesArguments"));
            }
            if (this.myAffectedModules.isEmpty()) {
                return;
            }
            this.reportRetrieving("Inner procedures and functions (arguments and result types)");
            List<OraIntroQueries.OneInnerRoutineArgument> args = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveInnerRoutineArguments);
            for (OraIntroQueries.OneInnerRoutineArgument a : args) {
                DbmInnerRoutine routine2;
                OraModule m;
                if (a.package_name == null || a.routine_name == null || (m = ((OraSchema)this.schema).findModule(a.package_name)) == null || (routine2 = (DbmInnerRoutine)m.getRoutines().get(a.routine_name)) == null) continue;
                this.makeArgument(routine2, a.arg_name, a.arg_direction, a.data_type_schema_name, a.data_type);
            }
        }

        private void retrieveSingleRoutines(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveSingleRoutines"));
            }
            if (((OraSchema)this.schema).getRoutines().isEmpty()) {
                return;
            }
            this.reportRetrieving("Procedures and functions");
            List<OraIntroQueries.OneSingleRoutine> routines = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSingleRoutines);
            if (routines.isEmpty()) {
                return;
            }
            for (OraIntroQueries.OneSingleRoutine r : routines) {
                DbmSingleRoutine routine2 = (DbmSingleRoutine)((OraSchema)this.schema).getRoutines().renew(r.object_id, r.name);
                routine2.setRoutineKind(DasRoutine.Kind.byChar((char)r.kind));
                routine2.setInvalid(r.is_invalid);
                routine2.setDeterministic(r.is_deterministic);
                routine2.setCreatedAndModifiedTimestamps(r.created_timestamp, r.modified_timestamp);
                this.myAffectedDepObjects.add(routine2);
            }
            ((OraSchema)this.schema).getRoutines().sort();
            this.affectsSingleRoutines = true;
        }

        private void retrieveSingleRoutinesArguments(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveSingleRoutinesArguments"));
            }
            if (!this.affectsSingleRoutines) {
                return;
            }
            this.reportRetrieving("Procedures and functions (arguments and result types)");
            List<OraIntroQueries.OneSingleRoutineArgument> args = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSingleRoutineArguments);
            for (OraIntroQueries.OneSingleRoutineArgument a : args) {
                DbmSingleRoutine routine2;
                if (a.routine_name == null || (routine2 = (DbmSingleRoutine)((OraSchema)this.schema).getRoutines().get(a.routine_name)) == null) continue;
                this.makeArgument(routine2, a.arg_name, a.arg_direction, a.data_type_schema_name, a.data_type);
            }
        }

        private void retrieveViewSources(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveViewSources"));
            }
            if (!this.myWithSources) {
                return;
            }
            if (!this.affectsViews) {
                return;
            }
            this.reportRetrieving("View Sources");
            List<OraIntroQueries.OneViewSource> views = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveViewSources);
            for (OraIntroQueries.OneViewSource v : views) {
                DbmView view2 = ((OraSchema)this.schema).getViews().getOrCreate(v.view_name);
                view2.setSourceText(v.text);
            }
        }

        private void retrieveTriggerSources(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveTriggerSources"));
            }
            if (!this.myWithSources) {
                return;
            }
            if (!this.affectsTables && !this.affectsViews) {
                return;
            }
            this.reportRetrieving("Trigger Sources");
            List<OraIntroQueries.OneTriggerSource> trigs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveTriggerSources);
            for (OraIntroQueries.OneTriggerSource trig : trigs) {
                DbmTrigger trigger2;
                DbmLikeTable table = ((OraSchema)this.schema).getTableOrView(trig.table_name);
                if (table == null || (trigger2 = (DbmTrigger)table.getTriggers().get(trig.trigger_name)) == null) continue;
                trigger2.setSourceText(trig.trigger_body);
            }
        }

        private void retrieveSources(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveSources"));
            }
            if (!this.myWithSources) {
                return;
            }
            if (!(this.affectsModulesOrBodies || this.affectsSingleRoutines || this.affectsTriggers)) {
                return;
            }
            this.reportRetrieving("Procedures and Functions Sources");
            List<OraIntroQueries.OneSrcLine> lines = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveSources);
            String theType = "";
            String theName = "";
            StringBuilder buf = new StringBuilder();
            for (OraIntroQueries.OneSrcLine line : lines) {
                boolean theSame;
                boolean bl = theSame = theType.equals(line.type) && theName.equals(line.name);
                if (!theSame) {
                    OraIntrospector.applySources((OraSchema)this.schema, theType, theName, buf.toString());
                    theType = line.type;
                    theName = line.name;
                    buf.delete(0, buf.length());
                }
                buf.append(line.text);
            }
            OraIntrospector.applySources((OraSchema)this.schema, theType, theName, buf.toString());
        }

        private void retrieveErrors(@NotNull DBTransaction tran) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "retrieveErrors"));
            }
            this.reportRetrieving("Statuses and Errors");
            SqlQuery<long[]> invalidObjectsQuery = OraIntrospector.this.myFast ? ((OraIntrospector)OraIntrospector.this).myQueries.listInvalidObjectsFast : ((OraIntrospector)OraIntrospector.this).myQueries.listInvalidObjectsSlow;
            long[] invalidObjectsAr = this.performQuery(tran, invalidObjectsQuery);
            TLongHashSet invalids = new TLongHashSet(invalidObjectsAr);
            this.updateInvalidStatus(((OraSchema)this.schema).getObjectTypes(), invalids);
            this.updateInvalidStatus(((OraSchema)this.schema).getPackages(), invalids);
            this.updateInvalidStatus(((OraSchema)this.schema).getRoutines(), invalids);
            this.updateInvalidStatus(((OraSchema)this.schema).getTables(), invalids);
            this.updateInvalidStatus(((OraSchema)this.schema).getViews(), invalids);
            this.updateInvalidStatus(((OraSchema)this.schema).getSynonyms(), invalids);
            if (invalids.isEmpty()) {
                return;
            }
            List<OraIntroQueries.OneError> errs = this.performQuery(tran, ((OraIntrospector)OraIntrospector.this).myQueries.retrieveErrors);
            if (errs.isEmpty()) {
                return;
            }
            MultiMap map = new MultiMap();
            for (OraIntroQueries.OneError err : errs) {
                DbmSourceAware src = null;
                switch (err.type_code) {
                    case 'R': {
                        src = (DbmSourceAware)((Object)((OraSchema)this.schema).getRoutines().get(err.name));
                        break;
                    }
                    case 'V': {
                        src = (DbmSourceAware)((Object)((OraSchema)this.schema).getViews().get(err.name));
                        break;
                    }
                    case 'T': {
                        OraModule m = (OraModule)((OraSchema)this.schema).getObjectTypes().get(err.name);
                        if (m == null) break;
                        src = err.is_body ? (DbmSourceAware)m.getBodies().firstIfExists() : m;
                        break;
                    }
                    case 'P': {
                        OraModule p = (OraModule)((OraSchema)this.schema).getPackages().get(err.name);
                        if (p == null) break;
                        src = err.is_body ? (DbmSourceAware)p.getBodies().firstIfExists() : p;
                        break;
                    }
                    case 'G': {
                        src = OraIntrospector.findTrigger((OraSchema)this.schema, err.name);
                    }
                }
                if (src == null) continue;
                SourceError error = SourceError.of(err.line, err.position, err.message);
                map.putValue((Object)src, (Object)error);
            }
            for (Map.Entry entry : map.entrySet()) {
                ((DbmSourceAware)entry.getKey()).setErrors((List<SourceError>)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
            }
        }

        private void updateInvalidStatus(@NotNull Family<? extends DbmObject> family, @NotNull TLongHashSet invalids) {
            if (family == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "updateInvalidStatus"));
            }
            if (invalids == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invalids", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "updateInvalidStatus"));
            }
            for (DbmObject dbmObject : family) {
                if (dbmObject instanceof DbmSourceAware) {
                    DbmSourceAware saO = (DbmSourceAware)((Object)dbmObject);
                    boolean invalid = invalids.contains(dbmObject.getObjectId());
                    saO.setInvalid(invalid);
                    if (!invalid) {
                        saO.setErrors(DbmSourceAware.NO_ERRORS);
                    }
                }
                if (dbmObject instanceof DbmLikeTable) {
                    this.updateInvalidStatus(((DbmLikeTable)dbmObject).getTriggers(), invalids);
                }
                if (!(dbmObject instanceof OraModule)) continue;
                this.updateInvalidStatus(((OraModule)dbmObject).getBodies(), invalids);
            }
        }

        private void reportRetrieving(@NotNull String what) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "reportRetrieving"));
            }
            String modeStr = this.myMode.increment ? "incrementally" : "completely";
            OraIntrospector.this.updateStatus(String.format("Introspecting schema %s (%s)", ((OraSchema)this.schema).getName(), modeStr), what);
        }

        private void makeArgument(@NotNull DbmRoutine routine2, String argName, char argDirection, String dataTypeSchemaName, String dataTypeSpec) {
            DbmArgument argument;
            if (routine2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/dbm/oracle/OraIntrospector$OraSchemaRetriever", "makeArgument"));
            }
            DasArgument.Direction dir = DasArgument.Direction.of((char)argDirection);
            if (dir == null && argName != null) {
                dir = DasArgument.Direction.IN;
            }
            if (dir == null) {
                dir = DasArgument.Direction.IN;
            }
            if (dir == DasArgument.Direction.RETURN) {
                argument = routine2.getOrCreateReturnArgument();
                argument.setName(argName);
            } else if (argName != null) {
                argument = (DbmArgument)((Family)routine2.getArguments()).getOrCreate(argName);
                argument.setDirection(dir);
            } else {
                return;
            }
            DataType type = this.makeDataType(dataTypeSchemaName, dataTypeSpec, -1, 0, null);
            argument.setDataType(type);
        }

        private DataType makeDataType(@Nullable String typeSchemaName, @Nullable String typeName, int precision, int scale, @Nullable String units) {
            DataType type;
            if (typeName == null) {
                type = DataType.UNKNOWN;
            } else if (typeName.contains("(")) {
                type = DataTypeFactory.of(typeName);
            } else {
                boolean customType;
                boolean explicitUnits = (typeName.equalsIgnoreCase("varchar") || typeName.equalsIgnoreCase("char")) && units != null && units.equalsIgnoreCase("C");
                boolean bl = customType = typeSchemaName != null;
                String explicitSchemaName = customType ? (((OraSchema)this.schema).isName(typeSchemaName) ? null : typeSchemaName) : null;
                type = customType ? DataTypeFactory.of(explicitSchemaName, typeName, -1, 0, null, null, false, true) : DataTypeFactory.of(null, typeName, precision, scale, LengthUnit.of((String)units), null, explicitUnits, false);
            }
            return type;
        }
    }

    private final class OraDatabaseIncRetriever
    extends BaseIntrospector.DatabaseRetriever {
        @NotNull
        private Date mySince;
        @NotNull
        private List<OraSchema> mySchemas;

        OraDatabaseIncRetriever(@NotNull DBTransaction transaction, @NotNull OraModel model, List<OraSchema> schemas, boolean glutton) {
            if (transaction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/dbm/oracle/OraIntrospector$OraDatabaseIncRetriever", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/oracle/OraIntrospector$OraDatabaseIncRetriever", "<init>"));
            }
            if (schemas == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/dbm/oracle/OraIntrospector$OraDatabaseIncRetriever", "<init>"));
            }
            super((BaseIntrospector)OraIntrospector.this, transaction, (DbmModel)model);
            this.mySince = AGES_AGO;
            this.mySchemas = schemas;
            this.setQueryParameter(glutton ? "GLUTTON" : "ASCETIC", Boolean.TRUE);
            this.setQueryParameter("ALL_SCHEMA_IDS", schemas.stream().map(DbmObject::getObjectId).toArray());
            this.setQueryParameter("ALL_SCHEMA_NAMES", schemas.stream().map(DbmObject::getName).toArray());
        }

        @Override
        protected void process() {
            this.withModel(this::determineAndRemoveAllDroppedStuff);
            long sinceTime = System.currentTimeMillis();
            for (OraSchema schema : this.mySchemas) {
                Date schemaIntrospectionTimestamp = schema.getIntrospectionTimestamp();
                if (schemaIntrospectionTimestamp == null) continue;
                sinceTime = Math.min(sinceTime, schemaIntrospectionTimestamp.getTime());
            }
            this.mySince = new Timestamp(sinceTime);
            this.setQueryParameter("INC", Boolean.TRUE);
            this.setQueryParameter("SINCE", this.mySince);
            this.withModel(this::retrieveAllOrdinaryNames);
            this.withModel(this::retrieveAllSynonyms);
        }

        private void determineAndRemoveAllDroppedStuff(OraModel model) {
            this.reportRetrieving("detect dropped objects");
            SqlQuery<long[]> query = OraIntrospector.this.myFast ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveAllObjectIdentifiersFast : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveAllObjectIdentifiersSlow;
            long[] idsArray = this.performQuery(query);
            TLongHashSet identifiers = new TLongHashSet(idsArray);
            for (OraSchema schema : this.mySchemas) {
                schema.traversBreadthFirst(DbmObject.class, object -> {
                    long id = object.getObjectId();
                    if (id == 0L || identifiers.contains(id) || object instanceof DbmNamespace) {
                        return true;
                    }
                    object.drop();
                    return false;
                });
            }
        }

        private void retrieveAllOrdinaryNames(OraModel model) {
            this.reportRetrieving("Major Object Names");
            Family modelSchemas = model.schemas();
            SqlQuery<String[]> query = OraIntrospector.this.myFast ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveAllMajorNamesSlow;
            String[] items = this.performQuery(query);
            OraIntrospector.processNames(items, modelSchemas, true);
        }

        private void retrieveAllSynonyms(OraModel model) {
            this.reportRetrieving("Synonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(((OraIntrospector)OraIntrospector.this).myQueries.retrieveAllSynonyms);
            OraIntrospector.processSynonyms(ss, model);
        }
    }

    private final class OraDatabaseFirstRetriever
    extends BaseIntrospector.DatabaseRetriever {
        @NotNull
        private List<OraSchema> mySchemas;

        OraDatabaseFirstRetriever(@NotNull DBTransaction transaction, @NotNull OraModel model, List<OraSchema> schemas, boolean glutton) {
            if (transaction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/dbm/oracle/OraIntrospector$OraDatabaseFirstRetriever", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/oracle/OraIntrospector$OraDatabaseFirstRetriever", "<init>"));
            }
            if (schemas == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/dbm/oracle/OraIntrospector$OraDatabaseFirstRetriever", "<init>"));
            }
            super((BaseIntrospector)OraIntrospector.this, transaction, (DbmModel)model);
            this.mySchemas = schemas;
            this.setQueryParameter(glutton ? "GLUTTON" : "ASCETIC", Boolean.TRUE);
            this.setQueryParameter("ALL_SCHEMA_IDS", schemas.stream().map(DbmObject::getObjectId).toArray());
            this.setQueryParameter("ALL_SCHEMA_NAMES", schemas.stream().map(DbmObject::getName).toArray());
        }

        @Override
        protected void process() {
            this.withModel(this::retrieveAllOrdinaryNames);
            this.withModel(this::retrieveAllSynonyms);
        }

        private void retrieveAllOrdinaryNames(OraModel model) {
            this.reportRetrieving("Major Object Names");
            Family modelSchemas = model.schemas();
            SqlQuery<String[]> query = OraIntrospector.this.myFast ? ((OraIntrospector)OraIntrospector.this).myQueries.retrieveAllMajorNamesFast : ((OraIntrospector)OraIntrospector.this).myQueries.retrieveAllMajorNamesSlow;
            String[] items = this.performQuery(query);
            for (OraSchema schema : this.mySchemas) {
                schema.getSequences().clear();
                schema.getObjectTypes().clear();
                schema.getCollectionTypes().clear();
                schema.getTables().clear();
                schema.getMatViews().clear();
                schema.getViews().clear();
                schema.getPackages().clear();
                schema.getRoutines().clear();
            }
            OraIntrospector.processNames(items, modelSchemas, false);
        }

        private void retrieveAllSynonyms(OraModel model) {
            this.reportRetrieving("Synonyms");
            List<OraIntroQueries.OneSynonym> ss = this.performQuery(((OraIntrospector)OraIntrospector.this).myQueries.retrieveAllSynonyms);
            OraIntrospector.processSynonyms(ss, model);
        }
    }
}

