/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.oracle;

import com.intellij.database.model.DataType;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSequence;
import com.intellij.dbm.common.DbmTable;
import com.intellij.dbm.oracle.DBAbstractScriptingService;
import com.intellij.dbm.oracle.OraBody;
import com.intellij.dbm.oracle.OraObjectType;
import com.intellij.dbm.oracle.OraSchema;
import com.intellij.dbm.oracle.OraSequence;
import com.intellij.openapi.util.Couple;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.sql.SqlScript;
import org.jetbrains.dekaf.sql.SqlScriptBuilder;

public class OraScriptingService
extends DBAbstractScriptingService {
    private static final Pattern NormalCatalogNamePattern = Pattern.compile("");

    @Override
    protected String convertNameFromCatalogToScript(String name) {
        int i2;
        if (name == null) {
            return null;
        }
        int n = name.length();
        for (i2 = 0; i2 < n; ++i2) {
            char c = name.charAt(i2);
            if (Character.isLetter(c)) {
                if (!Character.isLowerCase(c)) continue;
                break;
            }
            if (!Character.isDigit(c) ? c != '#' && c != '$' && c != '_' : i2 == 0) break;
        }
        return i2 == n ? this.humanizeName(name) : '\"' + name + '\"';
    }

    @Override
    @NotNull
    protected SqlScript makeSequenceScript(@NotNull DbmSequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/dbm/oracle/OraScriptingService", "makeSequenceScript"));
        }
        OraSequence seq = (OraSequence)sequence;
        StringBuilder b = new StringBuilder();
        b.append("create sequence ").append(this.nameOf(seq));
        if (seq.getMinValue() != null) {
            b.append("\n\tminvalue ").append(seq.getMinValue());
        }
        if (seq.getMaxValue() != null) {
            b.append("\n\tmaxvalue ").append(seq.getMaxValue());
        }
        if (seq.getIncrementBy() != null) {
            b.append("\n\tincrement by ").append(seq.getIncrementBy());
        }
        if (seq.getNextValue() != null) {
            b.append("\n\tstart with ").append(seq.getNextValue().add(BigInteger.ONE));
        }
        if (seq.isCycled()) {
            b.append("\n\tcycle");
        }
        if (seq.isOrdered()) {
            b.append("\n\torder");
        }
        if (seq.getCacheSize() != 0) {
            b.append("\n\t");
            if (seq.getCacheSize() < 0) {
                b.append("nocache");
            } else {
                b.append("cache ").append(seq.getCacheSize());
            }
        }
        SqlScript sqlScript = new SqlScript(new String[]{b.toString()});
        if (sqlScript == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraScriptingService", "makeSequenceScript"));
        }
        return sqlScript;
    }

    @Override
    @NotNull
    protected SqlScript makeTypesCompletely(@NotNull DbmSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/oracle/OraScriptingService", "makeTypesCompletely"));
        }
        OraSchema oraSchema = (OraSchema)schema;
        SqlScriptBuilder script = new SqlScriptBuilder();
        for (OraObjectType objectType : oraSchema.myObjectTypes) {
            OraBody body;
            if (objectType.getSourceText() != null) {
                script.parse(objectType.getSourceText());
            }
            if ((body = objectType.getBody()) == null || body.getSourceText() == null) continue;
            script.parse(body.getSourceText());
        }
        SqlScript sqlScript = script.build();
        if (sqlScript == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraScriptingService", "makeTypesCompletely"));
        }
        return sqlScript;
    }

    @Override
    public Couple<String> makeTableHeaderFooter(@NotNull DbmTable table) {
        String footer;
        String header;
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/oracle/OraScriptingService", "makeTableHeaderFooter"));
        }
        String name = table.getNameOrNull();
        assert (name != null);
        if (!table.isTemporary()) {
            header = "create table " + name;
            footer = "";
        } else {
            header = "create global temporary table " + name;
            footer = "on commit preserve rows";
        }
        return new Couple((Object)header, (Object)footer);
    }

    @Override
    public void makeTypeDefinition(@NotNull DataType type, @NotNull StringBuilder b) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/dbm/oracle/OraScriptingService", "makeTypeDefinition"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/dbm/oracle/OraScriptingService", "makeTypeDefinition"));
        }
        b.append(type.getSpecification());
    }

    @Override
    protected void makeInnerIndexDefinition(@NotNull DbmIndex index, @NotNull StringBuilder b) {
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/dbm/oracle/OraScriptingService", "makeInnerIndexDefinition"));
        }
        if (b == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/dbm/oracle/OraScriptingService", "makeInnerIndexDefinition"));
        }
        if (index.isUnique()) {
            b.append("unique (").append(this.namesOf(index.myColumns)).append(")");
        }
    }

    @Override
    @NotNull
    protected SqlScript makeTableScriptCompleteDrop(@NotNull DbmTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/oracle/OraScriptingService", "makeTableScriptCompleteDrop"));
        }
        String name = table.getNameOrNull();
        assert (name != null);
        String cmdText = "drop table " + name + " cascade constraints";
        SqlScript sqlScript = new SqlScript(new String[]{cmdText});
        if (sqlScript == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/oracle/OraScriptingService", "makeTableScriptCompleteDrop"));
        }
        return sqlScript;
    }
}

