/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.postgres;

import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmComplex;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.StateProperty;
import com.intellij.dbm.common.StringItems;
import com.intellij.dbm.postgres.PostgresDataTypeAttribute;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresDataType
extends DbmComplex
implements DasUserDefinedType {
    protected final Family<? extends PostgresDataTypeAttribute> myAttributes;
    @StateProperty
    public SubKind mySubKind;
    @StateProperty
    public SubCategory mySubCategory;
    @StateProperty
    public String myDefinition;
    @StateProperty
    public final StringItems labels;

    @NotNull
    public Family<? extends PostgresDataTypeAttribute> getAttributes() {
        Family<? extends PostgresDataTypeAttribute> family = this.myAttributes;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresDataType", "getAttributes"));
        }
        return family;
    }

    public PostgresDataType(@NotNull DbmSchema schema, @Nullable String name) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/postgres/PostgresDataType", "<init>"));
        }
        super(schema, name);
        this.labels = new StringItems(this);
        this.myAttributes = Family.of(this, ObjectKind.OBJECT_ATTRIBUTE);
        this.assignFamilies(this.myAttributes);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.OBJECT_TYPE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresDataType", "getKind"));
        }
        return objectKind;
    }

    public SubKind getSubKind() {
        return this.mySubKind;
    }

    public void setSubKind(SubKind subKind) {
        this.mySubKind = subKind;
    }

    public SubCategory getSubCategory() {
        return this.mySubCategory;
    }

    public void setSubCategory(SubCategory subCategory) {
        this.mySubCategory = subCategory;
    }

    public String getDefinition() {
        return this.myDefinition;
    }

    public void setDefinition(String definition) {
        this.myDefinition = definition;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        String labelsString;
        StringBuilder b = new StringBuilder(60);
        b.append(this.mySubKind.human_readable_name());
        if (this.mySubCategory != SubCategory.NONE && !this.mySubCategory.human_readable_name().equalsIgnoreCase(this.mySubKind.human_readable_name())) {
            b.append(' ').append('(').append(this.mySubCategory.human_readable_name()).append(')');
        }
        if (this.myDefinition != null) {
            b.append(" of ").append(this.myDefinition);
        }
        if ((labelsString = this.labels.exportState()) != null) {
            b.append(" of {").append(labelsString).append("}");
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresDataType", "description"));
        }
        return string;
    }

    public static enum SubCategory {
        NONE('\u0000'),
        ARRAY('A'),
        BOOLEAN('B'),
        COMPOSITE('C'),
        DATE_TIME('D'),
        ENUM('E'),
        GEOMETRIC('G'),
        NETWORK('I'),
        NUMERIC('N'),
        PSEUDO('P'),
        STRING('S'),
        TIME_SPAN('T'),
        USER_DEFINED('U'),
        BIT_STRING('V'),
        UNKNOWN('X');

        public final char code;

        private SubCategory(char code) {
            this.code = code;
        }

        public static SubCategory of(char c) {
            switch (Character.toUpperCase(c)) {
                case '\u0000': {
                    return NONE;
                }
                case 'A': {
                    return ARRAY;
                }
                case 'B': {
                    return BOOLEAN;
                }
                case 'C': {
                    return COMPOSITE;
                }
                case 'D': {
                    return DATE_TIME;
                }
                case 'E': {
                    return ENUM;
                }
                case 'G': {
                    return GEOMETRIC;
                }
                case 'I': {
                    return NETWORK;
                }
                case 'N': {
                    return NUMERIC;
                }
                case 'P': {
                    return PSEUDO;
                }
                case 'S': {
                    return STRING;
                }
                case 'T': {
                    return TIME_SPAN;
                }
                case 'U': {
                    return USER_DEFINED;
                }
                case 'V': {
                    return BIT_STRING;
                }
            }
            return UNKNOWN;
        }

        public String human_readable_name() {
            return this.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        }
    }

    public static enum SubKind {
        NONE('\u0000'),
        BASE_TYPE('b'),
        COMPOSITE('c'),
        DOMAIN('d'),
        ENUM('e'),
        PSEUDO('p'),
        UNKNOWN('x');

        public final char code;

        private SubKind(char code) {
            this.code = code;
        }

        public static SubKind of(char c) {
            switch (Character.toLowerCase(c)) {
                case 'b': {
                    return BASE_TYPE;
                }
                case 'c': {
                    return COMPOSITE;
                }
                case 'd': {
                    return DOMAIN;
                }
                case 'e': {
                    return ENUM;
                }
                case 'p': {
                    return PSEUDO;
                }
                case '\u0000': {
                    return NONE;
                }
            }
            return UNKNOWN;
        }

        public String human_readable_name() {
            return this.name().toLowerCase(Locale.ROOT).replace('_', ' ');
        }
    }
}

