/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.postgres;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RelativeReference;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.Resolver;
import com.intellij.dbm.postgres.PostgresDataType;
import com.intellij.dbm.postgres.PostgresDatabase;
import com.intellij.dbm.postgres.PostgresOperator;
import com.intellij.dbm.postgres.PostgresRoutine;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostgresSchema
extends DbmSchema {
    protected final Family<PostgresDataType> myDataTypes;
    public final RoutineResolver routineResolver;

    public PostgresSchema(@NotNull PostgresDatabase database, @Nullable String name) {
        if (database == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "database", "com/intellij/dbm/postgres/PostgresSchema", "<init>"));
        }
        super(database, name);
        this.routineResolver = new RoutineResolver();
        this.myDataTypes = Family.of(this, ObjectKind.OBJECT_TYPE);
        this.assignFamilies(this.mySequences, this.myDataTypes, this.myTables, this.myMatViews, this.myViews, this.myRoutines, this.myOperators, this.mySynonyms);
    }

    @NotNull
    public Family<PostgresDataType> getDataTypes() {
        Family<PostgresDataType> family = this.myDataTypes;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresSchema", "getDataTypes"));
        }
        return family;
    }

    @NotNull
    public Family<PostgresRoutine> getRoutines() {
        Family family = this.myRoutines;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresSchema", "getRoutines"));
        }
        return family;
    }

    @NotNull
    public Family<PostgresOperator> getOperators() {
        Family family = this.myOperators;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresSchema", "getOperators"));
        }
        return family;
    }

    @NotNull
    public PostgresDatabase getDatabase() {
        assert (this.myDatabase != null);
        PostgresDatabase postgresDatabase = (PostgresDatabase)this.myDatabase;
        if (postgresDatabase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/postgres/PostgresSchema", "getDatabase"));
        }
        return postgresDatabase;
    }

    public final class RoutineResolver
    implements Resolver<PostgresRoutine> {
        @Override
        @Nullable
        public PostgresRoutine resolve(@NotNull RelativeReference p) {
            if (p == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/dbm/postgres/PostgresSchema$RoutineResolver", "resolve"));
            }
            return this.resolve2(p.path, p.args);
        }

        @Override
        @Nullable
        public PostgresRoutine resolve(String ... path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/postgres/PostgresSchema$RoutineResolver", "resolve"));
            }
            return this.resolve2(path, ArrayUtil.EMPTY_STRING_ARRAY);
        }

        @Override
        @Nullable
        public PostgresRoutine resolve2(@NotNull String[] path, @Nullable String[] argTypes) {
            PostgresSchema schema;
            String routineName;
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/dbm/postgres/PostgresSchema$RoutineResolver", "resolve2"));
            }
            int n = path.length;
            switch (n) {
                case 1: {
                    String routineName2 = path[0];
                    return PostgresSchema.this.getRoutines().getOverload(routineName2, argTypes, false);
                }
                case 2: {
                    String schemaName = path[0];
                    routineName = path[1];
                    schema = (PostgresSchema)((Family)PostgresSchema.this.getDatabase().getSchemas()).get(schemaName);
                    break;
                }
                case 3: {
                    String databaseName = path[0];
                    String schemaName = path[1];
                    routineName = path[2];
                    PostgresDatabase db = (PostgresDatabase)PostgresSchema.this.model.getRootNamespaces().get(databaseName);
                    if (db == null) {
                        return null;
                    }
                    schema = (PostgresSchema)((Family)PostgresSchema.this.getDatabase().getSchemas()).get(schemaName);
                    break;
                }
                default: {
                    schema = null;
                    routineName = null;
                }
            }
            return schema != null ? schema.routineResolver.resolve2(new String[]{routineName}, argTypes) : null;
        }
    }
}

