/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root2, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/sql/SqlFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/sql/SqlFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/sql/SqlFoldingBuilder", "buildLanguageFoldRegions"));
        }
        if (quick || !(root2 instanceof SqlFile)) {
            return;
        }
        CharSequence charSequence = document.getCharsSequence();
        for (PsiElement e : SqlImplUtil.sqlTraverser(root2)) {
            if (!(e instanceof SqlStatement) && (!(e instanceof SqlQueryExpression) || e.getParent() instanceof SqlSelectStatement) && (!(e instanceof PsiComment) || ((PsiComment)e).getTokenType() != SqlTokens.SQL_BLOCK_COMMENT)) continue;
            SqlFoldingBuilder.addFoldingDescriptor(e, charSequence, descriptors);
        }
    }

    private static void addFoldingDescriptor(@NotNull PsiElement o, @NotNull CharSequence charSequence, @NotNull List<FoldingDescriptor> result) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/SqlFoldingBuilder", "addFoldingDescriptor"));
        }
        if (charSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charSequence", "com/intellij/sql/SqlFoldingBuilder", "addFoldingDescriptor"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/SqlFoldingBuilder", "addFoldingDescriptor"));
        }
        TextRange range = o.getTextRange();
        if (range.getLength() > 12) {
            TextRange realRange;
            int lastCharIndex = Math.min(range.getEndOffset(), charSequence.length()) - 1;
            SqlFoldingBuilder.checkLastIndexInRange(o, charSequence, range, lastCharIndex);
            boolean leaveLastNewLine = '\n' == charSequence.charAt(lastCharIndex);
            TextRange textRange = realRange = leaveLastNewLine ? new TextRange(range.getStartOffset(), lastCharIndex) : range;
            if (PsiUtilCore.getElementType((PsiElement)o) == SqlCompositeElementTypes.SQL_BLOCK_STATEMENT) {
                PsiElement content = SqlImplUtil.getBlockContentElement(o);
                if (content != null) {
                    result.add(new FoldingDescriptor(content, content.getTextRange()));
                }
            } else {
                result.add(new FoldingDescriptor(o, realRange));
            }
        }
    }

    private static void checkLastIndexInRange(@NotNull PsiElement o, @NotNull CharSequence charSequence, TextRange range, int lastCharIndex) {
        boolean inRange;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/SqlFoldingBuilder", "checkLastIndexInRange"));
        }
        if (charSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charSequence", "com/intellij/sql/SqlFoldingBuilder", "checkLastIndexInRange"));
        }
        boolean bl = inRange = lastCharIndex >= 0 && lastCharIndex < charSequence.length() && lastCharIndex > range.getStartOffset();
        if (!inRange) {
            PsiFile containingFile = o.getContainingFile();
            FileViewProvider viewProvider = containingFile.getViewProvider();
            String docInfo = "";
            if (containingFile.isValid()) {
                PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)containingFile.getProject());
                Document document = docManager.getDocument(containingFile);
                boolean committed = document != null && docManager.isCommitted(document);
                docInfo = (document != null ? "Committed: " + committed + ", doc.length: " + document.getTextLength() + ", " : "") + "document: " + document + ",\n";
            }
            SqlDialectImplUtil.LOG.error("Length: " + charSequence.length() + ", Range: " + range + ",\n" + docInfo + "element: " + o.getClass() + ",\ncontainingFile: " + containingFile + ", file.length: " + containingFile.getText().length() + ", valid: " + containingFile.isValid() + ",\nviewProvider: " + viewProvider);
        }
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        SqlNameElement nameElement;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/SqlFoldingBuilder", "getLanguagePlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/sql/SqlFoldingBuilder", "getLanguagePlaceholderText"));
        }
        StringBuilder sb = new StringBuilder();
        PsiElement psi = node.getPsi();
        if (psi instanceof SqlDefinition) {
            nameElement = ((SqlDefinition)psi).getNameElement();
        } else if (psi instanceof SqlAlterStatement) {
            nameElement = ((SqlAlterStatement)psi).getAlterTargetReference();
        } else if (psi instanceof SqlDmlStatement) {
            SqlDmlInstruction instruction = (SqlDmlInstruction)ContainerUtil.getFirstItem((List)((SqlDmlStatement)psi).getDmlInstructions());
            SqlExpression expression = instruction == null ? null : instruction.getTargetExpression();
            nameElement = SqlFoldingBuilder.findFirstChildOfType((PsiElement)expression, SqlNameElement.class);
        } else if (psi instanceof SqlSelectStatement || psi instanceof SqlQueryExpression) {
            SqlQueryExpression queryExpression = psi instanceof SqlSelectStatement ? ((SqlSelectStatement)psi).getQueryExpression() : (SqlQueryExpression)psi;
            SqlTableExpression tableExpression = queryExpression == null ? null : queryExpression.getTableExpression();
            nameElement = SqlFoldingBuilder.findFirstChildOfType((PsiElement)tableExpression, SqlNameElement.class);
        } else {
            nameElement = null;
        }
        CharSequence charSequence = node.getChars();
        int maxLen = 12;
        boolean addName = false;
        if (nameElement != null) {
            int offsetInParent = nameElement.getTextRange().getStartOffset() - psi.getTextRange().getStartOffset();
            if (offsetInParent < maxLen + 1) {
                maxLen = offsetInParent + nameElement.getTextLength();
            } else {
                addName = true;
            }
        }
        boolean ws = false;
        for (int i2 = 0; i2 < charSequence.length() && sb.length() < maxLen; ++i2) {
            char c = charSequence.charAt(i2);
            if (Character.isWhitespace(c)) {
                if (ws) continue;
                sb.append(' ');
                ws = true;
                continue;
            }
            sb.append(c);
            ws = false;
        }
        if (!ws) {
            sb.append("... ");
        }
        if (addName) {
            sb.append(nameElement.getName());
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlFoldingBuilder", "getLanguagePlaceholderText"));
        }
        return string;
    }

    @Nullable
    private static <T> T findFirstChildOfType(@Nullable PsiElement element, @NotNull Class<? extends T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/SqlFoldingBuilder", "findFirstChildOfType"));
        }
        return (T)SyntaxTraverser.psiTraverser((PsiElement)element).filter(clazz).first();
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/SqlFoldingBuilder", "isRegionCollapsedByDefault"));
        }
        return false;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/SqlFoldingBuilder", "isCustomFoldingRoot"));
        }
        IElementType type = node.getElementType();
        return type != SqlElementTypes.SQL_DUMMY_BLOCK && type != SqlCompositeElementTypes.SQL_BATCH_BLOCK && super.isCustomFoldingRoot(node);
    }
}

