/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiTable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.AliasedSqlTableType;
import com.intellij.sql.psi.impl.ConcreteSqlTableType;
import com.intellij.sql.psi.impl.SqlTableTypeComposite;
import com.intellij.sql.psi.impl.SubtractedSqlTableTypeImpl;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlTableTypeBase
extends SqlTableType {
    public static final SqlTableType EMPTY_TABLE = new Empty(){

        @Override
        public SqlTableType join(SqlTableType type) {
            return type;
        }

        @Override
        public SqlTableType add(SqlTableType type) {
            return type;
        }
    };

    public static SqlTableType ensureTableType(SqlType type, @NotNull SqlElement element, @Nullable PsiElement qualifier) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlTableTypeBase", "ensureTableType"));
        }
        if (type instanceof SqlTableType) {
            return (SqlTableType)type;
        }
        return SqlTableTypeBase.createType(element, type, element instanceof SqlNameElement ? element.getName() : element.getText(), qualifier);
    }

    public static SqlTableType createType(final @NotNull SqlElement element, final @NotNull SqlType type, final @Nullable String name, final @Nullable PsiElement qualifier) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlTableTypeBase", "createType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/impl/SqlTableTypeBase", "createType"));
        }
        return new SqlTableTypeBase(){

            public int getColumnCount() {
                return 1;
            }

            public String getColumnName(int i2) {
                return name;
            }

            public SqlType getColumnType(int i2) {
                return type;
            }

            @Nullable
            public PsiElement getColumnQualifier(int i2) {
                return qualifier;
            }

            public DataType getDataType(int i2) {
                return DataType.UNKNOWN;
            }

            @NotNull
            public PsiElement getColumnElement(int i2) {
                SqlElement sqlElement = element;
                if (sqlElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlTableTypeBase$2", "getColumnElement"));
                }
                return sqlElement;
            }

            public PsiElement getSourceColumnElement(int i2) {
                return element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).resolve() : element;
            }

            @Override
            @Nullable
            public PsiElement getTypeElement() {
                SqlElement e = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).resolve() : element;
                DasTable table = e instanceof PsiColumn ? ((PsiColumn)e).getTable() : null;
                return table instanceof PsiElement ? (PsiElement)table : null;
            }
        };
    }

    public static SqlTableType createUnresolvedTableType(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/sql/psi/impl/SqlTableTypeBase", "createUnresolvedTableType"));
        }
        return new UnresolvedRefType(reference);
    }

    public static SqlTableType createType(@NotNull PsiTable info, @Nullable PsiElement place) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/sql/psi/impl/SqlTableTypeBase", "createType"));
        }
        return new TableBasedSqlTableTypeImpl(info, place);
    }

    @Nullable
    public PsiElement getTypeElement() {
        return null;
    }

    @Nullable
    public String getTypeName() {
        return null;
    }

    @Nullable
    public SqlType getConcreteType() {
        return null;
    }

    @Nullable
    public String getColumnTypeAlias(int i2) {
        return null;
    }

    public SqlTableType join(SqlTableType type) {
        return SqlTableTypeComposite.join(this, type);
    }

    public SqlTableType add(SqlTableType type) {
        return SqlTableTypeComposite.add(this, type);
    }

    public SqlTableType subtract(@Nullable PsiElement element) {
        return new SubtractedSqlTableTypeImpl(this, element);
    }

    public SqlTableType alias(String aliasName, @Nullable PsiElement aliasElement, List<? extends SqlNameElement> newColumns) {
        return new AliasedSqlTableType(this, aliasName, aliasElement, newColumns);
    }

    public SqlTableType concretize(@Nullable SqlType type) {
        return new ConcreteSqlTableType(this, type);
    }

    public static class UnresolvedRefType
    extends Empty {
        private final PsiReference myReference;

        public UnresolvedRefType(PsiReference reference) {
            this.myReference = reference;
        }

        @Override
        @Nullable
        public String getTypeName() {
            return this.myReference.getCanonicalText();
        }

        @Override
        @Nullable
        public PsiElement getTypeElement() {
            return this.myReference.getElement();
        }
    }

    public static class Empty
    extends SqlTableTypeBase {
        @Override
        @Nullable
        public String getTypeName() {
            return null;
        }

        @Override
        @Nullable
        public PsiElement getTypeElement() {
            return null;
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int i2) {
            throw new NoSuchElementException();
        }

        public SqlType getColumnType(int i2) {
            throw new NoSuchElementException();
        }

        @Nullable
        public PsiElement getColumnQualifier(int i2) {
            throw new NoSuchElementException();
        }

        public DataType getDataType(int i2) {
            throw new NoSuchElementException();
        }

        @NotNull
        public PsiElement getColumnElement(int i2) {
            throw new NoSuchElementException();
        }

        public PsiElement getSourceColumnElement(int i2) {
            throw new NoSuchElementException();
        }

        @Override
        public String getColumnTypeAlias(int i2) {
            throw new NoSuchElementException();
        }

        @Override
        public SqlTableType subtract(PsiElement element) {
            return this;
        }

        @Override
        public SqlTableType alias(String aliasName, PsiElement aliasElement, List<? extends SqlNameElement> newColumns) {
            return newColumns.isEmpty() ? this : new AliasedSqlTableType(this, aliasName, aliasElement, newColumns);
        }
    }
}

