/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Numbers {
    public static boolean valuesAreEqual(@Nullable Number x, @Nullable Number y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.getClass() == y.getClass() ? x.equals(y) : x.toString().equals(y.toString());
    }

    @NotNull
    public static String toFixLengthNumber(int value, int length) {
        String str = Integer.toString(value);
        int n = str.length();
        if (n < length) {
            assert (length <= 10) : "The length must be from 1 to 10";
            str = value >= 0 ? "0000000000".substring(0, length - n) + str : "-000000000".substring(0, length - n + 1) + str.substring(1);
        }
        if (n > length) {
            str = "??????????".substring(0, n);
        }
        String string = str;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Numbers", "toFixLengthNumber"));
        }
        return string;
    }

    @NotNull
    public static String toFixLengthNumber(long value, int length) {
        String str = Long.toString(value);
        int n = str.length();
        if (n < length) {
            assert (length <= 20) : "The length must be from 1 to 20";
            str = value >= 0L ? "00000000000000000000".substring(0, length - n) + str : "-0000000000000000000".substring(0, length - n + 1) + str.substring(1);
        }
        if (n > length) {
            str = "????????????????????".substring(0, n);
        }
        String string = str;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/Numbers", "toFixLengthNumber"));
        }
        return string;
    }
}

