/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flow;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CompletionServiceImpl;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSCompletionContributor
extends CompletionContributor {
    private static final Logger LOGGER = Logger.getInstance(FlowJSCompletionContributor.class);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet resultSet) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/javascript/flow/FlowJSCompletionContributor", "fillCompletionVariants"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "com/intellij/javascript/flow/FlowJSCompletionContributor", "fillCompletionVariants"));
        }
        PsiFile originalFile = parameters.getOriginalFile();
        FlowJSServerService service = FlowJSServerService.getService(originalFile.getProject());
        if (service == null) {
            return;
        }
        Document document = parameters.getEditor().getDocument();
        FlowJSConfig config = service.getConfig(originalFile.getVirtualFile());
        if (config == null) {
            return;
        }
        Runnable restartService = () -> {
            CompletionProgressIndicator completion = CompletionServiceImpl.getCompletionService().getCurrentCompletion();
            if (completion != null) {
                completion.scheduleRestart();
            }
        };
        if (service.saveAsyncAllUnsavedFiles(restartService, document)) {
            return;
        }
        List<JsonObject> requestAnswer = service.getCompletionOfElement(parameters.getOriginalFile(), document, config, parameters, parameters.getPosition().getContainingFile().getText());
        Map<String, String> names = FlowJSCompletionContributor.parseCompletionAnswer(requestAnswer);
        java.util.HashSet entrySet = ContainerUtil.newHashSet();
        resultSet.runRemainingContributors(parameters, result -> entrySet.add(result.getLookupElement()));
        HashMap entryMap = ContainerUtil.newHashMap();
        entrySet.forEach(element -> entryMap.put(element.getLookupString(), element));
        HashSet elementsToAdd = new HashSet();
        for (Map.Entry<String, String> entry : names.entrySet()) {
            LookupElement element2 = (LookupElement)entryMap.get(entry.getKey());
            if (element2 != null) {
                if (element2 instanceof MutableLookupElement) {
                    ((MutableLookupElement)element2).setBold();
                    ((MutableLookupElement)element2).setPriority((double)JSLookupPriority.LOCAL_SCOPE_MAX_PRIORITY.getPriorityValue());
                }
                elementsToAdd.add(element2);
                entryMap.remove(entry.getKey());
                entrySet.remove(element2);
                continue;
            }
            LookupElementBuilder lookupElement = LookupElementBuilder.create((String)entry.getKey()).withTypeText(entry.getValue(), false).bold();
            elementsToAdd.add(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)JSLookupPriority.LOCAL_SCOPE_MAX_PRIORITY.getPriorityValue()));
        }
        elementsToAdd.addAll(entrySet);
        FlowJSCompletionContributor.removeIncorrectCompletionElements(parameters.getPosition(), (Set<LookupElement>)elementsToAdd);
        resultSet.addAllElements((Iterable)elementsToAdd);
        resultSet.stopHere();
    }

    private static Map<String, String> parseCompletionAnswer(List<JsonObject> requestAnswer) {
        HashMap<String, String> names = new HashMap<String, String>();
        try {
            JsonObject parse = new JsonObject();
            if (requestAnswer.size() > 0) {
                parse = requestAnswer.get(0).get("result");
            }
            if (parse instanceof JsonArray) {
                for (JsonElement e : (JsonArray)parse) {
                    if (!(e instanceof JsonObject)) continue;
                    JsonObject object = (JsonObject)e;
                    names.put(object.get("name").getAsString(), object.get("type").getAsString());
                }
            }
        }
        catch (Throwable e) {
            LOGGER.warn(e);
        }
        return names;
    }

    private static void removeIncorrectCompletionElements(@NotNull PsiElement element, @NotNull Set<LookupElement> results) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flow/FlowJSCompletionContributor", "removeIncorrectCompletionElements"));
        }
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/javascript/flow/FlowJSCompletionContributor", "removeIncorrectCompletionElements"));
        }
        PsiElement importKeyword = FlowJSCompletionContributor.checkImport(element);
        if (importKeyword != null) {
            if (FlowJSCompletionContributor.isTypeImport(importKeyword)) {
                FlowJSCompletionContributor.removeImportSuggestions(results, true);
            } else {
                FlowJSCompletionContributor.removeImportSuggestions(results, false);
            }
        }
    }

    private static void removeImportSuggestions(@NotNull Set<LookupElement> results, boolean isType) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/javascript/flow/FlowJSCompletionContributor", "removeImportSuggestions"));
        }
        HashSet copyOfSet = new HashSet(results);
        results.forEach(arg_0 -> FlowJSCompletionContributor.lambda$removeImportSuggestions$3(isType, (Set)copyOfSet, arg_0));
        results.clear();
        results.addAll((Collection<LookupElement>)copyOfSet);
    }

    @Nullable
    private static PsiElement checkImport(@NotNull PsiElement element) {
        PsiElement importKeyWord;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flow/FlowJSCompletionContributor", "checkImport"));
        }
        PsiElement importElement = PsiTreeUtil.getParentOfType((PsiElement)element, ES6ImportDeclaration.class);
        if (importElement != null && (importKeyWord = importElement.getFirstChild()).getNode().getElementType() == JSTokenTypes.IMPORT_KEYWORD) {
            return importKeyWord;
        }
        return null;
    }

    private static boolean isTypeImport(@NotNull PsiElement importKeyWord) {
        if (importKeyWord == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importKeyWord", "com/intellij/javascript/flow/FlowJSCompletionContributor", "isTypeImport"));
        }
        PsiElement next = importKeyWord.getNextSibling();
        if (next != null) {
            PsiElement typeElement;
            PsiElement psiElement = typeElement = next instanceof PsiWhiteSpace ? next.getNextSibling() : next;
            if (typeElement != null && typeElement.getNode().getElementType() == JSTokenTypes.TYPE_KEYWORD) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void lambda$removeImportSuggestions$3(boolean isType, Set copyOfSet, LookupElement element) {
        PsiElement psiElement = element.getPsiElement();
        if (psiElement != null) {
            if (isType) {
                if (!(psiElement instanceof TypeScriptTypeAlias || psiElement instanceof ES6Class || psiElement instanceof TypeScriptInterface)) {
                    copyOfSet.remove(element);
                }
            } else if (psiElement instanceof TypeScriptTypeAlias) {
                copyOfSet.remove(element);
            }
        }
    }
}

