/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.execution;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NodeRunConfigurationLocationFilter {
    private static final ExtensionPointName<NodeRunConfigurationLocationFilter> EP_NAME = ExtensionPointName.create((String)"NodeJS.runConfigurationLocationFilter");
    private static final Map<FileType, NodeRunConfigurationLocationFilter> FILTER_BY_FILE_TYPE;

    public abstract boolean accept(@NotNull PsiFile var1);

    @NotNull
    public abstract FileType getFileType();

    @NotNull
    public Collection<FileType> getAdditionalFileTypes() {
        List<FileType> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/execution/NodeRunConfigurationLocationFilter", "getAdditionalFileTypes"));
        }
        return list;
    }

    @Nullable
    public static NodeRunConfigurationLocationFilter findByFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/javascript/nodejs/execution/NodeRunConfigurationLocationFilter", "findByFileType"));
        }
        return FILTER_BY_FILE_TYPE.get(fileType);
    }

    static {
        HashMap builder = ContainerUtil.newHashMap();
        for (NodeRunConfigurationLocationFilter consumer : (NodeRunConfigurationLocationFilter[])EP_NAME.getExtensions()) {
            NodeRunConfigurationLocationFilter fileTypeConsumer = (NodeRunConfigurationLocationFilter)ObjectUtils.tryCast((Object)consumer, NodeRunConfigurationLocationFilter.class);
            if (fileTypeConsumer == null) continue;
            builder.put(fileTypeConsumer.getFileType(), fileTypeConsumer);
            for (FileType type : fileTypeConsumer.getAdditionalFileTypes()) {
                builder.put(type, fileTypeConsumer);
            }
        }
        FILTER_BY_FILE_TYPE = ImmutableMap.copyOf((Map)builder);
    }
}

