/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.ide.DataManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpretersDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpreterField
extends ComponentWithBrowseButton<ComboBox> {
    private static final Object ADD_INTERPRETER = new Object();
    private final Project myProject;
    private final KeyEventAwareComboBox myComboBox;
    private final DefaultComboBoxModel<Object> myModel;
    private final boolean myEnableRemote;
    private final List<NodeJsInterpreterChangeListener> myChangeListeners;
    private Object myLastSelectedItem;
    private boolean myProcessItemStateChangedEvents;

    public NodeJsInterpreterField(@NotNull Project project, boolean enableRemote) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField", "<init>"));
        }
        super((JComponent)((Object)new KeyEventAwareComboBox()), null);
        this.myChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProcessItemStateChangedEvents = true;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeJsInterpreterField.this.showInterpretersDialog();
            }
        });
        this.myProject = project;
        this.myEnableRemote = enableRemote;
        this.myComboBox = (KeyEventAwareComboBox)((Object)this.getChildComponent());
        this.myModel = new NodeJsInterpreterComboBoxModel();
        this.myComboBox.setModel(this.myModel);
        this.myComboBox.setRenderer(new DelegatingListCellRenderer());
        this.myComboBox.setMinimumAndPreferredWidth(0);
        this.myComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                NodeJsInterpreterField.this.myComboBox.removePopupMenuListener((PopupMenuListener)((Object)this));
                NodeJsInterpreterField.this.updateDropDownListAndSelect(null, true);
            }
        });
        this.myComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && NodeJsInterpreterField.this.myProcessItemStateChangedEvents) {
                    NodeJsInterpreterField.this.handleSelectedItemChange();
                }
            }
        });
    }

    private void handleSelectedItemChange() {
        Object selectedItem = this.myComboBox.getSelectedItem();
        if (selectedItem == ADD_INTERPRETER) {
            this.myComboBox.setSelectedItem(this.myLastSelectedItem);
            if (!this.myComboBox.myKeyEventProcessing) {
                ApplicationManager.getApplication().invokeLater(this::showPopup, ModalityState.current());
            }
        } else if (this.myLastSelectedItem != selectedItem) {
            this.myLastSelectedItem = selectedItem;
            for (NodeJsInterpreterChangeListener listener : this.myChangeListeners) {
                listener.interpreterChanged(NodeJsInterpreter.tryCast(selectedItem));
            }
        }
    }

    private void showPopup() {
        JBPopup popup = NodeJsInterpretersDialog.createAddPopup(this.myProject, this.myEnableRemote, DataManager.getInstance().getDataContext((Component)((Object)this.myComboBox)), (Consumer<NodeJsInterpreter>)((Consumer)interpreter -> {
            NodeJsInterpreterType<? extends NodeJsInterpreter> type = interpreter.getType();
            ArrayList interpreters = ContainerUtil.newArrayList(type.getInterpreters());
            if (!interpreters.contains(interpreter)) {
                interpreters.add(interpreter);
                type.setInterpreters(interpreters);
                this.updateDropDownListAndSelect((NodeJsInterpreter)interpreter, false);
            }
        }), Collections.emptySet());
        popup.showUnderneathOf((Component)((Object)this.myComboBox));
    }

    public boolean isDefaultProjectInterpreterField() {
        return false;
    }

    public void addChangeListener(@NotNull NodeJsInterpreterChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField", "addChangeListener"));
        }
        this.myChangeListeners.add(listener);
    }

    private void showInterpretersDialog() {
        NodeJsInterpretersDialog dialog = new NodeJsInterpretersDialog(this.myProject, this.isDefaultProjectInterpreterField(), this.myEnableRemote);
        Pair<Boolean, NodeJsInterpreter> pair = dialog.showAndGetSelected(NodeJsInterpreter.tryCast(this.myModel.getSelectedItem()));
        if (((Boolean)pair.getFirst()).booleanValue()) {
            this.updateDropDownListAndSelect((NodeJsInterpreter)pair.getSecond(), false);
        }
    }

    private void updateDropDownListAndSelect(@Nullable NodeJsInterpreter interpreterToSelect, boolean preserveCurrentSelection) {
        List<NodeJsInterpreterType> types = NodeJsInterpretersDialog.enabledTypes(this.myEnableRemote);
        List<NodeJsInterpreter> interpreters = NodeJsInterpreterType.getInterpretersFor(types);
        if (interpreterToSelect != null) {
            NodeJsInterpreterField.addIfNeeded(interpreters, interpreterToSelect);
        } else if (preserveCurrentSelection) {
            NodeJsInterpreter previouslySelected = (NodeJsInterpreter)this.myComboBox.getSelectedItem();
            NodeJsInterpreterField.addIfNeeded(interpreters, previouslySelected);
        }
        this.myProcessItemStateChangedEvents = false;
        SwingHelper.updateItems((JComboBox)((Object)this.myComboBox), interpreters, null);
        this.myComboBox.addItem(ADD_INTERPRETER);
        this.myProcessItemStateChangedEvents = true;
        if (interpreterToSelect != null || !preserveCurrentSelection) {
            this.myComboBox.setSelectedItem(interpreterToSelect);
            this.handleSelectedItemChange();
        }
    }

    private static void addIfNeeded(@NotNull List<NodeJsInterpreter> list, @Nullable NodeJsInterpreter interpreter) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField", "addIfNeeded"));
        }
        if (!list.contains(interpreter)) {
            list.add(0, interpreter);
        }
    }

    public void setInterpreter(@Nullable NodeJsInterpreter interpreter) {
        this.myModel.setSelectedItem(interpreter);
    }

    public void setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
        if (interpreterRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField", "setInterpreterRef"));
        }
        NodeJsInterpreter interpreter = interpreterRef.resolve(this.myProject);
        this.setInterpreter(interpreter);
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreter projectInterpreter;
        NodeJsInterpreter selectedInterpreter = this.getInterpreter();
        if (ComparatorUtil.equalsNullable((Object)selectedInterpreter, (Object)(projectInterpreter = NodeJsInterpreterManager.getInstance(this.myProject).getDefault()))) {
            NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            if (nodeJsInterpreterRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField", "getInterpreterRef"));
            }
            return nodeJsInterpreterRef;
        }
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create(selectedInterpreter);
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return NodeJsInterpreter.tryCast(this.myComboBox.getSelectedItem());
    }

    public void setPreferredWidthToFitText() {
        Object item = this.myComboBox.getSelectedItem();
        if (item instanceof NodeJsInterpreter) {
            this.myComboBox.setMinimumAndPreferredWidth(-1);
            Object prevPrototype = this.myComboBox.getPrototypeDisplayValue();
            this.myComboBox.setPrototypeDisplayValue(item);
            Dimension size = this.getPreferredSize();
            this.setPreferredSize(size);
            this.myComboBox.setMinimumAndPreferredWidth(0);
            this.myComboBox.setPrototypeDisplayValue(prevPrototype);
        }
    }

    static class NodeJsInterpreterComboBoxModel
    extends DefaultComboBoxModel<Object> {
        NodeJsInterpreterComboBoxModel() {
        }

        void repaintSelectedElementIfMatches(@NotNull NodeJsInterpreter expectedSelectedElement) {
            if (expectedSelectedElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedSelectedElement", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField$NodeJsInterpreterComboBoxModel", "repaintSelectedElementIfMatches"));
            }
            if (this.getSelectedItem() == expectedSelectedElement) {
                this.fireContentsChanged(this, -1, -1);
            }
        }
    }

    private class DelegatingListCellRenderer
    implements ListCellRenderer<Object> {
        private final SpecialValueRenderer mySpecialValueRenderer = new SpecialValueRenderer();
        private final NodeJsInterpreterRenderer myInterpreterRenderer = new NodeJsInterpreterRenderer(true, new Predicate<NodeJsInterpreter>(){

            public boolean apply(@Nullable NodeJsInterpreter input) {
                if (input == null || NodeJsInterpreterField.this.isDefaultProjectInterpreterField()) {
                    return false;
                }
                NodeJsInterpreter projectInterpreter = NodeJsInterpreterManager.getInstance(NodeJsInterpreterField.this.myProject).getDefault();
                return input.equals(projectInterpreter);
            }
        });

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object renderer = value instanceof NodeJsInterpreter ? this.myInterpreterRenderer : this.mySpecialValueRenderer;
            list.setEnabled(NodeJsInterpreterField.this.isEnabled());
            return renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class SpecialValueRenderer
    extends ColoredListCellRenderer<Object> {
        public SpecialValueRenderer() {
            this.setIpad((Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0));
            NodeJsInterpreterRenderer.adjustBorderHeight((SimpleColoredComponent)this);
        }

        protected void customizeCellRenderer(@NotNull JList<?> list, Object value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField$SpecialValueRenderer", "customizeCellRenderer"));
            }
            if (value == null) {
                this.append("No interpreter", new SimpleTextAttributes(0, (Color)JBColor.RED));
            } else if (value == ADD_INTERPRETER) {
                this.append(" Add...", new SimpleTextAttributes(0, (Color)JBColor.darkGray));
            } else {
                this.append("Unexpected value", new SimpleTextAttributes(0, (Color)JBColor.RED));
            }
        }
    }

    private static class KeyEventAwareComboBox
    extends ComboBox {
        private boolean myKeyEventProcessing = false;

        private KeyEventAwareComboBox() {
        }

        public void processKeyEvent(KeyEvent e) {
            this.myKeyEventProcessing = true;
            super.processKeyEvent(e);
            this.myKeyEventProcessing = false;
        }
    }
}

