/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeModulesExcludePolicy
implements DirectoryIndexExcludePolicy {
    private final Project myProject;

    public NodeModulesExcludePolicy(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesExcludePolicy", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public VirtualFile[] getExcludeRootsForProject() {
        List dirs = ContainerUtil.filter(NodeModulesDirectoryManager.getInstance(this.myProject).getNodeModulesDirsNotExcludedByProjectModel(), VirtualFile::isValid);
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)dirs);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesExcludePolicy", "getExcludeRootsForProject"));
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFilePointer[] getExcludeRootsForModule(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/javascript/nodejs/library/NodeModulesExcludePolicy", "getExcludeRootsForModule"));
        }
        if (VirtualFilePointer.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesExcludePolicy", "getExcludeRootsForModule"));
        }
        return VirtualFilePointer.EMPTY_ARRAY;
    }
}

