/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModulesLibraryProvider
extends JSPredefinedLibraryProvider {
    private static final Logger LOG = Logger.getInstance(NodeModulesLibraryProvider.class);
    private static final Set<String> EXCLUDED_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"test", "tests", "spec", "specs", "node_modules"});
    public static final String TYPESCRIPT_DEPENDENCY = "typescript";

    @Override
    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "getPredefinedLibraries"));
        }
        NodeModulesDirectoryManager manager = NodeModulesDirectoryManager.getInstance(project);
        List<NodeModulesLibraryDirectory> nodeModulesDirs = manager.getNodeModulesDirectories();
        List models = ContainerUtil.mapNotNull(nodeModulesDirs, nodeModulesDir -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "lambda$getPredefinedLibraries$0"));
            }
            return NodeModulesLibraryProvider.createLibraryModel(project, nodeModulesDir);
        });
        ScriptingLibraryModel[] scriptingLibraryModelArray = ScriptingLibraryModel.toArray((Collection)models);
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "getPredefinedLibraries"));
        }
        return scriptingLibraryModelArray;
    }

    @Nullable
    private static ScriptingLibraryModel createLibraryModel(@NotNull Project project, @NotNull NodeModulesLibraryDirectory libraryDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "createLibraryModel"));
        }
        if (libraryDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDir", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "createLibraryModel"));
        }
        if (!libraryDir.getNodeModulesDir().isValid()) {
            LOG.warn("Cannot create library as " + libraryDir.getNodeModulesDir().getPath() + " is invalid");
            return null;
        }
        if (libraryDir.isForApplicationSourceCode()) {
            return null;
        }
        NodeModulesLibraryModel libraryModel = new NodeModulesLibraryModel(libraryDir, project);
        libraryDir.setLibraryModel(libraryModel);
        return libraryModel;
    }

    @NotNull
    private static List<VirtualFile> getRootsInsideNodeModules(@NotNull Project project, @NotNull VirtualFile nodeModulesDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "getRootsInsideNodeModules"));
        }
        if (nodeModulesDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeModulesDir", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "getRootsInsideNodeModules"));
        }
        ArrayList rootsToIndex = ContainerUtil.newArrayList();
        VirtualFile parent = nodeModulesDir.getParent();
        if (parent != null) {
            VirtualFile packageJson = parent.findChild("package.json");
            if (packageJson != null && packageJson.isValid() && !packageJson.isDirectory()) {
                PackageJsonData data = PackageJsonUtil.getOrCreateData(packageJson);
                Set<String> dependencies = data.getAllDependencies();
                for (String dependency : dependencies) {
                    VirtualFile dir;
                    if (!NodeModulesLibraryProvider.isDependencyIndexed(data, dependency) || (dir = nodeModulesDir.findFileByRelativePath(dependency)) == null || !dir.isValid() || !dir.isDirectory()) continue;
                    NodeModulesLibraryProvider.collectDependencyRoots(rootsToIndex, dir);
                }
                VirtualFile types = nodeModulesDir.findChild("@types");
                if (types != null && types.isValid() && types.isDirectory()) {
                    rootsToIndex.add(types);
                }
                NodeModulesDirectoryManager.getInstance(project).setProvidedPackageJsonRoots(packageJson, data);
            } else {
                VirtualFile[] children;
                for (VirtualFile child : children = (VirtualFile[])ObjectUtils.notNull((Object)nodeModulesDir.getChildren(), (Object)VirtualFile.EMPTY_ARRAY)) {
                    String name = child.getName();
                    if (name.startsWith(".") || name.startsWith("_")) continue;
                    NodeModulesLibraryProvider.collectDependencyRoots(rootsToIndex, child);
                }
            }
        }
        ArrayList arrayList = rootsToIndex;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "getRootsInsideNodeModules"));
        }
        return arrayList;
    }

    public static boolean isDependencyIndexed(@NotNull PackageJsonData data, @NotNull String dependencyName) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "isDependencyIndexed"));
        }
        if (dependencyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencyName", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "isDependencyIndexed"));
        }
        if (TYPESCRIPT_DEPENDENCY.equals(dependencyName)) {
            return data.isDependencyOfAnyTypeExcludeDev(dependencyName);
        }
        return data.isDependencyOfAnyType(dependencyName) && !PackageJsonUtil.hasScope(dependencyName, "@types") && !data.isDependencyOfAnyType("@types/" + dependencyName);
    }

    public static boolean isDependencyChildIncluded(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "isDependencyChildIncluded"));
        }
        String name = fileOrDir.getName();
        return !StringUtil.startsWith((CharSequence)name, (CharSequence)".") && !EXCLUDED_NAMES.contains(name);
    }

    private static void collectDependencyRoots(@NotNull List<VirtualFile> roots, @NotNull VirtualFile dependency) {
        VirtualFile[] children;
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "collectDependencyRoots"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider", "collectDependencyRoots"));
        }
        for (VirtualFile child : children = (VirtualFile[])ObjectUtils.notNull((Object)dependency.getChildren(), (Object)VirtualFile.EMPTY_ARRAY)) {
            if (!NodeModulesLibraryProvider.isDependencyChildIncluded(child)) continue;
            roots.add(child);
        }
    }

    private static class NodeModulesLibraryModel
    extends ScriptingLibraryModel {
        private final Project myProject;
        private final VirtualFile myNodeModulesDir;
        private final AtomicNotNullLazyValue<Set<VirtualFile>> myRoots;

        public NodeModulesLibraryModel(@NotNull NodeModulesLibraryDirectory libraryDir, @NotNull Project project) {
            if (libraryDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDir", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider$NodeModulesLibraryModel", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider$NodeModulesLibraryModel", "<init>"));
            }
            super(libraryDir.getLibraryName(), VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.PREDEFINED, false);
            this.myRoots = new AtomicNotNullLazyValue<Set<VirtualFile>>(){

                @NotNull
                protected Set<VirtualFile> compute() {
                    Set set = this.calcRoots();
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider$NodeModulesLibraryModel$1", "compute"));
                    }
                    return set;
                }
            };
            this.myProject = project;
            this.myNodeModulesDir = libraryDir.getNodeModulesDir();
        }

        @NotNull
        public Set<VirtualFile> getSourceFiles() {
            Set set = (Set)this.myRoots.getValue();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider$NodeModulesLibraryModel", "getSourceFiles"));
            }
            return set;
        }

        public void collectFilesWithGlobalDefinitions(@NotNull Collection<VirtualFile> result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider$NodeModulesLibraryModel", "collectFilesWithGlobalDefinitions"));
            }
        }

        public boolean shouldIndexSourcesWithoutMappings() {
            return false;
        }

        @NotNull
        public List<VirtualFile> getDefaultMappings() {
            List<VirtualFile> list = Collections.singletonList(this.myNodeModulesDir.getParent());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider$NodeModulesLibraryModel", "getDefaultMappings"));
            }
            return list;
        }

        @NotNull
        private Set<VirtualFile> calcRoots() {
            Set result = (Set)RecursionManager.doPreventingRecursion((Object)this.myNodeModulesDir, (boolean)false, () -> {
                JSLibraryMappings libraryMappings = JSLibraryMappings.getInstance(this.myProject);
                if (libraryMappings.getMappingsByLibraryName(this.getName()).isEmpty()) {
                    return Collections.emptySet();
                }
                List roots = NodeModulesLibraryProvider.getRootsInsideNodeModules(this.myProject, this.myNodeModulesDir);
                return ContainerUtil.newHashSet((Iterable)roots);
            });
            if (result == null) {
                LOG.warn(new Throwable("Recursion prevented when calculating node_modules roots: " + this.myNodeModulesDir.getPath()));
                Set<VirtualFile> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider$NodeModulesLibraryModel", "calcRoots"));
                }
                return set;
            }
            Set set = result;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesLibraryProvider$NodeModulesLibraryModel", "calcRoots"));
            }
            return set;
        }
    }
}

