/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageEditor;
import com.intellij.javascript.nodejs.util.NodePackageRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class NodePackageField
extends ComponentWithBrowseButton<ComboBox<Object>> {
    private static final Object SELECT_PACKAGE = new Object();
    private final Project myProject;
    private final List<String> myPackageNames;
    private final KeyEventAwareComboBox<Object> myComboBox;
    private final SortedComboBoxModel<Object> myModel;
    private final NodePackageEditor myEditor;

    public NodePackageField(@NotNull Project project, @NotNull String packageName, @Nullable Supplier<NodeJsInterpreter> interpreterSupplier) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackageField", "<init>"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackageField", "<init>"));
        }
        this(project, Collections.singletonList(packageName), interpreterSupplier);
    }

    public NodePackageField(@NotNull Project project, @NotNull List<String> packageNames, @Nullable Supplier<NodeJsInterpreter> interpreterSupplier) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackageField", "<init>"));
        }
        if (packageNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNames", "com/intellij/javascript/nodejs/util/NodePackageField", "<init>"));
        }
        super(new KeyEventAwareComboBox(), null);
        this.myProject = project;
        this.myPackageNames = packageNames;
        this.myComboBox = (KeyEventAwareComboBox)((Object)this.getChildComponent());
        this.myModel = NodePackageField.createModel();
        this.myComboBox.setModel((ComboBoxModel)this.myModel);
        this.myComboBox.setRenderer(new DelegatingListCellRenderer());
        this.myComboBox.setEditable(true);
        this.myEditor = new NodePackageEditor(this.myModel);
        this.myComboBox.setEditor(this.myEditor);
        this.installFileCompletionAndBrowserFolderListener(this.myEditor.getTextField());
        this.myComboBox.setMinimumAndPreferredWidth(0);
        this.installListeners(interpreterSupplier);
    }

    private void installListeners(final @Nullable Supplier<NodeJsInterpreter> interpreterSupplier) {
        final ItemListener itemListener = new ItemListener(){
            private Object myLastSelectedItem;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object selectedItem = NodePackageField.this.myComboBox.getSelectedItem();
                    if (selectedItem == SELECT_PACKAGE) {
                        NodePackageField.this.myComboBox.setSelectedItem(this.myLastSelectedItem);
                        if (!((KeyEventAwareComboBox)NodePackageField.this.myComboBox).myKeyEventProcessing) {
                            ApplicationManager.getApplication().invokeLater(() -> NodePackageField.this.performSelection((NodePackage)ObjectUtils.tryCast((Object)this.myLastSelectedItem, NodePackage.class)), ModalityState.defaultModalityState());
                        }
                    } else {
                        this.myLastSelectedItem = selectedItem;
                    }
                }
            }
        };
        this.myComboBox.addItemListener(itemListener);
        this.myComboBox.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                NodePackageField.this.myComboBox.removeItemListener(itemListener);
                NodeJsInterpreter interpreter = interpreterSupplier != null ? (NodeJsInterpreter)interpreterSupplier.get() : null;
                ArrayList packages = ContainerUtil.newArrayList();
                for (String packageName : NodePackageField.this.myPackageNames) {
                    packages.addAll(NodePackage.collectAvailableNodePackages(NodePackageField.this.myProject, packageName, interpreter));
                }
                NodePackage prevSelected = (NodePackage)ObjectUtils.tryCast((Object)NodePackageField.this.myModel.getSelectedItem(), NodePackage.class);
                List all = ContainerUtil.concat((List)packages, Collections.singletonList(SELECT_PACKAGE));
                NodePackageField.this.myModel.setAll((Collection)all);
                NodePackageField.this.addIfMissingAndSelect(prevSelected);
                NodePackageField.this.myComboBox.addItemListener(itemListener);
            }
        });
    }

    private void performSelection(@Nullable NodePackage initial) {
        VirtualFile initialFile = initial != null ? LocalFileFinder.findFile((String)initial.getSystemIndependentPath()) : null;
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withShowHiddenFiles(SystemInfo.isUnix);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)this.myProject, (VirtualFile)initialFile);
        if (file != null) {
            this.addIfMissingAndSelect(new NodePackage(file.getPath()));
        }
    }

    void addIfMissingAndSelect(@Nullable NodePackage pkg) {
        int i = this.myModel.indexOf((Object)pkg);
        if (i >= 0) {
            this.myModel.setSelectedItem(this.myModel.get(i));
        } else if (pkg == null) {
            this.myModel.setSelectedItem(null);
        } else {
            this.myModel.add((Object)pkg);
            this.myModel.setSelectedItem((Object)pkg);
        }
    }

    public void setSelected(@NotNull NodePackage pkg) {
        if (pkg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pkg", "com/intellij/javascript/nodejs/util/NodePackageField", "setSelected"));
        }
        this.addIfMissingAndSelect(pkg);
    }

    @NotNull
    public NodePackage getSelected() {
        NodePackage nodePackage = this.myEditor.getItem();
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackageField", "getSelected"));
        }
        return nodePackage;
    }

    public void setPreferredWidthToFitText() {
        Object item = this.myComboBox.getSelectedItem();
        if (item instanceof NodePackage) {
            this.myComboBox.setMinimumAndPreferredWidth(-1);
            Object prevPrototype = this.myComboBox.getPrototypeDisplayValue();
            this.myComboBox.setPrototypeDisplayValue(item);
            Dimension size = this.getPreferredSize();
            this.setPreferredSize(size);
            this.myComboBox.setMinimumAndPreferredWidth(0);
            this.myComboBox.setPrototypeDisplayValue(prevPrototype);
        }
    }

    @NotNull
    private static SortedComboBoxModel<Object> createModel() {
        SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel((o1, o2) -> {
            if (o1 instanceof NodePackage) {
                if (o2 instanceof NodePackage) {
                    return ((NodePackage)o1).getSystemDependentPath().compareTo(((NodePackage)o2).getSystemDependentPath());
                }
                return o2 == null ? 1 : -1;
            }
            if (o1 == null) {
                return o2 == null ? 0 : -1;
            }
            if (o1 == SELECT_PACKAGE) {
                return o2 == SELECT_PACKAGE ? 0 : 1;
            }
            throw new IllegalArgumentException("Unexpected " + o1.getClass());
        });
        if (sortedComboBoxModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackageField", "createModel"));
        }
        return sortedComboBoxModel;
    }

    private void installFileCompletionAndBrowserFolderListener(@NotNull JTextField textField) {
        if (textField == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textField", "com/intellij/javascript/nodejs/util/NodePackageField", "installFileCompletionAndBrowserFolderListener"));
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withShowHiddenFiles(SystemInfo.isUnix);
        FileChooserFactory.getInstance().installFileCompletion(textField, descriptor, true, (Disposable)this.myProject);
        this.addBrowseFolderListener("Select " + StringUtil.join(this.myPackageNames, (String)"/") + " Package Directory", null, this.myProject, descriptor, NodePackageEditor.TEXT_COMPONENT_ACCESSOR);
    }

    private class DelegatingListCellRenderer
    implements ListCellRenderer<Object> {
        private final SpecialValueRenderer mySpecialValueRenderer = new SpecialValueRenderer();
        private final NodePackageRenderer myPackageRenderer = new NodePackageRenderer();

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object renderer = value instanceof NodePackage ? this.myPackageRenderer : this.mySpecialValueRenderer;
            list.setEnabled(NodePackageField.this.isEnabled());
            return renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static class SpecialValueRenderer
    extends ColoredListCellRenderer<Object> {
        public SpecialValueRenderer() {
            this.setIpad((Insets)JBUI.insets((int)0, (int)2, (int)0, (int)0));
            NodeJsInterpreterRenderer.adjustBorderHeight((SimpleColoredComponent)this);
        }

        protected void customizeCellRenderer(@NotNull JList<?> list, Object value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/javascript/nodejs/util/NodePackageField$SpecialValueRenderer", "customizeCellRenderer"));
            }
            if (value == null) {
                this.append("No package", new SimpleTextAttributes(0, (Color)JBColor.RED));
            } else if (value == SELECT_PACKAGE) {
                this.append(" Select...", new SimpleTextAttributes(0, (Color)JBColor.darkGray));
            } else {
                this.append("Unexpected value", new SimpleTextAttributes(0, (Color)JBColor.RED));
            }
        }
    }

    private static class KeyEventAwareComboBox<T>
    extends ComboBox<T> {
        private boolean myKeyEventProcessing = false;

        private KeyEventAwareComboBox() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            try {
                this.myKeyEventProcessing = true;
                boolean bl = super.processKeyBinding(ks, e, condition, pressed);
                return bl;
            }
            finally {
                this.myKeyEventProcessing = false;
            }
        }
    }
}

