/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorConsoleFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    public static final FileHyperlinkRawDataFinder FINDER = new ProtractorHyperlinkFinder();

    public ProtractorConsoleFilter(@NotNull Project project, @Nullable File baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/protractor/ProtractorConsoleFilter", "<init>"));
        }
        super(project, baseDir != null ? baseDir.getAbsolutePath() : null);
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/protractor/ProtractorConsoleFilter", "parse"));
        }
        List list = FINDER.find(line);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorConsoleFilter", "parse"));
        }
        return list;
    }

    private static class ProtractorHyperlinkFinder
    implements FileHyperlinkRawDataFinder {
        private ProtractorHyperlinkFinder() {
        }

        @NotNull
        public List<FileHyperlinkRawData> find(@NotNull String line) {
            int endInd;
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/protractor/ProtractorConsoleFilter$ProtractorHyperlinkFinder", "find"));
            }
            if (line.startsWith("[") && (endInd = line.indexOf("] ")) != -1) {
                int skippedPrefixLength = endInd + 2;
                List<FileHyperlinkRawData> links = ProtractorHyperlinkFinder.doFind(line.substring(skippedPrefixLength));
                ArrayList<FileHyperlinkRawData> result = new ArrayList<FileHyperlinkRawData>();
                for (FileHyperlinkRawData link : links) {
                    result.add(new FileHyperlinkRawData(link.getFilePath(), link.getDocumentLine(), link.getDocumentColumn(), link.getHyperlinkStartInd() + skippedPrefixLength, link.getHyperlinkEndInd() + skippedPrefixLength));
                }
                ArrayList<FileHyperlinkRawData> arrayList = result;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorConsoleFilter$ProtractorHyperlinkFinder", "find"));
                }
                return arrayList;
            }
            List<FileHyperlinkRawData> list = ProtractorHyperlinkFinder.doFind(line);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/protractor/ProtractorConsoleFilter$ProtractorHyperlinkFinder", "find"));
            }
            return list;
        }

        private static List<FileHyperlinkRawData> doFind(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/javascript/protractor/ProtractorConsoleFilter$ProtractorHyperlinkFinder", "doFind"));
            }
            List links = NodeConsoleAdditionalFilter.FINDER.find(line);
            if (!links.isEmpty()) {
                return links;
            }
            return NodeStackTraceFilter.FINDER.find(line);
        }
    }
}

