/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class StylelintUtil {
    public static final String PACKAGE_NAME = "stylelint";
    public static final String DEFAULT_CONFIG_PREFIX = ".stylelintrc";
    public static final String IGNORE_FILE = ".stylelintignore";
    private static final String CONFIG_JS_FILE_NAME = "stylelint.config.js";
    private static final String[] CONFIG_EXTENSIONS = new String[]{"", ".js", ".yaml", ".yml", ".json"};
    private static final HashSet<String> CONFIG_FILENAMES = ContainerUtil.newHashSet();

    public static VirtualFile findWorkingDirectory(@NotNull VirtualFile fileToLint) {
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/css/linter/stylelint/StylelintUtil", "findWorkingDirectory"));
        }
        VirtualFile parent = fileToLint.getParent();
        if (parent == null) {
            return null;
        }
        CommonProcessors.FindProcessor<VirtualFile> processor = new CommonProcessors.FindProcessor<VirtualFile>(){

            protected boolean accept(VirtualFile file) {
                if (!file.isValid() || file.isDirectory()) {
                    return false;
                }
                return StylelintUtil.IGNORE_FILE.equals(file.getName());
            }
        };
        StylelintUtil.processFromDirectoryUp(parent, (Processor<VirtualFile>)processor);
        VirtualFile ignoreFile = (VirtualFile)processor.getFoundValue();
        if (ignoreFile != null && ignoreFile.getParent() != null) {
            return ignoreFile.getParent();
        }
        return parent;
    }

    @NotNull
    public static Collection<VirtualFile> getPossibleConfigs(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/lang/css/linter/stylelint/StylelintUtil", "getPossibleConfigs"));
        }
        CommonProcessors.CollectProcessor<VirtualFile> processor = new CommonProcessors.CollectProcessor<VirtualFile>((Collection)ContainerUtil.newSmartList()){

            protected boolean accept(VirtualFile file) {
                return StylelintUtil.isStylelintConfigFile(file);
            }
        };
        StylelintUtil.processFromDirectoryUp(dir, (Processor<VirtualFile>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/css/linter/stylelint/StylelintUtil", "getPossibleConfigs"));
        }
        return collection;
    }

    public static boolean isStylelintConfigFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/css/linter/stylelint/StylelintUtil", "isStylelintConfigFile"));
        }
        if (!file.isValid() || file.isDirectory()) {
            return false;
        }
        return CONFIG_FILENAMES.contains(file.getName());
    }

    private static void processFromDirectoryUp(@NotNull VirtualFile dir, @NotNull Processor<VirtualFile> processor) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/lang/css/linter/stylelint/StylelintUtil", "processFromDirectoryUp"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/css/linter/stylelint/StylelintUtil", "processFromDirectoryUp"));
        }
        while (dir != null) {
            for (VirtualFile file : dir.getChildren()) {
                if (processor.process((Object)file)) continue;
                return;
            }
            dir = dir.getParent();
        }
    }

    static {
        CONFIG_FILENAMES.add("package.json");
        CONFIG_FILENAMES.add(CONFIG_JS_FILE_NAME);
        CONFIG_FILENAMES.add(IGNORE_FILE);
        for (String CONFIG_EXTENSION : CONFIG_EXTENSIONS) {
            CONFIG_FILENAMES.add(DEFAULT_CONFIG_PREFIX + CONFIG_EXTENSION);
        }
    }
}

