/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.findUsages;

import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportAliasReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    protected ES6ImportAliasReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/lang/ecmascript6/findUsages/ES6ImportAliasReferenceSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ImportAliasReferenceSearcher", "processQuery"));
        }
        PsiElement target = queryParameters.getElementToSearch();
        if (!(target instanceof JSElement) || !(target instanceof PsiNamedElement)) {
            return;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(target);
        if (holder == null || !holder.isTypeScript && !holder.isECMA6) {
            return;
        }
        SearchRequestCollector collector = queryParameters.getOptimizer();
        SearchSession session = collector.getSearchSession();
        String name = ((PsiNamedElement)target).getName();
        if (name != null) {
            collector.searchWord(name, queryParameters.getEffectiveSearchScope(), (short)1, true, target, (RequestResultProcessor)new MyProcessor(target, name, session));
        }
    }

    private static class MyProcessor
    extends RequestResultProcessor {
        private final PsiElement myTarget;
        @NotNull
        private final String myName;
        private final SearchSession mySession;

        MyProcessor(PsiElement target, @NotNull String name, SearchSession session) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/ecmascript6/findUsages/ES6ImportAliasReferenceSearcher$MyProcessor", "<init>"));
            }
            super(new Object[]{target});
            this.myTarget = target;
            this.myName = name;
            this.mySession = session;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<PsiReference> consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/findUsages/ES6ImportAliasReferenceSearcher$MyProcessor", "processTextOccurrence"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/ecmascript6/findUsages/ES6ImportAliasReferenceSearcher$MyProcessor", "processTextOccurrence"));
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            JSNamedElement alias = MyProcessor.getAlias(element);
            if (alias == null || alias.getName() == null) {
                return true;
            }
            PsiReference reference = element.getReference();
            if (reference == null) {
                return true;
            }
            if (!reference.isReferenceTo(this.myTarget)) {
                return true;
            }
            String name = alias.getName();
            SearchRequestCollector collector = new SearchRequestCollector(this.mySession);
            LocalSearchScope fileScope = new LocalSearchScope((PsiElement)element.getContainingFile());
            collector.searchWord(name, (SearchScope)fileScope, (short)1, true, (PsiElement)alias);
            return PsiSearchHelper.SERVICE.getInstance((Project)element.getProject()).processRequests(collector, consumer);
        }

        @Nullable
        private static JSNamedElement getAlias(PsiElement element) {
            TypeScriptImportStatement importStatement;
            if (element instanceof ES6ImportSpecifier) {
                ES6ImportSpecifierAlias alias = ((ES6ImportSpecifier)element).getAlias();
                if (alias != null) {
                    return alias;
                }
            } else if (element instanceof TypeScriptEntityName && !(element.getParent() instanceof TypeScriptEntityName) && (importStatement = (TypeScriptImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, TypeScriptImportStatement.class)) != null) {
                return importStatement;
            }
            return null;
        }
    }
}

