/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveHelper;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSParentReference;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.psi.impl.TypeScriptExternalModuleReferenceImpl;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6PsiUtil {
    public static final TokenSet DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DECLARATION});
    private static final Key<ParameterizedCachedValue<Collection<PsiElement>, PsiElement>> CACHE_KEY = Key.create((String)"TypeScript.External.Module.Resolve");
    private static final Key<ParameterizedCachedValue<Collection<PsiElement>, PsiElement>> CACHE_LIBRARY_MODULES_KEY = Key.create((String)"Library.External.Module.Resolve");
    private static final ParameterizedCachedValueProvider<Collection<PsiElement>, PsiElement> CACHED_VALUE_PROVIDER = el -> CachedValueProvider.Result.create(ES6PsiUtil.getModulesWithAugmentations(el), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    private static final ParameterizedCachedValueProvider<Collection<PsiElement>, PsiElement> CACHED_LIBRARY_MODULES_VALUE_PROVIDER = new ParameterizedCachedValueProvider<Collection<PsiElement>, PsiElement>(){

        @Nullable
        public CachedValueProvider.Result<Collection<PsiElement>> compute(PsiElement param) {
            Collection elements = ES6PsiUtil.getMainModules(param);
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)param.getProject()).getFileIndex();
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)param);
            ArrayList deps = ContainerUtil.newArrayListWithCapacity((int)(elements.size() + 2));
            deps.add(file);
            deps.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            boolean allResolveResultsFromLibrary = true;
            for (PsiElement element : elements) {
                VirtualFile curr = PsiUtilCore.getVirtualFile((PsiElement)element);
                if (curr != null && index.isInLibrary(curr) && element instanceof JSFile) {
                    deps.add(curr);
                    continue;
                }
                allResolveResultsFromLibrary = false;
                break;
            }
            if (allResolveResultsFromLibrary) {
                return CachedValueProvider.Result.create((Object)elements, (Object[])deps.toArray());
            }
            return CachedValueProvider.Result.create((Object)elements, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };
    public static final String DEFAULT_NAME = "default";

    public static Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement moduleReference) {
        if (moduleReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReference", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "resolveModuleReferences"));
        }
        return (Collection)CachedValuesManager.getManager((Project)moduleReference.getProject()).getParameterizedCachedValue((UserDataHolder)moduleReference, CACHE_KEY, CACHED_VALUE_PROVIDER, false, (Object)moduleReference);
    }

    @Nullable
    private static String getReferenceModuleText(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getReferenceModuleText"));
        }
        if (element instanceof ES6FromClause) {
            return ((ES6FromClause)element).getReferenceText();
        }
        if (element instanceof TypeScriptExternalModuleReference) {
            return ((TypeScriptExternalModuleReference)element).getReferenceText();
        }
        if (element instanceof TypeScriptModule) {
            return ((TypeScriptModule)element).getName();
        }
        return null;
    }

    @NotNull
    public static Collection<PsiElement> getBindingAllPossibleExports(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
        }
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) continue;
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])new PsiElement[]{assignment});
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
            }
            return arrayList;
        }
        Collection<PsiElement> collection = elements;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getBindingAllPossibleExports"));
        }
        return collection;
    }

    @Nullable
    public static JSElement findDefaultExport(@NotNull JSElement scopeElement, @Nullable Collection<PsiElement> visited) {
        if (scopeElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeElement", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "findDefaultExport"));
        }
        Collection exportDefaultAssignments = JSStubBasedPsiTreeUtil.findDescendants((PsiElement)scopeElement, ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT);
        if (!exportDefaultAssignments.isEmpty()) {
            return (JSElement)exportDefaultAssignments.iterator().next();
        }
        final Ref resultElement = Ref.create();
        JSResolveProcessorBase processor = new JSResolveProcessorBase(DEFAULT_NAME){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$2", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$2", "execute"));
                }
                if (element instanceof ES6ExportSpecifierAlias || element instanceof ES6ExportSpecifier || element instanceof ES6ExportedDefaultBinding) {
                    resultElement.set((Object)element);
                    return false;
                }
                return true;
            }
        };
        JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scopeElement, processor, false);
        PsiElement result = (PsiElement)resultElement.get();
        if (!(result instanceof JSElement)) {
            return null;
        }
        if (result instanceof ES6ExportSpecifier) {
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            if (!visited.add(result)) {
                return null;
            }
            ResolveResult[] resultResultsForSpecifier = ((ES6ExportSpecifier)result).multiResolve((Collection)visited);
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(JSResolveResult.toElements(resultResultsForSpecifier));
            return item instanceof JSElement ? (JSElement)item : null;
        }
        return (JSElement)result;
    }

    public static boolean isAsyncContext(@Nullable JSFunction parent) {
        JSAttributeList attributeList;
        return parent != null && (attributeList = parent.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.ASYNC);
    }

    public static boolean isGeneratorContext(@Nullable JSFunction parent) {
        if (parent != null) {
            return parent.isGenerator();
        }
        return false;
    }

    public static boolean processExportAllDeclarations(@NotNull JSElement owner, PsiElement place, @NotNull PsiScopeProcessor processor, Collection<PsiElement> visited) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportAllDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportAllDeclarations"));
        }
        if (visited != null && !visited.add((PsiElement)owner)) {
            return false;
        }
        if (!TypeScriptPsiUtil.isExternalModule((PsiElement)owner)) {
            return true;
        }
        PsiElement[] children = JSStubBasedPsiTreeUtil.getChildrenByType(owner, DECLARATIONS);
        if (children == null) {
            return true;
        }
        for (PsiElement child : children) {
            ES6FromClause clause;
            ES6ExportDeclaration declaration;
            if (!(child instanceof ES6ExportDeclaration) || !(declaration = (ES6ExportDeclaration)child).isExportAll() || (clause = declaration.getFromClause()) == null) continue;
            Collection<PsiElement> elements = ES6PsiUtil.getFromClauseResolvedReferences(clause);
            for (PsiElement element : elements) {
                if (!(element instanceof JSElement) || element.isEquivalentTo((PsiElement)owner)) continue;
                if (visited == null) {
                    visited = ContainerUtil.newHashSet();
                }
                if (ES6PsiUtil.processExportDeclarationInScope((JSElement)element, processor, ResolveState.initial(), (PsiElement)element.getContainingFile(), place, visited)) continue;
                return false;
            }
        }
        return true;
    }

    private static Collection<PsiElement> getFromClauseResolvedReferences(@NotNull ES6FromClause clause) {
        if (clause == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clause", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getFromClauseResolvedReferences"));
        }
        Collection elements = clause.resolveReferencedElements();
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)elements.size());
        for (PsiElement element : elements) {
            TypeScriptExportAssignment assignment = TypeScriptPsiUtil.findExportAssignment(element);
            if (assignment == null) {
                result.add(element);
                continue;
            }
            String name = assignment.getInitializerReference();
            if (name == null) continue;
            JSTypeResolveResult typeResolveResult = TypeScriptImportHandler.getInstance().resolveName(name, (PsiElement)assignment);
            for (PsiElement psiElement : typeResolveResult.getElements()) {
                result.add(psiElement);
            }
        }
        return result;
    }

    public static void processSpecifier(@NotNull ES6ImportExportSpecifier specifier, @NotNull ResultSink sink, @Nullable PsiElement defaultScope) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifier"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifier"));
        }
        ES6ImportExportDeclaration declaration = specifier.getDeclaration();
        if (declaration == null) {
            return;
        }
        ES6FromClause clause = declaration.getFromClause();
        List scopes = null;
        if (clause != null) {
            scopes = ES6PsiUtil.getFromClauseResolvedReferences(clause);
        } else if (defaultScope != null && defaultScope instanceof JSElement) {
            scopes = ContainerUtil.createMaybeSingletonList((Object)defaultScope);
        }
        if (scopes == null) {
            return;
        }
        for (PsiElement scope : scopes) {
            QualifiedItemProcessor<?> processor = ES6PsiUtil.createSpecifierResolveProcessor(specifier, scope, sink);
            ES6PsiUtil.processSpecifierForScope(specifier, processor, defaultScope, scope);
        }
    }

    private static void processSpecifierForScope(@NotNull ES6ImportExportSpecifier specifier, final @NotNull QualifiedItemProcessor<?> processor, @Nullable PsiElement defaultScope, PsiElement scope) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifierForScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processSpecifierForScope"));
        }
        if (!(scope instanceof JSElement)) {
            return;
        }
        if (scope instanceof JSVariable) {
            JSType possibleType = ((JSVariable)scope).getType();
            if (possibleType != null) {
                processor.process(possibleType, new JSEvaluateContext(scope.getContainingFile()), scope);
            }
        } else if (scope == defaultScope) {
            JSResolveProcessorBase delegatingProcessor = new JSResolveProcessorBase(processor.getName()){

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$3", "execute"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$3", "execute"));
                    }
                    if (element instanceof ES6ExportSpecifier || element instanceof ES6ExportSpecifierAlias) {
                        return true;
                    }
                    return processor.execute(element, state);
                }
            };
            JSResolveUtil.processDeclarationsInScope((JSElement)scope, delegatingProcessor, ResolveState.initial(), (PsiElement)scope.getContainingFile(), (PsiElement)specifier);
        } else {
            ES6PsiUtil.processExportDeclarationInScope((JSElement)scope, processor, ResolveState.initial(), null, (PsiElement)specifier);
        }
    }

    public static QualifiedItemProcessor<?> createSpecifierResolveProcessor(@NotNull ES6ImportExportSpecifier specifier, @NotNull PsiElement scope, @NotNull ResultSink sink) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createSpecifierResolveProcessor"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createSpecifierResolveProcessor"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createSpecifierResolveProcessor"));
        }
        QualifiedItemProcessor<? extends ResultSink> processor = JSDialectSpecificHandlersFactory.forElement(scope).createCompletionItemProcessor(sink, specifier.getContainingFile());
        processor.setLocalResolve(true);
        processor.setTypeContext(true);
        processor.setSkipImplicitDeclarations(true);
        return processor;
    }

    @Nullable
    public static JSElement getExportScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getExportScope"));
        }
        return element instanceof PsiFile ? null : (JSElement)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{TypeScriptModule.class, JSFile.class});
    }

    @Nullable
    public static PsiElement getNonStrictExportScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getNonStrictExportScope"));
        }
        return PsiTreeUtil.getContextOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{TypeScriptModule.class, JSFile.class});
    }

    public static PsiReference[] calcImportExportFromClauseReferences(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "calcImportExportFromClauseReferences"));
        }
        Pair<String, PsiElement> pair = JSPsiImplUtils.getChildStringLiteralWithText(element);
        if (pair == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement literalExpression = (PsiElement)pair.second;
        String quotedText = (String)pair.first;
        return ES6PsiUtil.createImportExportFromClauseReferences(element, literalExpression.getStartOffsetInParent() + 1, quotedText, provider);
    }

    public static PsiReference[] createImportExportFromClauseReferences(@NotNull PsiElement host, int offset, @NotNull String text, @Nullable PsiReferenceProvider provider) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createImportExportFromClauseReferences"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "createImportExportFromClauseReferences"));
        }
        String unquoted = StringUtil.unquoteString((String)text);
        Object[] result = PsiReference.EMPTY_ARRAY;
        for (JSModuleReferenceContributor contributor : (JSModuleReferenceContributor[])JSModuleReferenceContributor.EP_NAME.getExtensions()) {
            if (!contributor.isApplicable(host)) continue;
            Object[] references = contributor.getAllReferences(unquoted, host, offset, provider);
            result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])references);
        }
        result = ES6PsiUtil.addReferences((PsiReference[])result, TypeScriptExternalModuleReferenceImpl.getSimpleExternalModuleReferences(host, text, offset, false));
        return result;
    }

    private static PsiReference[] addReferences(@NotNull PsiReference[] current, @NotNull PsiReference[] toAdd) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "addReferences"));
        }
        if (toAdd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toAdd", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "addReferences"));
        }
        if (toAdd != PsiReference.EMPTY_ARRAY) {
            current = (PsiReference[])ArrayUtil.mergeArrays((Object[])current, (Object[])toAdd);
        }
        return current;
    }

    public static boolean processExportDeclarationInScope(@NotNull JSElement scope, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        return ES6PsiUtil.processExportDeclarationInScope(scope, processor, state, lastParent, place, null);
    }

    private static boolean processExportDeclarationInScope(@NotNull JSElement scope, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place, @Nullable Collection<PsiElement> visited) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "processExportDeclarationInScope"));
        }
        boolean hasIncompleteMatch = false;
        if (scope instanceof JSFile && !DialectDetector.isTypeScript((PsiElement)scope)) {
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((PsiFile)((JSFile)scope));
            Processor namespaceMembersProcessor = element -> {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "lambda$processExportDeclarationInScope$1"));
                }
                boolean processingFromIndices = false;
                try {
                    if (processor instanceof ResolveProcessor) {
                        if (((ResolveProcessor)processor).getName() == null && (element.getAccessType() == JSAttributeList.AccessType.PRIVATE || JSVisibilityUtil.seemsToBePrivateSymbol(element.getName()))) {
                            boolean bl = true;
                            return bl;
                        }
                        processingFromIndices = ((ResolveProcessor)processor).isProcessingFromIndices();
                        ((ResolveProcessor)processor).setSkipImplicitDeclarations(true);
                    }
                    boolean bl = processor.execute((PsiElement)element, ResolveState.initial());
                    return bl;
                }
                finally {
                    if (processor instanceof ResolveProcessor) {
                        ((ResolveProcessor)processor).setSkipImplicitDeclarations(processingFromIndices);
                    }
                }
            };
            JSClassResolver.getInstance().processNamespaceMembers("exports", fileScope, (Processor<JSPsiElementBase>)namespaceMembersProcessor);
            JSClassResolver.getInstance().processNamespaceMembers("module.exports", fileScope, (Processor<JSPsiElementBase>)namespaceMembersProcessor);
            hasIncompleteMatch = ((JSFile)scope).getExportsInnerAlias() != null || !((JSFile)scope).hasES6Syntax();
        }
        JSExportedElementsProcessor exportedElementsProcessor = processor instanceof JSExportedElementsProcessor ? (JSExportedElementsProcessor)processor : new JSExportedElementsProcessor(processor);
        boolean result = true;
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)scope);
        if (isTypeScript || scope instanceof JSFile && ((JSFile)scope).hasES6Syntax()) {
            boolean bl = result = isTypeScript ? JSResolveUtil.processDeclarationsInScope(scope, exportedElementsProcessor, state, lastParent, place) : JSStubBasedPsiTreeUtil.processDeclarationsInScope((PsiElement)scope, exportedElementsProcessor, false);
            if (result) {
                ES6PsiUtil.processExportAllDeclarations(scope, place, exportedElementsProcessor, visited);
            }
            if (result && DialectDetector.isTypeScript((PsiElement)scope) && exportedElementsProcessor.getName() != null && processor instanceof SinkResolveProcessor && ((ResultSink)((SinkResolveProcessor)processor).getResultSink()).getResultCount() == 0) {
                TypeScriptResolveHelper.processGlobalThings((JSResolveProcessorBase)processor, ResolveState.initial(), (PsiElement)scope);
            }
        }
        return hasIncompleteMatch || result;
    }

    public static boolean isImportElement(PsiElement item) {
        return item instanceof ES6ImportedBinding || item instanceof ES6ImportSpecifierAlias || item instanceof TypeScriptImportStatement;
    }

    private static Collection<PsiElement> getModulesWithAugmentations(@NotNull PsiElement context) {
        Collection<PsiElement> modules;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getModulesWithAugmentations"));
        }
        Collection<PsiElement> collection = modules = ES6PsiUtil.isLibraryElement(context) ? ES6PsiUtil.getMainModulesFromCache(context) : ES6PsiUtil.getMainModules(context);
        if (context instanceof TypeScriptModule && ((TypeScriptModule)context).isAugmentation() || modules.isEmpty()) {
            return modules;
        }
        return ES6PsiUtil.mergeWithAugmentations(context, modules);
    }

    private static boolean isLibraryElement(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "isLibraryElement"));
        }
        if (DumbService.isDumb((Project)context.getProject())) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)context);
        return file != null && index.isInLibrary(file);
    }

    private static Collection<PsiElement> getMainModulesFromCache(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getMainModulesFromCache"));
        }
        return (Collection)CachedValuesManager.getManager((Project)context.getProject()).getParameterizedCachedValue((UserDataHolder)context, CACHE_LIBRARY_MODULES_KEY, CACHED_LIBRARY_MODULES_VALUE_PROVIDER, false, (Object)context);
    }

    private static Collection<PsiElement> getMainModules(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "getMainModules"));
        }
        String text = ES6PsiUtil.getReferenceModuleText(context);
        if (StringUtil.isEmpty((String)text)) {
            return ContainerUtil.emptyList();
        }
        PsiReference[] references = ES6PsiUtil.createImportExportFromClauseReferences(context, 0, text, null);
        THashSet modulesResult = new THashSet();
        THashSet results = new THashSet();
        for (PsiReference reference : references) {
            if (reference == null || reference instanceof FileReference && !((FileReference)reference).isLast() || reference instanceof JSParentReference) continue;
            Collection<PsiElement> currentResults = JSResolveUtil.getResolvedElements(reference);
            String[] extensions = DialectDetector.isTypeScript(context) ? TypeScriptUtil.TYPESCRIPT_EXTENSIONS : JSFileReference.IMPLICIT_EXTENSIONS;
            for (PsiElement result : currentResults) {
                if (result instanceof PsiDirectory) {
                    PsiFile file = ES6PsiUtil.findIndexFile(extensions, (PsiDirectory)result);
                    if (file == null) continue;
                    results.add(file);
                    continue;
                }
                if (TypeScriptPsiUtil.IS_TS_MODULE.value((Object)result)) {
                    modulesResult.add(result);
                    continue;
                }
                results.add(result);
            }
        }
        return ES6PsiUtil.getMostPriorityModules(context, (Set<PsiElement>)modulesResult, (Set<PsiElement>)results);
    }

    public static PsiFile findIndexFile(@NotNull String[] extensions, @NotNull PsiDirectory result) {
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "findIndexFile"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "findIndexFile"));
        }
        for (String ext : extensions) {
            PsiFile file = result.findFile("index" + ext);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    private static Collection<PsiElement> getMostPriorityModules(PsiElement context, Set<PsiElement> modulesResult, Set<PsiElement> results) {
        if (modulesResult.isEmpty()) {
            return results;
        }
        if (DialectDetector.isTypeScript(context)) {
            boolean allHasAsterisk;
            List<PsiElement> accessibleModules = modulesResult.stream().filter(el -> TypeScriptConfigService.Provider.isAccessible(context, el)).collect(Collectors.toList());
            if (!accessibleModules.isEmpty() && !(allHasAsterisk = ES6PsiUtil.checkAllModulesHasWildcard(accessibleModules))) {
                return accessibleModules;
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return modulesResult;
    }

    private static boolean checkAllModulesHasWildcard(List<PsiElement> accessibleModules) {
        for (PsiElement module : accessibleModules) {
            if (module instanceof TypeScriptModule) {
                if (JSPathMappingsUtil.AsteriskCount.ONE == JSPathMappingsUtil.hasZeroOrOneAsteriskCharacter(((TypeScriptModule)module).getName())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<PsiElement> mergeWithAugmentations(PsiElement context, Collection<PsiElement> modules) {
        Collection<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations(context, modules);
        if (augmentations.isEmpty()) {
            Collection<PsiElement> collection = modules;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "mergeWithAugmentations"));
            }
            return collection;
        }
        ArrayList result = ContainerUtil.newArrayList(modules);
        result.addAll(augmentations);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil", "mergeWithAugmentations"));
        }
        return arrayList;
    }

    public static class JSExportedElementsProcessor
    extends JSResolveProcessorBase {
        @NotNull
        private final PsiScopeProcessor myDelegate;

        public JSExportedElementsProcessor(@NotNull PsiScopeProcessor delegateProcessor) {
            if (delegateProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateProcessor", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSExportedElementsProcessor", "<init>"));
            }
            super(delegateProcessor instanceof JSResolveProcessorBase ? ((JSResolveProcessorBase)delegateProcessor).getName() : null);
            this.myDelegate = delegateProcessor;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSExportedElementsProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/ecmascript6/resolve/ES6PsiUtil$JSExportedElementsProcessor", "execute"));
            }
            if (element instanceof ES6ExportSpecifier) {
                ResolveResult[] results;
                ES6ImportExportDeclaration declaration = ((ES6ExportSpecifier)element).getDeclaration();
                if (declaration != null && declaration.getFromClause() == null) {
                    return true;
                }
                for (ResolveResult result : results = ((ES6ExportSpecifier)element).multiResolve(false)) {
                    PsiElement resultElement;
                    if (!result.isValidResult() || (resultElement = result.getElement()) == null || this.myDelegate.execute(resultElement, state)) continue;
                    return false;
                }
            } else {
                if (ES6ImportHandler.isExported(element)) {
                    return this.myDelegate.execute(element, state);
                }
                if (this.myDelegate instanceof SinkResolveProcessor && ((ResultSink)((SinkResolveProcessor)this.myDelegate).getResultSink()).accepts(element)) {
                    ((SinkResolveProcessor)this.myDelegate).addPossibleCandidateResult(element, "javascript.element.need.to.be.exported");
                }
            }
            return true;
        }
    }
}

