/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlowJSShowTypeInfoAction
extends ExpressionTypeProvider<PsiElement> {
    @NotNull
    public String getInformationHint(@NotNull PsiElement element) {
        FlowJSConfig config;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getInformationHint"));
        }
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        Project project = element.getProject();
        FlowJSServerService service = FlowJSServerService.getService(project);
        if (service != null && (config = service.getConfig(virtualFile)) != null) {
            service.saveSyncAllUnsavedFiles();
            Document document = element.getContainingFile().getViewProvider().getDocument();
            if (document != null) {
                String string = service.getTypeOfElement(element, virtualFile, document, config);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getInformationHint"));
                }
                return string;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getInformationHint"));
        }
        return "";
    }

    @NotNull
    public String getErrorHint() {
        String string = JSBundle.message((String)"js.show.type.info.action.error", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getErrorHint"));
        }
        return string;
    }

    @NotNull
    public List<PsiElement> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getExpressionsAt"));
        }
        if (FlowJSServerService.getService(elementAt.getProject()) != null) {
            List<PsiElement> list = Collections.singletonList(elementAt);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getExpressionsAt"));
            }
            return list;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/actions/FlowJSShowTypeInfoAction", "getExpressionsAt"));
        }
        return list;
    }
}

